/*
 * Decompiled with CFR 0.152.
 */
package org.helios.jmx.reverseclassloader.server.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.helios.helpers.FileHelper;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;

public class HttpReverseClassloaderHandler
extends AbstractHandler {
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    protected File baseDirectory = null;
    protected String hostName = "0.0.0.0";
    protected int port = 7776;
    protected static Server server = null;
    protected static Object lock = new Object();

    public HttpReverseClassloaderHandler(String baseDirName) throws Exception {
        this.baseDirectory = new File(baseDirName);
        if (!this.baseDirectory.exists()) {
            throw new Exception("Base Directory [" + baseDirName + "] does not exist");
        }
        if (!this.baseDirectory.isDirectory()) {
            throw new Exception("Base Directory [" + baseDirName + "] is not a directory.");
        }
        this.startServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String baseDir) throws Exception {
        if (server == null) {
            Object object = lock;
            synchronized (object) {
                if (server == null) {
                    HttpReverseClassloaderHandler httpReverseClassloaderHandler = new HttpReverseClassloaderHandler(baseDir);
                }
            }
        }
    }

    public void startServer() throws Exception {
        server = new Server(this.port);
        server.setHandler((Handler)this);
        server.start();
        this.log.info((Object)"Http Reverse Classloader Started");
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        int size;
        StringBuilder buff = new StringBuilder();
        buff.append("ReverseClassLoader Request.");
        buff.append("\n\tTarget:").append(target);
        buff.append("\n\tLocal Port:").append(request.getLocalPort());
        buff.append("\n\tRemote Port:").append(request.getRemotePort());
        buff.append("\n\tServer Port:").append(request.getServerPort());
        buff.append("\n\tContext Path:").append(request.getContextPath());
        buff.append("\n\tContent Type:").append(request.getContentType());
        Map params = request.getParameterMap();
        buff.append("\n\tParameters:[" + params.size() + "]");
        for (Map.Entry entry : params.entrySet()) {
            buff.append("\n\t\t").append((String)entry.getKey()).append(":").append(entry.getValue());
        }
        buff.append("\n\tHeaders:");
        Enumeration henum = request.getHeaderNames();
        while (henum.hasMoreElements()) {
            String headerName = henum.nextElement().toString();
            buff.append("\n\t\t").append(headerName).append(":").append(request.getHeader(headerName));
        }
        buff.append("\n\tRequest Length:").append(request.getContentLength());
        this.log.debug((Object)buff.toString());
        Object mletTxt = null;
        ServletInputStream is = request.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] byteBuffer = new byte[1024];
        while ((size = is.read(byteBuffer)) != -1) {
            baos.write(byteBuffer, 0, size);
        }
        this.log.info((Object)("Read [" + baos.size() + "] bytes"));
        String lib = request.getParameter("lib");
        if (lib == null) {
            response.setStatus(200);
            return;
        }
        StringBuilder mletUrlStr = new StringBuilder(this.baseDirectory.toURL().toString() + lib);
        URL url = new URL(mletUrlStr.toString());
        this.log.info((Object)("Reverse Loading [" + url.toString() + "]"));
        response.setStatus(200);
        byte[] jar = FileHelper.getBytesFromUrl((URL)url);
        ServletOutputStream os = response.getOutputStream();
        os.write(jar);
        os.flush();
        os.close();
    }
}

