# A wrapper for a status bar that makes some simple but common
# operations easier.
#
#   Copyright (C) 2003 Daniel Burrows <dburrows@debian.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

class Status:
    def __init__(self, widget):
        self.widget=widget
        self.context_id=widget.get_context_id('Library status')
        self.msg_id=[]

    # Pushes the new message before removing the old one.  Not sure
    # that really makes a difference.
    def set_message(self, text):
        new_msg_id=self.widget.push(self.context_id, text)

        if len(self.msg_id)>0:
            self.widget.remove(self.context_id, self.msg_id[-1])
            del self.msg_id[-1]

        self.msg_id.append(new_msg_id)

    # Pushes a new level of message.
    def push(self, text=""):
        self.msg_id.append(self.widget.push(self.context_id, text))

    # Pops a level of message.
    def pop(self):
        if len(self.msg_id)>0:
            self.widget.remove(self.context_id, self.msg_id[-1])
            del self.msg_id[-1]

