/*

  Source code generator

  Copyright © 2017 F.Hroch (hroch@physics.muni.cz)

  This file is part of Munipack.

  Munipack is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Munipack is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Munipack.  If not, see <http://www.gnu.org/licenses/>.

*/


/*
   All the code depends on the XPM file generated by Gimp.
*/

#include "artpicture.xpm"
#include <string>
#include <iostream>
#include <sstream>

using namespace std;

int main()
{
  string modname = "artpicture";
  int xdim, ydim;

  string line(artpicture_xpm[0]);
  istringstream iss(line);
  iss >> xdim >> ydim;

  char zero, one;
  zero = artpicture_xpm[2][0];
  one = artpicture_xpm[3][0];

  cout << "! dimensions: " << xdim << " x " << ydim << " " << endl;

  cout << "module " << modname << endl;
  cout << "  implicit none "  << endl;
  cout << "  integer, parameter :: xdimask = "  << xdim << endl;
  cout << "  integer, parameter :: ydimask = "  << ydim << endl;
  cout << "contains" << endl;
  cout << "  subroutine genmask(mask)" << endl;
  cout << "    real, dimension(:,:), intent(out) :: mask" << endl;
  for(int j = 0; j < ydim; j++) {
    string line = artpicture_xpm[4+j];
    cout << "      mask(:," << j+1 << ") = (/";
    for(int i = 0; i < xdim; i++) {
      int pix = line[i] == zero ? 1 : 0;
      string sep = i > 0 ? "," : "";
      cout << sep  << pix;
    }
    cout << "/)" << endl;
  }
  cout << "  end subroutine genmask" << endl;
  cout << "end module " << modname << endl;

  return 0;
}
