package org.multiverse.api.blocking;

import org.junit.Before;
import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.multiverse.TestUtils.*;

public class DefaultRetryLatch_openTest {
    @Before
       public void setUp(){
           clearCurrentThreadInterruptedStatus();
       }

    @Test
    public void whenAlreadyOpenAndDifferentEra() {
        DefaultRetryLatch latch = new DefaultRetryLatch();
        long era = latch.getEra();
        latch.open(era);

        latch.open(era + 1);

        assertEquals(era, latch.getEra());
        assertOpen(latch);
    }

    @Test
    public void whenAlreadyOpenAndSameEra() {
        DefaultRetryLatch latch = new DefaultRetryLatch();
        long era = latch.getEra();
        latch.open(era);

        latch.open(era);

        assertEquals(era, latch.getEra());
        assertOpen(latch);
    }

    @Test
    public void whenClosedAndDifferentEra() {
        DefaultRetryLatch latch = new DefaultRetryLatch();
        long era = latch.getEra();

        latch.open(era + 1);

        assertEquals(era, latch.getEra());
        assertClosed(latch);
    }

    @Test
    public void whenClosedAndSameEra() {
        DefaultRetryLatch latch = new DefaultRetryLatch();
        long era = latch.getEra();

        latch.open(era);

        assertEquals(era, latch.getEra());
        assertOpen(latch);
    }
}
