#######################################################
# 
# CommandFactory.py
# Python implementation of the Class CommandFactory
# Generated by Enterprise Architect
# Created on:      14-Aug-2019 10:12:00 AM
# Original author: talve
# 
#######################################################


class CommandFactory:
    commands = {}
    """This class is responsible for creating and registering the commands.
    """
    @classmethod
    def register(cls, command_type, obj):
        """This method should  be use from the specific command in order to perform the
           command registration.
        """
        cls.commands.update({command_type: obj})

    @classmethod
    def create(cls, command_type, **kwargs):
        """create the command and return the command obj.
        """
        if command_type not in cls.commands:
            raise Exception("command type:{0} is not supported".format(command_type))
        return cls.commands[command_type](**kwargs)

