!     -*- Mode: Fortran; -*-
!  (C) 2008 by Argonne National Laboratory.
!      See COPYRIGHT in top-level directory.
        MODULE MPI_t1_s
        IMPLICIT NONE
        PRIVATE
        PUBLIC :: MPI_FILE_READ_AT_ALL_BEGIN
        INTERFACE MPI_FILE_READ_AT_ALL_BEGIN
           MODULE PROCEDURE MPI_FILE_READ_AT_ALL_BEGIN_T
        END INTERFACE MPI_FILE_READ_AT_ALL_BEGIN

        PUBLIC :: MPI_IREDUCE_SCATTER_BLOCK
        INTERFACE MPI_IREDUCE_SCATTER_BLOCK
           MODULE PROCEDURE MPI_IREDUCE_SCATTER_BLOCK_T
        END INTERFACE MPI_IREDUCE_SCATTER_BLOCK

        PUBLIC :: MPI_WIN_ATTACH
        INTERFACE MPI_WIN_ATTACH
           MODULE PROCEDURE MPI_WIN_ATTACH_T
        END INTERFACE MPI_WIN_ATTACH

        PUBLIC :: MPI_INEIGHBOR_ALLTOALL
        INTERFACE MPI_INEIGHBOR_ALLTOALL
           MODULE PROCEDURE MPI_INEIGHBOR_ALLTOALL_T
        END INTERFACE MPI_INEIGHBOR_ALLTOALL

        PUBLIC :: MPI_ALLREDUCE
        INTERFACE MPI_ALLREDUCE
           MODULE PROCEDURE MPI_ALLREDUCE_T
        END INTERFACE MPI_ALLREDUCE

        PUBLIC :: MPI_SENDRECV
        INTERFACE MPI_SENDRECV
           MODULE PROCEDURE MPI_SENDRECV_T
        END INTERFACE MPI_SENDRECV

        PUBLIC :: MPI_NEIGHBOR_ALLTOALLV
        INTERFACE MPI_NEIGHBOR_ALLTOALLV
           MODULE PROCEDURE MPI_NEIGHBOR_ALLTOALLV_T
        END INTERFACE MPI_NEIGHBOR_ALLTOALLV

        PUBLIC :: MPI_NEIGHBOR_ALLTOALL
        INTERFACE MPI_NEIGHBOR_ALLTOALL
           MODULE PROCEDURE MPI_NEIGHBOR_ALLTOALL_T
        END INTERFACE MPI_NEIGHBOR_ALLTOALL

        PUBLIC :: MPI_FILE_READ_ORDERED
        INTERFACE MPI_FILE_READ_ORDERED
           MODULE PROCEDURE MPI_FILE_READ_ORDERED_T
        END INTERFACE MPI_FILE_READ_ORDERED

        PUBLIC :: MPI_TYPE_GET_ATTR
        INTERFACE MPI_TYPE_GET_ATTR
           MODULE PROCEDURE MPI_TYPE_GET_ATTR_T
        END INTERFACE MPI_TYPE_GET_ATTR

        PUBLIC :: MPI_RGET_ACCUMULATE
        INTERFACE MPI_RGET_ACCUMULATE
           MODULE PROCEDURE MPI_RGET_ACCUMULATE_T
        END INTERFACE MPI_RGET_ACCUMULATE

        PUBLIC :: MPI_IBCAST
        INTERFACE MPI_IBCAST
           MODULE PROCEDURE MPI_IBCAST_T
        END INTERFACE MPI_IBCAST

        PUBLIC :: MPI_FILE_READ_ORDERED_END
        INTERFACE MPI_FILE_READ_ORDERED_END
           MODULE PROCEDURE MPI_FILE_READ_ORDERED_END_T
        END INTERFACE MPI_FILE_READ_ORDERED_END

        PUBLIC :: MPI_WIN_DETACH
        INTERFACE MPI_WIN_DETACH
           MODULE PROCEDURE MPI_WIN_DETACH_T
        END INTERFACE MPI_WIN_DETACH

        PUBLIC :: MPI_SEND
        INTERFACE MPI_SEND
           MODULE PROCEDURE MPI_SEND_T
        END INTERFACE MPI_SEND

        PUBLIC :: MPI_FILE_WRITE
        INTERFACE MPI_FILE_WRITE
           MODULE PROCEDURE MPI_FILE_WRITE_T
        END INTERFACE MPI_FILE_WRITE

        PUBLIC :: MPI_FILE_WRITE_ORDERED_BEGIN
        INTERFACE MPI_FILE_WRITE_ORDERED_BEGIN
           MODULE PROCEDURE MPI_FILE_WRITE_ORDERED_BEGIN_T
        END INTERFACE MPI_FILE_WRITE_ORDERED_BEGIN

        PUBLIC :: MPI_PACK_EXTERNAL
        INTERFACE MPI_PACK_EXTERNAL
           MODULE PROCEDURE MPI_PACK_EXTERNAL_T
        END INTERFACE MPI_PACK_EXTERNAL

        PUBLIC :: MPI_WIN_CREATE_KEYVAL
        INTERFACE MPI_WIN_CREATE_KEYVAL
           MODULE PROCEDURE MPI_WIN_CREATE_KEYVAL_T
        END INTERFACE MPI_WIN_CREATE_KEYVAL

        PUBLIC :: MPI_FILE_WRITE_ALL_END
        INTERFACE MPI_FILE_WRITE_ALL_END
           MODULE PROCEDURE MPI_FILE_WRITE_ALL_END_T
        END INTERFACE MPI_FILE_WRITE_ALL_END

        PUBLIC :: MPI_FILE_READ_ORDERED_BEGIN
        INTERFACE MPI_FILE_READ_ORDERED_BEGIN
           MODULE PROCEDURE MPI_FILE_READ_ORDERED_BEGIN_T
        END INTERFACE MPI_FILE_READ_ORDERED_BEGIN

        PUBLIC :: MPI_BSEND_INIT
        INTERFACE MPI_BSEND_INIT
           MODULE PROCEDURE MPI_BSEND_INIT_T
        END INTERFACE MPI_BSEND_INIT

        PUBLIC :: MPI_FILE_WRITE_AT_ALL_END
        INTERFACE MPI_FILE_WRITE_AT_ALL_END
           MODULE PROCEDURE MPI_FILE_WRITE_AT_ALL_END_T
        END INTERFACE MPI_FILE_WRITE_AT_ALL_END

        PUBLIC :: MPI_COMM_GET_ATTR
        INTERFACE MPI_COMM_GET_ATTR
           MODULE PROCEDURE MPI_COMM_GET_ATTR_T
        END INTERFACE MPI_COMM_GET_ATTR

        PUBLIC :: MPI_FILE_IWRITE_AT
        INTERFACE MPI_FILE_IWRITE_AT
           MODULE PROCEDURE MPI_FILE_IWRITE_AT_T
        END INTERFACE MPI_FILE_IWRITE_AT

        PUBLIC :: MPI_FILE_WRITE_ALL
        INTERFACE MPI_FILE_WRITE_ALL
           MODULE PROCEDURE MPI_FILE_WRITE_ALL_T
        END INTERFACE MPI_FILE_WRITE_ALL

        PUBLIC :: MPI_REDUCE
        INTERFACE MPI_REDUCE
           MODULE PROCEDURE MPI_REDUCE_T
        END INTERFACE MPI_REDUCE

        PUBLIC :: MPI_WIN_SET_ATTR
        INTERFACE MPI_WIN_SET_ATTR
           MODULE PROCEDURE MPI_WIN_SET_ATTR_T
        END INTERFACE MPI_WIN_SET_ATTR

        PUBLIC :: MPI_FILE_WRITE_ORDERED
        INTERFACE MPI_FILE_WRITE_ORDERED
           MODULE PROCEDURE MPI_FILE_WRITE_ORDERED_T
        END INTERFACE MPI_FILE_WRITE_ORDERED

        PUBLIC :: MPI_FILE_READ_ALL_END
        INTERFACE MPI_FILE_READ_ALL_END
           MODULE PROCEDURE MPI_FILE_READ_ALL_END_T
        END INTERFACE MPI_FILE_READ_ALL_END

        PUBLIC :: MPI_GET_ACCUMULATE
        INTERFACE MPI_GET_ACCUMULATE
           MODULE PROCEDURE MPI_GET_ACCUMULATE_T
        END INTERFACE MPI_GET_ACCUMULATE

        PUBLIC :: MPI_RECV
        INTERFACE MPI_RECV
           MODULE PROCEDURE MPI_RECV_T
        END INTERFACE MPI_RECV

        PUBLIC :: MPI_GET
        INTERFACE MPI_GET
           MODULE PROCEDURE MPI_GET_T
        END INTERFACE MPI_GET

        PUBLIC :: MPI_WIN_ALLOCATE
        INTERFACE MPI_WIN_ALLOCATE
           MODULE PROCEDURE MPI_WIN_ALLOCATE_T
        END INTERFACE MPI_WIN_ALLOCATE

        PUBLIC :: MPI_FILE_READ_AT_ALL_END
        INTERFACE MPI_FILE_READ_AT_ALL_END
           MODULE PROCEDURE MPI_FILE_READ_AT_ALL_END_T
        END INTERFACE MPI_FILE_READ_AT_ALL_END

        PUBLIC :: MPI_ALLOC_MEM
        INTERFACE MPI_ALLOC_MEM
           MODULE PROCEDURE MPI_ALLOC_MEM_T
        END INTERFACE MPI_ALLOC_MEM

        PUBLIC :: MPI_REDUCE_SCATTER
        INTERFACE MPI_REDUCE_SCATTER
           MODULE PROCEDURE MPI_REDUCE_SCATTER_T
        END INTERFACE MPI_REDUCE_SCATTER

        PUBLIC :: MPI_FILE_READ_AT_ALL
        INTERFACE MPI_FILE_READ_AT_ALL
           MODULE PROCEDURE MPI_FILE_READ_AT_ALL_T
        END INTERFACE MPI_FILE_READ_AT_ALL

        PUBLIC :: MPI_IALLREDUCE
        INTERFACE MPI_IALLREDUCE
           MODULE PROCEDURE MPI_IALLREDUCE_T
        END INTERFACE MPI_IALLREDUCE

        PUBLIC :: MPI_GET_ADDRESS
        INTERFACE MPI_GET_ADDRESS
           MODULE PROCEDURE MPI_GET_ADDRESS_T
        END INTERFACE MPI_GET_ADDRESS

        PUBLIC :: MPI_IGATHERV
        INTERFACE MPI_IGATHERV
           MODULE PROCEDURE MPI_IGATHERV_T
        END INTERFACE MPI_IGATHERV

        PUBLIC :: MPI_FILE_IREAD_SHARED
        INTERFACE MPI_FILE_IREAD_SHARED
           MODULE PROCEDURE MPI_FILE_IREAD_SHARED_T
        END INTERFACE MPI_FILE_IREAD_SHARED

        PUBLIC :: MPI_FILE_WRITE_AT
        INTERFACE MPI_FILE_WRITE_AT
           MODULE PROCEDURE MPI_FILE_WRITE_AT_T
        END INTERFACE MPI_FILE_WRITE_AT

        PUBLIC :: MPI_NEIGHBOR_ALLGATHER
        INTERFACE MPI_NEIGHBOR_ALLGATHER
           MODULE PROCEDURE MPI_NEIGHBOR_ALLGATHER_T
        END INTERFACE MPI_NEIGHBOR_ALLGATHER

        PUBLIC :: MPI_PACK
        INTERFACE MPI_PACK
           MODULE PROCEDURE MPI_PACK_T
        END INTERFACE MPI_PACK

        PUBLIC :: MPI_ALLGATHERV
        INTERFACE MPI_ALLGATHERV
           MODULE PROCEDURE MPI_ALLGATHERV_T
        END INTERFACE MPI_ALLGATHERV

        PUBLIC :: MPI_ALLTOALLW
        INTERFACE MPI_ALLTOALLW
           MODULE PROCEDURE MPI_ALLTOALLW_T
        END INTERFACE MPI_ALLTOALLW

        PUBLIC :: MPI_ATTR_GET
        INTERFACE MPI_ATTR_GET
           MODULE PROCEDURE MPI_ATTR_GET_T
        END INTERFACE MPI_ATTR_GET

        PUBLIC :: MPI_RPUT
        INTERFACE MPI_RPUT
           MODULE PROCEDURE MPI_RPUT_T
        END INTERFACE MPI_RPUT

        PUBLIC :: MPI_TYPE_SET_ATTR
        INTERFACE MPI_TYPE_SET_ATTR
           MODULE PROCEDURE MPI_TYPE_SET_ATTR_T
        END INTERFACE MPI_TYPE_SET_ATTR

        PUBLIC :: MPI_FILE_IREAD_AT
        INTERFACE MPI_FILE_IREAD_AT
           MODULE PROCEDURE MPI_FILE_IREAD_AT_T
        END INTERFACE MPI_FILE_IREAD_AT

        PUBLIC :: MPI_BCAST
        INTERFACE MPI_BCAST
           MODULE PROCEDURE MPI_BCAST_T
        END INTERFACE MPI_BCAST

        PUBLIC :: MPI_FILE_IWRITE
        INTERFACE MPI_FILE_IWRITE
           MODULE PROCEDURE MPI_FILE_IWRITE_T
        END INTERFACE MPI_FILE_IWRITE

        PUBLIC :: MPI_ISSEND
        INTERFACE MPI_ISSEND
           MODULE PROCEDURE MPI_ISSEND_T
        END INTERFACE MPI_ISSEND

        PUBLIC :: MPI_FILE_READ_ALL
        INTERFACE MPI_FILE_READ_ALL
           MODULE PROCEDURE MPI_FILE_READ_ALL_T
        END INTERFACE MPI_FILE_READ_ALL

        PUBLIC :: MPI_SCATTER
        INTERFACE MPI_SCATTER
           MODULE PROCEDURE MPI_SCATTER_T
        END INTERFACE MPI_SCATTER

        PUBLIC :: MPI_GATHER
        INTERFACE MPI_GATHER
           MODULE PROCEDURE MPI_GATHER_T
        END INTERFACE MPI_GATHER

        PUBLIC :: MPI_IEXSCAN
        INTERFACE MPI_IEXSCAN
           MODULE PROCEDURE MPI_IEXSCAN_T
        END INTERFACE MPI_IEXSCAN

        PUBLIC :: MPI_KEYVAL_CREATE
        INTERFACE MPI_KEYVAL_CREATE
           MODULE PROCEDURE MPI_KEYVAL_CREATE_T
        END INTERFACE MPI_KEYVAL_CREATE

        PUBLIC :: MPI_BSEND
        INTERFACE MPI_BSEND
           MODULE PROCEDURE MPI_BSEND_T
        END INTERFACE MPI_BSEND

        PUBLIC :: MPI_BUFFER_DETACH
        INTERFACE MPI_BUFFER_DETACH
           MODULE PROCEDURE MPI_BUFFER_DETACH_T
        END INTERFACE MPI_BUFFER_DETACH

        PUBLIC :: MPI_ATTR_PUT
        INTERFACE MPI_ATTR_PUT
           MODULE PROCEDURE MPI_ATTR_PUT_T
        END INTERFACE MPI_ATTR_PUT

        PUBLIC :: MPI_FILE_READ_ALL_BEGIN
        INTERFACE MPI_FILE_READ_ALL_BEGIN
           MODULE PROCEDURE MPI_FILE_READ_ALL_BEGIN_T
        END INTERFACE MPI_FILE_READ_ALL_BEGIN

        PUBLIC :: MPI_INEIGHBOR_ALLTOALLV
        INTERFACE MPI_INEIGHBOR_ALLTOALLV
           MODULE PROCEDURE MPI_INEIGHBOR_ALLTOALLV_T
        END INTERFACE MPI_INEIGHBOR_ALLTOALLV

        PUBLIC :: MPI_TYPE_CREATE_KEYVAL
        INTERFACE MPI_TYPE_CREATE_KEYVAL
           MODULE PROCEDURE MPI_TYPE_CREATE_KEYVAL_T
        END INTERFACE MPI_TYPE_CREATE_KEYVAL

        PUBLIC :: MPI_FILE_WRITE_SHARED
        INTERFACE MPI_FILE_WRITE_SHARED
           MODULE PROCEDURE MPI_FILE_WRITE_SHARED_T
        END INTERFACE MPI_FILE_WRITE_SHARED

        PUBLIC :: MPI_IBSEND
        INTERFACE MPI_IBSEND
           MODULE PROCEDURE MPI_IBSEND_T
        END INTERFACE MPI_IBSEND

        PUBLIC :: MPI_PUT
        INTERFACE MPI_PUT
           MODULE PROCEDURE MPI_PUT_T
        END INTERFACE MPI_PUT

        PUBLIC :: MPI_FINALIZE
        INTERFACE MPI_FINALIZE
           MODULE PROCEDURE MPI_FINALIZE_T
        END INTERFACE MPI_FINALIZE

        PUBLIC :: MPI_WIN_SHARED_QUERY
        INTERFACE MPI_WIN_SHARED_QUERY
           MODULE PROCEDURE MPI_WIN_SHARED_QUERY_T
        END INTERFACE MPI_WIN_SHARED_QUERY

        PUBLIC :: MPI_WIN_CREATE
        INTERFACE MPI_WIN_CREATE
           MODULE PROCEDURE MPI_WIN_CREATE_T
        END INTERFACE MPI_WIN_CREATE

        PUBLIC :: MPI_IREDUCE
        INTERFACE MPI_IREDUCE
           MODULE PROCEDURE MPI_IREDUCE_T
        END INTERFACE MPI_IREDUCE

        PUBLIC :: MPI_NEIGHBOR_ALLGATHERV
        INTERFACE MPI_NEIGHBOR_ALLGATHERV
           MODULE PROCEDURE MPI_NEIGHBOR_ALLGATHERV_T
        END INTERFACE MPI_NEIGHBOR_ALLGATHERV

        PUBLIC :: MPI_ALLTOALL
        INTERFACE MPI_ALLTOALL
           MODULE PROCEDURE MPI_ALLTOALL_T
        END INTERFACE MPI_ALLTOALL

        PUBLIC :: MPI_ISEND
        INTERFACE MPI_ISEND
           MODULE PROCEDURE MPI_ISEND_T
        END INTERFACE MPI_ISEND

        PUBLIC :: MPI_REDUCE_LOCAL
        INTERFACE MPI_REDUCE_LOCAL
           MODULE PROCEDURE MPI_REDUCE_LOCAL_T
        END INTERFACE MPI_REDUCE_LOCAL

        PUBLIC :: MPI_IGATHER
        INTERFACE MPI_IGATHER
           MODULE PROCEDURE MPI_IGATHER_T
        END INTERFACE MPI_IGATHER

        PUBLIC :: MPI_FILE_IWRITE_SHARED
        INTERFACE MPI_FILE_IWRITE_SHARED
           MODULE PROCEDURE MPI_FILE_IWRITE_SHARED_T
        END INTERFACE MPI_FILE_IWRITE_SHARED

        PUBLIC :: MPI_MRECV
        INTERFACE MPI_MRECV
           MODULE PROCEDURE MPI_MRECV_T
        END INTERFACE MPI_MRECV

        PUBLIC :: MPI_IALLTOALL
        INTERFACE MPI_IALLTOALL
           MODULE PROCEDURE MPI_IALLTOALL_T
        END INTERFACE MPI_IALLTOALL

        PUBLIC :: MPI_IALLTOALLV
        INTERFACE MPI_IALLTOALLV
           MODULE PROCEDURE MPI_IALLTOALLV_T
        END INTERFACE MPI_IALLTOALLV

        PUBLIC :: MPI_UNPACK_EXTERNAL
        INTERFACE MPI_UNPACK_EXTERNAL
           MODULE PROCEDURE MPI_UNPACK_EXTERNAL_T
        END INTERFACE MPI_UNPACK_EXTERNAL

        PUBLIC :: MPI_SSEND
        INTERFACE MPI_SSEND
           MODULE PROCEDURE MPI_SSEND_T
        END INTERFACE MPI_SSEND

        PUBLIC :: MPI_ALLGATHER
        INTERFACE MPI_ALLGATHER
           MODULE PROCEDURE MPI_ALLGATHER_T
        END INTERFACE MPI_ALLGATHER

        PUBLIC :: MPI_IRECV
        INTERFACE MPI_IRECV
           MODULE PROCEDURE MPI_IRECV_T
        END INTERFACE MPI_IRECV

        PUBLIC :: MPI_RSEND
        INTERFACE MPI_RSEND
           MODULE PROCEDURE MPI_RSEND_T
        END INTERFACE MPI_RSEND

        PUBLIC :: MPI_FILE_READ_SHARED
        INTERFACE MPI_FILE_READ_SHARED
           MODULE PROCEDURE MPI_FILE_READ_SHARED_T
        END INTERFACE MPI_FILE_READ_SHARED

        PUBLIC :: MPI_ADDRESS
        INTERFACE MPI_ADDRESS
           MODULE PROCEDURE MPI_ADDRESS_T
        END INTERFACE MPI_ADDRESS

        PUBLIC :: MPI_FILE_WRITE_ORDERED_END
        INTERFACE MPI_FILE_WRITE_ORDERED_END
           MODULE PROCEDURE MPI_FILE_WRITE_ORDERED_END_T
        END INTERFACE MPI_FILE_WRITE_ORDERED_END

        PUBLIC :: MPI_FILE_WRITE_ALL_BEGIN
        INTERFACE MPI_FILE_WRITE_ALL_BEGIN
           MODULE PROCEDURE MPI_FILE_WRITE_ALL_BEGIN_T
        END INTERFACE MPI_FILE_WRITE_ALL_BEGIN

        PUBLIC :: MPI_SENDRECV_REPLACE
        INTERFACE MPI_SENDRECV_REPLACE
           MODULE PROCEDURE MPI_SENDRECV_REPLACE_T
        END INTERFACE MPI_SENDRECV_REPLACE

        PUBLIC :: MPI_RGET
        INTERFACE MPI_RGET
           MODULE PROCEDURE MPI_RGET_T
        END INTERFACE MPI_RGET

        PUBLIC :: MPI_FETCH_AND_OP
        INTERFACE MPI_FETCH_AND_OP
           MODULE PROCEDURE MPI_FETCH_AND_OP_T
        END INTERFACE MPI_FETCH_AND_OP

        PUBLIC :: MPI_ALLTOALLV
        INTERFACE MPI_ALLTOALLV
           MODULE PROCEDURE MPI_ALLTOALLV_T
        END INTERFACE MPI_ALLTOALLV

        PUBLIC :: MPI_IALLTOALLW
        INTERFACE MPI_IALLTOALLW
           MODULE PROCEDURE MPI_IALLTOALLW_T
        END INTERFACE MPI_IALLTOALLW

        PUBLIC :: MPI_FILE_READ
        INTERFACE MPI_FILE_READ
           MODULE PROCEDURE MPI_FILE_READ_T
        END INTERFACE MPI_FILE_READ

        PUBLIC :: MPI_IREDUCE_SCATTER
        INTERFACE MPI_IREDUCE_SCATTER
           MODULE PROCEDURE MPI_IREDUCE_SCATTER_T
        END INTERFACE MPI_IREDUCE_SCATTER

        PUBLIC :: MPI_FREE_MEM
        INTERFACE MPI_FREE_MEM
           MODULE PROCEDURE MPI_FREE_MEM_T
        END INTERFACE MPI_FREE_MEM

        PUBLIC :: MPI_BUFFER_ATTACH
        INTERFACE MPI_BUFFER_ATTACH
           MODULE PROCEDURE MPI_BUFFER_ATTACH_T
        END INTERFACE MPI_BUFFER_ATTACH

        PUBLIC :: MPI_SSEND_INIT
        INTERFACE MPI_SSEND_INIT
           MODULE PROCEDURE MPI_SSEND_INIT_T
        END INTERFACE MPI_SSEND_INIT

        PUBLIC :: MPI_FILE_IREAD
        INTERFACE MPI_FILE_IREAD
           MODULE PROCEDURE MPI_FILE_IREAD_T
        END INTERFACE MPI_FILE_IREAD

        PUBLIC :: MPI_NEIGHBOR_ALLTOALLW
        INTERFACE MPI_NEIGHBOR_ALLTOALLW
           MODULE PROCEDURE MPI_NEIGHBOR_ALLTOALLW_T
        END INTERFACE MPI_NEIGHBOR_ALLTOALLW

        PUBLIC :: MPI_IALLGATHERV
        INTERFACE MPI_IALLGATHERV
           MODULE PROCEDURE MPI_IALLGATHERV_T
        END INTERFACE MPI_IALLGATHERV

        PUBLIC :: MPI_ISCATTER
        INTERFACE MPI_ISCATTER
           MODULE PROCEDURE MPI_ISCATTER_T
        END INTERFACE MPI_ISCATTER

        PUBLIC :: MPI_UNPACK
        INTERFACE MPI_UNPACK
           MODULE PROCEDURE MPI_UNPACK_T
        END INTERFACE MPI_UNPACK

        PUBLIC :: MPI_IMRECV
        INTERFACE MPI_IMRECV
           MODULE PROCEDURE MPI_IMRECV_T
        END INTERFACE MPI_IMRECV

        PUBLIC :: MPI_GREQUEST_START
        INTERFACE MPI_GREQUEST_START
           MODULE PROCEDURE MPI_GREQUEST_START_T
        END INTERFACE MPI_GREQUEST_START

        PUBLIC :: MPI_REGISTER_DATAREP
        INTERFACE MPI_REGISTER_DATAREP
           MODULE PROCEDURE MPI_REGISTER_DATAREP_T
        END INTERFACE MPI_REGISTER_DATAREP

        PUBLIC :: MPI_ISCAN
        INTERFACE MPI_ISCAN
           MODULE PROCEDURE MPI_ISCAN_T
        END INTERFACE MPI_ISCAN

        PUBLIC :: MPI_FILE_WRITE_AT_ALL_BEGIN
        INTERFACE MPI_FILE_WRITE_AT_ALL_BEGIN
           MODULE PROCEDURE MPI_FILE_WRITE_AT_ALL_BEGIN_T
        END INTERFACE MPI_FILE_WRITE_AT_ALL_BEGIN

        PUBLIC :: MPI_INEIGHBOR_ALLGATHER
        INTERFACE MPI_INEIGHBOR_ALLGATHER
           MODULE PROCEDURE MPI_INEIGHBOR_ALLGATHER_T
        END INTERFACE MPI_INEIGHBOR_ALLGATHER

        PUBLIC :: MPI_EXSCAN
        INTERFACE MPI_EXSCAN
           MODULE PROCEDURE MPI_EXSCAN_T
        END INTERFACE MPI_EXSCAN

        PUBLIC :: MPI_SCATTERV
        INTERFACE MPI_SCATTERV
           MODULE PROCEDURE MPI_SCATTERV_T
        END INTERFACE MPI_SCATTERV

        PUBLIC :: MPI_SCAN
        INTERFACE MPI_SCAN
           MODULE PROCEDURE MPI_SCAN_T
        END INTERFACE MPI_SCAN

        PUBLIC :: MPI_FILE_READ_AT
        INTERFACE MPI_FILE_READ_AT
           MODULE PROCEDURE MPI_FILE_READ_AT_T
        END INTERFACE MPI_FILE_READ_AT

        PUBLIC :: MPI_WIN_ALLOCATE_SHARED
        INTERFACE MPI_WIN_ALLOCATE_SHARED
           MODULE PROCEDURE MPI_WIN_ALLOCATE_SHARED_T
        END INTERFACE MPI_WIN_ALLOCATE_SHARED

        PUBLIC :: MPI_RSEND_INIT
        INTERFACE MPI_RSEND_INIT
           MODULE PROCEDURE MPI_RSEND_INIT_T
        END INTERFACE MPI_RSEND_INIT

        PUBLIC :: MPI_REDUCE_SCATTER_BLOCK
        INTERFACE MPI_REDUCE_SCATTER_BLOCK
           MODULE PROCEDURE MPI_REDUCE_SCATTER_BLOCK_T
        END INTERFACE MPI_REDUCE_SCATTER_BLOCK

        PUBLIC :: MPI_GATHERV
        INTERFACE MPI_GATHERV
           MODULE PROCEDURE MPI_GATHERV_T
        END INTERFACE MPI_GATHERV

        PUBLIC :: MPI_WIN_GET_ATTR
        INTERFACE MPI_WIN_GET_ATTR
           MODULE PROCEDURE MPI_WIN_GET_ATTR_T
        END INTERFACE MPI_WIN_GET_ATTR

        PUBLIC :: MPI_SEND_INIT
        INTERFACE MPI_SEND_INIT
           MODULE PROCEDURE MPI_SEND_INIT_T
        END INTERFACE MPI_SEND_INIT

        PUBLIC :: MPI_COMM_SET_ATTR
        INTERFACE MPI_COMM_SET_ATTR
           MODULE PROCEDURE MPI_COMM_SET_ATTR_T
        END INTERFACE MPI_COMM_SET_ATTR

        PUBLIC :: MPI_IALLGATHER
        INTERFACE MPI_IALLGATHER
           MODULE PROCEDURE MPI_IALLGATHER_T
        END INTERFACE MPI_IALLGATHER

        PUBLIC :: MPI_ACCUMULATE
        INTERFACE MPI_ACCUMULATE
           MODULE PROCEDURE MPI_ACCUMULATE_T
        END INTERFACE MPI_ACCUMULATE

        PUBLIC :: MPI_COMM_CREATE_KEYVAL
        INTERFACE MPI_COMM_CREATE_KEYVAL
           MODULE PROCEDURE MPI_COMM_CREATE_KEYVAL_T
        END INTERFACE MPI_COMM_CREATE_KEYVAL

        PUBLIC :: MPI_RACCUMULATE
        INTERFACE MPI_RACCUMULATE
           MODULE PROCEDURE MPI_RACCUMULATE_T
        END INTERFACE MPI_RACCUMULATE

        PUBLIC :: MPI_IRSEND
        INTERFACE MPI_IRSEND
           MODULE PROCEDURE MPI_IRSEND_T
        END INTERFACE MPI_IRSEND

        PUBLIC :: MPI_RECV_INIT
        INTERFACE MPI_RECV_INIT
           MODULE PROCEDURE MPI_RECV_INIT_T
        END INTERFACE MPI_RECV_INIT

        PUBLIC :: MPI_COMPARE_AND_SWAP
        INTERFACE MPI_COMPARE_AND_SWAP
           MODULE PROCEDURE MPI_COMPARE_AND_SWAP_T
        END INTERFACE MPI_COMPARE_AND_SWAP

        PUBLIC :: MPI_INEIGHBOR_ALLGATHERV
        INTERFACE MPI_INEIGHBOR_ALLGATHERV
           MODULE PROCEDURE MPI_INEIGHBOR_ALLGATHERV_T
        END INTERFACE MPI_INEIGHBOR_ALLGATHERV

        PUBLIC :: MPI_FILE_WRITE_AT_ALL
        INTERFACE MPI_FILE_WRITE_AT_ALL
           MODULE PROCEDURE MPI_FILE_WRITE_AT_ALL_T
        END INTERFACE MPI_FILE_WRITE_AT_ALL

        PUBLIC :: MPI_INEIGHBOR_ALLTOALLW
        INTERFACE MPI_INEIGHBOR_ALLTOALLW
           MODULE PROCEDURE MPI_INEIGHBOR_ALLTOALLW_T
        END INTERFACE MPI_INEIGHBOR_ALLTOALLW

        PUBLIC :: MPI_ISCATTERV
        INTERFACE MPI_ISCATTERV
           MODULE PROCEDURE MPI_ISCATTERV_T
        END INTERFACE MPI_ISCATTERV

        CONTAINS

        SUBROUTINE MPI_FILE_READ_AT_ALL_BEGIN_T(v0,v1,v2,v3,v4,ierror)
        INTEGER v0
        INTEGER(KIND=MPI_OFFSET_KIND) v1
        <type> v2<dims>
        INTEGER v3
        INTEGER v4
        INTEGER ierror
        EXTERNAL MPI_FILE_READ_AT_ALL_BEGIN
        CALL MPI_FILE_READ_AT_ALL_BEGIN(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_FILE_READ_AT_ALL_BEGIN_T

        SUBROUTINE MPI_IREDUCE_SCATTER_BLOCK_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        <type1> v1<dims1>
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_IREDUCE_SCATTER_BLOCK
        CALL MPI_IREDUCE_SCATTER_BLOCK(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_IREDUCE_SCATTER_BLOCK_T

        SUBROUTINE MPI_WIN_ATTACH_T(v0,v1,v2,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER(KIND=MPI_ADDRESS_KIND) v2
        INTEGER ierror
        EXTERNAL MPI_WIN_ATTACH
        CALL MPI_WIN_ATTACH(v0,v1,v2,ierror)
        END SUBROUTINE MPI_WIN_ATTACH_T

        SUBROUTINE MPI_INEIGHBOR_ALLTOALL_T(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER v7
        INTEGER ierror
        EXTERNAL MPI_INEIGHBOR_ALLTOALL
        CALL MPI_INEIGHBOR_ALLTOALL(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        END SUBROUTINE MPI_INEIGHBOR_ALLTOALL_T

        SUBROUTINE MPI_ALLREDUCE_T(v0,v1,v2,v3,v4,v5,ierror)
        <type> v0<dims>
        <type1> v1<dims1>
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER ierror
        EXTERNAL MPI_ALLREDUCE
        CALL MPI_ALLREDUCE(v0,v1,v2,v3,v4,v5,ierror)
        END SUBROUTINE MPI_ALLREDUCE_T

        SUBROUTINE MPI_SENDRECV_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        <type1> v5<dims1>
        INTEGER v6
        INTEGER v7
        INTEGER v8
        INTEGER v9
        INTEGER v10
        INTEGER v11(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_SENDRECV
        CALL MPI_SENDRECV(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,ierror)
        END SUBROUTINE MPI_SENDRECV_T

        SUBROUTINE MPI_NEIGHBOR_ALLTOALLV_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        <type> v0<dims>
        INTEGER v1(*)
        INTEGER v2(*)
        INTEGER v3
        <type1> v4<dims1>
        INTEGER v5(*)
        INTEGER v6(*)
        INTEGER v7
        INTEGER v8
        INTEGER ierror
        EXTERNAL MPI_NEIGHBOR_ALLTOALLV
        CALL MPI_NEIGHBOR_ALLTOALLV(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        END SUBROUTINE MPI_NEIGHBOR_ALLTOALLV_T

        SUBROUTINE MPI_NEIGHBOR_ALLTOALL_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_NEIGHBOR_ALLTOALL
        CALL MPI_NEIGHBOR_ALLTOALL(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_NEIGHBOR_ALLTOALL_T

        SUBROUTINE MPI_FILE_READ_ORDERED_T(v0,v1,v2,v3,v4,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2
        INTEGER v3
        INTEGER v4(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_FILE_READ_ORDERED
        CALL MPI_FILE_READ_ORDERED(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_FILE_READ_ORDERED_T

        SUBROUTINE MPI_TYPE_GET_ATTR_T(v0,v1,v2,v3,ierror)
        INTEGER v0
        INTEGER v1
        <type> v2<dims>
        LOGICAL v3
        INTEGER ierror
        EXTERNAL MPI_TYPE_GET_ATTR
        CALL MPI_TYPE_GET_ATTR(v0,v1,v2,v3,ierror)
        END SUBROUTINE MPI_TYPE_GET_ATTR_T

        SUBROUTINE MPI_RGET_ACCUMULATE_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER(KIND=MPI_ADDRESS_KIND) v7
        INTEGER v8
        INTEGER v9
        INTEGER v10
        INTEGER v11
        INTEGER v12
        INTEGER ierror
        EXTERNAL MPI_RGET_ACCUMULATE
        CALL MPI_RGET_ACCUMULATE(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,ierror)
        END SUBROUTINE MPI_RGET_ACCUMULATE_T

        SUBROUTINE MPI_IBCAST_T(v0,v1,v2,v3,v4,v5,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER ierror
        EXTERNAL MPI_IBCAST
        CALL MPI_IBCAST(v0,v1,v2,v3,v4,v5,ierror)
        END SUBROUTINE MPI_IBCAST_T

        SUBROUTINE MPI_FILE_READ_ORDERED_END_T(v0,v1,v2,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_FILE_READ_ORDERED_END
        CALL MPI_FILE_READ_ORDERED_END(v0,v1,v2,ierror)
        END SUBROUTINE MPI_FILE_READ_ORDERED_END_T

        SUBROUTINE MPI_WIN_DETACH_T(v0,v1,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER ierror
        EXTERNAL MPI_WIN_DETACH
        CALL MPI_WIN_DETACH(v0,v1,ierror)
        END SUBROUTINE MPI_WIN_DETACH_T

        SUBROUTINE MPI_SEND_T(v0,v1,v2,v3,v4,v5,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER ierror
        EXTERNAL MPI_SEND
        CALL MPI_SEND(v0,v1,v2,v3,v4,v5,ierror)
        END SUBROUTINE MPI_SEND_T

        SUBROUTINE MPI_FILE_WRITE_T(v0,v1,v2,v3,v4,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2
        INTEGER v3
        INTEGER v4(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_FILE_WRITE
        CALL MPI_FILE_WRITE(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_FILE_WRITE_T

        SUBROUTINE MPI_FILE_WRITE_ORDERED_BEGIN_T(v0,v1,v2,v3,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2
        INTEGER v3
        INTEGER ierror
        EXTERNAL MPI_FILE_WRITE_ORDERED_BEGIN
        CALL MPI_FILE_WRITE_ORDERED_BEGIN(v0,v1,v2,v3,ierror)
        END SUBROUTINE MPI_FILE_WRITE_ORDERED_BEGIN_T

        SUBROUTINE MPI_PACK_EXTERNAL_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        CHARACTER (LEN=*) v0
        <type> v1<dims>
        INTEGER v2
        INTEGER v3
        <type1> v4<dims1>
        INTEGER(KIND=MPI_ADDRESS_KIND) v5
        INTEGER(KIND=MPI_ADDRESS_KIND) v6
        INTEGER ierror
        EXTERNAL MPI_PACK_EXTERNAL
        CALL MPI_PACK_EXTERNAL(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_PACK_EXTERNAL_T

        SUBROUTINE MPI_WIN_CREATE_KEYVAL_T(v0,v1,v2,v3,ierror)
        EXTERNAL v0
        EXTERNAL v1
        INTEGER v2
        <type> v3<dims>
        INTEGER ierror
        EXTERNAL MPI_WIN_CREATE_KEYVAL
        CALL MPI_WIN_CREATE_KEYVAL(v0,v1,v2,v3,ierror)
        END SUBROUTINE MPI_WIN_CREATE_KEYVAL_T

        SUBROUTINE MPI_FILE_WRITE_ALL_END_T(v0,v1,v2,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_FILE_WRITE_ALL_END
        CALL MPI_FILE_WRITE_ALL_END(v0,v1,v2,ierror)
        END SUBROUTINE MPI_FILE_WRITE_ALL_END_T

        SUBROUTINE MPI_FILE_READ_ORDERED_BEGIN_T(v0,v1,v2,v3,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2
        INTEGER v3
        INTEGER ierror
        EXTERNAL MPI_FILE_READ_ORDERED_BEGIN
        CALL MPI_FILE_READ_ORDERED_BEGIN(v0,v1,v2,v3,ierror)
        END SUBROUTINE MPI_FILE_READ_ORDERED_BEGIN_T

        SUBROUTINE MPI_BSEND_INIT_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_BSEND_INIT
        CALL MPI_BSEND_INIT(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_BSEND_INIT_T

        SUBROUTINE MPI_FILE_WRITE_AT_ALL_END_T(v0,v1,v2,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_FILE_WRITE_AT_ALL_END
        CALL MPI_FILE_WRITE_AT_ALL_END(v0,v1,v2,ierror)
        END SUBROUTINE MPI_FILE_WRITE_AT_ALL_END_T

        SUBROUTINE MPI_COMM_GET_ATTR_T(v0,v1,v2,v3,ierror)
        INTEGER v0
        INTEGER v1
        <type> v2<dims>
        LOGICAL v3
        INTEGER ierror
        EXTERNAL MPI_COMM_GET_ATTR
        CALL MPI_COMM_GET_ATTR(v0,v1,v2,v3,ierror)
        END SUBROUTINE MPI_COMM_GET_ATTR_T

        SUBROUTINE MPI_FILE_IWRITE_AT_T(v0,v1,v2,v3,v4,v5,ierror)
        INTEGER v0
        INTEGER(KIND=MPI_OFFSET_KIND) v1
        <type> v2<dims>
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER ierror
        EXTERNAL MPI_FILE_IWRITE_AT
        CALL MPI_FILE_IWRITE_AT(v0,v1,v2,v3,v4,v5,ierror)
        END SUBROUTINE MPI_FILE_IWRITE_AT_T

        SUBROUTINE MPI_FILE_WRITE_ALL_T(v0,v1,v2,v3,v4,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2
        INTEGER v3
        INTEGER v4(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_FILE_WRITE_ALL
        CALL MPI_FILE_WRITE_ALL(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_FILE_WRITE_ALL_T

        SUBROUTINE MPI_REDUCE_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        <type1> v1<dims1>
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_REDUCE
        CALL MPI_REDUCE(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_REDUCE_T

        SUBROUTINE MPI_WIN_SET_ATTR_T(v0,v1,v2,ierror)
        INTEGER v0
        INTEGER v1
        <type> v2<dims>
        INTEGER ierror
        EXTERNAL MPI_WIN_SET_ATTR
        CALL MPI_WIN_SET_ATTR(v0,v1,v2,ierror)
        END SUBROUTINE MPI_WIN_SET_ATTR_T

        SUBROUTINE MPI_FILE_WRITE_ORDERED_T(v0,v1,v2,v3,v4,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2
        INTEGER v3
        INTEGER v4(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_FILE_WRITE_ORDERED
        CALL MPI_FILE_WRITE_ORDERED(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_FILE_WRITE_ORDERED_T

        SUBROUTINE MPI_FILE_READ_ALL_END_T(v0,v1,v2,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_FILE_READ_ALL_END
        CALL MPI_FILE_READ_ALL_END(v0,v1,v2,ierror)
        END SUBROUTINE MPI_FILE_READ_ALL_END_T

        SUBROUTINE MPI_GET_ACCUMULATE_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER(KIND=MPI_ADDRESS_KIND) v7
        INTEGER v8
        INTEGER v9
        INTEGER v10
        INTEGER v11
        INTEGER ierror
        EXTERNAL MPI_GET_ACCUMULATE
        CALL MPI_GET_ACCUMULATE(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,ierror)
        END SUBROUTINE MPI_GET_ACCUMULATE_T

        SUBROUTINE MPI_RECV_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER v6(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_RECV
        CALL MPI_RECV(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_RECV_T

        SUBROUTINE MPI_GET_T(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER(KIND=MPI_ADDRESS_KIND) v4
        INTEGER v5
        INTEGER v6
        INTEGER v7
        INTEGER ierror
        EXTERNAL MPI_GET
        CALL MPI_GET(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        END SUBROUTINE MPI_GET_T

        SUBROUTINE MPI_WIN_ALLOCATE_T(v0,v1,v2,v3,v4,v5,ierror)
        INTEGER(KIND=MPI_ADDRESS_KIND) v0
        INTEGER v1
        INTEGER v2
        INTEGER v3
        <type> v4<dims>
        INTEGER v5
        INTEGER ierror
        EXTERNAL MPI_WIN_ALLOCATE
        CALL MPI_WIN_ALLOCATE(v0,v1,v2,v3,v4,v5,ierror)
        END SUBROUTINE MPI_WIN_ALLOCATE_T

        SUBROUTINE MPI_FILE_READ_AT_ALL_END_T(v0,v1,v2,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_FILE_READ_AT_ALL_END
        CALL MPI_FILE_READ_AT_ALL_END(v0,v1,v2,ierror)
        END SUBROUTINE MPI_FILE_READ_AT_ALL_END_T

        SUBROUTINE MPI_ALLOC_MEM_T(v0,v1,v2,ierror)
        INTEGER(KIND=MPI_ADDRESS_KIND) v0
        INTEGER v1
        <type> v2<dims>
        INTEGER ierror
        EXTERNAL MPI_ALLOC_MEM
        CALL MPI_ALLOC_MEM(v0,v1,v2,ierror)
        END SUBROUTINE MPI_ALLOC_MEM_T

        SUBROUTINE MPI_REDUCE_SCATTER_T(v0,v1,v2,v3,v4,v5,ierror)
        <type> v0<dims>
        <type1> v1<dims1>
        INTEGER v2(*)
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER ierror
        EXTERNAL MPI_REDUCE_SCATTER
        CALL MPI_REDUCE_SCATTER(v0,v1,v2,v3,v4,v5,ierror)
        END SUBROUTINE MPI_REDUCE_SCATTER_T

        SUBROUTINE MPI_FILE_READ_AT_ALL_T(v0,v1,v2,v3,v4,v5,ierror)
        INTEGER v0
        INTEGER(KIND=MPI_OFFSET_KIND) v1
        <type> v2<dims>
        INTEGER v3
        INTEGER v4
        INTEGER v5(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_FILE_READ_AT_ALL
        CALL MPI_FILE_READ_AT_ALL(v0,v1,v2,v3,v4,v5,ierror)
        END SUBROUTINE MPI_FILE_READ_AT_ALL_T

        SUBROUTINE MPI_IALLREDUCE_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        <type1> v1<dims1>
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_IALLREDUCE
        CALL MPI_IALLREDUCE(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_IALLREDUCE_T

        SUBROUTINE MPI_GET_ADDRESS_T(v0,v1,ierror)
        <type> v0<dims>
        INTEGER(KIND=MPI_ADDRESS_KIND) v1
        INTEGER ierror
        EXTERNAL MPI_GET_ADDRESS
        CALL MPI_GET_ADDRESS(v0,v1,ierror)
        END SUBROUTINE MPI_GET_ADDRESS_T

        SUBROUTINE MPI_IGATHERV_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4(*)
        INTEGER v5(*)
        INTEGER v6
        INTEGER v7
        INTEGER v8
        INTEGER v9
        INTEGER ierror
        EXTERNAL MPI_IGATHERV
        CALL MPI_IGATHERV(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,ierror)
        END SUBROUTINE MPI_IGATHERV_T

        SUBROUTINE MPI_FILE_IREAD_SHARED_T(v0,v1,v2,v3,v4,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER ierror
        EXTERNAL MPI_FILE_IREAD_SHARED
        CALL MPI_FILE_IREAD_SHARED(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_FILE_IREAD_SHARED_T

        SUBROUTINE MPI_FILE_WRITE_AT_T(v0,v1,v2,v3,v4,v5,ierror)
        INTEGER v0
        INTEGER(KIND=MPI_OFFSET_KIND) v1
        <type> v2<dims>
        INTEGER v3
        INTEGER v4
        INTEGER v5(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_FILE_WRITE_AT
        CALL MPI_FILE_WRITE_AT(v0,v1,v2,v3,v4,v5,ierror)
        END SUBROUTINE MPI_FILE_WRITE_AT_T

        SUBROUTINE MPI_NEIGHBOR_ALLGATHER_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_NEIGHBOR_ALLGATHER
        CALL MPI_NEIGHBOR_ALLGATHER(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_NEIGHBOR_ALLGATHER_T

        SUBROUTINE MPI_PACK_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_PACK
        CALL MPI_PACK(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_PACK_T

        SUBROUTINE MPI_ALLGATHERV_T(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4(*)
        INTEGER v5(*)
        INTEGER v6
        INTEGER v7
        INTEGER ierror
        EXTERNAL MPI_ALLGATHERV
        CALL MPI_ALLGATHERV(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        END SUBROUTINE MPI_ALLGATHERV_T

        SUBROUTINE MPI_ALLTOALLW_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        <type> v0<dims>
        INTEGER v1(*)
        INTEGER v2(*)
        INTEGER v3(*)
        <type1> v4<dims1>
        INTEGER v5(*)
        INTEGER v6(*)
        INTEGER v7(*)
        INTEGER v8
        INTEGER ierror
        EXTERNAL MPI_ALLTOALLW
        CALL MPI_ALLTOALLW(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        END SUBROUTINE MPI_ALLTOALLW_T

        SUBROUTINE MPI_ATTR_GET_T(v0,v1,v2,v3,ierror)
        INTEGER v0
        INTEGER v1
        <type> v2<dims>
        LOGICAL v3
        INTEGER ierror
        EXTERNAL MPI_ATTR_GET
        CALL MPI_ATTR_GET(v0,v1,v2,v3,ierror)
        END SUBROUTINE MPI_ATTR_GET_T

        SUBROUTINE MPI_RPUT_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER(KIND=MPI_ADDRESS_KIND) v4
        INTEGER v5
        INTEGER v6
        INTEGER v7
        INTEGER v8
        INTEGER ierror
        EXTERNAL MPI_RPUT
        CALL MPI_RPUT(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        END SUBROUTINE MPI_RPUT_T

        SUBROUTINE MPI_TYPE_SET_ATTR_T(v0,v1,v2,ierror)
        INTEGER v0
        INTEGER v1
        <type> v2<dims>
        INTEGER ierror
        EXTERNAL MPI_TYPE_SET_ATTR
        CALL MPI_TYPE_SET_ATTR(v0,v1,v2,ierror)
        END SUBROUTINE MPI_TYPE_SET_ATTR_T

        SUBROUTINE MPI_FILE_IREAD_AT_T(v0,v1,v2,v3,v4,v5,ierror)
        INTEGER v0
        INTEGER(KIND=MPI_OFFSET_KIND) v1
        <type> v2<dims>
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER ierror
        EXTERNAL MPI_FILE_IREAD_AT
        CALL MPI_FILE_IREAD_AT(v0,v1,v2,v3,v4,v5,ierror)
        END SUBROUTINE MPI_FILE_IREAD_AT_T

        SUBROUTINE MPI_BCAST_T(v0,v1,v2,v3,v4,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER ierror
        EXTERNAL MPI_BCAST
        CALL MPI_BCAST(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_BCAST_T

        SUBROUTINE MPI_FILE_IWRITE_T(v0,v1,v2,v3,v4,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER ierror
        EXTERNAL MPI_FILE_IWRITE
        CALL MPI_FILE_IWRITE(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_FILE_IWRITE_T

        SUBROUTINE MPI_ISSEND_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_ISSEND
        CALL MPI_ISSEND(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_ISSEND_T

        SUBROUTINE MPI_FILE_READ_ALL_T(v0,v1,v2,v3,v4,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2
        INTEGER v3
        INTEGER v4(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_FILE_READ_ALL
        CALL MPI_FILE_READ_ALL(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_FILE_READ_ALL_T

        SUBROUTINE MPI_SCATTER_T(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER v7
        INTEGER ierror
        EXTERNAL MPI_SCATTER
        CALL MPI_SCATTER(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        END SUBROUTINE MPI_SCATTER_T

        SUBROUTINE MPI_GATHER_T(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER v7
        INTEGER ierror
        EXTERNAL MPI_GATHER
        CALL MPI_GATHER(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        END SUBROUTINE MPI_GATHER_T

        SUBROUTINE MPI_IEXSCAN_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        <type1> v1<dims1>
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_IEXSCAN
        CALL MPI_IEXSCAN(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_IEXSCAN_T

        SUBROUTINE MPI_KEYVAL_CREATE_T(v0,v1,v2,v3,ierror)
        EXTERNAL v0
        EXTERNAL v1
        INTEGER v2
        <type> v3<dims>
        INTEGER ierror
        EXTERNAL MPI_KEYVAL_CREATE
        CALL MPI_KEYVAL_CREATE(v0,v1,v2,v3,ierror)
        END SUBROUTINE MPI_KEYVAL_CREATE_T

        SUBROUTINE MPI_BSEND_T(v0,v1,v2,v3,v4,v5,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER ierror
        EXTERNAL MPI_BSEND
        CALL MPI_BSEND(v0,v1,v2,v3,v4,v5,ierror)
        END SUBROUTINE MPI_BSEND_T

        SUBROUTINE MPI_BUFFER_DETACH_T(v0,v1,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER ierror
        EXTERNAL MPI_BUFFER_DETACH
        CALL MPI_BUFFER_DETACH(v0,v1,ierror)
        END SUBROUTINE MPI_BUFFER_DETACH_T

        SUBROUTINE MPI_ATTR_PUT_T(v0,v1,v2,ierror)
        INTEGER v0
        INTEGER v1
        <type> v2<dims>
        INTEGER ierror
        EXTERNAL MPI_ATTR_PUT
        CALL MPI_ATTR_PUT(v0,v1,v2,ierror)
        END SUBROUTINE MPI_ATTR_PUT_T

        SUBROUTINE MPI_FILE_READ_ALL_BEGIN_T(v0,v1,v2,v3,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2
        INTEGER v3
        INTEGER ierror
        EXTERNAL MPI_FILE_READ_ALL_BEGIN
        CALL MPI_FILE_READ_ALL_BEGIN(v0,v1,v2,v3,ierror)
        END SUBROUTINE MPI_FILE_READ_ALL_BEGIN_T

        SUBROUTINE MPI_INEIGHBOR_ALLTOALLV_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,ierror)
        <type> v0<dims>
        INTEGER v1(*)
        INTEGER v2(*)
        INTEGER v3
        <type1> v4<dims1>
        INTEGER v5(*)
        INTEGER v6(*)
        INTEGER v7
        INTEGER v8
        INTEGER v9
        INTEGER ierror
        EXTERNAL MPI_INEIGHBOR_ALLTOALLV
        CALL MPI_INEIGHBOR_ALLTOALLV(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,ierror)
        END SUBROUTINE MPI_INEIGHBOR_ALLTOALLV_T

        SUBROUTINE MPI_TYPE_CREATE_KEYVAL_T(v0,v1,v2,v3,ierror)
        EXTERNAL v0
        EXTERNAL v1
        INTEGER v2
        <type> v3<dims>
        INTEGER ierror
        EXTERNAL MPI_TYPE_CREATE_KEYVAL
        CALL MPI_TYPE_CREATE_KEYVAL(v0,v1,v2,v3,ierror)
        END SUBROUTINE MPI_TYPE_CREATE_KEYVAL_T

        SUBROUTINE MPI_FILE_WRITE_SHARED_T(v0,v1,v2,v3,v4,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2
        INTEGER v3
        INTEGER v4(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_FILE_WRITE_SHARED
        CALL MPI_FILE_WRITE_SHARED(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_FILE_WRITE_SHARED_T

        SUBROUTINE MPI_IBSEND_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_IBSEND
        CALL MPI_IBSEND(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_IBSEND_T

        SUBROUTINE MPI_PUT_T(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER(KIND=MPI_ADDRESS_KIND) v4
        INTEGER v5
        INTEGER v6
        INTEGER v7
        INTEGER ierror
        EXTERNAL MPI_PUT
        CALL MPI_PUT(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        END SUBROUTINE MPI_PUT_T

        SUBROUTINE MPI_FINALIZE_T(v0,ierror)
        <type> v0<dims>
        INTEGER ierror
        EXTERNAL MPI_FINALIZE
        CALL MPI_FINALIZE(v0,ierror)
        END SUBROUTINE MPI_FINALIZE_T

        SUBROUTINE MPI_WIN_SHARED_QUERY_T(v0,v1,v2,v3,v4,ierror)
        INTEGER v0
        INTEGER v1
        INTEGER(KIND=MPI_ADDRESS_KIND) v2
        INTEGER v3
        <type> v4<dims>
        INTEGER ierror
        EXTERNAL MPI_WIN_SHARED_QUERY
        CALL MPI_WIN_SHARED_QUERY(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_WIN_SHARED_QUERY_T

        SUBROUTINE MPI_WIN_CREATE_T(v0,v1,v2,v3,v4,v5,ierror)
        <type> v0<dims>
        INTEGER(KIND=MPI_ADDRESS_KIND) v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER ierror
        EXTERNAL MPI_WIN_CREATE
        CALL MPI_WIN_CREATE(v0,v1,v2,v3,v4,v5,ierror)
        END SUBROUTINE MPI_WIN_CREATE_T

        SUBROUTINE MPI_IREDUCE_T(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        <type> v0<dims>
        <type1> v1<dims1>
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER v7
        INTEGER ierror
        EXTERNAL MPI_IREDUCE
        CALL MPI_IREDUCE(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        END SUBROUTINE MPI_IREDUCE_T

        SUBROUTINE MPI_NEIGHBOR_ALLGATHERV_T(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4(*)
        INTEGER v5(*)
        INTEGER v6
        INTEGER v7
        INTEGER ierror
        EXTERNAL MPI_NEIGHBOR_ALLGATHERV
        CALL MPI_NEIGHBOR_ALLGATHERV(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        END SUBROUTINE MPI_NEIGHBOR_ALLGATHERV_T

        SUBROUTINE MPI_ALLTOALL_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_ALLTOALL
        CALL MPI_ALLTOALL(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_ALLTOALL_T

        SUBROUTINE MPI_ISEND_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_ISEND
        CALL MPI_ISEND(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_ISEND_T

        SUBROUTINE MPI_REDUCE_LOCAL_T(v0,v1,v2,v3,v4,ierror)
        <type> v0<dims>
        <type1> v1<dims1>
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER ierror
        EXTERNAL MPI_REDUCE_LOCAL
        CALL MPI_REDUCE_LOCAL(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_REDUCE_LOCAL_T

        SUBROUTINE MPI_IGATHER_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER v7
        INTEGER v8
        INTEGER ierror
        EXTERNAL MPI_IGATHER
        CALL MPI_IGATHER(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        END SUBROUTINE MPI_IGATHER_T

        SUBROUTINE MPI_FILE_IWRITE_SHARED_T(v0,v1,v2,v3,v4,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER ierror
        EXTERNAL MPI_FILE_IWRITE_SHARED
        CALL MPI_FILE_IWRITE_SHARED(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_FILE_IWRITE_SHARED_T

        SUBROUTINE MPI_MRECV_T(v0,v1,v2,v3,v4,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_MRECV
        CALL MPI_MRECV(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_MRECV_T

        SUBROUTINE MPI_IALLTOALL_T(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER v7
        INTEGER ierror
        EXTERNAL MPI_IALLTOALL
        CALL MPI_IALLTOALL(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        END SUBROUTINE MPI_IALLTOALL_T

        SUBROUTINE MPI_IALLTOALLV_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,ierror)
        <type> v0<dims>
        INTEGER v1(*)
        INTEGER v2(*)
        INTEGER v3
        <type1> v4<dims1>
        INTEGER v5(*)
        INTEGER v6(*)
        INTEGER v7
        INTEGER v8
        INTEGER v9
        INTEGER ierror
        EXTERNAL MPI_IALLTOALLV
        CALL MPI_IALLTOALLV(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,ierror)
        END SUBROUTINE MPI_IALLTOALLV_T

        SUBROUTINE MPI_UNPACK_EXTERNAL_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        CHARACTER (LEN=*) v0
        <type> v1<dims>
        INTEGER(KIND=MPI_ADDRESS_KIND) v2
        INTEGER(KIND=MPI_ADDRESS_KIND) v3
        <type1> v4<dims1>
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_UNPACK_EXTERNAL
        CALL MPI_UNPACK_EXTERNAL(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_UNPACK_EXTERNAL_T

        SUBROUTINE MPI_SSEND_T(v0,v1,v2,v3,v4,v5,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER ierror
        EXTERNAL MPI_SSEND
        CALL MPI_SSEND(v0,v1,v2,v3,v4,v5,ierror)
        END SUBROUTINE MPI_SSEND_T

        SUBROUTINE MPI_ALLGATHER_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_ALLGATHER
        CALL MPI_ALLGATHER(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_ALLGATHER_T

        SUBROUTINE MPI_IRECV_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_IRECV
        CALL MPI_IRECV(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_IRECV_T

        SUBROUTINE MPI_RSEND_T(v0,v1,v2,v3,v4,v5,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER ierror
        EXTERNAL MPI_RSEND
        CALL MPI_RSEND(v0,v1,v2,v3,v4,v5,ierror)
        END SUBROUTINE MPI_RSEND_T

        SUBROUTINE MPI_FILE_READ_SHARED_T(v0,v1,v2,v3,v4,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2
        INTEGER v3
        INTEGER v4(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_FILE_READ_SHARED
        CALL MPI_FILE_READ_SHARED(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_FILE_READ_SHARED_T

        SUBROUTINE MPI_ADDRESS_T(v0,v1,ierror)
        <type> v0<dims>
        INTEGER(KIND=MPI_ADDRESS_KIND) v1
        INTEGER ierror
        EXTERNAL MPI_ADDRESS
        CALL MPI_ADDRESS(v0,v1,ierror)
        END SUBROUTINE MPI_ADDRESS_T

        SUBROUTINE MPI_FILE_WRITE_ORDERED_END_T(v0,v1,v2,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_FILE_WRITE_ORDERED_END
        CALL MPI_FILE_WRITE_ORDERED_END(v0,v1,v2,ierror)
        END SUBROUTINE MPI_FILE_WRITE_ORDERED_END_T

        SUBROUTINE MPI_FILE_WRITE_ALL_BEGIN_T(v0,v1,v2,v3,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2
        INTEGER v3
        INTEGER ierror
        EXTERNAL MPI_FILE_WRITE_ALL_BEGIN
        CALL MPI_FILE_WRITE_ALL_BEGIN(v0,v1,v2,v3,ierror)
        END SUBROUTINE MPI_FILE_WRITE_ALL_BEGIN_T

        SUBROUTINE MPI_SENDRECV_REPLACE_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER v7
        INTEGER v8(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_SENDRECV_REPLACE
        CALL MPI_SENDRECV_REPLACE(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        END SUBROUTINE MPI_SENDRECV_REPLACE_T

        SUBROUTINE MPI_RGET_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER(KIND=MPI_ADDRESS_KIND) v4
        INTEGER v5
        INTEGER v6
        INTEGER v7
        INTEGER v8
        INTEGER ierror
        EXTERNAL MPI_RGET
        CALL MPI_RGET(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        END SUBROUTINE MPI_RGET_T

        SUBROUTINE MPI_FETCH_AND_OP_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        <type1> v1<dims1>
        INTEGER v2
        INTEGER v3
        INTEGER(KIND=MPI_ADDRESS_KIND) v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_FETCH_AND_OP
        CALL MPI_FETCH_AND_OP(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_FETCH_AND_OP_T

        SUBROUTINE MPI_ALLTOALLV_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        <type> v0<dims>
        INTEGER v1(*)
        INTEGER v2(*)
        INTEGER v3
        <type1> v4<dims1>
        INTEGER v5(*)
        INTEGER v6(*)
        INTEGER v7
        INTEGER v8
        INTEGER ierror
        EXTERNAL MPI_ALLTOALLV
        CALL MPI_ALLTOALLV(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        END SUBROUTINE MPI_ALLTOALLV_T

        SUBROUTINE MPI_IALLTOALLW_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,ierror)
        <type> v0<dims>
        INTEGER v1(*)
        INTEGER v2(*)
        INTEGER v3(*)
        <type1> v4<dims1>
        INTEGER v5(*)
        INTEGER v6(*)
        INTEGER v7(*)
        INTEGER v8
        INTEGER v9
        INTEGER ierror
        EXTERNAL MPI_IALLTOALLW
        CALL MPI_IALLTOALLW(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,ierror)
        END SUBROUTINE MPI_IALLTOALLW_T

        SUBROUTINE MPI_FILE_READ_T(v0,v1,v2,v3,v4,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2
        INTEGER v3
        INTEGER v4(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_FILE_READ
        CALL MPI_FILE_READ(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_FILE_READ_T

        SUBROUTINE MPI_IREDUCE_SCATTER_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        <type1> v1<dims1>
        INTEGER v2(*)
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_IREDUCE_SCATTER
        CALL MPI_IREDUCE_SCATTER(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_IREDUCE_SCATTER_T

        SUBROUTINE MPI_FREE_MEM_T(v0,ierror)
        <type> v0<dims>
        INTEGER ierror
        EXTERNAL MPI_FREE_MEM
        CALL MPI_FREE_MEM(v0,ierror)
        END SUBROUTINE MPI_FREE_MEM_T

        SUBROUTINE MPI_BUFFER_ATTACH_T(v0,v1,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER ierror
        EXTERNAL MPI_BUFFER_ATTACH
        CALL MPI_BUFFER_ATTACH(v0,v1,ierror)
        END SUBROUTINE MPI_BUFFER_ATTACH_T

        SUBROUTINE MPI_SSEND_INIT_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_SSEND_INIT
        CALL MPI_SSEND_INIT(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_SSEND_INIT_T

        SUBROUTINE MPI_FILE_IREAD_T(v0,v1,v2,v3,v4,ierror)
        INTEGER v0
        <type> v1<dims>
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER ierror
        EXTERNAL MPI_FILE_IREAD
        CALL MPI_FILE_IREAD(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_FILE_IREAD_T

        SUBROUTINE MPI_NEIGHBOR_ALLTOALLW_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        <type> v0<dims>
        INTEGER v1(*)
        INTEGER(KIND=MPI_ADDRESS_KIND) v2(*)
        INTEGER v3(*)
        <type1> v4<dims1>
        INTEGER v5(*)
        INTEGER(KIND=MPI_ADDRESS_KIND) v6(*)
        INTEGER v7(*)
        INTEGER v8
        INTEGER ierror
        EXTERNAL MPI_NEIGHBOR_ALLTOALLW
        CALL MPI_NEIGHBOR_ALLTOALLW(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        END SUBROUTINE MPI_NEIGHBOR_ALLTOALLW_T

        SUBROUTINE MPI_IALLGATHERV_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4(*)
        INTEGER v5(*)
        INTEGER v6
        INTEGER v7
        INTEGER v8
        INTEGER ierror
        EXTERNAL MPI_IALLGATHERV
        CALL MPI_IALLGATHERV(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        END SUBROUTINE MPI_IALLGATHERV_T

        SUBROUTINE MPI_ISCATTER_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER v7
        INTEGER v8
        INTEGER ierror
        EXTERNAL MPI_ISCATTER
        CALL MPI_ISCATTER(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        END SUBROUTINE MPI_ISCATTER_T

        SUBROUTINE MPI_UNPACK_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_UNPACK
        CALL MPI_UNPACK(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_UNPACK_T

        SUBROUTINE MPI_IMRECV_T(v0,v1,v2,v3,v4,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER ierror
        EXTERNAL MPI_IMRECV
        CALL MPI_IMRECV(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_IMRECV_T

        SUBROUTINE MPI_GREQUEST_START_T(v0,v1,v2,v3,v4,ierror)
        EXTERNAL v0
        EXTERNAL v1
        EXTERNAL v2
        <type> v3<dims>
        INTEGER v4
        INTEGER ierror
        EXTERNAL MPI_GREQUEST_START
        CALL MPI_GREQUEST_START(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_GREQUEST_START_T

        SUBROUTINE MPI_REGISTER_DATAREP_T(v0,v1,v2,v3,v4,ierror)
        CHARACTER (LEN=*) v0
        EXTERNAL v1
        EXTERNAL v2
        EXTERNAL v3
        <type> v4<dims>
        INTEGER ierror
        EXTERNAL MPI_REGISTER_DATAREP
        CALL MPI_REGISTER_DATAREP(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_REGISTER_DATAREP_T

        SUBROUTINE MPI_ISCAN_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        <type1> v1<dims1>
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_ISCAN
        CALL MPI_ISCAN(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_ISCAN_T

        SUBROUTINE MPI_FILE_WRITE_AT_ALL_BEGIN_T(v0,v1,v2,v3,v4,ierror)
        INTEGER v0
        INTEGER(KIND=MPI_OFFSET_KIND) v1
        <type> v2<dims>
        INTEGER v3
        INTEGER v4
        INTEGER ierror
        EXTERNAL MPI_FILE_WRITE_AT_ALL_BEGIN
        CALL MPI_FILE_WRITE_AT_ALL_BEGIN(v0,v1,v2,v3,v4,ierror)
        END SUBROUTINE MPI_FILE_WRITE_AT_ALL_BEGIN_T

        SUBROUTINE MPI_INEIGHBOR_ALLGATHER_T(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER v7
        INTEGER ierror
        EXTERNAL MPI_INEIGHBOR_ALLGATHER
        CALL MPI_INEIGHBOR_ALLGATHER(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        END SUBROUTINE MPI_INEIGHBOR_ALLGATHER_T

        SUBROUTINE MPI_EXSCAN_T(v0,v1,v2,v3,v4,v5,ierror)
        <type> v0<dims>
        <type1> v1<dims1>
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER ierror
        EXTERNAL MPI_EXSCAN
        CALL MPI_EXSCAN(v0,v1,v2,v3,v4,v5,ierror)
        END SUBROUTINE MPI_EXSCAN_T

        SUBROUTINE MPI_SCATTERV_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        <type> v0<dims>
        INTEGER v1(*)
        INTEGER v2(*)
        INTEGER v3
        <type1> v4<dims1>
        INTEGER v5
        INTEGER v6
        INTEGER v7
        INTEGER v8
        INTEGER ierror
        EXTERNAL MPI_SCATTERV
        CALL MPI_SCATTERV(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        END SUBROUTINE MPI_SCATTERV_T

        SUBROUTINE MPI_SCAN_T(v0,v1,v2,v3,v4,v5,ierror)
        <type> v0<dims>
        <type1> v1<dims1>
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER ierror
        EXTERNAL MPI_SCAN
        CALL MPI_SCAN(v0,v1,v2,v3,v4,v5,ierror)
        END SUBROUTINE MPI_SCAN_T

        SUBROUTINE MPI_FILE_READ_AT_T(v0,v1,v2,v3,v4,v5,ierror)
        INTEGER v0
        INTEGER(KIND=MPI_OFFSET_KIND) v1
        <type> v2<dims>
        INTEGER v3
        INTEGER v4
        INTEGER v5(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_FILE_READ_AT
        CALL MPI_FILE_READ_AT(v0,v1,v2,v3,v4,v5,ierror)
        END SUBROUTINE MPI_FILE_READ_AT_T

        SUBROUTINE MPI_WIN_ALLOCATE_SHARED_T(v0,v1,v2,v3,v4,v5,ierror)
        INTEGER(KIND=MPI_ADDRESS_KIND) v0
        INTEGER v1
        INTEGER v2
        INTEGER v3
        <type> v4<dims>
        INTEGER v5
        INTEGER ierror
        EXTERNAL MPI_WIN_ALLOCATE_SHARED
        CALL MPI_WIN_ALLOCATE_SHARED(v0,v1,v2,v3,v4,v5,ierror)
        END SUBROUTINE MPI_WIN_ALLOCATE_SHARED_T

        SUBROUTINE MPI_RSEND_INIT_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_RSEND_INIT
        CALL MPI_RSEND_INIT(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_RSEND_INIT_T

        SUBROUTINE MPI_REDUCE_SCATTER_BLOCK_T(v0,v1,v2,v3,v4,v5,ierror)
        <type> v0<dims>
        <type1> v1<dims1>
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER ierror
        EXTERNAL MPI_REDUCE_SCATTER_BLOCK
        CALL MPI_REDUCE_SCATTER_BLOCK(v0,v1,v2,v3,v4,v5,ierror)
        END SUBROUTINE MPI_REDUCE_SCATTER_BLOCK_T

        SUBROUTINE MPI_GATHERV_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4(*)
        INTEGER v5(*)
        INTEGER v6
        INTEGER v7
        INTEGER v8
        INTEGER ierror
        EXTERNAL MPI_GATHERV
        CALL MPI_GATHERV(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        END SUBROUTINE MPI_GATHERV_T

        SUBROUTINE MPI_WIN_GET_ATTR_T(v0,v1,v2,v3,ierror)
        INTEGER v0
        INTEGER v1
        <type> v2<dims>
        LOGICAL v3
        INTEGER ierror
        EXTERNAL MPI_WIN_GET_ATTR
        CALL MPI_WIN_GET_ATTR(v0,v1,v2,v3,ierror)
        END SUBROUTINE MPI_WIN_GET_ATTR_T

        SUBROUTINE MPI_SEND_INIT_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_SEND_INIT
        CALL MPI_SEND_INIT(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_SEND_INIT_T

        SUBROUTINE MPI_COMM_SET_ATTR_T(v0,v1,v2,ierror)
        INTEGER v0
        INTEGER v1
        <type> v2<dims>
        INTEGER ierror
        EXTERNAL MPI_COMM_SET_ATTR
        CALL MPI_COMM_SET_ATTR(v0,v1,v2,ierror)
        END SUBROUTINE MPI_COMM_SET_ATTR_T

        SUBROUTINE MPI_IALLGATHER_T(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER v7
        INTEGER ierror
        EXTERNAL MPI_IALLGATHER
        CALL MPI_IALLGATHER(v0,v1,v2,v3,v4,v5,v6,v7,ierror)
        END SUBROUTINE MPI_IALLGATHER_T

        SUBROUTINE MPI_ACCUMULATE_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER(KIND=MPI_ADDRESS_KIND) v4
        INTEGER v5
        INTEGER v6
        INTEGER v7
        INTEGER v8
        INTEGER ierror
        EXTERNAL MPI_ACCUMULATE
        CALL MPI_ACCUMULATE(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        END SUBROUTINE MPI_ACCUMULATE_T

        SUBROUTINE MPI_COMM_CREATE_KEYVAL_T(v0,v1,v2,v3,ierror)
        EXTERNAL v0
        EXTERNAL v1
        INTEGER v2
        <type> v3<dims>
        INTEGER ierror
        EXTERNAL MPI_COMM_CREATE_KEYVAL
        CALL MPI_COMM_CREATE_KEYVAL(v0,v1,v2,v3,ierror)
        END SUBROUTINE MPI_COMM_CREATE_KEYVAL_T

        SUBROUTINE MPI_RACCUMULATE_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER(KIND=MPI_ADDRESS_KIND) v4
        INTEGER v5
        INTEGER v6
        INTEGER v7
        INTEGER v8
        INTEGER v9
        INTEGER ierror
        EXTERNAL MPI_RACCUMULATE
        CALL MPI_RACCUMULATE(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,ierror)
        END SUBROUTINE MPI_RACCUMULATE_T

        SUBROUTINE MPI_IRSEND_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_IRSEND
        CALL MPI_IRSEND(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_IRSEND_T

        SUBROUTINE MPI_RECV_INIT_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        INTEGER v3
        INTEGER v4
        INTEGER v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_RECV_INIT
        CALL MPI_RECV_INIT(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_RECV_INIT_T

        SUBROUTINE MPI_COMPARE_AND_SWAP_T(v0,v1,v2,v3,v4,v5,v6,ierror)
        <type> v0<dims>
        <type1> v1<dims1>
        <type2> v2<dims2>
        INTEGER v3
        INTEGER v4
        INTEGER(KIND=MPI_ADDRESS_KIND) v5
        INTEGER v6
        INTEGER ierror
        EXTERNAL MPI_COMPARE_AND_SWAP
        CALL MPI_COMPARE_AND_SWAP(v0,v1,v2,v3,v4,v5,v6,ierror)
        END SUBROUTINE MPI_COMPARE_AND_SWAP_T

        SUBROUTINE MPI_INEIGHBOR_ALLGATHERV_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        <type> v0<dims>
        INTEGER v1
        INTEGER v2
        <type1> v3<dims1>
        INTEGER v4(*)
        INTEGER v5(*)
        INTEGER v6
        INTEGER v7
        INTEGER v8
        INTEGER ierror
        EXTERNAL MPI_INEIGHBOR_ALLGATHERV
        CALL MPI_INEIGHBOR_ALLGATHERV(v0,v1,v2,v3,v4,v5,v6,v7,v8,ierror)
        END SUBROUTINE MPI_INEIGHBOR_ALLGATHERV_T

        SUBROUTINE MPI_FILE_WRITE_AT_ALL_T(v0,v1,v2,v3,v4,v5,ierror)
        INTEGER v0
        INTEGER(KIND=MPI_OFFSET_KIND) v1
        <type> v2<dims>
        INTEGER v3
        INTEGER v4
        INTEGER v5(MPI_STATUS_SIZE)
        INTEGER ierror
        EXTERNAL MPI_FILE_WRITE_AT_ALL
        CALL MPI_FILE_WRITE_AT_ALL(v0,v1,v2,v3,v4,v5,ierror)
        END SUBROUTINE MPI_FILE_WRITE_AT_ALL_T

        SUBROUTINE MPI_INEIGHBOR_ALLTOALLW_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,ierror)
        <type> v0<dims>
        INTEGER v1(*)
        INTEGER(KIND=MPI_ADDRESS_KIND) v2(*)
        INTEGER v3(*)
        <type1> v4<dims1>
        INTEGER v5(*)
        INTEGER(KIND=MPI_ADDRESS_KIND) v6(*)
        INTEGER v7(*)
        INTEGER v8
        INTEGER v9
        INTEGER ierror
        EXTERNAL MPI_INEIGHBOR_ALLTOALLW
        CALL MPI_INEIGHBOR_ALLTOALLW(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,ierror)
        END SUBROUTINE MPI_INEIGHBOR_ALLTOALLW_T

        SUBROUTINE MPI_ISCATTERV_T(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,ierror)
        <type> v0<dims>
        INTEGER v1(*)
        INTEGER v2(*)
        INTEGER v3
        <type1> v4<dims1>
        INTEGER v5
        INTEGER v6
        INTEGER v7
        INTEGER v8
        INTEGER v9
        INTEGER ierror
        EXTERNAL MPI_ISCATTERV
        CALL MPI_ISCATTERV(v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,ierror)
        END SUBROUTINE MPI_ISCATTERV_T

        END MODULE MPI_t1_s
