%{
/*
 * merge.l - Flex source
 * Merges two PostScript files
 * 
 */

#include <stdio.h>


#ifndef TRUE
#define TRUE (1)
#endif

#ifndef FALSE
#define FALSE (0)
#endif

YY_BUFFER_STATE file1, file2;

int second_is_open = 0;

FILE *fp1, *fp2;

%}

%option noyywrap

%x SECOND_FILE

%%

^showsheet {
	printf("%%%%SHOWSHEET IN FIRST FILE: Removed!\n");
	BEGIN(SECOND_FILE);
	if ( !second_is_open ){
		second_is_open = 1;
		file1 = YY_CURRENT_BUFFER;
		yyin = fp2;
		file2 = yy_create_buffer(yyin, YY_BUF_SIZE);
	}
	yy_switch_to_buffer(file2); }

<SECOND_FILE>^showpage {
	printf("%%%%Next line renders the merged page.\nshowsheet\n");
	BEGIN(INITIAL);
	yy_switch_to_buffer(file1); }

%%

void yyerror(char *msg)
{
	fprintf(stderr, "Error...\n");
	exit(1);
}

main(int argc, char *argv[])
{

	if ( (fp1 = fopen(argv[1], "r")) == NULL ){
		fprintf(stderr, "%s: file not found!\n", argv[1]);
		exit(1);
	}

	if ( (fp2 = fopen(argv[2], "r")) == NULL ){
		fprintf(stderr, "%s: file not found!\n", argv[2]);
		exit(1);
	}

	yyin = fp1;

	yylex();

	exit(0);
}





