/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MODELMATCHCOLLECTOR_H
#define MODELMATCHCOLLECTOR_H

#include <QModelIndex>
#include <QModelIndexList>
#include <QSet>

class QAbstractItemModel;

class TreeModelMatchCollector
{
public:
    TreeModelMatchCollector();

    void match(QString value, int column, Qt::MatchFlags flags,
               const QModelIndex& startIndex);

    void setModel(QAbstractItemModel* model);
    void clear();
    QModelIndexList items() const { return items_; }
    int itemCount() const { return items_.count(); }
    int startItemPos() const { return startItemPos_; }
    bool isSameAsStartIndex(const QModelIndex&) const;

    void allValues(QSet<QString>& vals) const;
    void allValues(const QModelIndex& idx, QSet<QString>& vals) const;

protected:
    void findMatch(const QModelIndex& idx);

    QAbstractItemModel* model_;
    QString value_;
    int column_;
    Qt::MatchFlags flags_;
    QModelIndex startIndex_;
    int startItemPos_;
    bool startItemFound_;
    bool startIndexPassed_;
    QModelIndexList items_;
};

#endif  // MODELMATCHCOLLECTOR_H
