/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

//
// .NAME:
//  PlotModInteractive
//
// .AUTHOR:
//  Fernando Ii		Jul/2010
//
// .SUMMARY:
//   Defines the interactive mode of the PlotMod
//   class, which defines a higher level of the
//   visualisation control
//
// .CLIENTS:
//   This class is used by any METVIEW object, which
//   defines an interactive access
//
// .RESPONSIBILITY:
//
// .COLLABORATORS:
//   PlotModApp ( which will be either PlotModXApp or PlotModBatchApp).
//
// .DESCENDENT:
//   (none)
//
// .RELATED:
//   (none)
//
// .ASCENDENT:
//   (none)
//
#ifndef PlotModInteractive_H
#define PlotModInteractive_H

#include "PlotMod.h"

class uPlotBase;

class PlotModInteractive : public PlotMod
{
public:
    PlotModInteractive();
    ~PlotModInteractive(){}

    // Internal Error should not happen in user version
    //	static void InternalError ( const string & message, const string & title = string() );

    // System Error is used when probems are in one of the modules that PlotMod uses
    // including OpenGL
    void SystemError(const string& message, const string& title = string()) override;

    void setPlotApplication(uPlotBase* pa) { plotApplication_ = pa; }

protected:
    void showInfoMessagePopup(const string&) override;
    void showWarningMessagePopup(const string&) override;
    void showErrorMessagePopup(const string&) override;

    // print a message to the log window or the output so it will be visible without '-slog'
    void printMessage(const string&, PlotMod::MessageLevel, bool) override;

private:
    uPlotBase* plotApplication_{nullptr};
};
#endif
