/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

//#include "Log.h"
#include "Wastebasket.h"
#include "IconFactory.h"

Wastebasket::Wastebasket(Folder* parent, const IconClass& kind,
                         const string& name, IconInfo* info) :
    SystemFolder(parent, kind, name, info)
{
}

Wastebasket::~Wastebasket()
{
}

bool Wastebasket::adopt(IconObject* obj)
{
    IconObject* x = find(obj->name());
    if (x == obj) {
        return false;
    }

    if (x != 0) {
        x->destroy();
        //Log::warning(this) << "Object " << o->name()
        //	<< " already in wastebasket" << endl;
    }

    return SystemFolder::adopt(obj);
}

void Wastebasket::empty()
{
    scan();
    KidMap kids = kids_;
    for (KidMap::iterator j = kids.begin(); j != kids.end(); ++j) {
        IconObject* o = (*j).second;
        //Log::info(this) << "Remove " << *o << endl;
        o->destroy();
    }
}

set<string> Wastebasket::can()
{
    //scan();
    set<string> c = SystemFolder::can();
    c.insert("empty");
    //if(kids_.size()) c.insert("empty");
    return c;
}

static IconMaker<Wastebasket> wastebasketFactory("WASTEBASKET");
