/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQAbstractMessageExaminer_H
#define MvQAbstractMessageExaminer_H

#include <QModelIndex>
#include <QSettings>

#include "MvQMenuItem.h"
#include "MvQSearchLinePanel.h"

#include "MvMessageMetaData.h"

#include "MvQMainWindow.h"

class QAction;
class QComboBox;
class QLabel;
class QSortFilterProxyModel;
class QSplitter;
class QStackedLayout;
class QVBoxLayout;

class MvKeyProfile;

class MvQFileInfoLabel;
class MvQKeyManager;
class MvQKeyProfileModel;
class MvQKeyProfileSortFilterModel;
class MvQKeyProfileTree;
class MvQLogBrowser;
class MvQTreeViewSearchLine;
class MvQTreeView;

class MvQAbstractMessageExaminer : public MvQMainWindow, public MvMessageMetaDataObserver
{
    Q_OBJECT

public:
    	MvQAbstractMessageExaminer(QString,QWidget *parent = 0);
    	~MvQAbstractMessageExaminer();
    	void init(MvMessageMetaData*,MvQKeyManager *);

	MvQFileInfoLabel* fileInfoLabel() {return fileInfoLabel_;}
	QSplitter* messageSplitter() {return messageSplitter_;}
	QWidget* messagePanel() {return messagePanel_;}
	QWidget* dumpPanel() {return dumpPanel_;}
	QWidget* findPanel() {return findPanel_;}
	QWidget* logPanel() {return logPanel_;}
	const MvQMainWindow::MenuItemMap& menuItems () {return menuItems_;}
	QString currentKeyProfileName();
	void setCurrentKeyProfileName(QString);
	void close();

public slots:
	void slotSelectMessage(QModelIndex);
	void slotSelectMessage(int);
	void slotManageKeyProfiles();
	void slotLoadKeyProfile(int);
	void slotReloadProfile();
	void slotProfileChanged(bool);
	void slotCreateNewProfile();
	void slotSaveCurrentProfile();
	void slotSaveAsCurrentProfile();
	virtual void slotShowAboutBox()=0;
	void slotClearLog(bool);
	void slotUpdateLogOutput();
	
signals:
	void logOutputChanged();
	void messageScanProgess(int);
	void statusMessage(QString);

protected:
	virtual void setupEditMenu();
	virtual void setupViewMenu();
	virtual void setupSettingsMenu();
	virtual void setupProfilesMenu();
	virtual void setupHelpMenu();
	void setupMessageBox();
	virtual void setupDumpBox()=0;
 	void setupFindBox();
 	void setupLogBox();

	virtual void loadKeyProfile(MvKeyProfile *);
	void loadKeyProfileCore(MvKeyProfile *);

	virtual void initDumps()=0;
	virtual void loadDumps()=0;
	virtual void initAllKeys()=0;
	bool saveProfileBeforeAction(bool);
	void messageScanStepChanged(int);
	virtual void updateFileInfoLabel()=0;

	QString messageType_;
	QString appName_;

	MvMessageMetaData *data_;
 	int currentMessageNo_;

	MvQMainWindow::MenuItemMap menuItems_;

	MvQFileInfoLabel*  fileInfoLabel_;

	QVBoxLayout *messageLayout_;
	QWidget*     dumpPanel_;

	QComboBox*   keyCombo_;

	QWidget*     messagePanel_;
	QSplitter*     messageSplitter_; 	
	MvQKeyProfileTree*   messageTree_;
	MvQKeyProfileModel* messageModel_;
	MvQKeyProfileSortFilterModel* messageSortModel_;

	MvQKeyManager *keyManager_;
	MvKeyProfile* tmpProfile_;
	QAction* actionSave_;

	QString savedKeyProfileName_;
	QAction* actionFileInfo_;
	QAction* actionLog_;

	QWidget*     logPanel_;
	MvQLogBrowser* logBrowser_;

	QList<MvKeyProfile*> allKeys_;

	qint64 fileSize_;
	
	QAction *actionFind_;
	MvQDualSearchLinePanel* findPanel_;
	MvQTreeViewSearchLine* messageFind_;
};

#endif
