# Changes of mboxgrep

## Changes since 0.7.12

- Fix Automake macros to include the license file and others.

## Changes since 0.7.11

- Port to the pcre2 library (pcre1 is no longer supported).
- Check command-line options for conflicting matchers and actions.
- Various minor code cleanups.

## Changes since 0.7.10

- GNU Automake is now utilized instead of manually written Makefile.in files.
- Code indentation has been corrected and documented (GNU indent is used for this purpose).

## Changes since 0.7.9

- development has been restarted after a longer hiatus
- moved the source tree to git
- fixed compile bug on FreeBSD and other systems
- fixed deleting messages mbox folders compressed with bzip2
- fixed multiple compilation errors and warnings on Linux and FreeBSD
- started implementing a debug mode

## Changes since 0.7.8

- implemented support for mbox folders compressed with bzip2 algorithm
- improved detection of PCRE library; this also fixes a compilation bug
  on recent RedHat Linux systems
- fixed a problem with message deletion, which used to occur if an mbox
  folder and temporary directory were on different filesystems;
  thanks to James P. Dugal <jpd AT louisiana.edu> for providing a patch

## Changes since 0.7.7

- fixed crashes on MH folders, as well as a potential problem with mbox
  and maildir folders with the same cause
- debugging with the dmalloc library
- MH and maildir functions no longer read files which aren't RFC 2822 messages
- mboxgrep can now read gzip compressed mbox folders from standard input
  (which is a side effect of a code cleanup!)

## Changes since 0.7.6a

- mboxgrep can now read mbox folders from standard input

## Changes since 0.7.6

- fixed a bug which prevented mboxgrep from being compiled

## Changes since 0.7.5

- fixed a bug which caused mboxgrep to coredump on recursive search of 
  maildirs
- code cleanups

## Changes since 0.7.4

- recursive search through directories has been reimplemented

## Changes since 0.7.3

- mboxgrep can now ignore messages with identical bodies

## Changes since 0.7.2

- file locking method can be selected at runtime
- mboxgrep used to coredump on messages with empty headers; the problem is 
  now hopefully fixed
- mboxgrep now compiles on FreeBSD

## Changes since 0.7.1

- file locking with `flock()` instead of `fcntl()` is now supported
- mboxgrep should now compile on systems which don't have `getopt_long()`
- other minor bugfixes

## Changes since 0.7.0

- bugfixes

## Changes since 0.5.3

- NOTE: there was no stable version between 0.5.x and 0.7.x
- mboxgrep is almost completely rewritten
- implemented message deleting feature (`--delete`)
- implemented piping messages to a command (`--pipe`) (using this option, 
  each selected message is piped to a separate instance of the specified
  command)
- added support for compressed mbox folders

## Changes since 0.5.2

- implemented ability to write found messages to another folder (instead
  of standard output)
- started writing a *real* changelog (while this file has been renamed to
  "NEWS")
- wrote a manual in Texinfo format

## Changes since 0.5.1

- implemented message counting (`-c, --count`)
- fixed manual page installation target in src/Makefile.in -- manual page 
  is now installed in `$(manpath)/man1/` rather than `$(prefix)/man/man1/`
- added `--without-sense-of-humor` switch to the configure script, which
  disables checking whether Garfield still hates Mondays
- short version of `--version` switch is now `-V` instead of `-v`, 
  because `-v` will be used for inverted matching
- implemented inverted matching (`-v, --invert-match`)
- implemented recursive search through directories (`-r, --recursive`)
- config.h[.in] is now wrapped (`#ifndef CONFIG_H` and stuff)

## Changes since 0.5.0

- added support for qmail-style maildir folders

## Changes since 0.4.0

- the source of `getopt_long()` is now included, so long options are also available
  on platforms that don't use GNU libc
- file locking is now performed on mbox folders only

## Changes since 0.2.0

- added support for MH mailboxes
- added scope selection switches `-B` (or `--body`) and `-H` (or `--headers`)
- `getopt()` (or `getopt_long()`, if available) is now used to parse command line
  arguments, instead of my own lousy routine
- the configure script now looks for PCRE by default, unless `--with-pcre=no` or
  `--without-pcre` is specified
- the feature of reading from standard input is gone
- added `-v` (or `--version`) switch

## Changes since 0.1.1

- mboxgrep now puts a shared lock on a mailbox before reading it
- various code cleanups

## Changes since 0.1.0

- fixed install target in Makefile (`install` is now used instead of `cp`)
- added support for mailboxes generated by Gnus
