# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_widget import AbstractWidget


class CoordinateFrameWidget(AbstractWidget):
    r"""
    CoordinateFrameWidget - 3D widget for manipulating a display sized
    coordinate frame widget
    
    Superclass: AbstractWidget
    
    This 3D widget defines a display sized coordinate frame that can be
    interactively placed in a scene. The widget is assumed to consist of
    three parts: 1) an origin, 2) 3 axis normals which are rooted at the
    origin and 3 axis lockers. (The representation paired with this
    widget determines the actual geometry of the widget.)
    
    To use this widget, you generally pair it with a
    CoordinateFrameRepresentation (or a subclass). Various options are
    available for controlling how the representation appears, and how the
    widget functions.
    
    @par Event Bindings: By default, the widget responds to the following
    VTK events (i.e., it watches the RenderWindowInteractor for these
    events):
    
    If the mouse is over the one of the axis normals:
      left_button_press_event - select normal
      left_button_release_event - release normal
      mouse_move_event - orient the axis normal vectors (possibly
    constrained to
      one of the axis' planes) If the mouse is over the origin point
    (handle):
      left_button_press_event - select handle
      left_button_release_event - release handle (if selected)
      mouse_move_event - move the origin point (possibly constrained to one
    of the axis' planes) If the mouse is over one of the axis lockers:
      left_button_press_event - select axis locker
      left_button_release_event - unlock/lock and axis locker (and unlock
    all the other lockers) If the keypress characters are used
      'Down/Left' Move plane down
      'Up/Right' Move plane up
      'P/p' Pick a new origin from the intersection with a mesh cell
    rendered by the renderer
      'Ctrl' + 'P/p' Snap to a new origin from the closest mesh point
    rendered by the renderer
      'N/n' Pick a new normal from the intersection with a mesh cell
    rendered by the renderer
      'Ctrl' + 'N/n' Snap to a new normal from the closest mesh point
    rendered by the renderer
      'D/d' Pick a new point to define the direction normal which will be
    the new normal
      'Ctrl' + 'D/d' Snap to a new point to define the direction normal
    which will be the new normal 
    
    @par Event Bindings: Note that the event bindings described above can
    be changed using this class's WidgetEventTranslator. This class
    translates VTK events into the CoordinateFrameWidget's widget
    events:
    
    
      WidgetEvent::Select -- some part of the widget has been selected
      WidgetEvent::EndSelect -- the selection process has completed
      WidgetEvent::Move -- a request for widget motion has been
    invoked
      WidgetEvent::PickPoint -- pick_origin_action
      WidgetEvent::PickNormal -- pick_normal_action
      WidgetEvent::PickDirectionPoint -- pick_direction_point_action 
    
    @par Event Bindings: In turn, when these widget events are processed,
    the CoordinateFrameWidget invokes the following VTK events on
    itself (which observers can listen for):
    
    
      Command::StartInteractionEvent (on WidgetEvent::Select)
      Command::EndInteractionEvent (on WidgetEvent::EndSelect)
      Command::InteractionEvent (on WidgetEvent::Move) 
    
    @par Event Bindings: This class, and
    CoordinateFrameRepresentation, are next generation VTK widgets.
    
    @sa
    ThreeDWidget BoxWidget PlaneWidget LineWidget PointWidget
    SphereWidget ImagePlaneWidget ImplicitCylinderWidget,
    ImplicitPlaneWidget2 DisplaySizedImplicitPlaneWidget
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCoordinateFrameWidget, obj, update, **traits)
    
    def _get_representation(self):
        return wrap_vtk(self._vtk_obj.GetRepresentation())
    def _set_representation(self, arg):
        old_val = self._get_representation()
        self._wrap_call(self._vtk_obj.SetRepresentation,
                        deref_vtk(arg))
        self.trait_property_changed('representation', old_val, arg)
    representation = traits.Property(_get_representation, _set_representation, desc=\
        r"""
        Return an instance of WidgetRepresentation used to represent
        this widget in the scene. Note that the representation is a
        subclass of Prop (typically a subclass of
        WidgetRepresentation) so it can be added to the renderer
        independent of the widget.
        """
    )

    def _get_coordinate_frame_representation(self):
        return wrap_vtk(self._vtk_obj.GetCoordinateFrameRepresentation())
    coordinate_frame_representation = traits.Property(_get_coordinate_frame_representation, desc=\
        r"""
        Return the representation as a CoordinateFrameRepresentation.
        """
    )

    _updateable_traits_ = \
    (('manages_cursor', 'GetManagesCursor'), ('process_events',
    'GetProcessEvents'), ('enabled', 'GetEnabled'),
    ('key_press_activation', 'GetKeyPressActivation'), ('picking_managed',
    'GetPickingManaged'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('priority',
    'GetPriority'), ('key_press_activation_value',
    'GetKeyPressActivationValue'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'enabled', 'global_warning_display',
    'key_press_activation', 'manages_cursor', 'picking_managed',
    'process_events', 'key_press_activation_value', 'object_name',
    'priority'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CoordinateFrameWidget, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CoordinateFrameWidget properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['enabled', 'key_press_activation', 'manages_cursor',
            'picking_managed', 'process_events'], [],
            ['key_press_activation_value', 'object_name', 'priority']),
            title='Edit CoordinateFrameWidget properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CoordinateFrameWidget properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

