// Tags: JDK1.1

// Copyright (C) 2011 Pavel Tisnovsky <ptisnovs@redhat.com>

// This file is part of Mauve.

// Mauve is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.

// Mauve is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with Mauve; see the file COPYING.  If not, write to
// the Free Software Foundation, Inc., 51 Franklin Street,
// Fifth Floor, Boston, MA 02110-1301 USA.

package gnu.testlet.java.awt.CardLayout;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

import java.awt.CardLayout;
import javax.swing.JComponent;

/**
 * Some checks for the getLayoutAlignmentY() method in the {@link CardLayout} class.  
 */
public class getLayoutAlignmentY implements Testlet
{

  /**
   * Runs the test using the specified harness.
   * 
   * @param harness  the test harness (<code>null</code> not permitted).
   */
  public void test(TestHarness harness)
  {
    JComponent component = new JComponent(){};
    CardLayout cardLayout = new CardLayout();

    // Check for the value when nothing is touched.
    harness.check(cardLayout.getLayoutAlignmentY(component), 0.5f);

    // Setting the containers AlignmentY doesn't change anything.
    // 0 == alignment along the origin
    component.setAlignmentY(0.0f);
    harness.check(cardLayout.getLayoutAlignmentY(component), 0.5f);

    // Setting the containers AlignmentY doesn't change anything.
    // 1 == alignment furthest away from the origin
    component.setAlignmentY(1.0f);
    harness.check(cardLayout.getLayoutAlignmentY(component), 0.5f);
  }

}

