// This file is part of AsmJit project <https://asmjit.com>
//
// See asmjit.h or LICENSE.md for license and copyright information
// SPDX-License-Identifier: Zlib

#include <asmjit/core.h>
#if !defined(ASMJIT_NO_AARCH64)

#include <asmjit/a64.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "asmjit_test_assembler.h"
#include "cmdline.h"

using namespace asmjit;

#define TEST_INSTRUCTION(OPCODE, ...) \
  tester.testInstruction(OPCODE, #__VA_ARGS__, tester.assembler.__VA_ARGS__)

static void ASMJIT_NOINLINE testA64AssemblerBase(AssemblerTester<a64::Assembler>& tester) noexcept {
  using namespace a64;

  TEST_INSTRUCTION("4100031A", adc(w1, w2, w3));
  TEST_INSTRUCTION("4100039A", adc(x1, x2, x3));
  TEST_INSTRUCTION("E103031A", adc(w1, wzr, w3));
  TEST_INSTRUCTION("E103039A", adc(x1, xzr, x3));
  TEST_INSTRUCTION("5F00031A", adc(wzr, w2, w3));
  TEST_INSTRUCTION("5F00039A", adc(xzr, x2, x3));
  TEST_INSTRUCTION("4100033A", adcs(w1, w2, w3));
  TEST_INSTRUCTION("410003BA", adcs(x1, x2, x3));
  TEST_INSTRUCTION("4100030B", add(w1, w2, w3));
  TEST_INSTRUCTION("4100038B", add(x1, x2, x3));
  TEST_INSTRUCTION("410C030B", add(w1, w2, w3, lsl(3)));
  TEST_INSTRUCTION("410C038B", add(x1, x2, x3, lsl(3)));
  TEST_INSTRUCTION("FF030411", add(wsp, wsp, 256));
  TEST_INSTRUCTION("FFFF3F11", add(wsp, wsp, 0xFFF));
  TEST_INSTRUCTION("FF030491", add(sp, sp, 256));
  TEST_INSTRUCTION("FFFF3F91", add(sp, sp, 0xFFF));
  TEST_INSTRUCTION("E103030B", add(w1, wzr, w3));
  TEST_INSTRUCTION("E103038B", add(x1, xzr, x3));
  TEST_INSTRUCTION("5F00030B", add(wzr, w2, w3));
  TEST_INSTRUCTION("5F00038B", add(xzr, x2, x3));
  TEST_INSTRUCTION("83004011", add(w3, w4, 0, lsl(12)));
  TEST_INSTRUCTION("83004091", add(x3, x4, 0, lsl(12)));
  TEST_INSTRUCTION("83005011", add(w3, w4, 1024, lsl(12)));
  TEST_INSTRUCTION("83005091", add(x3, x4, 1024, lsl(12)));
  TEST_INSTRUCTION("83005011", add(w3, w4, 1024, lsl(12)));
  TEST_INSTRUCTION("83005091", add(x3, x4, 1024, lsl(12)));
  TEST_INSTRUCTION("FF830091", add(sp, sp, 32));
  TEST_INSTRUCTION("412C8291", addg(x1, x2, 32, 11));
  TEST_INSTRUCTION("5F2C8291", addg(sp, x2, 32, 11));
  TEST_INSTRUCTION("E12F8291", addg(x1, sp, 32, 11));
  TEST_INSTRUCTION("4100032B", adds(w1, w2, w3));
  TEST_INSTRUCTION("410003AB", adds(x1, x2, x3));
  TEST_INSTRUCTION("01000010", adr(x1, 0));
  TEST_INSTRUCTION("01080010", adr(x1, 256));
  TEST_INSTRUCTION("010000B0", adrp(x1, 4096));
  TEST_INSTRUCTION("4100030A", and_(w1, w2, w3));
  TEST_INSTRUCTION("4100038A", and_(x1, x2, x3));
  TEST_INSTRUCTION("41000012", and_(w1, w2, 1));
  TEST_INSTRUCTION("41004092", and_(x1, x2, 1));
  TEST_INSTRUCTION("410C0012", and_(w1, w2, 15));
  TEST_INSTRUCTION("410C4092", and_(x1, x2, 15));
  TEST_INSTRUCTION("3F1C0012", and_(wsp, w1, 0xFF));
  TEST_INSTRUCTION("3F1C4092", and_(sp, x1, 0xFF));
  TEST_INSTRUCTION("E103030A", and_(w1, wzr, w3));
  TEST_INSTRUCTION("E103038A", and_(x1, xzr, x3));
  TEST_INSTRUCTION("5F00030A", and_(wzr, w2, w3));
  TEST_INSTRUCTION("5F00038A", and_(xzr, x2, x3));
  TEST_INSTRUCTION("00000012", and_(w0, w0, 0x1));
  TEST_INSTRUCTION("00004092", and_(x0, x0, 0x1));
  TEST_INSTRUCTION("410C0012", and_(w1, w2, 0xf));
  TEST_INSTRUCTION("410C4092", and_(x1, x2, 0xf));
  TEST_INSTRUCTION("BFEC7C92", and_(sp, x5, 0xfffffffffffffff0));
  TEST_INSTRUCTION("4100036A", ands(w1, w2, w3));
  TEST_INSTRUCTION("410003EA", ands(x1, x2, x3));
  TEST_INSTRUCTION("E103036A", ands(w1, wzr, w3));
  TEST_INSTRUCTION("E10303EA", ands(x1, xzr, x3));
  TEST_INSTRUCTION("5F00036A", ands(wzr, w2, w3));
  TEST_INSTRUCTION("5F0003EA", ands(xzr, x2, x3));
  TEST_INSTRUCTION("00000072", ands(w0, w0, 0x1));
  TEST_INSTRUCTION("000040F2", ands(x0, x0, 0x1));
  TEST_INSTRUCTION("410C0072", ands(w1, w2, 0xf));
  TEST_INSTRUCTION("410C40F2", ands(x1, x2, 0xf));
  TEST_INSTRUCTION("417C0F13", asr(w1, w2, 15));
  TEST_INSTRUCTION("41FC4F93", asr(x1, x2, 15));
  TEST_INSTRUCTION("4128C31A", asrv(w1, w2, w3));
  TEST_INSTRUCTION("4128C39A", asrv(x1, x2, x3));
  TEST_INSTRUCTION("4F7808D5", at(Predicate::AT::kS1E0R, x15));
  TEST_INSTRUCTION("4118C1DA", autda(x1, x2));
  TEST_INSTRUCTION("E11BC1DA", autda(x1, sp));
  TEST_INSTRUCTION("411CC1DA", autdb(x1, x2));
  TEST_INSTRUCTION("E11FC1DA", autdb(x1, sp));
  TEST_INSTRUCTION("E13BC1DA", autdza(x1));
  TEST_INSTRUCTION("F43BC1DA", autdza(x20));
  TEST_INSTRUCTION("E13FC1DA", autdzb(x1));
  TEST_INSTRUCTION("F43FC1DA", autdzb(x20));
  TEST_INSTRUCTION("4110C1DA", autia(x1, x2));
  TEST_INSTRUCTION("E113C1DA", autia(x1, sp));
  TEST_INSTRUCTION("9F2103D5", autia1716());
  TEST_INSTRUCTION("BF2303D5", autiasp());
  TEST_INSTRUCTION("9F2303D5", autiaz());
  TEST_INSTRUCTION("4114C1DA", autib(x1, x2));
  TEST_INSTRUCTION("E117C1DA", autib(x1, sp));
  TEST_INSTRUCTION("DF2103D5", autib1716());
  TEST_INSTRUCTION("FF2303D5", autibsp());
  TEST_INSTRUCTION("DF2303D5", autibz());
  TEST_INSTRUCTION("E133C1DA", autiza(x1));
  TEST_INSTRUCTION("F433C1DA", autiza(x20));
  TEST_INSTRUCTION("E137C1DA", autizb(x1));
  TEST_INSTRUCTION("F437C1DA", autizb(x20));
  TEST_INSTRUCTION("5F4000D5", axflag());
  TEST_INSTRUCTION("E13F1833", bfc(w1, 8, 16));
  TEST_INSTRUCTION("E13F78B3", bfc(x1, 8, 16));
  TEST_INSTRUCTION("413C1833", bfi(w1, w2, 8, 16));
  TEST_INSTRUCTION("413C78B3", bfi(x1, x2, 8, 16));
  TEST_INSTRUCTION("41400833", bfm(w1, w2, 8, 16));
  TEST_INSTRUCTION("414048B3", bfm(x1, x2, 8, 16));
  TEST_INSTRUCTION("415C0833", bfxil(w1, w2, 8, 16));
  TEST_INSTRUCTION("415C48B3", bfxil(x1, x2, 8, 16));
  TEST_INSTRUCTION("41781F12", bic(w1, w2, 1));
  TEST_INSTRUCTION("41F87F92", bic(x1, x2, 1));
  TEST_INSTRUCTION("416C1C12", bic(w1, w2, 15));
  TEST_INSTRUCTION("41EC7C92", bic(x1, x2, 15));
  TEST_INSTRUCTION("4110230A", bic(w1, w2, w3, lsl(4)));
  TEST_INSTRUCTION("4110238A", bic(x1, x2, x3, lsl(4)));
  TEST_INSTRUCTION("E103230A", bic(w1, wzr, w3));
  TEST_INSTRUCTION("E103238A", bic(x1, xzr, x3));
  TEST_INSTRUCTION("41781F72", bics(w1, w2, 1));
  TEST_INSTRUCTION("41F87FF2", bics(x1, x2, 1));
  TEST_INSTRUCTION("416C1C72", bics(w1, w2, 15));
  TEST_INSTRUCTION("41EC7CF2", bics(x1, x2, 15));
  TEST_INSTRUCTION("4110236A", bics(w1, w2, w3, lsl(4)));
  TEST_INSTRUCTION("411023EA", bics(x1, x2, x3, lsl(4)));
  TEST_INSTRUCTION("E103236A", bics(w1, wzr, w3));
  TEST_INSTRUCTION("E10323EA", bics(x1, xzr, x3));
  TEST_INSTRUCTION("60031FD6", br(x27));
  TEST_INSTRUCTION("E0031FD6", br(xzr));
  TEST_INSTRUCTION("200020D4", brk(1));
  TEST_INSTRUCTION("627CA188", cas(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("627CA1C8", cas(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("627CE188", casa(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("627CE1C8", casa(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("627CE108", casab(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("627CE148", casah(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("62FCE188", casal(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("62FCE1C8", casal(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("62FCE108", casalb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("62FCE148", casalh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("627CA108", casb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("627CA148", cash(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("62FCA188", casl(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("62FCA1C8", casl(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("62FCA108", caslb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("62FCA148", caslh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("687C2208", casp(w2, w3, w8, w9, ptr(x3)));
  TEST_INSTRUCTION("687C2248", casp(x2, x3, x8, x9, ptr(x3)));
  TEST_INSTRUCTION("687C6208", caspa(w2, w3, w8, w9, ptr(x3)));
  TEST_INSTRUCTION("687C6248", caspa(x2, x3, x8, x9, ptr(x3)));
  TEST_INSTRUCTION("68FC6208", caspal(w2, w3, w8, w9, ptr(x3)));
  TEST_INSTRUCTION("68FC6248", caspal(x2, x3, x8, x9, ptr(x3)));
  TEST_INSTRUCTION("68FC2208", caspl(w2, w3, w8, w9, ptr(x3)));
  TEST_INSTRUCTION("68FC2248", caspl(x2, x3, x8, x9, ptr(x3)));
  TEST_INSTRUCTION("2300423A", ccmn(w1, w2, 3, CondCode::kEQ));
  TEST_INSTRUCTION("230042BA", ccmn(x1, x2, 3, CondCode::kEQ));
  TEST_INSTRUCTION("2308423A", ccmn(w1, 2, 3, CondCode::kEQ));
  TEST_INSTRUCTION("230842BA", ccmn(x1, 2, 3, CondCode::kEQ));
  TEST_INSTRUCTION("23005F3A", ccmn(w1, wzr, 3, CondCode::kEQ));
  TEST_INSTRUCTION("23005FBA", ccmn(x1, xzr, 3, CondCode::kEQ));
  TEST_INSTRUCTION("2300427A", ccmp(w1, w2, 3, CondCode::kEQ));
  TEST_INSTRUCTION("230042FA", ccmp(x1, x2, 3, CondCode::kEQ));
  TEST_INSTRUCTION("2308427A", ccmp(w1, 2, 3, CondCode::kEQ));
  TEST_INSTRUCTION("230842FA", ccmp(x1, 2, 3, CondCode::kEQ));
  TEST_INSTRUCTION("23005F7A", ccmp(w1, wzr, 3, CondCode::kEQ));
  TEST_INSTRUCTION("23005FFA", ccmp(x1, xzr, 3, CondCode::kEQ));
  TEST_INSTRUCTION("1F4000D5", cfinv());
  TEST_INSTRUCTION("4114821A", cinc(w1, w2, CondCode::kEQ));
  TEST_INSTRUCTION("4114829A", cinc(x1, x2, CondCode::kEQ));
  TEST_INSTRUCTION("5F14821A", cinc(wzr, w2, CondCode::kEQ));
  TEST_INSTRUCTION("E1179F1A", cinc(w1, wzr, CondCode::kEQ));
  TEST_INSTRUCTION("5F14829A", cinc(xzr, x2, CondCode::kEQ));
  TEST_INSTRUCTION("E1179F9A", cinc(x1, xzr, CondCode::kEQ));
  TEST_INSTRUCTION("4110825A", cinv(w1, w2, CondCode::kEQ));
  TEST_INSTRUCTION("411082DA", cinv(x1, x2, CondCode::kEQ));
  TEST_INSTRUCTION("5F10825A", cinv(wzr, w2, CondCode::kEQ));
  TEST_INSTRUCTION("E1139F5A", cinv(w1, wzr, CondCode::kEQ));
  TEST_INSTRUCTION("5F1082DA", cinv(xzr, x2, CondCode::kEQ));
  TEST_INSTRUCTION("E1139FDA", cinv(x1, xzr, CondCode::kEQ));
  TEST_INSTRUCTION("5F3B03D5", clrex(11));
  TEST_INSTRUCTION("4114C05A", cls(w1, w2));
  TEST_INSTRUCTION("4114C0DA", cls(x1, x2));
  TEST_INSTRUCTION("E117C05A", cls(w1, wzr));
  TEST_INSTRUCTION("E117C0DA", cls(x1, xzr));
  TEST_INSTRUCTION("5F14C05A", cls(wzr, w2));
  TEST_INSTRUCTION("5F14C0DA", cls(xzr, x2));
  TEST_INSTRUCTION("4110C05A", clz(w1, w2));
  TEST_INSTRUCTION("4110C0DA", clz(x1, x2));
  TEST_INSTRUCTION("E113C05A", clz(w1, wzr));
  TEST_INSTRUCTION("E113C0DA", clz(x1, xzr));
  TEST_INSTRUCTION("5F10C05A", clz(wzr, w2));
  TEST_INSTRUCTION("5F10C0DA", clz(xzr, x2));
  TEST_INSTRUCTION("3F840031", cmn(w1, 33));
  TEST_INSTRUCTION("3FFC4331", cmn(w1, 0xFF000));
  TEST_INSTRUCTION("FF030231", cmn(wsp, 128));
  TEST_INSTRUCTION("3F8400B1", cmn(x1, 33));
  TEST_INSTRUCTION("3FFC43B1", cmn(x1, 0xFF000));
  TEST_INSTRUCTION("FF0302B1", cmn(sp, 128));
  TEST_INSTRUCTION("3F00022B", cmn(w1, w2));
  TEST_INSTRUCTION("3F0002AB", cmn(x1, x2));
  TEST_INSTRUCTION("3F08222B", cmn(w1, w2, uxtb(2)));
  TEST_INSTRUCTION("3F0822AB", cmn(x1, x2, uxtb(2)));
  TEST_INSTRUCTION("FF43212B", cmn(wsp, w1));
  TEST_INSTRUCTION("FF07212B", cmn(wsp, w1, uxtb(1)));
  TEST_INSTRUCTION("FF6321AB", cmn(sp, x1));
  TEST_INSTRUCTION("FF6721AB", cmn(sp, x1, uxtx(1)));
  TEST_INSTRUCTION("3F840071", cmp(w1, 33));
  TEST_INSTRUCTION("3FFC4371", cmp(w1, 0xFF000));
  TEST_INSTRUCTION("FF030271", cmp(wsp, 128));
  TEST_INSTRUCTION("3F8400F1", cmp(x1, 33));
  TEST_INSTRUCTION("3FFC43F1", cmp(x1, 0xFF000));
  TEST_INSTRUCTION("FF0302F1", cmp(sp, 128));
  TEST_INSTRUCTION("3F00026B", cmp(w1, w2));
  TEST_INSTRUCTION("3F0002EB", cmp(x1, x2));
  TEST_INSTRUCTION("3F08226B", cmp(w1, w2, uxtb(2)));
  TEST_INSTRUCTION("3F0822EB", cmp(x1, x2, uxtb(2)));
  TEST_INSTRUCTION("FF43216B", cmp(wsp, w1));
  TEST_INSTRUCTION("FF07216B", cmp(wsp, w1, uxtb(1)));
  TEST_INSTRUCTION("FF6321EB", cmp(sp, x1));
  TEST_INSTRUCTION("FF6721EB", cmp(sp, x1, uxtx(1)));
  TEST_INSTRUCTION("3F00C2BA", cmpp(x1, x2));
  TEST_INSTRUCTION("3F00DFBA", cmpp(x1, sp));
  TEST_INSTRUCTION("FF03C2BA", cmpp(sp, x2));
  TEST_INSTRUCTION("FF03DFBA", cmpp(sp, sp));
  TEST_INSTRUCTION("4140C31A", crc32b(w1, w2, w3));
  TEST_INSTRUCTION("5F40C31A", crc32b(wzr, w2, w3));
  TEST_INSTRUCTION("E143C31A", crc32b(w1, wzr, w3));
  TEST_INSTRUCTION("4140DF1A", crc32b(w1, w2, wzr));
  TEST_INSTRUCTION("4150C31A", crc32cb(w1, w2, w3));
  TEST_INSTRUCTION("5F50C31A", crc32cb(wzr, w2, w3));
  TEST_INSTRUCTION("E153C31A", crc32cb(w1, wzr, w3));
  TEST_INSTRUCTION("4150DF1A", crc32cb(w1, w2, wzr));
  TEST_INSTRUCTION("4154C31A", crc32ch(w1, w2, w3));
  TEST_INSTRUCTION("5F54C31A", crc32ch(wzr, w2, w3));
  TEST_INSTRUCTION("E157C31A", crc32ch(w1, wzr, w3));
  TEST_INSTRUCTION("4154DF1A", crc32ch(w1, w2, wzr));
  TEST_INSTRUCTION("4158C31A", crc32cw(w1, w2, w3));
  TEST_INSTRUCTION("5F58C31A", crc32cw(wzr, w2, w3));
  TEST_INSTRUCTION("E15BC31A", crc32cw(w1, wzr, w3));
  TEST_INSTRUCTION("4158DF1A", crc32cw(w1, w2, wzr));
  TEST_INSTRUCTION("415CC39A", crc32cx(w1, w2, x3));
  TEST_INSTRUCTION("5F5CC39A", crc32cx(wzr, w2, x3));
  TEST_INSTRUCTION("E15FC39A", crc32cx(w1, wzr, x3));
  TEST_INSTRUCTION("415CDF9A", crc32cx(w1, w2, xzr));
  TEST_INSTRUCTION("4144C31A", crc32h(w1, w2, w3));
  TEST_INSTRUCTION("5F44C31A", crc32h(wzr, w2, w3));
  TEST_INSTRUCTION("E147C31A", crc32h(w1, wzr, w3));
  TEST_INSTRUCTION("4144DF1A", crc32h(w1, w2, wzr));
  TEST_INSTRUCTION("4148C31A", crc32w(w1, w2, w3));
  TEST_INSTRUCTION("5F48C31A", crc32w(wzr, w2, w3));
  TEST_INSTRUCTION("E14BC31A", crc32w(w1, wzr, w3));
  TEST_INSTRUCTION("4148DF1A", crc32w(w1, w2, wzr));
  TEST_INSTRUCTION("414CC39A", crc32x(w1, w2, x3));
  TEST_INSTRUCTION("5F4CC39A", crc32x(wzr, w2, x3));
  TEST_INSTRUCTION("E14FC39A", crc32x(w1, wzr, x3));
  TEST_INSTRUCTION("414CDF9A", crc32x(w1, w2, xzr));
  TEST_INSTRUCTION("9F2203D5", csdb());
  TEST_INSTRUCTION("4100831A", csel(w1, w2, w3, CondCode::kEQ));
  TEST_INSTRUCTION("4100839A", csel(x1, x2, x3, CondCode::kEQ));
  TEST_INSTRUCTION("E1179F1A", cset(w1, CondCode::kEQ));
  TEST_INSTRUCTION("E1179F9A", cset(x1, CondCode::kEQ));
  TEST_INSTRUCTION("E1179F1A", cset(w1, CondCode::kEQ));
  TEST_INSTRUCTION("E1179F9A", cset(x1, CondCode::kEQ));
  TEST_INSTRUCTION("E1139F5A", csetm(w1, CondCode::kEQ));
  TEST_INSTRUCTION("E1139FDA", csetm(x1, CondCode::kEQ));
  TEST_INSTRUCTION("4104831A", csinc(w1, w2, w3, CondCode::kEQ));
  TEST_INSTRUCTION("4104839A", csinc(x1, x2, x3, CondCode::kEQ));
  TEST_INSTRUCTION("4100835A", csinv(w1, w2, w3, CondCode::kEQ));
  TEST_INSTRUCTION("410083DA", csinv(x1, x2, x3, CondCode::kEQ));
  TEST_INSTRUCTION("4104835A", csneg(w1, w2, w3, CondCode::kEQ));
  TEST_INSTRUCTION("410483DA", csneg(x1, x2, x3, CondCode::kEQ));
  TEST_INSTRUCTION("2F740BD5", dc(Predicate::DC::kZVA, x15));
  TEST_INSTRUCTION("2100B0D4", dcps1(0x8001));
  TEST_INSTRUCTION("2200B0D4", dcps2(0x8001));
  TEST_INSTRUCTION("2300B0D4", dcps3(0x8001));
  TEST_INSTRUCTION("DF2003D5", dgh());
  TEST_INSTRUCTION("BF3103D5", dmb(1));
  TEST_INSTRUCTION("E003BFD6", drps());
  TEST_INSTRUCTION("9F3103D5", dsb(1));
  TEST_INSTRUCTION("4100234A", eon(w1, w2, w3));
  TEST_INSTRUCTION("5F00234A", eon(wzr, w2, w3));
  TEST_INSTRUCTION("E103234A", eon(w1, wzr, w3));
  TEST_INSTRUCTION("41003F4A", eon(w1, w2, wzr));
  TEST_INSTRUCTION("4110234A", eon(w1, w2, w3, lsl(4)));
  TEST_INSTRUCTION("410023CA", eon(x1, x2, x3));
  TEST_INSTRUCTION("5F0023CA", eon(xzr, x2, x3));
  TEST_INSTRUCTION("E10323CA", eon(x1, xzr, x3));
  TEST_INSTRUCTION("41003FCA", eon(x1, x2, xzr));
  TEST_INSTRUCTION("411023CA", eon(x1, x2, x3, lsl(4)));
  TEST_INSTRUCTION("4100034A", eor(w1, w2, w3));
  TEST_INSTRUCTION("5F00034A", eor(wzr, w2, w3));
  TEST_INSTRUCTION("E103034A", eor(w1, wzr, w3));
  TEST_INSTRUCTION("41001F4A", eor(w1, w2, wzr));
  TEST_INSTRUCTION("410003CA", eor(x1, x2, x3));
  TEST_INSTRUCTION("5F0003CA", eor(xzr, x2, x3));
  TEST_INSTRUCTION("E10303CA", eor(x1, xzr, x3));
  TEST_INSTRUCTION("41001FCA", eor(x1, x2, xzr));
  TEST_INSTRUCTION("4110034A", eor(w1, w2, w3, lsl(4)));
  TEST_INSTRUCTION("411003CA", eor(x1, x2, x3, lsl(4)));
  TEST_INSTRUCTION("3F1C0052", eor(wsp, w1, 0xFF));
  TEST_INSTRUCTION("FF1F0052", eor(wsp, wzr, 0xFF));
  TEST_INSTRUCTION("3F1C40D2", eor(sp, x1, 0xFF));
  TEST_INSTRUCTION("FF1F40D2", eor(sp, xzr, 0xFF));
  TEST_INSTRUCTION("41001252", eor(w1, w2, 0x4000));
  TEST_INSTRUCTION("410071D2", eor(x1, x2, 0x8000));
  TEST_INSTRUCTION("E0039FD6", eret());
  TEST_INSTRUCTION("1F2203D5", esb());
  TEST_INSTRUCTION("413C8313", extr(w1, w2, w3, 15));
  TEST_INSTRUCTION("5F3C8313", extr(wzr, w2, w3, 15));
  TEST_INSTRUCTION("E13F8313", extr(w1, wzr, w3, 15));
  TEST_INSTRUCTION("413C9F13", extr(w1, w2, wzr, 15));
  TEST_INSTRUCTION("413CC393", extr(x1, x2, x3, 15));
  TEST_INSTRUCTION("5F3CC393", extr(xzr, x2, x3, 15));
  TEST_INSTRUCTION("E13FC393", extr(x1, xzr, x3, 15));
  TEST_INSTRUCTION("413CDF93", extr(x1, x2, xzr, 15));
  TEST_INSTRUCTION("4114C39A", gmi(x1, x2, x3));
  TEST_INSTRUCTION("E117C39A", gmi(x1, sp, x3));
  TEST_INSTRUCTION("200040D4", hlt(1));
  TEST_INSTRUCTION("220000D4", hvc(1));
  TEST_INSTRUCTION("2F750BD5", ic(Predicate::IC::kIVAU, x15));
  TEST_INSTRUCTION("DF3103D5", isb(1));
  TEST_INSTRUCTION("620021B8", ldadd(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E20321B8", ldadd(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("620021F8", ldadd(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E20321F8", ldadd(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6200A1B8", ldadda(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E203A1B8", ldadda(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6200A1F8", ldadda(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E203A1F8", ldadda(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6200A138", ldaddab(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E203A138", ldaddab(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6200A178", ldaddah(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E203A178", ldaddah(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6200E1B8", ldaddal(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E203E1B8", ldaddal(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6200E1F8", ldaddal(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E203E1F8", ldaddal(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6200E138", ldaddalb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E203E138", ldaddalb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6200E178", ldaddalh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E203E178", ldaddalh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62002138", ldaddb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2032138", ldaddb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62002178", ldaddh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2032178", ldaddh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("620061B8", ldaddl(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E20361B8", ldaddl(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("620061F8", ldaddl(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E20361F8", ldaddl(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("62006138", ldaddlb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2036138", ldaddlb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62006178", ldaddlh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2036178", ldaddlh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("621021B8", ldclr(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E21321B8", ldclr(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("621021F8", ldclr(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E21321F8", ldclr(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6210A1B8", ldclra(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E213A1B8", ldclra(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6210A1F8", ldclra(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E213A1F8", ldclra(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6210A138", ldclrab(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E213A138", ldclrab(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6210A178", ldclrah(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E213A178", ldclrah(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6210E1B8", ldclral(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E213E1B8", ldclral(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6210E1F8", ldclral(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E213E1F8", ldclral(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6210E138", ldclralb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E213E138", ldclralb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6210E178", ldclralh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E213E178", ldclralh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62102138", ldclrb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2132138", ldclrb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62102178", ldclrh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2132178", ldclrh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("621061B8", ldclrl(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E21361B8", ldclrl(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("621061F8", ldclrl(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E21361F8", ldclrl(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("62106138", ldclrlb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2136138", ldclrlb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62106178", ldclrlh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2136178", ldclrlh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("622021B8", ldeor(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E22321B8", ldeor(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("622021F8", ldeor(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E22321F8", ldeor(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6220A1B8", ldeora(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E223A1B8", ldeora(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6220A1F8", ldeora(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E223A1F8", ldeora(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6220A138", ldeorab(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E223A138", ldeorab(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6220A178", ldeorah(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E223A178", ldeorah(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6220E1B8", ldeoral(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E223E1B8", ldeoral(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6220E1F8", ldeoral(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E223E1F8", ldeoral(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6220E138", ldeoralb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E223E138", ldeoralb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6220E178", ldeoralh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E223E178", ldeoralh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62202138", ldeorb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2232138", ldeorb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62202178", ldeorh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2232178", ldeorh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("622061B8", ldeorl(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E22361B8", ldeorl(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("622061F8", ldeorl(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E22361F8", ldeorl(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("62206138", ldeorlb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2236138", ldeorlb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62206178", ldeorlh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2236178", ldeorlh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("410060D9", ldg(x1, ptr(x2)));
  TEST_INSTRUCTION("418060D9", ldg(x1, ptr(x2, 128)));
  TEST_INSTRUCTION("E10360D9", ldg(x1, ptr(sp)));
  TEST_INSTRUCTION("E18360D9", ldg(x1, ptr(sp, 128)));
  TEST_INSTRUCTION("4100E0D9", ldgm(x1, ptr(x2)));
  TEST_INSTRUCTION("E103E0D9", ldgm(x1, ptr(sp)));
  TEST_INSTRUCTION("417CDF88", ldlar(w1, ptr(x2)));
  TEST_INSTRUCTION("E17FDF88", ldlar(w1, ptr(sp)));
  TEST_INSTRUCTION("417CDFC8", ldlar(x1, ptr(x2)));
  TEST_INSTRUCTION("E17FDFC8", ldlar(x1, ptr(sp)));
  TEST_INSTRUCTION("417CDF08", ldlarb(w1, ptr(x2)));
  TEST_INSTRUCTION("E17FDF08", ldlarb(w1, ptr(sp)));
  TEST_INSTRUCTION("417CDF48", ldlarh(w1, ptr(x2)));
  TEST_INSTRUCTION("E17FDF48", ldlarh(w1, ptr(sp)));
  TEST_INSTRUCTION("41084028", ldnp(w1, w2, ptr(x2)));
  TEST_INSTRUCTION("41086028", ldnp(w1, w2, ptr(x2, -256)));
  TEST_INSTRUCTION("41885F28", ldnp(w1, w2, ptr(x2, 252)));
  TEST_INSTRUCTION("410840A8", ldnp(x1, x2, ptr(x2)));
  TEST_INSTRUCTION("410860A8", ldnp(x1, x2, ptr(x2, -512)));
  TEST_INSTRUCTION("41885FA8", ldnp(x1, x2, ptr(x2, 504)));
  TEST_INSTRUCTION("41084029", ldp(w1, w2, ptr(x2)));
  TEST_INSTRUCTION("41086029", ldp(w1, w2, ptr(x2, -256)));
  TEST_INSTRUCTION("41885F29", ldp(w1, w2, ptr(x2, 252)));
  TEST_INSTRUCTION("410840A9", ldp(x1, x2, ptr(x2)));
  TEST_INSTRUCTION("410860A9", ldp(x1, x2, ptr(x2, -512)));
  TEST_INSTRUCTION("41885FA9", ldp(x1, x2, ptr(x2, 504)));
  TEST_INSTRUCTION("41084069", ldpsw(x1, x2, ptr(x2)));
  TEST_INSTRUCTION("41086069", ldpsw(x1, x2, ptr(x2, -256)));
  TEST_INSTRUCTION("41885F69", ldpsw(x1, x2, ptr(x2, 252)));
  TEST_INSTRUCTION("410040B9", ldr(w1, ptr(x2)));
  TEST_INSTRUCTION("413040B9", ldr(w1, ptr(x2, 48)));
  TEST_INSTRUCTION("410C43B8", ldr(w1, ptr_pre(x2, 48)));
  TEST_INSTRUCTION("416863B8", ldr(w1, ptr(x2, x3)));
  TEST_INSTRUCTION("410040F9", ldr(x1, ptr(x2)));
  TEST_INSTRUCTION("411840F9", ldr(x1, ptr(x2, 48)));
  TEST_INSTRUCTION("410C43F8", ldr(x1, ptr_pre(x2, 48)));
  TEST_INSTRUCTION("416863F8", ldr(x1, ptr(x2, x3)));
  TEST_INSTRUCTION("FB0F5FF8", ldr(x27, ptr_pre(sp, -16)));
  TEST_INSTRUCTION("FB0741F8", ldr(x27, ptr_post(sp, 16)));
  TEST_INSTRUCTION("411040B8", ldr(w1, ptr(x2, 1)));    // LDUR
  TEST_INSTRUCTION("41D05FB8", ldr(w1, ptr(x2, -3)));   // LDUR
  TEST_INSTRUCTION("41705FB8", ldr(w1, ptr(x2, -9)));   // LDUR
  TEST_INSTRUCTION("411040F8", ldr(x1, ptr(x2, 1)));    // LDUR
  TEST_INSTRUCTION("413040F8", ldr(x1, ptr(x2, 3)));    // LDUR
  TEST_INSTRUCTION("41705FF8", ldr(x1, ptr(x2, -9)));   // LDUR
  TEST_INSTRUCTION("41004039", ldrb(w1, ptr(x2)));
  TEST_INSTRUCTION("41C04039", ldrb(w1, ptr(x2, 48)));
  TEST_INSTRUCTION("410C4338", ldrb(w1, ptr_pre(x2, 48)));
  TEST_INSTRUCTION("41686338", ldrb(w1, ptr(x2, x3)));
  TEST_INSTRUCTION("41044039", ldrb(w1, ptr(x2, 1)));
  TEST_INSTRUCTION("41D05F38", ldrb(w1, ptr(x2, -3)));  // LDURB
  TEST_INSTRUCTION("41705F38", ldrb(w1, ptr(x2, -9)));  // LDURB
  TEST_INSTRUCTION("41004079", ldrh(w1, ptr(x2)));
  TEST_INSTRUCTION("41604079", ldrh(w1, ptr(x2, 48)));
  TEST_INSTRUCTION("410C4378", ldrh(w1, ptr_pre(x2, 48)));
  TEST_INSTRUCTION("41686378", ldrh(w1, ptr(x2, x3)));
  TEST_INSTRUCTION("41104078", ldrh(w1, ptr(x2, 1)));   // LDURH
  TEST_INSTRUCTION("41D05F78", ldrh(w1, ptr(x2, -3)));  // LDURH
  TEST_INSTRUCTION("41705F78", ldrh(w1, ptr(x2, -9)));  // LDURH
  TEST_INSTRUCTION("4104C039", ldrsb(w1, ptr(x2, 1)));
  TEST_INSTRUCTION("41D0DF38", ldrsb(w1, ptr(x2, -3))); // LDURSB
  TEST_INSTRUCTION("4170DF38", ldrsb(w1, ptr(x2, -9))); // LDURSB
  TEST_INSTRUCTION("41048039", ldrsb(x1, ptr(x2, 1)));
  TEST_INSTRUCTION("41D09F38", ldrsb(x1, ptr(x2, -3))); // LDURSB
  TEST_INSTRUCTION("41709F38", ldrsb(x1, ptr(x2, -9))); // LDURSB
  TEST_INSTRUCTION("4110C078", ldrsh(w1, ptr(x2, 1)));  // LDURSH
  TEST_INSTRUCTION("41D0DF78", ldrsh(w1, ptr(x2, -3))); // LDURSH
  TEST_INSTRUCTION("4170DF78", ldrsh(w1, ptr(x2, -9))); // LDURSH
  TEST_INSTRUCTION("41108078", ldrsh(x1, ptr(x2, 1)));  // LDURSH
  TEST_INSTRUCTION("41D09F78", ldrsh(x1, ptr(x2, -3))); // LDURSH
  TEST_INSTRUCTION("41709F78", ldrsh(x1, ptr(x2, -9))); // LDURSH
  TEST_INSTRUCTION("410080B9", ldrsw(x1, ptr(x2)));
  TEST_INSTRUCTION("413080B9", ldrsw(x1, ptr(x2, 48)));
  TEST_INSTRUCTION("410C83B8", ldrsw(x1, ptr_pre(x2, 48)));
  TEST_INSTRUCTION("410483B8", ldrsw(x1, ptr_post(x2, 48)));
  TEST_INSTRUCTION("4168A3B8", ldrsw(x1, ptr(x2, x3)));
  TEST_INSTRUCTION("411080B8", ldrsw(x1, ptr(x2, 1)));  // LDURSW
  TEST_INSTRUCTION("413080B8", ldrsw(x1, ptr(x2, 3)));  // LDURSW
  TEST_INSTRUCTION("41709FB8", ldrsw(x1, ptr(x2, -9))); // LDURSW
  TEST_INSTRUCTION("410420F8", ldraa(x1, ptr(x2)));
  TEST_INSTRUCTION("410460F8", ldraa(x1, ptr(x2, -4096)));
  TEST_INSTRUCTION("410C60F8", ldraa(x1, ptr_pre(x2, -4096)));
  TEST_INSTRUCTION("41FC3FF8", ldraa(x1, ptr_pre(x2, 4088)));
  TEST_INSTRUCTION("E10720F8", ldraa(x1, ptr(sp)));
  TEST_INSTRUCTION("E10760F8", ldraa(x1, ptr(sp, -4096)));
  TEST_INSTRUCTION("E10F60F8", ldraa(x1, ptr_pre(sp, -4096)));
  TEST_INSTRUCTION("E1FF3FF8", ldraa(x1, ptr_pre(sp, 4088)));
  TEST_INSTRUCTION("4104A0F8", ldrab(x1, ptr(x2)));
  TEST_INSTRUCTION("4104E0F8", ldrab(x1, ptr(x2, -4096)));
  TEST_INSTRUCTION("410CE0F8", ldrab(x1, ptr_pre(x2, -4096)));
  TEST_INSTRUCTION("41FCBFF8", ldrab(x1, ptr_pre(x2, 4088)));
  TEST_INSTRUCTION("E107A0F8", ldrab(x1, ptr(sp)));
  TEST_INSTRUCTION("E107E0F8", ldrab(x1, ptr(sp, -4096)));
  TEST_INSTRUCTION("E10FE0F8", ldrab(x1, ptr_pre(sp, -4096)));
  TEST_INSTRUCTION("E1FFBFF8", ldrab(x1, ptr_pre(sp, 4088)));
  TEST_INSTRUCTION("60DBA0B8", ldrsw(x0, ptr(x27, w0, sxtw(2))));
  TEST_INSTRUCTION("623021B8", ldset(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E23321B8", ldset(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("623021F8", ldset(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E23321F8", ldset(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6230A1B8", ldseta(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E233A1B8", ldseta(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6230A1F8", ldseta(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E233A1F8", ldseta(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6230A138", ldsetab(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E233A138", ldsetab(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6230A178", ldsetah(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E233A178", ldsetah(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6230E1B8", ldsetal(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E233E1B8", ldsetal(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6230E1F8", ldsetal(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E233E1F8", ldsetal(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6230E178", ldsetalh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E233E178", ldsetalh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6230E138", ldsetalb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E233E138", ldsetalb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62302138", ldsetb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2332138", ldsetb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62302178", ldseth(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2332178", ldseth(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("623061B8", ldsetl(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E23361B8", ldsetl(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("623061F8", ldsetl(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E23361F8", ldsetl(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("62306138", ldsetlb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2336138", ldsetlb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62306178", ldsetlh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2336178", ldsetlh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("624021B8", ldsmax(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E24321B8", ldsmax(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("624021F8", ldsmax(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E24321F8", ldsmax(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6240A1B8", ldsmaxa(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E243A1B8", ldsmaxa(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6240A1F8", ldsmaxa(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E243A1F8", ldsmaxa(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6240A138", ldsmaxab(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E243A138", ldsmaxab(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6240A178", ldsmaxah(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E243A178", ldsmaxah(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6240E1B8", ldsmaxal(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E243E1B8", ldsmaxal(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6240E1F8", ldsmaxal(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E243E1F8", ldsmaxal(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6240E138", ldsmaxalb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E243E138", ldsmaxalb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6240E178", ldsmaxalh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E243E178", ldsmaxalh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62402138", ldsmaxb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2432138", ldsmaxb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62402178", ldsmaxh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2432178", ldsmaxh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("624061B8", ldsmaxl(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E24361B8", ldsmaxl(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("624061F8", ldsmaxl(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E24361F8", ldsmaxl(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("62406138", ldsmaxlb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2436138", ldsmaxlb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62406178", ldsmaxlh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2436178", ldsmaxlh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("625021B8", ldsmin(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E25321B8", ldsmin(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("625021F8", ldsmin(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E25321F8", ldsmin(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6250A1B8", ldsmina(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E253A1B8", ldsmina(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6250A1F8", ldsmina(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E253A1F8", ldsmina(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6250A138", ldsminab(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E253A138", ldsminab(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6250A178", ldsminah(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E253A178", ldsminah(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6250E1B8", ldsminal(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E253E1B8", ldsminal(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6250E1F8", ldsminal(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E253E1F8", ldsminal(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6250E138", ldsminalb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E253E138", ldsminalb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6250E178", ldsminalh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E253E178", ldsminalh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62502138", ldsminb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2532138", ldsminb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62502178", ldsminh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2532178", ldsminh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("625061B8", ldsminl(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E25361B8", ldsminl(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("625061F8", ldsminl(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E25361F8", ldsminl(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("62506138", ldsminlb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2536138", ldsminlb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62506178", ldsminlh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2536178", ldsminlh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("410840B8", ldtr(w1, ptr(x2)));
  TEST_INSTRUCTION("411848B8", ldtr(w1, ptr(x2, 129)));
  TEST_INSTRUCTION("E10B40B8", ldtr(w1, ptr(sp)));
  TEST_INSTRUCTION("E11B48B8", ldtr(w1, ptr(sp, 129)));
  TEST_INSTRUCTION("410840F8", ldtr(x1, ptr(x2)));
  TEST_INSTRUCTION("411848F8", ldtr(x1, ptr(x2, 129)));
  TEST_INSTRUCTION("E10B40F8", ldtr(x1, ptr(sp)));
  TEST_INSTRUCTION("E11B48F8", ldtr(x1, ptr(sp, 129)));
  TEST_INSTRUCTION("41084038", ldtrb(w1, ptr(x2)));
  TEST_INSTRUCTION("41184838", ldtrb(w1, ptr(x2, 129)));
  TEST_INSTRUCTION("E10B4038", ldtrb(w1, ptr(sp)));
  TEST_INSTRUCTION("E11B4838", ldtrb(w1, ptr(sp, 129)));
  TEST_INSTRUCTION("41084078", ldtrh(w1, ptr(x2)));
  TEST_INSTRUCTION("41184878", ldtrh(w1, ptr(x2, 129)));
  TEST_INSTRUCTION("E10B4078", ldtrh(w1, ptr(sp)));
  TEST_INSTRUCTION("E11B4878", ldtrh(w1, ptr(sp, 129)));
  TEST_INSTRUCTION("4108C038", ldtrsb(w1, ptr(x2)));
  TEST_INSTRUCTION("4118C838", ldtrsb(w1, ptr(x2, 129)));
  TEST_INSTRUCTION("E10BC038", ldtrsb(w1, ptr(sp)));
  TEST_INSTRUCTION("E11BC838", ldtrsb(w1, ptr(sp, 129)));
  TEST_INSTRUCTION("4108C078", ldtrsh(w1, ptr(x2)));
  TEST_INSTRUCTION("4118C878", ldtrsh(w1, ptr(x2, 129)));
  TEST_INSTRUCTION("E10BC078", ldtrsh(w1, ptr(sp)));
  TEST_INSTRUCTION("E11BC878", ldtrsh(w1, ptr(sp, 129)));
  TEST_INSTRUCTION("410880B8", ldtrsw(x1, ptr(x2)));
  TEST_INSTRUCTION("411888B8", ldtrsw(x1, ptr(x2, 129)));
  TEST_INSTRUCTION("E10B80B8", ldtrsw(x1, ptr(sp)));
  TEST_INSTRUCTION("E11B88B8", ldtrsw(x1, ptr(sp, 129)));
  TEST_INSTRUCTION("626021B8", ldumax(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E26321B8", ldumax(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("626021F8", ldumax(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E26321F8", ldumax(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6260A1B8", ldumaxa(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E263A1B8", ldumaxa(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6260A1F8", ldumaxa(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E263A1F8", ldumaxa(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6260A138", ldumaxab(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E263A138", ldumaxab(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6260A178", ldumaxah(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E263A178", ldumaxah(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6260E1B8", ldumaxal(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E263E1B8", ldumaxal(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6260E1F8", ldumaxal(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E263E1F8", ldumaxal(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6260E138", ldumaxalb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E263E138", ldumaxalb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6260E178", ldumaxalh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E263E178", ldumaxalh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62602138", ldumaxb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2632138", ldumaxb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62602178", ldumaxh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2632178", ldumaxh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("626061B8", ldumaxl(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E26361B8", ldumaxl(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("626061F8", ldumaxl(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E26361F8", ldumaxl(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("62606138", ldumaxlb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2636138", ldumaxlb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62606178", ldumaxlh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2636178", ldumaxlh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("627021B8", ldumin(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E27321B8", ldumin(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("627021F8", ldumin(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E27321F8", ldumin(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6270A1B8", ldumina(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E273A1B8", ldumina(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6270A1F8", ldumina(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E273A1F8", ldumina(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6270A138", lduminab(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E273A138", lduminab(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6270A178", lduminah(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E273A178", lduminah(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6270E1B8", lduminal(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E273E1B8", lduminal(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6270E1F8", lduminal(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E273E1F8", lduminal(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("6270E138", lduminalb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E273E138", lduminalb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("6270E178", lduminalh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E273E178", lduminalh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62702138", lduminb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2732138", lduminb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62702178", lduminh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2732178", lduminh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("627061B8", lduminl(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E27361B8", lduminl(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("627061F8", lduminl(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E27361F8", lduminl(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("62706138", lduminlb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2736138", lduminlb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("62706178", lduminlh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E2736178", lduminlh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("410040B8", ldur(w1, ptr(x2)));
  TEST_INSTRUCTION("411048B8", ldur(w1, ptr(x2, 129)));
  TEST_INSTRUCTION("E10340B8", ldur(w1, ptr(sp)));
  TEST_INSTRUCTION("E11348B8", ldur(w1, ptr(sp, 129)));
  TEST_INSTRUCTION("410040F8", ldur(x1, ptr(x2)));
  TEST_INSTRUCTION("411048F8", ldur(x1, ptr(x2, 129)));
  TEST_INSTRUCTION("E10340F8", ldur(x1, ptr(sp)));
  TEST_INSTRUCTION("E11348F8", ldur(x1, ptr(sp, 129)));
  TEST_INSTRUCTION("41004038", ldurb(w1, ptr(x2)));
  TEST_INSTRUCTION("41104838", ldurb(w1, ptr(x2, 129)));
  TEST_INSTRUCTION("E1034038", ldurb(w1, ptr(sp)));
  TEST_INSTRUCTION("E1134838", ldurb(w1, ptr(sp, 129)));
  TEST_INSTRUCTION("41004078", ldurh(w1, ptr(x2)));
  TEST_INSTRUCTION("41104878", ldurh(w1, ptr(x2, 129)));
  TEST_INSTRUCTION("E1034078", ldurh(w1, ptr(sp)));
  TEST_INSTRUCTION("E1134878", ldurh(w1, ptr(sp, 129)));
  TEST_INSTRUCTION("4100C038", ldursb(w1, ptr(x2)));
  TEST_INSTRUCTION("4110C838", ldursb(w1, ptr(x2, 129)));
  TEST_INSTRUCTION("E103C038", ldursb(w1, ptr(sp)));
  TEST_INSTRUCTION("E113C838", ldursb(w1, ptr(sp, 129)));
  TEST_INSTRUCTION("4100C078", ldursh(w1, ptr(x2)));
  TEST_INSTRUCTION("4110C878", ldursh(w1, ptr(x2, 129)));
  TEST_INSTRUCTION("E103C078", ldursh(w1, ptr(sp)));
  TEST_INSTRUCTION("E113C878", ldursh(w1, ptr(sp, 129)));
  TEST_INSTRUCTION("410080B8", ldursw(x1, ptr(x2)));
  TEST_INSTRUCTION("411088B8", ldursw(x1, ptr(x2, 129)));
  TEST_INSTRUCTION("E10380B8", ldursw(x1, ptr(sp)));
  TEST_INSTRUCTION("E11388B8", ldursw(x1, ptr(sp, 129)));
  TEST_INSTRUCTION("61087F88", ldxp(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E10B7F88", ldxp(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("61087FC8", ldxp(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("E10B7FC8", ldxp(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("417C5F88", ldxr(w1, ptr(x2)));
  TEST_INSTRUCTION("E17F5F88", ldxr(w1, ptr(sp)));
  TEST_INSTRUCTION("417C5FC8", ldxr(x1, ptr(x2)));
  TEST_INSTRUCTION("E17F5FC8", ldxr(x1, ptr(sp)));
  TEST_INSTRUCTION("417C5F08", ldxrb(w1, ptr(x2)));
  TEST_INSTRUCTION("E17F5F08", ldxrb(w1, ptr(sp)));
  TEST_INSTRUCTION("417C5F48", ldxrh(w1, ptr(x2)));
  TEST_INSTRUCTION("E17F5F48", ldxrh(w1, ptr(sp)));
  TEST_INSTRUCTION("4120C31A", lsl(w1, w2, w3));
  TEST_INSTRUCTION("4120C39A", lsl(x1, x2, x3));
  TEST_INSTRUCTION("41401153", lsl(w1, w2, 15));
  TEST_INSTRUCTION("41C071D3", lsl(x1, x2, 15));
  TEST_INSTRUCTION("4120C31A", lslv(w1, w2, w3));
  TEST_INSTRUCTION("4120C39A", lslv(x1, x2, x3));
  TEST_INSTRUCTION("4124C31A", lsr(w1, w2, w3));
  TEST_INSTRUCTION("4124C39A", lsr(x1, x2, x3));
  TEST_INSTRUCTION("417C0F53", lsr(w1, w2, 15));
  TEST_INSTRUCTION("41FC4FD3", lsr(x1, x2, 15));
  TEST_INSTRUCTION("4124C31A", lsrv(w1, w2, w3));
  TEST_INSTRUCTION("4124C39A", lsrv(x1, x2, x3));
  TEST_INSTRUCTION("4110031B", madd(w1, w2, w3, w4));
  TEST_INSTRUCTION("4110039B", madd(x1, x2, x3, x4));
  TEST_INSTRUCTION("41FC031B", mneg(w1, w2, w3));
  TEST_INSTRUCTION("41FC039B", mneg(x1, x2, x3));
  TEST_INSTRUCTION("E103022A", mov(w1, w2));
  TEST_INSTRUCTION("E10302AA", mov(x1, x2));
  TEST_INSTRUCTION("01008052", mov(w1, 0));
  TEST_INSTRUCTION("01008012", mov(w1, -1));
  TEST_INSTRUCTION("21008052", mov(w1, 1));
  TEST_INSTRUCTION("41008052", mov(w1, 2));
  TEST_INSTRUCTION("61008052", mov(w1, 3));
  TEST_INSTRUCTION("81008052", mov(w1, 4));
  TEST_INSTRUCTION("A1008052", mov(w1, 5));
  TEST_INSTRUCTION("C1008052", mov(w1, 6));
  TEST_INSTRUCTION("E1008052", mov(w1, 7));
  TEST_INSTRUCTION("01018052", mov(w1, 8));
  TEST_INSTRUCTION("21018052", mov(w1, 9));
  TEST_INSTRUCTION("41018052", mov(w1, 10));
  TEST_INSTRUCTION("8146A252", mov(w1, 0x12340000));
  TEST_INSTRUCTION("81468252", mov(w1, 0x00001234));
  TEST_INSTRUCTION("61B9BD12", mov(w1, 0x1234FFFF));
  TEST_INSTRUCTION("61B99D12", mov(w1, 0xFFFF1234));
  TEST_INSTRUCTION("010080D2", mov(x1, 0));
  TEST_INSTRUCTION("01008092", mov(x1, -1));
  TEST_INSTRUCTION("8146E2D2", mov(x1, 0x1234000000000000));
  TEST_INSTRUCTION("8146C2D2", mov(x1, 0x0000123400000000));
  TEST_INSTRUCTION("8146A2D2", mov(x1, 0x0000000012340000));
  TEST_INSTRUCTION("814682D2", mov(x1, 0x0000000000001234));
  TEST_INSTRUCTION("61B9FD92", mov(x1, 0x1234FFFFFFFFFFFF));
  TEST_INSTRUCTION("61B9DD92", mov(x1, 0xFFFF1234FFFFFFFF));
  TEST_INSTRUCTION("61B9BD92", mov(x1, 0xFFFFFFFF1234FFFF));
  TEST_INSTRUCTION("61B99D92", mov(x1, 0xFFFFFFFFFFFF1234));
  TEST_INSTRUCTION("E1030011", mov(w1, wsp));
  TEST_INSTRUCTION("E1030091", mov(x1, sp));
  TEST_INSTRUCTION("3F000011", mov(wsp, w1));
  TEST_INSTRUCTION("FF3F0032", mov(wsp, 0xFFFF));
  TEST_INSTRUCTION("3F000091", mov(sp, x1));
  TEST_INSTRUCTION("FF3F40B2", mov(sp, 0xFFFF));
  TEST_INSTRUCTION("FF030011", mov(wsp, wsp));
  TEST_INSTRUCTION("FF030091", mov(sp, sp));
  TEST_INSTRUCTION("015138D5", mrs(x1, Predicate::SysReg::kAFSR0_EL1));
  TEST_INSTRUCTION("01423BD5", mrs(x1, Predicate::SysReg::kNZCV));
  TEST_INSTRUCTION("015118D5", msr(Predicate::SysReg::kAFSR0_EL1, x1));
  TEST_INSTRUCTION("01421BD5", msr(Predicate::SysReg::kNZCV, x1));
  TEST_INSTRUCTION("4190031B", msub(w1, w2, w3, w4));
  TEST_INSTRUCTION("4190039B", msub(x1, x2, x3, x4));
  TEST_INSTRUCTION("417C031B", mul(w1, w2, w3));
  TEST_INSTRUCTION("417C039B", mul(x1, x2, x3));
  TEST_INSTRUCTION("E103222A", mvn(w1, w2));
  TEST_INSTRUCTION("E10322AA", mvn(x1, x2));
  TEST_INSTRUCTION("E113222A", mvn(w1, w2, lsl(4)));
  TEST_INSTRUCTION("E11322AA", mvn(x1, x2, lsl(4)));
  TEST_INSTRUCTION("E103024B", neg(w1, w2));
  TEST_INSTRUCTION("E10302CB", neg(x1, x2));
  TEST_INSTRUCTION("E113024B", neg(w1, w2, lsl(4)));
  TEST_INSTRUCTION("E11302CB", neg(x1, x2, lsl(4)));
  TEST_INSTRUCTION("E103026B", negs(w1, w2));
  TEST_INSTRUCTION("E10302EB", negs(x1, x2));
  TEST_INSTRUCTION("E113026B", negs(w1, w2, lsl(4)));
  TEST_INSTRUCTION("E11302EB", negs(x1, x2, lsl(4)));
  TEST_INSTRUCTION("E103025A", ngc(w1, w2));
  TEST_INSTRUCTION("E10302DA", ngc(x1, x2));
  TEST_INSTRUCTION("E103027A", ngcs(w1, w2));
  TEST_INSTRUCTION("E10302FA", ngcs(x1, x2));
  TEST_INSTRUCTION("4100232A", orn(w1, w2, w3));
  TEST_INSTRUCTION("410023AA", orn(x1, x2, x3));
  TEST_INSTRUCTION("4110232A", orn(w1, w2, w3, lsl(4)));
  TEST_INSTRUCTION("411023AA", orn(x1, x2, x3, lsl(4)));
  TEST_INSTRUCTION("4100032A", orr(w1, w2, w3));
  TEST_INSTRUCTION("410003AA", orr(x1, x2, x3));
  TEST_INSTRUCTION("4110032A", orr(w1, w2, w3, lsl(4)));
  TEST_INSTRUCTION("411003AA", orr(x1, x2, x3, lsl(4)));
  TEST_INSTRUCTION("3F1C0032", orr(wsp, w1, 0xFF));
  TEST_INSTRUCTION("3F1C40B2", orr(sp, x1, 0xFF));
  TEST_INSTRUCTION("41001232", orr(w1, w2, 0x4000));
  TEST_INSTRUCTION("410071B2", orr(x1, x2, 0x8000));
  TEST_INSTRUCTION("E8030032", orr(w8, wzr, 0x1));
  TEST_INSTRUCTION("E80340B2", orr(x8, xzr, 0x1));
  TEST_INSTRUCTION("4108C1DA", pacda(x1, x2));
  TEST_INSTRUCTION("E10BC1DA", pacda(x1, sp));
  TEST_INSTRUCTION("410CC1DA", pacdb(x1, x2));
  TEST_INSTRUCTION("E10FC1DA", pacdb(x1, sp));
  TEST_INSTRUCTION("E12BC1DA", pacdza(x1));
  TEST_INSTRUCTION("F42BC1DA", pacdza(x20));
  TEST_INSTRUCTION("E12FC1DA", pacdzb(x1));
  TEST_INSTRUCTION("F42FC1DA", pacdzb(x20));
  TEST_INSTRUCTION("4130C39A", pacga(x1, x2, x3));
  TEST_INSTRUCTION("4130DF9A", pacga(x1, x2, sp));
  TEST_INSTRUCTION("9F3403D5", pssbb());
  TEST_INSTRUCTION("4100C05A", rbit(w1, w2));
  TEST_INSTRUCTION("4100C0DA", rbit(x1, x2));
  TEST_INSTRUCTION("4108C05A", rev(w1, w2));
  TEST_INSTRUCTION("410CC0DA", rev(x1, x2));
  TEST_INSTRUCTION("4104C05A", rev16(w1, w2));
  TEST_INSTRUCTION("4104C0DA", rev16(x1, x2));
  TEST_INSTRUCTION("4108C0DA", rev32(x1, x2));
  TEST_INSTRUCTION("410CC0DA", rev64(x1, x2));
  TEST_INSTRUCTION("412CC31A", ror(w1, w2, w3));
  TEST_INSTRUCTION("412CC39A", ror(x1, x2, x3));
  TEST_INSTRUCTION("413C8213", ror(w1, w2, 15));
  TEST_INSTRUCTION("413CC293", ror(x1, x2, 15));
  TEST_INSTRUCTION("412CC31A", rorv(w1, w2, w3));
  TEST_INSTRUCTION("412CC39A", rorv(x1, x2, x3));
  TEST_INSTRUCTION("4100035A", sbc(w1, w2, w3));
  TEST_INSTRUCTION("410003DA", sbc(x1, x2, x3));
  TEST_INSTRUCTION("4100037A", sbcs(w1, w2, w3));
  TEST_INSTRUCTION("410003FA", sbcs(x1, x2, x3));
  TEST_INSTRUCTION("41241B13", sbfiz(w1, w2, 5, 10));
  TEST_INSTRUCTION("41247B93", sbfiz(x1, x2, 5, 10));
  TEST_INSTRUCTION("41280513", sbfm(w1, w2, 5, 10));
  TEST_INSTRUCTION("41284593", sbfm(x1, x2, 5, 10));
  TEST_INSTRUCTION("41380513", sbfx(w1, w2, 5, 10));
  TEST_INSTRUCTION("41384593", sbfx(x1, x2, 5, 10));
  TEST_INSTRUCTION("410CC31A", sdiv(w1, w2, w3));
  TEST_INSTRUCTION("410CC39A", sdiv(x1, x2, x3));
  TEST_INSTRUCTION("2D08003A", setf8(w1));
  TEST_INSTRUCTION("2D48003A", setf16(w1));
  TEST_INSTRUCTION("4110239B", smaddl(x1, w2, w3, x4));
  TEST_INSTRUCTION("230000D4", smc(1));
  TEST_INSTRUCTION("41FC239B", smnegl(x1, w2, w3));
  TEST_INSTRUCTION("4190239B", smsubl(x1, w2, w3, x4));
  TEST_INSTRUCTION("417C439B", smulh(x1, x2, x3));
  TEST_INSTRUCTION("417C239B", smull(x1, w2, w3));
  TEST_INSTRUCTION("9F3003D5", ssbb());
  TEST_INSTRUCTION("4108A0D9", st2g(x1, ptr(x2)));
  TEST_INSTRUCTION("4188A0D9", st2g(x1, ptr(x2, 128)));
  TEST_INSTRUCTION("418CA0D9", st2g(x1, ptr_pre(x2, 128)));
  TEST_INSTRUCTION("4184A0D9", st2g(x1, ptr_post(x2, 128)));
  TEST_INSTRUCTION("E10BA0D9", st2g(x1, ptr(sp)));
  TEST_INSTRUCTION("E18BA0D9", st2g(x1, ptr(sp, 128)));
  TEST_INSTRUCTION("E18FA0D9", st2g(x1, ptr_pre(sp, 128)));
  TEST_INSTRUCTION("E187A0D9", st2g(x1, ptr_post(sp, 128)));
  TEST_INSTRUCTION("5F08A0D9", st2g(sp, ptr(x2)));
  TEST_INSTRUCTION("5F88A0D9", st2g(sp, ptr(x2, 128)));
  TEST_INSTRUCTION("5F8CA0D9", st2g(sp, ptr_pre(x2, 128)));
  TEST_INSTRUCTION("5F84A0D9", st2g(sp, ptr_post(x2, 128)));
  TEST_INSTRUCTION("FF0BA0D9", st2g(sp, ptr(sp)));
  TEST_INSTRUCTION("FF8BA0D9", st2g(sp, ptr(sp, 128)));
  TEST_INSTRUCTION("FF8FA0D9", st2g(sp, ptr_pre(sp, 128)));
  TEST_INSTRUCTION("FF87A0D9", st2g(sp, ptr_post(sp, 128)));
  TEST_INSTRUCTION("410820D9", stg(x1, ptr(x2)));
  TEST_INSTRUCTION("418820D9", stg(x1, ptr(x2, 128)));
  TEST_INSTRUCTION("418C20D9", stg(x1, ptr_pre(x2, 128)));
  TEST_INSTRUCTION("418420D9", stg(x1, ptr_post(x2, 128)));
  TEST_INSTRUCTION("E10B20D9", stg(x1, ptr(sp)));
  TEST_INSTRUCTION("E18B20D9", stg(x1, ptr(sp, 128)));
  TEST_INSTRUCTION("E18F20D9", stg(x1, ptr_pre(sp, 128)));
  TEST_INSTRUCTION("E18720D9", stg(x1, ptr_post(sp, 128)));
  TEST_INSTRUCTION("5F0820D9", stg(sp, ptr(x2)));
  TEST_INSTRUCTION("5F8820D9", stg(sp, ptr(x2, 128)));
  TEST_INSTRUCTION("5F8C20D9", stg(sp, ptr_pre(x2, 128)));
  TEST_INSTRUCTION("5F8420D9", stg(sp, ptr_post(x2, 128)));
  TEST_INSTRUCTION("FF0B20D9", stg(sp, ptr(sp)));
  TEST_INSTRUCTION("FF8B20D9", stg(sp, ptr(sp, 128)));
  TEST_INSTRUCTION("FF8F20D9", stg(sp, ptr_pre(sp, 128)));
  TEST_INSTRUCTION("FF8720D9", stg(sp, ptr_post(sp, 128)));
  TEST_INSTRUCTION("4100A0D9", stgm(x1, ptr(x2)));
  TEST_INSTRUCTION("E103A0D9", stgm(x1, ptr(sp)));
  TEST_INSTRUCTION("FF03A0D9", stgm(xzr, ptr(sp)));
  TEST_INSTRUCTION("61080069", stgp(x1, x2, ptr(x3)));
  TEST_INSTRUCTION("61082069", stgp(x1, x2, ptr(x3, -1024)));
  TEST_INSTRUCTION("6108A069", stgp(x1, x2, ptr_pre(x3, -1024)));
  TEST_INSTRUCTION("6108A068", stgp(x1, x2, ptr_post(x3, -1024)));
  TEST_INSTRUCTION("61881F69", stgp(x1, x2, ptr(x3, 1008)));
  TEST_INSTRUCTION("61889F69", stgp(x1, x2, ptr_pre(x3, 1008)));
  TEST_INSTRUCTION("61889F68", stgp(x1, x2, ptr_post(x3, 1008)));
  TEST_INSTRUCTION("E10B0069", stgp(x1, x2, ptr(sp)));
  TEST_INSTRUCTION("E10B2069", stgp(x1, x2, ptr(sp, -1024)));
  TEST_INSTRUCTION("E10BA069", stgp(x1, x2, ptr_pre(sp, -1024)));
  TEST_INSTRUCTION("E10BA068", stgp(x1, x2, ptr_post(sp, -1024)));
  TEST_INSTRUCTION("E18B1F69", stgp(x1, x2, ptr(sp, 1008)));
  TEST_INSTRUCTION("E18B9F69", stgp(x1, x2, ptr_pre(sp, 1008)));
  TEST_INSTRUCTION("E18B9F68", stgp(x1, x2, ptr_post(sp, 1008)));
  TEST_INSTRUCTION("41080029", stp(w1, w2, ptr(x2)));
  TEST_INSTRUCTION("41082029", stp(w1, w2, ptr(x2, -256)));
  TEST_INSTRUCTION("41881F29", stp(w1, w2, ptr(x2, 252)));
  TEST_INSTRUCTION("410800A9", stp(x1, x2, ptr(x2)));
  TEST_INSTRUCTION("410820A9", stp(x1, x2, ptr(x2, -512)));
  TEST_INSTRUCTION("41881FA9", stp(x1, x2, ptr(x2, 504)));
  TEST_INSTRUCTION("FB0F1FF8", str(x27, ptr_pre(sp, -16)));
  TEST_INSTRUCTION("411000B8", str(w1, ptr(x2, 1)));    // STUR
  TEST_INSTRUCTION("41D01FB8", str(w1, ptr(x2, -3)));   // STUR
  TEST_INSTRUCTION("41701FB8", str(w1, ptr(x2, -9)));   // STUR
  TEST_INSTRUCTION("411000F8", str(x1, ptr(x2, 1)));    // STUR
  TEST_INSTRUCTION("413000F8", str(x1, ptr(x2, 3)));    // STUR
  TEST_INSTRUCTION("41701FF8", str(x1, ptr(x2, -9)));   // STUR
  TEST_INSTRUCTION("41040039", strb(w1, ptr(x2, 1)));
  TEST_INSTRUCTION("41D01F38", strb(w1, ptr(x2, -3)));  // STURB
  TEST_INSTRUCTION("41701F38", strb(w1, ptr(x2, -9)));  // STURB
  TEST_INSTRUCTION("41100078", strh(w1, ptr(x2, 1)));   // STURH
  TEST_INSTRUCTION("41D01F78", strh(w1, ptr(x2, -3)));  // STURH
  TEST_INSTRUCTION("41701F78", strh(w1, ptr(x2, -9)));  // STURH
  TEST_INSTRUCTION("410800B8", sttr(w1, ptr(x2)));
  TEST_INSTRUCTION("411808B8", sttr(w1, ptr(x2, 129)));
  TEST_INSTRUCTION("E10B00B8", sttr(w1, ptr(sp)));
  TEST_INSTRUCTION("E11B08B8", sttr(w1, ptr(sp, 129)));
  TEST_INSTRUCTION("410800F8", sttr(x1, ptr(x2)));
  TEST_INSTRUCTION("411808F8", sttr(x1, ptr(x2, 129)));
  TEST_INSTRUCTION("E10B00F8", sttr(x1, ptr(sp)));
  TEST_INSTRUCTION("E11B08F8", sttr(x1, ptr(sp, 129)));
  TEST_INSTRUCTION("41080038", sttrb(w1, ptr(x2)));
  TEST_INSTRUCTION("41180838", sttrb(w1, ptr(x2, 129)));
  TEST_INSTRUCTION("E10B0038", sttrb(w1, ptr(sp)));
  TEST_INSTRUCTION("E11B0838", sttrb(w1, ptr(sp, 129)));
  TEST_INSTRUCTION("41080078", sttrh(w1, ptr(x2)));
  TEST_INSTRUCTION("41180878", sttrh(w1, ptr(x2, 129)));
  TEST_INSTRUCTION("E10B0078", sttrh(w1, ptr(sp)));
  TEST_INSTRUCTION("E11B0878", sttrh(w1, ptr(sp, 129)));
  TEST_INSTRUCTION("410000B8", stur(w1, ptr(x2)));
  TEST_INSTRUCTION("411008B8", stur(w1, ptr(x2, 129)));
  TEST_INSTRUCTION("E10300B8", stur(w1, ptr(sp)));
  TEST_INSTRUCTION("E11308B8", stur(w1, ptr(sp, 129)));
  TEST_INSTRUCTION("410000F8", stur(x1, ptr(x2)));
  TEST_INSTRUCTION("411008F8", stur(x1, ptr(x2, 129)));
  TEST_INSTRUCTION("E10300F8", stur(x1, ptr(sp)));
  TEST_INSTRUCTION("E11308F8", stur(x1, ptr(sp, 129)));
  TEST_INSTRUCTION("41000038", sturb(w1, ptr(x2)));
  TEST_INSTRUCTION("41100838", sturb(w1, ptr(x2, 129)));
  TEST_INSTRUCTION("E1030038", sturb(w1, ptr(sp)));
  TEST_INSTRUCTION("E1130838", sturb(w1, ptr(sp, 129)));
  TEST_INSTRUCTION("41000078", sturh(w1, ptr(x2)));
  TEST_INSTRUCTION("41100878", sturh(w1, ptr(x2, 129)));
  TEST_INSTRUCTION("E1030078", sturh(w1, ptr(sp)));
  TEST_INSTRUCTION("E1130878", sturh(w1, ptr(sp, 129)));
  TEST_INSTRUCTION("820C2188", stxp(w1, w2, w3, ptr(x4)));
  TEST_INSTRUCTION("E20F2188", stxp(w1, w2, w3, ptr(sp)));
  TEST_INSTRUCTION("820C21C8", stxp(w1, x2, x3, ptr(x4)));
  TEST_INSTRUCTION("E20F21C8", stxp(w1, x2, x3, ptr(sp)));
  TEST_INSTRUCTION("627C0188", stxr(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E27F0188", stxr(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("627C01C8", stxr(w1, x2, ptr(x3)));
  TEST_INSTRUCTION("E27F01C8", stxr(w1, x2, ptr(sp)));
  TEST_INSTRUCTION("627C0108", stxrb(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E27F0108", stxrb(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("627C0148", stxrh(w1, w2, ptr(x3)));
  TEST_INSTRUCTION("E27F0148", stxrh(w1, w2, ptr(sp)));
  TEST_INSTRUCTION("4108E0D9", stz2g(x1, ptr(x2)));
  TEST_INSTRUCTION("4108F0D9", stz2g(x1, ptr(x2, -4096)));
  TEST_INSTRUCTION("410CF0D9", stz2g(x1, ptr_pre(x2, -4096)));
  TEST_INSTRUCTION("4104F0D9", stz2g(x1, ptr_post(x2, -4096)));
  TEST_INSTRUCTION("41F8EFD9", stz2g(x1, ptr(x2, 4080)));
  TEST_INSTRUCTION("41FCEFD9", stz2g(x1, ptr_pre(x2, 4080)));
  TEST_INSTRUCTION("41F4EFD9", stz2g(x1, ptr_post(x2, 4080)));
  TEST_INSTRUCTION("E10BE0D9", stz2g(x1, ptr(sp)));
  TEST_INSTRUCTION("E10BF0D9", stz2g(x1, ptr(sp, -4096)));
  TEST_INSTRUCTION("E10FF0D9", stz2g(x1, ptr_pre(sp, -4096)));
  TEST_INSTRUCTION("E107F0D9", stz2g(x1, ptr_post(sp, -4096)));
  TEST_INSTRUCTION("E1FBEFD9", stz2g(x1, ptr(sp, 4080)));
  TEST_INSTRUCTION("E1FFEFD9", stz2g(x1, ptr_pre(sp, 4080)));
  TEST_INSTRUCTION("E1F7EFD9", stz2g(x1, ptr_post(sp, 4080)));
  TEST_INSTRUCTION("410860D9", stzg(x1, ptr(x2)));
  TEST_INSTRUCTION("418860D9", stzg(x1, ptr(x2, 128)));
  TEST_INSTRUCTION("418C60D9", stzg(x1, ptr_pre(x2, 128)));
  TEST_INSTRUCTION("418460D9", stzg(x1, ptr_post(x2, 128)));
  TEST_INSTRUCTION("E10B60D9", stzg(x1, ptr(sp)));
  TEST_INSTRUCTION("E18B60D9", stzg(x1, ptr(sp, 128)));
  TEST_INSTRUCTION("E18F60D9", stzg(x1, ptr_pre(sp, 128)));
  TEST_INSTRUCTION("E18760D9", stzg(x1, ptr_post(sp, 128)));
  TEST_INSTRUCTION("5F0860D9", stzg(sp, ptr(x2)));
  TEST_INSTRUCTION("5F8860D9", stzg(sp, ptr(x2, 128)));
  TEST_INSTRUCTION("5F8C60D9", stzg(sp, ptr_pre(x2, 128)));
  TEST_INSTRUCTION("5F8460D9", stzg(sp, ptr_post(x2, 128)));
  TEST_INSTRUCTION("FF0B60D9", stzg(sp, ptr(sp)));
  TEST_INSTRUCTION("FF8B60D9", stzg(sp, ptr(sp, 128)));
  TEST_INSTRUCTION("FF8F60D9", stzg(sp, ptr_pre(sp, 128)));
  TEST_INSTRUCTION("FF8760D9", stzg(sp, ptr_post(sp, 128)));
  TEST_INSTRUCTION("410020D9", stzgm(x1, ptr(x2)));
  TEST_INSTRUCTION("E10320D9", stzgm(x1, ptr(sp)));
  TEST_INSTRUCTION("4100034B", sub(w1, w2, w3));
  TEST_INSTRUCTION("410003CB", sub(x1, x2, x3));
  TEST_INSTRUCTION("410C034B", sub(w1, w2, w3, lsl(3)));
  TEST_INSTRUCTION("410C03CB", sub(x1, x2, x3, lsl(3)));
  TEST_INSTRUCTION("FF030451", sub(wsp, wsp, 256));
  TEST_INSTRUCTION("FFFF3F51", sub(wsp, wsp, 0xFFF));
  TEST_INSTRUCTION("FF0304D1", sub(sp, sp, 256));
  TEST_INSTRUCTION("FFFF3FD1", sub(sp, sp, 0xFFF));
  TEST_INSTRUCTION("412C82D1", subg(x1, x2, 32, 11));
  TEST_INSTRUCTION("5F2C82D1", subg(sp, x2, 32, 11));
  TEST_INSTRUCTION("E12F82D1", subg(x1, sp, 32, 11));
  TEST_INSTRUCTION("4100C39A", subp(x1, x2, x3));
  TEST_INSTRUCTION("E103C39A", subp(x1, sp, x3));
  TEST_INSTRUCTION("4100DF9A", subp(x1, x2, sp));
  TEST_INSTRUCTION("4100C3BA", subps(x1, x2, x3));
  TEST_INSTRUCTION("E103C3BA", subps(x1, sp, x3));
  TEST_INSTRUCTION("4100DFBA", subps(x1, x2, sp));
  TEST_INSTRUCTION("4100036B", subs(w1, w2, w3));
  TEST_INSTRUCTION("410003EB", subs(x1, x2, x3));
  TEST_INSTRUCTION("410C036B", subs(w1, w2, w3, lsl(3)));
  TEST_INSTRUCTION("410C03EB", subs(x1, x2, x3, lsl(3)));
  TEST_INSTRUCTION("210000D4", svc(1));
  TEST_INSTRUCTION("411C0013", sxtb(w1, w2));
  TEST_INSTRUCTION("411C4093", sxtb(x1, w2));
  TEST_INSTRUCTION("413C0013", sxth(w1, w2));
  TEST_INSTRUCTION("413C4093", sxth(x1, w2));
  TEST_INSTRUCTION("417C4093", sxtw(x1, w2));
  TEST_INSTRUCTION("932309D5", sys(1, 2, 3, 4, x19));
  TEST_INSTRUCTION("AF8708D5", tlbi(Predicate::TLBI::kVALE1, x15));
  TEST_INSTRUCTION("3F000072", tst(w1, 1));
  TEST_INSTRUCTION("3F0040F2", tst(x1, 1));
  TEST_INSTRUCTION("3F00026A", tst(w1, w2));
  TEST_INSTRUCTION("3F0002EA", tst(x1, x2));
  TEST_INSTRUCTION("3F10026A", tst(w1, w2, lsl(4)));
  TEST_INSTRUCTION("3F1002EA", tst(x1, x2, lsl(4)));
  TEST_INSTRUCTION("00000000", udf(0));
  TEST_INSTRUCTION("01800000", udf(0x8001));
  TEST_INSTRUCTION("4108C31A", udiv(w1, w2, w3));
  TEST_INSTRUCTION("4108C39A", udiv(x1, x2, x3));
  TEST_INSTRUCTION("41241B53", ubfiz(w1, w2, 5, 10));
  TEST_INSTRUCTION("41247BD3", ubfiz(x1, x2, 5, 10));
  TEST_INSTRUCTION("41280553", ubfm(w1, w2, 5, 10));
  TEST_INSTRUCTION("412845D3", ubfm(x1, x2, 5, 10));
  TEST_INSTRUCTION("41380553", ubfx(w1, w2, 5, 10));
  TEST_INSTRUCTION("413845D3", ubfx(x1, x2, 5, 10));
  TEST_INSTRUCTION("4110A39B", umaddl(x1, w2, w3, x4));
  TEST_INSTRUCTION("41FCA39B", umnegl(x1, w2, w3));
  TEST_INSTRUCTION("4190A39B", umsubl(x1, w2, w3, x4));
  TEST_INSTRUCTION("417CC39B", umulh(x1, x2, x3));
  TEST_INSTRUCTION("417CA39B", umull(x1, w2, w3));
  TEST_INSTRUCTION("411C0053", uxtb(w1, w2));
  TEST_INSTRUCTION("413C0053", uxth(w1, w2));
  TEST_INSTRUCTION("3F4000D5", xaflag());
  TEST_INSTRUCTION("E147C1DA", xpacd(x1));
  TEST_INSTRUCTION("E143C1DA", xpaci(x1));
  TEST_INSTRUCTION("FF2003D5", xpaclri());
}

static void ASMJIT_NOINLINE testA64AssemblerRel(AssemblerTester<a64::Assembler>& tester) noexcept {
  using namespace a64;

  // Must be a reference, because it's recreated after every `TEST_INSTRUCTION()`.
  const Label& L0 = tester.L0;

  TEST_INSTRUCTION("01000010", adr(x1, L0));
  TEST_INSTRUCTION("00000014", b(L0));
  TEST_INSTRUCTION("00000014", b_al(L0));
  TEST_INSTRUCTION("00000054", b_eq(L0));
  TEST_INSTRUCTION("01000054", b_ne(L0));
  TEST_INSTRUCTION("02000054", b_hs(L0));
  TEST_INSTRUCTION("03000054", b_lo(L0));
  TEST_INSTRUCTION("04000054", b_mi(L0));
  TEST_INSTRUCTION("05000054", b_pl(L0));
  TEST_INSTRUCTION("06000054", b_vs(L0));
  TEST_INSTRUCTION("07000054", b_vc(L0));
  TEST_INSTRUCTION("08000054", b_hi(L0));
  TEST_INSTRUCTION("09000054", b_ls(L0));
  TEST_INSTRUCTION("0A000054", b_ge(L0));
  TEST_INSTRUCTION("0B000054", b_lt(L0));
  TEST_INSTRUCTION("0C000054", b_gt(L0));
  TEST_INSTRUCTION("0D000054", b_le(L0));
  TEST_INSTRUCTION("00000014", b(CondCode::kAL, L0));
  TEST_INSTRUCTION("00000054", b(CondCode::kEQ, L0));
  TEST_INSTRUCTION("01000054", b(CondCode::kNE, L0));
  TEST_INSTRUCTION("02000054", b(CondCode::kHS, L0));
  TEST_INSTRUCTION("03000054", b(CondCode::kLO, L0));
  TEST_INSTRUCTION("04000054", b(CondCode::kMI, L0));
  TEST_INSTRUCTION("05000054", b(CondCode::kPL, L0));
  TEST_INSTRUCTION("06000054", b(CondCode::kVS, L0));
  TEST_INSTRUCTION("07000054", b(CondCode::kVC, L0));
  TEST_INSTRUCTION("08000054", b(CondCode::kHI, L0));
  TEST_INSTRUCTION("09000054", b(CondCode::kLS, L0));
  TEST_INSTRUCTION("0A000054", b(CondCode::kGE, L0));
  TEST_INSTRUCTION("0B000054", b(CondCode::kLT, L0));
  TEST_INSTRUCTION("0C000054", b(CondCode::kGT, L0));
  TEST_INSTRUCTION("0D000054", b(CondCode::kLE, L0));

  TEST_INSTRUCTION("00000094", bl(L0));
  TEST_INSTRUCTION("01000034", cbz(w1, L0));
  TEST_INSTRUCTION("010000B4", cbz(x1, L0));
  TEST_INSTRUCTION("01000035", cbnz(w1, L0));
  TEST_INSTRUCTION("010000B5", cbnz(x1, L0));
  TEST_INSTRUCTION("01001837", tbnz(w1, 3, L0));
  TEST_INSTRUCTION("010008B7", tbnz(x1, 33, L0));
  TEST_INSTRUCTION("01001836", tbz(w1, 3, L0));
  TEST_INSTRUCTION("010008B6", tbz(x1, 33, L0));
}

static void ASMJIT_NOINLINE testA64AssemblerSIMD(AssemblerTester<a64::Assembler>& tester) noexcept {
  using namespace a64;

  TEST_INSTRUCTION("41B8200E", abs(v1.b8(), v2.b8()));
  TEST_INSTRUCTION("41B8600E", abs(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("41B8A00E", abs(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41B8E05E", abs(d1, d2));
  TEST_INSTRUCTION("41B8204E", abs(v1.b16(), v2.b16()));
  TEST_INSTRUCTION("41B8604E", abs(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("41B8A04E", abs(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41B8E04E", abs(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("4184230E", add(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4184630E", add(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4184A30E", add(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4184E35E", add(d1, d2, d3));
  TEST_INSTRUCTION("4184234E", add(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4184634E", add(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4184A34E", add(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4184E34E", add(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4140230E", addhn(v1.b8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4140630E", addhn(v1.h4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4140A30E", addhn(v1.s2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4140234E", addhn2(v1.b16(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4140634E", addhn2(v1.h8(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4140A34E", addhn2(v1.s4(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41BC230E", addp(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("41BC630E", addp(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41BCA30E", addp(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("41B8F15E", addp(d1, v2.d2()));
  TEST_INSTRUCTION("41BC234E", addp(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("41BC634E", addp(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41BCA34E", addp(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41BCE34E", addp(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41B8310E", addv(b1, v2.b8()));
  TEST_INSTRUCTION("41B8314E", addv(b1, v2.b16()));
  TEST_INSTRUCTION("41B8710E", addv(h1, v2.h4()));
  TEST_INSTRUCTION("41B8714E", addv(h1, v2.h8()));
  TEST_INSTRUCTION("41B8B14E", addv(s1, v2.s4()));
  TEST_INSTRUCTION("4158284E", aesd(v1.b16(), v2.b16()));
  TEST_INSTRUCTION("4148284E", aese(v1.b16(), v2.b16()));
  TEST_INSTRUCTION("4178284E", aesimc(v1.b16(), v2.b16()));
  TEST_INSTRUCTION("4168284E", aesmc(v1.b16(), v2.b16()));
  TEST_INSTRUCTION("411C230E", and_(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("411C234E", and_(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("411023CE", bcax(v1.b16(), v2.b16(), v3.b16(), v4.b16()));
  TEST_INSTRUCTION("4140631E", bfcvt(h1, s2));
  TEST_INSTRUCTION("4168A10E", bfcvtn(v1.h4(), v2.s4()));
  TEST_INSTRUCTION("4168A14E", bfcvtn2(v1.h8(), v2.s4()));
  TEST_INSTRUCTION("41FC432E", bfdot(v1.s2(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41FC436E", bfdot(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41F0430F", bfdot(v1.s2(), v2.h4(), v3.h2(0)));
  TEST_INSTRUCTION("41F8634F", bfdot(v1.s4(), v2.h8(), v3.h2(3)));
  TEST_INSTRUCTION("41FCC32E", bfmlalb(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41F0C30F", bfmlalb(v1.s4(), v2.h8(), v3.h(0)));
  TEST_INSTRUCTION("41F8F30F", bfmlalb(v1.s4(), v2.h8(), v3.h(7)));
  TEST_INSTRUCTION("41FCC36E", bfmlalt(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41F0C34F", bfmlalt(v1.s4(), v2.h8(), v3.h(0)));
  TEST_INSTRUCTION("41F8F34F", bfmlalt(v1.s4(), v2.h8(), v3.h(7)));
  TEST_INSTRUCTION("41EC436E", bfmmla(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("411C630E", bic(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("411C634E", bic(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("E197072F", bic(v1.h4(), 255));
  TEST_INSTRUCTION("E1B7072F", bic(v1.h4(), 255, lsl(8)));
  TEST_INSTRUCTION("E197076F", bic(v1.h8(), 255));
  TEST_INSTRUCTION("E1B7076F", bic(v1.h8(), 255, lsl(8)));
  TEST_INSTRUCTION("E117072F", bic(v1.s2(), 255));
  TEST_INSTRUCTION("E137072F", bic(v1.s2(), 255, lsl(8)));
  TEST_INSTRUCTION("E117076F", bic(v1.s4(), 255));
  TEST_INSTRUCTION("E177076F", bic(v1.s4(), 255, lsl(24)));
  TEST_INSTRUCTION("411CE32E", bif(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("411CE36E", bif(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("411CA32E", bit(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("411CA36E", bit(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("411C632E", bsl(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("411C636E", bsl(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4148200E", cls(v1.b8(), v2.b8()));
  TEST_INSTRUCTION("4148600E", cls(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("4148A00E", cls(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("4148204E", cls(v1.b16(), v2.b16()));
  TEST_INSTRUCTION("4148604E", cls(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("4148A04E", cls(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("4148202E", clz(v1.b8(), v2.b8()));
  TEST_INSTRUCTION("4148602E", clz(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("4148A02E", clz(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("4148206E", clz(v1.b16(), v2.b16()));
  TEST_INSTRUCTION("4148606E", clz(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("4148A06E", clz(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("418C232E", cmeq(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("418C632E", cmeq(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("418CA32E", cmeq(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("418CE37E", cmeq(d1, d2, d3));
  TEST_INSTRUCTION("418C236E", cmeq(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("418C636E", cmeq(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("418CA36E", cmeq(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("418CE36E", cmeq(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4198200E", cmeq(v1.b8(), v2.b8(), 0));
  TEST_INSTRUCTION("4198600E", cmeq(v1.h4(), v2.h4(), 0));
  TEST_INSTRUCTION("4198A00E", cmeq(v1.s2(), v2.s2(), 0));
  TEST_INSTRUCTION("4198E05E", cmeq(d1, d2, 0));
  TEST_INSTRUCTION("4198204E", cmeq(v1.b16(), v2.b16(), 0));
  TEST_INSTRUCTION("4198604E", cmeq(v1.h8(), v2.h8(), 0));
  TEST_INSTRUCTION("4198A04E", cmeq(v1.s4(), v2.s4(), 0));
  TEST_INSTRUCTION("4198E04E", cmeq(v1.d2(), v2.d2(), 0));
  TEST_INSTRUCTION("413C230E", cmge(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("413C630E", cmge(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("413CA30E", cmge(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("413CE35E", cmge(d1, d2, d3));
  TEST_INSTRUCTION("413C234E", cmge(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("413C634E", cmge(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("413CA34E", cmge(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("413CE34E", cmge(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4188202E", cmge(v1.b8(), v2.b8(), 0));
  TEST_INSTRUCTION("4188602E", cmge(v1.h4(), v2.h4(), 0));
  TEST_INSTRUCTION("4188A02E", cmge(v1.s2(), v2.s2(), 0));
  TEST_INSTRUCTION("4188E07E", cmge(d1, d2, 0));
  TEST_INSTRUCTION("4188206E", cmge(v1.b16(), v2.b16(), 0));
  TEST_INSTRUCTION("4188606E", cmge(v1.h8(), v2.h8(), 0));
  TEST_INSTRUCTION("4188A06E", cmge(v1.s4(), v2.s4(), 0));
  TEST_INSTRUCTION("4188E06E", cmge(v1.d2(), v2.d2(), 0));
  TEST_INSTRUCTION("4134230E", cmgt(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4134630E", cmgt(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4134A30E", cmgt(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4134E35E", cmgt(d1, d2, d3));
  TEST_INSTRUCTION("4134234E", cmgt(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4134634E", cmgt(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4134A34E", cmgt(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4134E34E", cmgt(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4188200E", cmgt(v1.b8(), v2.b8(), 0));
  TEST_INSTRUCTION("4188600E", cmgt(v1.h4(), v2.h4(), 0));
  TEST_INSTRUCTION("4188A00E", cmgt(v1.s2(), v2.s2(), 0));
  TEST_INSTRUCTION("4188E05E", cmgt(d1, d2, 0));
  TEST_INSTRUCTION("4188204E", cmgt(v1.b16(), v2.b16(), 0));
  TEST_INSTRUCTION("4188604E", cmgt(v1.h8(), v2.h8(), 0));
  TEST_INSTRUCTION("4188A04E", cmgt(v1.s4(), v2.s4(), 0));
  TEST_INSTRUCTION("4188E04E", cmgt(v1.d2(), v2.d2(), 0));
  TEST_INSTRUCTION("4134232E", cmhi(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4134632E", cmhi(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4134A32E", cmhi(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4134E37E", cmhi(d1, d2, d3));
  TEST_INSTRUCTION("4134236E", cmhi(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4134636E", cmhi(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4134A36E", cmhi(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4134E36E", cmhi(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("413C232E", cmhs(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("413C632E", cmhs(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("413CA32E", cmhs(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("413CE37E", cmhs(d1, d2, d3));
  TEST_INSTRUCTION("413C236E", cmhs(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("413C636E", cmhs(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("413CA36E", cmhs(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("413CE36E", cmhs(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4198202E", cmle(v1.b8(), v2.b8(), 0));
  TEST_INSTRUCTION("4198602E", cmle(v1.h4(), v2.h4(), 0));
  TEST_INSTRUCTION("4198A02E", cmle(v1.s2(), v2.s2(), 0));
  TEST_INSTRUCTION("4198E07E", cmle(d1, d2, 0));
  TEST_INSTRUCTION("4198206E", cmle(v1.b16(), v2.b16(), 0));
  TEST_INSTRUCTION("4198606E", cmle(v1.h8(), v2.h8(), 0));
  TEST_INSTRUCTION("4198A06E", cmle(v1.s4(), v2.s4(), 0));
  TEST_INSTRUCTION("4198E06E", cmle(v1.d2(), v2.d2(), 0));
  TEST_INSTRUCTION("41A8200E", cmlt(v1.b8(), v2.b8(), 0));
  TEST_INSTRUCTION("41A8600E", cmlt(v1.h4(), v2.h4(), 0));
  TEST_INSTRUCTION("41A8A00E", cmlt(v1.s2(), v2.s2(), 0));
  TEST_INSTRUCTION("41A8E05E", cmlt(d1, d2, 0));
  TEST_INSTRUCTION("41A8204E", cmlt(v1.b16(), v2.b16(), 0));
  TEST_INSTRUCTION("41A8604E", cmlt(v1.h8(), v2.h8(), 0));
  TEST_INSTRUCTION("41A8A04E", cmlt(v1.s4(), v2.s4(), 0));
  TEST_INSTRUCTION("41A8E04E", cmlt(v1.d2(), v2.d2(), 0));
  TEST_INSTRUCTION("418C230E", cmtst(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("418C630E", cmtst(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("418CA30E", cmtst(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("418CE35E", cmtst(d1, d2, d3));
  TEST_INSTRUCTION("418C234E", cmtst(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("418C634E", cmtst(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("418CA34E", cmtst(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("418CE34E", cmtst(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4158200E", cnt(v1.b8(), v2.b8()));
  TEST_INSTRUCTION("4158204E", cnt(v1.b16(), v2.b16()));
  TEST_INSTRUCTION("410C010E", dup(v1.b8(), w2));
  TEST_INSTRUCTION("410C020E", dup(v1.h4(), w2));
  TEST_INSTRUCTION("410C040E", dup(v1.s2(), w2));
  TEST_INSTRUCTION("410C014E", dup(v1.b16(), w2));
  TEST_INSTRUCTION("410C024E", dup(v1.h8(), w2));
  TEST_INSTRUCTION("410C044E", dup(v1.s4(), w2));
  TEST_INSTRUCTION("410C084E", dup(v1.d2(), x2));
  TEST_INSTRUCTION("4F04035E", dup(b15, v2.b(1)));
  TEST_INSTRUCTION("4F04065E", dup(h15, v2.h(1)));
  TEST_INSTRUCTION("4F040C5E", dup(s15, v2.s(1)));
  TEST_INSTRUCTION("4F04185E", dup(d15, v2.d(1)));
  TEST_INSTRUCTION("4F04030E", dup(v15.b8(), v2.b(1)));
  TEST_INSTRUCTION("4F04060E", dup(v15.h4(), v2.h(1)));
  TEST_INSTRUCTION("4F040C0E", dup(v15.s2(), v2.s(1)));
  TEST_INSTRUCTION("4F04034E", dup(v15.b16(), v2.b(1)));
  TEST_INSTRUCTION("4F04064E", dup(v15.h8(), v2.h(1)));
  TEST_INSTRUCTION("4F040C4E", dup(v15.s4(), v2.s(1)));
  TEST_INSTRUCTION("4F04184E", dup(v15.d2(), v2.d(1)));
  TEST_INSTRUCTION("411C232E", eor(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("411C236E", eor(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("411003CE", eor3(v1.b16(), v2.b16(), v3.b16(), v4.b16()));
  TEST_INSTRUCTION("4128032E", ext(v1.b8(), v2.b8(), v3.b8(), 5));
  TEST_INSTRUCTION("4128036E", ext(v1.b16(), v2.b16(), v3.b16(), 5));
  TEST_INSTRUCTION("4114C37E", fabd(h1, h2, h3));
  TEST_INSTRUCTION("41D4A37E", fabd(s1, s2, s3));
  TEST_INSTRUCTION("41D4E37E", fabd(d1, d2, d3));
  TEST_INSTRUCTION("4114C32E", fabd(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41D4A32E", fabd(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4114C36E", fabd(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41D4A36E", fabd(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41D4E36E", fabd(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41C0E01E", fabs(h1, h2));
  TEST_INSTRUCTION("41C0201E", fabs(s1, s2));
  TEST_INSTRUCTION("41C0601E", fabs(d1, d2));
  TEST_INSTRUCTION("41F8F80E", fabs(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("41F8A00E", fabs(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41F8F84E", fabs(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("41F8A04E", fabs(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41F8E04E", fabs(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("412C437E", facge(h1, h2, h3));
  TEST_INSTRUCTION("41EC237E", facge(s1, s2, s3));
  TEST_INSTRUCTION("41EC637E", facge(d1, d2, d3));
  TEST_INSTRUCTION("412C432E", facge(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41EC232E", facge(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("412C436E", facge(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41EC236E", facge(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41EC636E", facge(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("412CC37E", facgt(h1, h2, h3));
  TEST_INSTRUCTION("41ECA37E", facgt(s1, s2, s3));
  TEST_INSTRUCTION("41ECE37E", facgt(d1, d2, d3));
  TEST_INSTRUCTION("412CC32E", facgt(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41ECA32E", facgt(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("412CC36E", facgt(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41ECA36E", facgt(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41ECE36E", facgt(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4128E31E", fadd(h1, h2, h3));
  TEST_INSTRUCTION("4128231E", fadd(s1, s2, s3));
  TEST_INSTRUCTION("4128631E", fadd(d1, d2, d3));
  TEST_INSTRUCTION("4114430E", fadd(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41D4230E", fadd(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4114434E", fadd(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41D4234E", fadd(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41D4634E", fadd(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41D8305E", faddp(h1, v2.h2()));
  TEST_INSTRUCTION("41D8307E", faddp(s1, v2.s2()));
  TEST_INSTRUCTION("41D8707E", faddp(d1, v2.d2()));
  TEST_INSTRUCTION("4114432E", faddp(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41D4232E", faddp(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4114436E", faddp(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41D4236E", faddp(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41D4636E", faddp(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41E4432E", fcadd(v1.h4(), v2.h4(), v3.h4(), 90));
  TEST_INSTRUCTION("41E4832E", fcadd(v1.s2(), v2.s2(), v3.s2(), 90));
  TEST_INSTRUCTION("41E4436E", fcadd(v1.h8(), v2.h8(), v3.h8(), 90));
  TEST_INSTRUCTION("41E4836E", fcadd(v1.s4(), v2.s4(), v3.s4(), 90));
  TEST_INSTRUCTION("41E4C36E", fcadd(v1.d2(), v2.d2(), v3.d2(), 90));
  TEST_INSTRUCTION("41F4432E", fcadd(v1.h4(), v2.h4(), v3.h4(), 270));
  TEST_INSTRUCTION("41F4832E", fcadd(v1.s2(), v2.s2(), v3.s2(), 270));
  TEST_INSTRUCTION("41F4436E", fcadd(v1.h8(), v2.h8(), v3.h8(), 270));
  TEST_INSTRUCTION("41F4836E", fcadd(v1.s4(), v2.s4(), v3.s4(), 270));
  TEST_INSTRUCTION("41F4C36E", fcadd(v1.d2(), v2.d2(), v3.d2(), 270));
  TEST_INSTRUCTION("2404E21E", fccmp(h1, h2, 4, CondCode::kEQ));
  TEST_INSTRUCTION("2404221E", fccmp(s1, s2, 4, CondCode::kEQ));
  TEST_INSTRUCTION("2404621E", fccmp(d1, d2, 4, CondCode::kEQ));
  TEST_INSTRUCTION("3404E21E", fccmpe(h1, h2, 4, CondCode::kEQ));
  TEST_INSTRUCTION("3404221E", fccmpe(s1, s2, 4, CondCode::kEQ));
  TEST_INSTRUCTION("3404621E", fccmpe(d1, d2, 4, CondCode::kEQ));
  TEST_INSTRUCTION("4124435E", fcmeq(h1, h2, h3));
  TEST_INSTRUCTION("41E4235E", fcmeq(s1, s2, s3));
  TEST_INSTRUCTION("41E4635E", fcmeq(d1, d2, d3));
  TEST_INSTRUCTION("4124430E", fcmeq(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41E4230E", fcmeq(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4124434E", fcmeq(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41E4234E", fcmeq(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41E4634E", fcmeq(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41D8F85E", fcmeq(h1, h2, 0));
  TEST_INSTRUCTION("41D8A05E", fcmeq(s1, s2, 0));
  TEST_INSTRUCTION("41D8E05E", fcmeq(d1, d2, 0));
  TEST_INSTRUCTION("41D8F80E", fcmeq(v1.h4(), v2.h4(), 0));
  TEST_INSTRUCTION("41D8A00E", fcmeq(v1.s2(), v2.s2(), 0));
  TEST_INSTRUCTION("41D8F84E", fcmeq(v1.h8(), v2.h8(), 0));
  TEST_INSTRUCTION("41D8A04E", fcmeq(v1.s4(), v2.s4(), 0));
  TEST_INSTRUCTION("41D8E04E", fcmeq(v1.d2(), v2.d2(), 0));
  TEST_INSTRUCTION("4124437E", fcmge(h1, h2, h3));
  TEST_INSTRUCTION("41E4237E", fcmge(s1, s2, s3));
  TEST_INSTRUCTION("41E4637E", fcmge(d1, d2, d3));
  TEST_INSTRUCTION("4124432E", fcmge(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41E4232E", fcmge(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4124436E", fcmge(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41E4236E", fcmge(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41E4636E", fcmge(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41C8F87E", fcmge(h1, h2, 0));
  TEST_INSTRUCTION("41C8A07E", fcmge(s1, s2, 0));
  TEST_INSTRUCTION("41C8E07E", fcmge(d1, d2, 0));
  TEST_INSTRUCTION("41C8F82E", fcmge(v1.h4(), v2.h4(), 0));
  TEST_INSTRUCTION("41C8A02E", fcmge(v1.s2(), v2.s2(), 0));
  TEST_INSTRUCTION("41C8F86E", fcmge(v1.h8(), v2.h8(), 0));
  TEST_INSTRUCTION("41C8A06E", fcmge(v1.s4(), v2.s4(), 0));
  TEST_INSTRUCTION("41C8E06E", fcmge(v1.d2(), v2.d2(), 0));
  TEST_INSTRUCTION("4124C37E", fcmgt(h1, h2, h3));
  TEST_INSTRUCTION("41E4A37E", fcmgt(s1, s2, s3));
  TEST_INSTRUCTION("41E4E37E", fcmgt(d1, d2, d3));
  TEST_INSTRUCTION("4124C32E", fcmgt(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41E4A32E", fcmgt(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4124C36E", fcmgt(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41E4A36E", fcmgt(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41E4E36E", fcmgt(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41C8F85E", fcmgt(h1, h2, 0));
  TEST_INSTRUCTION("41C8A05E", fcmgt(s1, s2, 0));
  TEST_INSTRUCTION("41C8E05E", fcmgt(d1, d2, 0));
  TEST_INSTRUCTION("41C8F80E", fcmgt(v1.h4(), v2.h4(), 0));
  TEST_INSTRUCTION("41C8A00E", fcmgt(v1.s2(), v2.s2(), 0));
  TEST_INSTRUCTION("41C8F84E", fcmgt(v1.h8(), v2.h8(), 0));
  TEST_INSTRUCTION("41C8A04E", fcmgt(v1.s4(), v2.s4(), 0));
  TEST_INSTRUCTION("41C8E04E", fcmgt(v1.d2(), v2.d2(), 0));
  TEST_INSTRUCTION("41CC432E", fcmla(v1.h4(), v2.h4(), v3.h4(), 90));
  TEST_INSTRUCTION("41CC832E", fcmla(v1.s2(), v2.s2(), v3.s2(), 90));
  TEST_INSTRUCTION("41CC436E", fcmla(v1.h8(), v2.h8(), v3.h8(), 90));
  TEST_INSTRUCTION("41CC836E", fcmla(v1.s4(), v2.s4(), v3.s4(), 90));
  TEST_INSTRUCTION("41CCC36E", fcmla(v1.d2(), v2.d2(), v3.d2(), 90));
  TEST_INSTRUCTION("41DC432E", fcmla(v1.h4(), v2.h4(), v3.h4(), 270));
  TEST_INSTRUCTION("41DC832E", fcmla(v1.s2(), v2.s2(), v3.s2(), 270));
  TEST_INSTRUCTION("41DC436E", fcmla(v1.h8(), v2.h8(), v3.h8(), 270));
  TEST_INSTRUCTION("41DC836E", fcmla(v1.s4(), v2.s4(), v3.s4(), 270));
  TEST_INSTRUCTION("41DCC36E", fcmla(v1.d2(), v2.d2(), v3.d2(), 270));
  TEST_INSTRUCTION("4130432F", fcmla(v1.h4(), v2.h4(), v3.h(0), 90));
  TEST_INSTRUCTION("4130632F", fcmla(v1.h4(), v2.h4(), v3.h(1), 90));
  TEST_INSTRUCTION("4130436F", fcmla(v1.h8(), v2.h8(), v3.h(0), 90));
  TEST_INSTRUCTION("4138636F", fcmla(v1.h8(), v2.h8(), v3.h(3), 90));
  TEST_INSTRUCTION("4130836F", fcmla(v1.s4(), v2.s4(), v3.s(0), 90));
  TEST_INSTRUCTION("4138836F", fcmla(v1.s4(), v2.s4(), v3.s(1), 90));
  TEST_INSTRUCTION("4170432F", fcmla(v1.h4(), v2.h4(), v3.h(0), 270));
  TEST_INSTRUCTION("4170632F", fcmla(v1.h4(), v2.h4(), v3.h(1), 270));
  TEST_INSTRUCTION("4170436F", fcmla(v1.h8(), v2.h8(), v3.h(0), 270));
  TEST_INSTRUCTION("4178636F", fcmla(v1.h8(), v2.h8(), v3.h(3), 270));
  TEST_INSTRUCTION("4170836F", fcmla(v1.s4(), v2.s4(), v3.s(0), 270));
  TEST_INSTRUCTION("4178836F", fcmla(v1.s4(), v2.s4(), v3.s(1), 270));
  TEST_INSTRUCTION("41D8F87E", fcmle(h1, h2, 0));
  TEST_INSTRUCTION("41D8A07E", fcmle(s1, s2, 0));
  TEST_INSTRUCTION("41D8E07E", fcmle(d1, d2, 0));
  TEST_INSTRUCTION("41D8F82E", fcmle(v1.h4(), v2.h4(), 0));
  TEST_INSTRUCTION("41D8A02E", fcmle(v1.s2(), v2.s2(), 0));
  TEST_INSTRUCTION("41D8F86E", fcmle(v1.h8(), v2.h8(), 0));
  TEST_INSTRUCTION("41D8A06E", fcmle(v1.s4(), v2.s4(), 0));
  TEST_INSTRUCTION("41D8E06E", fcmle(v1.d2(), v2.d2(), 0));
  TEST_INSTRUCTION("41E8F85E", fcmlt(h1, h2, 0));
  TEST_INSTRUCTION("41E8A05E", fcmlt(s1, s2, 0));
  TEST_INSTRUCTION("41E8E05E", fcmlt(d1, d2, 0));
  TEST_INSTRUCTION("41E8F80E", fcmlt(v1.h4(), v2.h4(), 0));
  TEST_INSTRUCTION("41E8A00E", fcmlt(v1.s2(), v2.s2(), 0));
  TEST_INSTRUCTION("41E8F84E", fcmlt(v1.h8(), v2.h8(), 0));
  TEST_INSTRUCTION("41E8A04E", fcmlt(v1.s4(), v2.s4(), 0));
  TEST_INSTRUCTION("41E8E04E", fcmlt(v1.d2(), v2.d2(), 0));
  TEST_INSTRUCTION("2020E21E", fcmp(h1, h2));
  TEST_INSTRUCTION("2020221E", fcmp(s1, s2));
  TEST_INSTRUCTION("2020621E", fcmp(d1, d2));
  TEST_INSTRUCTION("2820E01E", fcmp(h1, 0));
  TEST_INSTRUCTION("2820201E", fcmp(s1, 0));
  TEST_INSTRUCTION("2820601E", fcmp(d1, 0));
  TEST_INSTRUCTION("3020E21E", fcmpe(h1, h2));
  TEST_INSTRUCTION("3020221E", fcmpe(s1, s2));
  TEST_INSTRUCTION("3020621E", fcmpe(d1, d2));
  TEST_INSTRUCTION("3820E01E", fcmpe(h1, 0));
  TEST_INSTRUCTION("3820201E", fcmpe(s1, 0));
  TEST_INSTRUCTION("3820601E", fcmpe(d1, 0));
  TEST_INSTRUCTION("410CE31E", fcsel(h1, h2, h3, CondCode::kEQ));
  TEST_INSTRUCTION("410C231E", fcsel(s1, s2, s3, CondCode::kEQ));
  TEST_INSTRUCTION("410C631E", fcsel(d1, d2, d3, CondCode::kEQ));
  TEST_INSTRUCTION("41C0231E", fcvt(h1, s2));
  TEST_INSTRUCTION("41C0631E", fcvt(h1, d2));
  TEST_INSTRUCTION("4140E21E", fcvt(s1, h2));
  TEST_INSTRUCTION("4140621E", fcvt(s1, d2));
  TEST_INSTRUCTION("41C0E21E", fcvt(d1, h2));
  TEST_INSTRUCTION("41C0221E", fcvt(d1, s2));
  TEST_INSTRUCTION("4100E41E", fcvtas(w1, h2));
  TEST_INSTRUCTION("4100241E", fcvtas(w1, s2));
  TEST_INSTRUCTION("4100641E", fcvtas(w1, d2));
  TEST_INSTRUCTION("4100E49E", fcvtas(x1, h2));
  TEST_INSTRUCTION("4100249E", fcvtas(x1, s2));
  TEST_INSTRUCTION("4100649E", fcvtas(x1, d2));
  TEST_INSTRUCTION("41C8795E", fcvtas(h1, h2));
  TEST_INSTRUCTION("41C8215E", fcvtas(s1, s2));
  TEST_INSTRUCTION("41C8615E", fcvtas(d1, d2));
  TEST_INSTRUCTION("41C8790E", fcvtas(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("41C8210E", fcvtas(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41C8794E", fcvtas(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("41C8214E", fcvtas(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41C8614E", fcvtas(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("4100E51E", fcvtau(w1, h2));
  TEST_INSTRUCTION("4100251E", fcvtau(w1, s2));
  TEST_INSTRUCTION("4100651E", fcvtau(w1, d2));
  TEST_INSTRUCTION("4100E59E", fcvtau(x1, h2));
  TEST_INSTRUCTION("4100259E", fcvtau(x1, s2));
  TEST_INSTRUCTION("4100659E", fcvtau(x1, d2));
  TEST_INSTRUCTION("41C8797E", fcvtau(h1, h2));
  TEST_INSTRUCTION("41C8217E", fcvtau(s1, s2));
  TEST_INSTRUCTION("41C8617E", fcvtau(d1, d2));
  TEST_INSTRUCTION("41C8792E", fcvtau(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("41C8212E", fcvtau(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41C8796E", fcvtau(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("41C8216E", fcvtau(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41C8616E", fcvtau(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("4178210E", fcvtl(v1.s4(), v2.h4()));
  TEST_INSTRUCTION("4178214E", fcvtl2(v1.s4(), v2.h8()));
  TEST_INSTRUCTION("4178610E", fcvtl(v1.d2(), v2.s2()));
  TEST_INSTRUCTION("4178614E", fcvtl2(v1.d2(), v2.s4()));
  TEST_INSTRUCTION("4100F01E", fcvtms(w1, h2));
  TEST_INSTRUCTION("4100301E", fcvtms(w1, s2));
  TEST_INSTRUCTION("4100701E", fcvtms(w1, d2));
  TEST_INSTRUCTION("4100F09E", fcvtms(x1, h2));
  TEST_INSTRUCTION("4100309E", fcvtms(x1, s2));
  TEST_INSTRUCTION("4100709E", fcvtms(x1, d2));
  TEST_INSTRUCTION("41B8795E", fcvtms(h1, h2));
  TEST_INSTRUCTION("41B8215E", fcvtms(s1, s2));
  TEST_INSTRUCTION("41B8615E", fcvtms(d1, d2));
  TEST_INSTRUCTION("41B8790E", fcvtms(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("41B8210E", fcvtms(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41B8794E", fcvtms(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("41B8214E", fcvtms(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41B8614E", fcvtms(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("4100F11E", fcvtmu(w1, h2));
  TEST_INSTRUCTION("4100311E", fcvtmu(w1, s2));
  TEST_INSTRUCTION("4100711E", fcvtmu(w1, d2));
  TEST_INSTRUCTION("4100F19E", fcvtmu(x1, h2));
  TEST_INSTRUCTION("4100319E", fcvtmu(x1, s2));
  TEST_INSTRUCTION("4100719E", fcvtmu(x1, d2));
  TEST_INSTRUCTION("41B8797E", fcvtmu(h1, h2));
  TEST_INSTRUCTION("41B8217E", fcvtmu(s1, s2));
  TEST_INSTRUCTION("41B8617E", fcvtmu(d1, d2));
  TEST_INSTRUCTION("41B8792E", fcvtmu(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("41B8212E", fcvtmu(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41B8796E", fcvtmu(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("41B8216E", fcvtmu(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41B8616E", fcvtmu(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("4168210E", fcvtn(v1.h4(), v2.s4()));
  TEST_INSTRUCTION("4168214E", fcvtn2(v1.h8(), v2.s4()));
  TEST_INSTRUCTION("4168610E", fcvtn(v1.s2(), v2.d2()));
  TEST_INSTRUCTION("4168614E", fcvtn2(v1.s4(), v2.d2()));
  TEST_INSTRUCTION("4100E01E", fcvtns(w1, h2));
  TEST_INSTRUCTION("4100201E", fcvtns(w1, s2));
  TEST_INSTRUCTION("4100601E", fcvtns(w1, d2));
  TEST_INSTRUCTION("4100E09E", fcvtns(x1, h2));
  TEST_INSTRUCTION("4100209E", fcvtns(x1, s2));
  TEST_INSTRUCTION("4100609E", fcvtns(x1, d2));
  TEST_INSTRUCTION("41A8795E", fcvtns(h1, h2));
  TEST_INSTRUCTION("41A8215E", fcvtns(s1, s2));
  TEST_INSTRUCTION("41A8615E", fcvtns(d1, d2));
  TEST_INSTRUCTION("41A8790E", fcvtns(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("41A8210E", fcvtns(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41A8794E", fcvtns(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("41A8214E", fcvtns(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41A8614E", fcvtns(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("4100E11E", fcvtnu(w1, h2));
  TEST_INSTRUCTION("4100211E", fcvtnu(w1, s2));
  TEST_INSTRUCTION("4100611E", fcvtnu(w1, d2));
  TEST_INSTRUCTION("4100E19E", fcvtnu(x1, h2));
  TEST_INSTRUCTION("4100219E", fcvtnu(x1, s2));
  TEST_INSTRUCTION("4100619E", fcvtnu(x1, d2));
  TEST_INSTRUCTION("41A8797E", fcvtnu(h1, h2));
  TEST_INSTRUCTION("41A8217E", fcvtnu(s1, s2));
  TEST_INSTRUCTION("41A8617E", fcvtnu(d1, d2));
  TEST_INSTRUCTION("41A8792E", fcvtnu(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("41A8212E", fcvtnu(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41A8796E", fcvtnu(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("41A8216E", fcvtnu(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41A8616E", fcvtnu(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("4100E81E", fcvtps(w1, h2));
  TEST_INSTRUCTION("4100281E", fcvtps(w1, s2));
  TEST_INSTRUCTION("4100681E", fcvtps(w1, d2));
  TEST_INSTRUCTION("4100E89E", fcvtps(x1, h2));
  TEST_INSTRUCTION("4100289E", fcvtps(x1, s2));
  TEST_INSTRUCTION("4100689E", fcvtps(x1, d2));
  TEST_INSTRUCTION("41A8F95E", fcvtps(h1, h2));
  TEST_INSTRUCTION("41A8A15E", fcvtps(s1, s2));
  TEST_INSTRUCTION("41A8E15E", fcvtps(d1, d2));
  TEST_INSTRUCTION("41A8F90E", fcvtps(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("41A8A10E", fcvtps(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41A8F94E", fcvtps(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("41A8A14E", fcvtps(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41A8E14E", fcvtps(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("4100E91E", fcvtpu(w1, h2));
  TEST_INSTRUCTION("4100291E", fcvtpu(w1, s2));
  TEST_INSTRUCTION("4100691E", fcvtpu(w1, d2));
  TEST_INSTRUCTION("4100E99E", fcvtpu(x1, h2));
  TEST_INSTRUCTION("4100299E", fcvtpu(x1, s2));
  TEST_INSTRUCTION("4100699E", fcvtpu(x1, d2));
  TEST_INSTRUCTION("41A8F97E", fcvtpu(h1, h2));
  TEST_INSTRUCTION("41A8A17E", fcvtpu(s1, s2));
  TEST_INSTRUCTION("41A8E17E", fcvtpu(d1, d2));
  TEST_INSTRUCTION("41A8F92E", fcvtpu(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("41A8A12E", fcvtpu(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41A8F96E", fcvtpu(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("41A8A16E", fcvtpu(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41A8E16E", fcvtpu(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("2168617E", fcvtxn(s1, d1));
  TEST_INSTRUCTION("4168612E", fcvtxn(v1.s2(), v2.d2()));
  TEST_INSTRUCTION("4168616E", fcvtxn2(v1.s4(), v2.d2()));
  TEST_INSTRUCTION("4100F81E", fcvtzs(w1, h2));
  TEST_INSTRUCTION("4100381E", fcvtzs(w1, s2));
  TEST_INSTRUCTION("4100781E", fcvtzs(w1, d2));
  TEST_INSTRUCTION("4100F89E", fcvtzs(x1, h2));
  TEST_INSTRUCTION("4100389E", fcvtzs(x1, s2));
  TEST_INSTRUCTION("4100789E", fcvtzs(x1, d2));
  TEST_INSTRUCTION("41B8F95E", fcvtzs(h1, h2));
  TEST_INSTRUCTION("41B8A15E", fcvtzs(s1, s2));
  TEST_INSTRUCTION("41B8E15E", fcvtzs(d1, d2));
  TEST_INSTRUCTION("41B8F90E", fcvtzs(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("41B8A10E", fcvtzs(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41B8F94E", fcvtzs(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("41B8A14E", fcvtzs(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41B8E14E", fcvtzs(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("41E0D81E", fcvtzs(w1, h2, 8));
  TEST_INSTRUCTION("41E0181E", fcvtzs(w1, s2, 8));
  TEST_INSTRUCTION("41E0581E", fcvtzs(w1, d2, 8));
  TEST_INSTRUCTION("41E0D89E", fcvtzs(x1, h2, 8));
  TEST_INSTRUCTION("41E0189E", fcvtzs(x1, s2, 8));
  TEST_INSTRUCTION("41E0589E", fcvtzs(x1, d2, 8));
  TEST_INSTRUCTION("41FC185F", fcvtzs(h1, h2, 8));
  TEST_INSTRUCTION("41FC385F", fcvtzs(s1, s2, 8));
  TEST_INSTRUCTION("41FC785F", fcvtzs(d1, d2, 8));
  TEST_INSTRUCTION("41FC180F", fcvtzs(v1.h4(), v2.h4(), 8));
  TEST_INSTRUCTION("41FC380F", fcvtzs(v1.s2(), v2.s2(), 8));
  TEST_INSTRUCTION("41FC184F", fcvtzs(v1.h8(), v2.h8(), 8));
  TEST_INSTRUCTION("41FC384F", fcvtzs(v1.s4(), v2.s4(), 8));
  TEST_INSTRUCTION("41FC784F", fcvtzs(v1.d2(), v2.d2(), 8));
  TEST_INSTRUCTION("4100F91E", fcvtzu(w1, h2));
  TEST_INSTRUCTION("4100391E", fcvtzu(w1, s2));
  TEST_INSTRUCTION("4100791E", fcvtzu(w1, d2));
  TEST_INSTRUCTION("4100F99E", fcvtzu(x1, h2));
  TEST_INSTRUCTION("4100399E", fcvtzu(x1, s2));
  TEST_INSTRUCTION("4100799E", fcvtzu(x1, d2));
  TEST_INSTRUCTION("41B8F97E", fcvtzu(h1, h2));
  TEST_INSTRUCTION("41B8A17E", fcvtzu(s1, s2));
  TEST_INSTRUCTION("41B8E17E", fcvtzu(d1, d2));
  TEST_INSTRUCTION("41B8F92E", fcvtzu(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("41B8A12E", fcvtzu(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41B8F96E", fcvtzu(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("41B8A16E", fcvtzu(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41B8E16E", fcvtzu(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("41E0D91E", fcvtzu(w1, h2, 8));
  TEST_INSTRUCTION("41E0191E", fcvtzu(w1, s2, 8));
  TEST_INSTRUCTION("41E0591E", fcvtzu(w1, d2, 8));
  TEST_INSTRUCTION("41E0D99E", fcvtzu(x1, h2, 8));
  TEST_INSTRUCTION("41E0199E", fcvtzu(x1, s2, 8));
  TEST_INSTRUCTION("41E0599E", fcvtzu(x1, d2, 8));
  TEST_INSTRUCTION("41FC187F", fcvtzu(h1, h2, 8));
  TEST_INSTRUCTION("41FC387F", fcvtzu(s1, s2, 8));
  TEST_INSTRUCTION("41FC787F", fcvtzu(d1, d2, 8));
  TEST_INSTRUCTION("41FC182F", fcvtzu(v1.h4(), v2.h4(), 8));
  TEST_INSTRUCTION("41FC382F", fcvtzu(v1.s2(), v2.s2(), 8));
  TEST_INSTRUCTION("41FC186F", fcvtzu(v1.h8(), v2.h8(), 8));
  TEST_INSTRUCTION("41FC386F", fcvtzu(v1.s4(), v2.s4(), 8));
  TEST_INSTRUCTION("41FC786F", fcvtzu(v1.d2(), v2.d2(), 8));
  TEST_INSTRUCTION("4118E31E", fdiv(h1, h2, h3));
  TEST_INSTRUCTION("4118231E", fdiv(s1, s2, s3));
  TEST_INSTRUCTION("4118631E", fdiv(d1, d2, d3));
  TEST_INSTRUCTION("413C432E", fdiv(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41FC232E", fdiv(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("413C436E", fdiv(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41FC236E", fdiv(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41FC636E", fdiv(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41007E1E", fjcvtzs(w1, d2));
  TEST_INSTRUCTION("4110C31F", fmadd(h1, h2, h3, h4));
  TEST_INSTRUCTION("4110031F", fmadd(s1, s2, s3, s4));
  TEST_INSTRUCTION("4110431F", fmadd(d1, d2, d3, d4));
  TEST_INSTRUCTION("4148E31E", fmax(h1, h2, h3));
  TEST_INSTRUCTION("4148231E", fmax(s1, s2, s3));
  TEST_INSTRUCTION("4148631E", fmax(d1, d2, d3));
  TEST_INSTRUCTION("4134430E", fmax(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41F4230E", fmax(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4134434E", fmax(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41F4234E", fmax(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41F4634E", fmax(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4168E31E", fmaxnm(h1, h2, h3));
  TEST_INSTRUCTION("4168231E", fmaxnm(s1, s2, s3));
  TEST_INSTRUCTION("4168631E", fmaxnm(d1, d2, d3));
  TEST_INSTRUCTION("4104430E", fmaxnm(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41C4230E", fmaxnm(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4104434E", fmaxnm(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41C4234E", fmaxnm(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41C4634E", fmaxnm(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41C8305E", fmaxnmp(h1, v2.h2()));
  TEST_INSTRUCTION("41C8307E", fmaxnmp(s1, v2.s2()));
  TEST_INSTRUCTION("41C8707E", fmaxnmp(d1, v2.d2()));
  TEST_INSTRUCTION("4104432E", fmaxnmp(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41C4232E", fmaxnmp(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4104436E", fmaxnmp(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41C4236E", fmaxnmp(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41C4636E", fmaxnmp(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41C8300E", fmaxnmv(h1, v2.h4()));
  TEST_INSTRUCTION("41C8304E", fmaxnmv(h1, v2.h8()));
  TEST_INSTRUCTION("41C8306E", fmaxnmv(s1, v2.s4()));
  TEST_INSTRUCTION("41F8305E", fmaxp(h1, v2.h2()));
  TEST_INSTRUCTION("41F8307E", fmaxp(s1, v2.s2()));
  TEST_INSTRUCTION("41F8707E", fmaxp(d1, v2.d2()));
  TEST_INSTRUCTION("4134432E", fmaxp(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41F4232E", fmaxp(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4134436E", fmaxp(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41F4236E", fmaxp(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41F4636E", fmaxp(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41F8300E", fmaxv(h1, v2.h4()));
  TEST_INSTRUCTION("41F8304E", fmaxv(h1, v2.h8()));
  TEST_INSTRUCTION("41F8306E", fmaxv(s1, v2.s4()));
  TEST_INSTRUCTION("4158E31E", fmin(h1, h2, h3));
  TEST_INSTRUCTION("4158231E", fmin(s1, s2, s3));
  TEST_INSTRUCTION("4158631E", fmin(d1, d2, d3));
  TEST_INSTRUCTION("4134C30E", fmin(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41F4A30E", fmin(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4134C34E", fmin(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41F4A34E", fmin(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41F4E34E", fmin(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4178E31E", fminnm(h1, h2, h3));
  TEST_INSTRUCTION("4178231E", fminnm(s1, s2, s3));
  TEST_INSTRUCTION("4178631E", fminnm(d1, d2, d3));
  TEST_INSTRUCTION("4104C30E", fminnm(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41C4A30E", fminnm(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4104C34E", fminnm(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41C4A34E", fminnm(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41C4E34E", fminnm(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41C8B05E", fminnmp(h1, v2.h2()));
  TEST_INSTRUCTION("41C8B07E", fminnmp(s1, v2.s2()));
  TEST_INSTRUCTION("41C8F07E", fminnmp(d1, v2.d2()));
  TEST_INSTRUCTION("4104C32E", fminnmp(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41C4A32E", fminnmp(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4104C36E", fminnmp(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41C4A36E", fminnmp(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41C4E36E", fminnmp(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41C8B00E", fminnmv(h1, v2.h4()));
  TEST_INSTRUCTION("41C8B04E", fminnmv(h1, v2.h8()));
  TEST_INSTRUCTION("41C8B06E", fminnmv(s1, v2.s4()));
  TEST_INSTRUCTION("41F8B05E", fminp(h1, v2.h2()));
  TEST_INSTRUCTION("41F8B07E", fminp(s1, v2.s2()));
  TEST_INSTRUCTION("41F8F07E", fminp(d1, v2.d2()));
  TEST_INSTRUCTION("4134C32E", fminp(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41F4A32E", fminp(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4134C36E", fminp(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41F4A36E", fminp(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41F4E36E", fminp(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41F8B00E", fminv(h1, v2.h4()));
  TEST_INSTRUCTION("41F8B04E", fminv(h1, v2.h8()));
  TEST_INSTRUCTION("41F8B06E", fminv(s1, v2.s4()));
  TEST_INSTRUCTION("410C430E", fmla(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41CC230E", fmla(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("410C434E", fmla(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41CC234E", fmla(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41CC634E", fmla(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4118335F", fmla(h1, h2, v3.h(7)));
  TEST_INSTRUCTION("4118A35F", fmla(s1, s2, v3.s(3)));
  TEST_INSTRUCTION("4118C35F", fmla(d1, d2, v3.d(1)));
  TEST_INSTRUCTION("4118330F", fmla(v1.h4(), v2.h4(), v3.h(7)));
  TEST_INSTRUCTION("4118A30F", fmla(v1.s2(), v2.s2(), v3.s(3)));
  TEST_INSTRUCTION("4118334F", fmla(v1.h8(), v2.h8(), v3.h(7)));
  TEST_INSTRUCTION("4118A34F", fmla(v1.s4(), v2.s4(), v3.s(3)));
  TEST_INSTRUCTION("4118C34F", fmla(v1.d2(), v2.d2(), v3.d(1)));
  TEST_INSTRUCTION("41EC230E", fmlal(v1.s2(), v2.h2(), v3.h2()));
  TEST_INSTRUCTION("41EC234E", fmlal(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4100830F", fmlal(v1.s2(), v2.h2(), v3.h(0)));
  TEST_INSTRUCTION("4108B30F", fmlal(v1.s2(), v2.h2(), v3.h(7)));
  TEST_INSTRUCTION("4100834F", fmlal(v1.s4(), v2.h4(), v3.h(0)));
  TEST_INSTRUCTION("4108B34F", fmlal(v1.s4(), v2.h4(), v3.h(7)));
  TEST_INSTRUCTION("41CC232E", fmlal2(v1.s2(), v2.h2(), v3.h2()));
  TEST_INSTRUCTION("41CC236E", fmlal2(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4180832F", fmlal2(v1.s2(), v2.h2(), v3.h(0)));
  TEST_INSTRUCTION("4188B32F", fmlal2(v1.s2(), v2.h2(), v3.h(7)));
  TEST_INSTRUCTION("4180836F", fmlal2(v1.s4(), v2.h4(), v3.h(0)));
  TEST_INSTRUCTION("4188B36F", fmlal2(v1.s4(), v2.h4(), v3.h(7)));
  TEST_INSTRUCTION("410CC30E", fmls(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41CCA30E", fmls(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("410CC34E", fmls(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41CCA34E", fmls(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41CCE34E", fmls(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4158335F", fmls(h1, h2, v3.h(7)));
  TEST_INSTRUCTION("4158A35F", fmls(s1, s2, v3.s(3)));
  TEST_INSTRUCTION("4158C35F", fmls(d1, d2, v3.d(1)));
  TEST_INSTRUCTION("4158330F", fmls(v1.h4(), v2.h4(), v3.h(7)));
  TEST_INSTRUCTION("4158A30F", fmls(v1.s2(), v2.s2(), v3.s(3)));
  TEST_INSTRUCTION("4158334F", fmls(v1.h8(), v2.h8(), v3.h(7)));
  TEST_INSTRUCTION("4158A34F", fmls(v1.s4(), v2.s4(), v3.s(3)));
  TEST_INSTRUCTION("4158C34F", fmls(v1.d2(), v2.d2(), v3.d(1)));
  TEST_INSTRUCTION("41ECA30E", fmlsl(v1.s2(), v2.h2(), v3.h2()));
  TEST_INSTRUCTION("41ECA34E", fmlsl(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4140830F", fmlsl(v1.s2(), v2.h2(), v3.h(0)));
  TEST_INSTRUCTION("4148B30F", fmlsl(v1.s2(), v2.h2(), v3.h(7)));
  TEST_INSTRUCTION("4140834F", fmlsl(v1.s4(), v2.h4(), v3.h(0)));
  TEST_INSTRUCTION("4148B34F", fmlsl(v1.s4(), v2.h4(), v3.h(7)));
  TEST_INSTRUCTION("41CCA32E", fmlsl2(v1.s2(), v2.h2(), v3.h2()));
  TEST_INSTRUCTION("41CCA36E", fmlsl2(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41C0832F", fmlsl2(v1.s2(), v2.h2(), v3.h(0)));
  TEST_INSTRUCTION("41C8B32F", fmlsl2(v1.s2(), v2.h2(), v3.h(7)));
  TEST_INSTRUCTION("41C0836F", fmlsl2(v1.s4(), v2.h4(), v3.h(0)));
  TEST_INSTRUCTION("41C8B36F", fmlsl2(v1.s4(), v2.h4(), v3.h(7)));
  TEST_INSTRUCTION("4100E71E", fmov(h1, w2));
  TEST_INSTRUCTION("4100E79E", fmov(h1, x2));
  TEST_INSTRUCTION("4100271E", fmov(s1, w2));
  TEST_INSTRUCTION("4100679E", fmov(d1, x2));
  TEST_INSTRUCTION("4100AF9E", fmov(v1.d(1), x2));
  TEST_INSTRUCTION("4100E61E", fmov(w1, h2));
  TEST_INSTRUCTION("4100E69E", fmov(x1, h2));
  TEST_INSTRUCTION("4100261E", fmov(w1, s2));
  TEST_INSTRUCTION("4100669E", fmov(x1, d2));
  TEST_INSTRUCTION("4100AE9E", fmov(x1, v2.d(1)));
  TEST_INSTRUCTION("0110EA1E", fmov(h1, 0.25));
  TEST_INSTRUCTION("0110EC1E", fmov(h1, 0.5));
  TEST_INSTRUCTION("0110EF1E", fmov(h1, 1.5));
  TEST_INSTRUCTION("0110E01E", fmov(h1, 2.0));
  TEST_INSTRUCTION("01D0E51E", fmov(h1, 15.0));
  TEST_INSTRUCTION("01102A1E", fmov(s1, 0.25));
  TEST_INSTRUCTION("01102C1E", fmov(s1, 0.5));
  TEST_INSTRUCTION("01102F1E", fmov(s1, 1.5));
  TEST_INSTRUCTION("0110201E", fmov(s1, 2.0));
  TEST_INSTRUCTION("01D0251E", fmov(s1, 15.0));
  TEST_INSTRUCTION("01106A1E", fmov(d1, 0.25));
  TEST_INSTRUCTION("01106C1E", fmov(d1, 0.5));
  TEST_INSTRUCTION("01106F1E", fmov(d1, 1.5));
  TEST_INSTRUCTION("0110601E", fmov(d1, 2.0));
  TEST_INSTRUCTION("01D0651E", fmov(d1, 15.0));
  TEST_INSTRUCTION("01FC030F", fmov(v1.h4(), 0.5));
  TEST_INSTRUCTION("01FC000F", fmov(v1.h4(), 2.0));
  TEST_INSTRUCTION("01FC034F", fmov(v1.h8(), 0.5));
  TEST_INSTRUCTION("01FC004F", fmov(v1.h8(), 2.0));
  TEST_INSTRUCTION("01F4030F", fmov(v1.s2(), 0.5));
  TEST_INSTRUCTION("01F4000F", fmov(v1.s2(), 2.0));
  TEST_INSTRUCTION("01F4034F", fmov(v1.s4(), 0.5));
  TEST_INSTRUCTION("01F4004F", fmov(v1.s4(), 2.0));
  TEST_INSTRUCTION("01F4036F", fmov(v1.d2(), 0.5));
  TEST_INSTRUCTION("01F4006F", fmov(v1.d2(), 2.0));
  TEST_INSTRUCTION("4190C31F", fmsub(h1, h2, h3, h4));
  TEST_INSTRUCTION("4190031F", fmsub(s1, s2, s3, s4));
  TEST_INSTRUCTION("4190431F", fmsub(d1, d2, d3, d4));
  TEST_INSTRUCTION("4108E31E", fmul(h1, h2, h3));
  TEST_INSTRUCTION("4108231E", fmul(s1, s2, s3));
  TEST_INSTRUCTION("4108631E", fmul(d1, d2, d3));
  TEST_INSTRUCTION("411C432E", fmul(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41DC232E", fmul(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("411C436E", fmul(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41DC236E", fmul(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41DC636E", fmul(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4198335F", fmul(h1, h2, v3.h(7)));
  TEST_INSTRUCTION("4198A35F", fmul(s1, s2, v3.s(3)));
  TEST_INSTRUCTION("4198C35F", fmul(d1, d2, v3.d(1)));
  TEST_INSTRUCTION("4198330F", fmul(v1.h4(), v2.h4(), v3.h(7)));
  TEST_INSTRUCTION("4198A30F", fmul(v1.s2(), v2.s2(), v3.s(3)));
  TEST_INSTRUCTION("4198334F", fmul(v1.h8(), v2.h8(), v3.h(7)));
  TEST_INSTRUCTION("4198A34F", fmul(v1.s4(), v2.s4(), v3.s(3)));
  TEST_INSTRUCTION("4198C34F", fmul(v1.d2(), v2.d2(), v3.d(1)));
  TEST_INSTRUCTION("411C435E", fmulx(h1, h2, h3));
  TEST_INSTRUCTION("41DC235E", fmulx(s1, s2, s3));
  TEST_INSTRUCTION("41DC635E", fmulx(d1, d2, d3));
  TEST_INSTRUCTION("411C430E", fmulx(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41DC230E", fmulx(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("411C434E", fmulx(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41DC234E", fmulx(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41DC634E", fmulx(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4198337F", fmulx(h1, h2, v3.h(7)));
  TEST_INSTRUCTION("4198A37F", fmulx(s1, s2, v3.s(3)));
  TEST_INSTRUCTION("4198C37F", fmulx(d1, d2, v3.d(1)));
  TEST_INSTRUCTION("4198332F", fmulx(v1.h4(), v2.h4(), v3.h(7)));
  TEST_INSTRUCTION("4198A32F", fmulx(v1.s2(), v2.s2(), v3.s(3)));
  TEST_INSTRUCTION("4198336F", fmulx(v1.h8(), v2.h8(), v3.h(7)));
  TEST_INSTRUCTION("4198A36F", fmulx(v1.s4(), v2.s4(), v3.s(3)));
  TEST_INSTRUCTION("4198C36F", fmulx(v1.d2(), v2.d2(), v3.d(1)));
  TEST_INSTRUCTION("4140E11E", fneg(h1, h2));
  TEST_INSTRUCTION("4140211E", fneg(s1, s2));
  TEST_INSTRUCTION("4140611E", fneg(d1, d2));
  TEST_INSTRUCTION("41F8F82E", fneg(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("41F8A02E", fneg(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41F8F86E", fneg(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("41F8A06E", fneg(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41F8E06E", fneg(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("4110E31F", fnmadd(h1, h2, h3, h4));
  TEST_INSTRUCTION("4110231F", fnmadd(s1, s2, s3, s4));
  TEST_INSTRUCTION("4110631F", fnmadd(d1, d2, d3, d4));
  TEST_INSTRUCTION("4190E31F", fnmsub(h1, h2, h3, h4));
  TEST_INSTRUCTION("4190231F", fnmsub(s1, s2, s3, s4));
  TEST_INSTRUCTION("4190631F", fnmsub(d1, d2, d3, d4));
  TEST_INSTRUCTION("4188E31E", fnmul(h1, h2, h3));
  TEST_INSTRUCTION("4188231E", fnmul(s1, s2, s3));
  TEST_INSTRUCTION("4188631E", fnmul(d1, d2, d3));
  TEST_INSTRUCTION("41D8F95E", frecpe(h1, h2));
  TEST_INSTRUCTION("41D8A15E", frecpe(s1, s2));
  TEST_INSTRUCTION("41D8E15E", frecpe(d1, d2));
  TEST_INSTRUCTION("41D8F90E", frecpe(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("41D8A10E", frecpe(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41D8F94E", frecpe(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("41D8A14E", frecpe(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41D8E14E", frecpe(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("413C435E", frecps(h1, h2, h3));
  TEST_INSTRUCTION("41FC235E", frecps(s1, s2, s3));
  TEST_INSTRUCTION("41FC635E", frecps(d1, d2, d3));
  TEST_INSTRUCTION("413C430E", frecps(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41FC230E", frecps(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("413C434E", frecps(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41FC234E", frecps(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41FC634E", frecps(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41F8F95E", frecpx(h1, h2));
  TEST_INSTRUCTION("41F8A15E", frecpx(s1, s2));
  TEST_INSTRUCTION("41F8E15E", frecpx(d1, d2));
  TEST_INSTRUCTION("41C0281E", frint32x(s1, s2));
  TEST_INSTRUCTION("41C0681E", frint32x(d1, d2));
  TEST_INSTRUCTION("41E8212E", frint32x(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41E8216E", frint32x(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41E8616E", frint32x(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("4140281E", frint32z(s1, s2));
  TEST_INSTRUCTION("4140681E", frint32z(d1, d2));
  TEST_INSTRUCTION("41E8210E", frint32z(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41E8214E", frint32z(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41E8614E", frint32z(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("41C0291E", frint64x(s1, s2));
  TEST_INSTRUCTION("41C0691E", frint64x(d1, d2));
  TEST_INSTRUCTION("41F8212E", frint64x(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41F8216E", frint64x(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41F8616E", frint64x(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("4140291E", frint64z(s1, s2));
  TEST_INSTRUCTION("4140691E", frint64z(d1, d2));
  TEST_INSTRUCTION("41F8210E", frint64z(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41F8214E", frint64z(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41F8614E", frint64z(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("4140E61E", frinta(h1, h2));
  TEST_INSTRUCTION("4140261E", frinta(s1, s2));
  TEST_INSTRUCTION("4140661E", frinta(d1, d2));
  TEST_INSTRUCTION("4188792E", frinta(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("4188212E", frinta(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("4188796E", frinta(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("4188216E", frinta(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("4188616E", frinta(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("41C0E71E", frinti(h1, h2));
  TEST_INSTRUCTION("41C0271E", frinti(s1, s2));
  TEST_INSTRUCTION("41C0671E", frinti(d1, d2));
  TEST_INSTRUCTION("4198F92E", frinti(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("4198A12E", frinti(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("4198F96E", frinti(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("4198A16E", frinti(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("4198E16E", frinti(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("4140E51E", frintm(h1, h2));
  TEST_INSTRUCTION("4140251E", frintm(s1, s2));
  TEST_INSTRUCTION("4140651E", frintm(d1, d2));
  TEST_INSTRUCTION("4198790E", frintm(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("4198210E", frintm(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("4198794E", frintm(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("4198214E", frintm(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("4198614E", frintm(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("4140E41E", frintn(h1, h2));
  TEST_INSTRUCTION("4140241E", frintn(s1, s2));
  TEST_INSTRUCTION("4140641E", frintn(d1, d2));
  TEST_INSTRUCTION("4188790E", frintn(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("4188210E", frintn(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("4188794E", frintn(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("4188214E", frintn(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("4188614E", frintn(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("41C0E41E", frintp(h1, h2));
  TEST_INSTRUCTION("41C0241E", frintp(s1, s2));
  TEST_INSTRUCTION("41C0641E", frintp(d1, d2));
  TEST_INSTRUCTION("4188F90E", frintp(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("4188A10E", frintp(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("4188F94E", frintp(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("4188A14E", frintp(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("4188E14E", frintp(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("4140E71E", frintx(h1, h2));
  TEST_INSTRUCTION("4140271E", frintx(s1, s2));
  TEST_INSTRUCTION("4140671E", frintx(d1, d2));
  TEST_INSTRUCTION("4198792E", frintx(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("4198212E", frintx(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("4198796E", frintx(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("4198216E", frintx(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("4198616E", frintx(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("41C0E51E", frintz(h1, h2));
  TEST_INSTRUCTION("41C0251E", frintz(s1, s2));
  TEST_INSTRUCTION("41C0651E", frintz(d1, d2));
  TEST_INSTRUCTION("4198F90E", frintz(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("4198A10E", frintz(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("4198F94E", frintz(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("4198A14E", frintz(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("4198E14E", frintz(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("41D8F97E", frsqrte(h1, h2));
  TEST_INSTRUCTION("41D8A17E", frsqrte(s1, s2));
  TEST_INSTRUCTION("41D8E17E", frsqrte(d1, d2));
  TEST_INSTRUCTION("41D8F92E", frsqrte(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("41D8A12E", frsqrte(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41D8F96E", frsqrte(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("41D8A16E", frsqrte(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41D8E16E", frsqrte(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("413CC35E", frsqrts(h1, h2, h3));
  TEST_INSTRUCTION("41FCA35E", frsqrts(s1, s2, s3));
  TEST_INSTRUCTION("41FCE35E", frsqrts(d1, d2, d3));
  TEST_INSTRUCTION("413CC30E", frsqrts(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41FCA30E", frsqrts(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("413CC34E", frsqrts(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41FCA34E", frsqrts(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41FCE34E", frsqrts(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41C0E11E", fsqrt(h1, h2));
  TEST_INSTRUCTION("41C0211E", fsqrt(s1, s2));
  TEST_INSTRUCTION("41C0611E", fsqrt(d1, d2));
  TEST_INSTRUCTION("41F8F92E", fsqrt(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("41F8A12E", fsqrt(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41F8F96E", fsqrt(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("41F8A16E", fsqrt(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41F8E16E", fsqrt(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("4138E31E", fsub(h1, h2, h3));
  TEST_INSTRUCTION("4138231E", fsub(s1, s2, s3));
  TEST_INSTRUCTION("4138631E", fsub(d1, d2, d3));
  TEST_INSTRUCTION("4114C30E", fsub(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41D4A30E", fsub(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4114C34E", fsub(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41D4A34E", fsub(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41D4E34E", fsub(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("411C014E", ins(v1.b(0), w2));
  TEST_INSTRUCTION("411C074E", ins(v1.b(3), w2));
  TEST_INSTRUCTION("411C0D4E", ins(v1.b(6), w2));
  TEST_INSTRUCTION("411C134E", ins(v1.b(9), w2));
  TEST_INSTRUCTION("411C1F4E", ins(v1.b(15), w2));
  TEST_INSTRUCTION("411C024E", ins(v1.h(0), w2));
  TEST_INSTRUCTION("411C0E4E", ins(v1.h(3), w2));
  TEST_INSTRUCTION("411C1E4E", ins(v1.h(7), w2));
  TEST_INSTRUCTION("411C044E", ins(v1.s(0), w2));
  TEST_INSTRUCTION("411C0C4E", ins(v1.s(1), w2));
  TEST_INSTRUCTION("411C144E", ins(v1.s(2), w2));
  TEST_INSTRUCTION("411C1C4E", ins(v1.s(3), w2));
  TEST_INSTRUCTION("411C084E", ins(v1.d(0), x2));
  TEST_INSTRUCTION("411C184E", ins(v1.d(1), x2));
  TEST_INSTRUCTION("417C016E", ins(v1.b(0), v2.b(15)));
  TEST_INSTRUCTION("4174036E", ins(v1.b(1), v2.b(14)));
  TEST_INSTRUCTION("4174026E", ins(v1.h(0), v2.h(7)));
  TEST_INSTRUCTION("4164066E", ins(v1.h(1), v2.h(6)));
  TEST_INSTRUCTION("4164046E", ins(v1.s(0), v2.s(3)));
  TEST_INSTRUCTION("41440C6E", ins(v1.s(1), v2.s(2)));
  TEST_INSTRUCTION("4144086E", ins(v1.d(0), v2.d(1)));
  TEST_INSTRUCTION("4104186E", ins(v1.d(1), v2.d(0)));
  TEST_INSTRUCTION("4100400D", ld1(v1.b(0), ptr(x2)));
  TEST_INSTRUCTION("4100DF0D", ld1(v1.b(0), ptr_post(x2, 1)));
  TEST_INSTRUCTION("4100CB0D", ld1(v1.b(0), ptr_post(x2, x11)));
  TEST_INSTRUCTION("4140400D", ld1(v1.h(0), ptr(x2)));
  TEST_INSTRUCTION("4140DF0D", ld1(v1.h(0), ptr_post(x2, 2)));
  TEST_INSTRUCTION("4140CB0D", ld1(v1.h(0), ptr_post(x2, x11)));
  TEST_INSTRUCTION("4180400D", ld1(v1.s(0), ptr(x2)));
  TEST_INSTRUCTION("4180DF0D", ld1(v1.s(0), ptr_post(x2, 4)));
  TEST_INSTRUCTION("4180CB0D", ld1(v1.s(0), ptr_post(x2, x11)));
  TEST_INSTRUCTION("4184400D", ld1(v1.d(0), ptr(x2)));
  TEST_INSTRUCTION("4184DF0D", ld1(v1.d(0), ptr_post(x2, 8)));
  TEST_INSTRUCTION("4184CB0D", ld1(v1.d(0), ptr_post(x2, x11)));
  TEST_INSTRUCTION("411C404D", ld1(v1.b(15), ptr(x2)));
  TEST_INSTRUCTION("411CDF4D", ld1(v1.b(15), ptr_post(x2, 1)));
  TEST_INSTRUCTION("411CCB4D", ld1(v1.b(15), ptr_post(x2, x11)));
  TEST_INSTRUCTION("4158404D", ld1(v1.h(7), ptr(x2)));
  TEST_INSTRUCTION("4158DF4D", ld1(v1.h(7), ptr_post(x2, 2)));
  TEST_INSTRUCTION("4158CB4D", ld1(v1.h(7), ptr_post(x2, x11)));
  TEST_INSTRUCTION("4190404D", ld1(v1.s(3), ptr(x2)));
  TEST_INSTRUCTION("4190DF4D", ld1(v1.s(3), ptr_post(x2, 4)));
  TEST_INSTRUCTION("4190CB4D", ld1(v1.s(3), ptr_post(x2, x11)));
  TEST_INSTRUCTION("4184404D", ld1(v1.d(1), ptr(x2)));
  TEST_INSTRUCTION("4184DF4D", ld1(v1.d(1), ptr_post(x2, 8)));
  TEST_INSTRUCTION("4184CB4D", ld1(v1.d(1), ptr_post(x2, x11)));
  TEST_INSTRUCTION("4170400C", ld1(v1.b8(), ptr(x2)));
  TEST_INSTRUCTION("4170DF0C", ld1(v1.b8(), ptr_post(x2, 8)));
  TEST_INSTRUCTION("4170404C", ld1(v1.b16(), ptr(x2)));
  TEST_INSTRUCTION("4170DF4C", ld1(v1.b16(), ptr_post(x2, 16)));
  TEST_INSTRUCTION("61A0400C", ld1(v1.b8(), v2.b8(), ptr(x3)));
  TEST_INSTRUCTION("61A0DF0C", ld1(v1.b8(), v2.b8(), ptr_post(x3, 16)));
  TEST_INSTRUCTION("61A0404C", ld1(v1.b16(), v2.b16(), ptr(x3)));
  TEST_INSTRUCTION("61A0DF4C", ld1(v1.b16(), v2.b16(), ptr_post(x3, 32)));
  TEST_INSTRUCTION("8160400C", ld1(v1.b8(), v2.b8(), v3.b8(), ptr(x4)));
  TEST_INSTRUCTION("8160DF0C", ld1(v1.b8(), v2.b8(), v3.b8(), ptr_post(x4, 24)));
  TEST_INSTRUCTION("8160404C", ld1(v1.b16(), v2.b16(), v3.b16(), ptr(x4)));
  TEST_INSTRUCTION("8160DF4C", ld1(v1.b16(), v2.b16(), v3.b16(), ptr_post(x4, 48)));
  TEST_INSTRUCTION("A120400C", ld1(v1.b8(), v2.b8(), v3.b8(), v4.b8(), ptr(x5)));
  TEST_INSTRUCTION("A120DF0C", ld1(v1.b8(), v2.b8(), v3.b8(), v4.b8(), ptr_post(x5, 32)));
  TEST_INSTRUCTION("A120404C", ld1(v1.b16(), v2.b16(), v3.b16(), v4.b16(), ptr(x5)));
  TEST_INSTRUCTION("A120DF4C", ld1(v1.b16(), v2.b16(), v3.b16(), v4.b16(), ptr_post(x5, 64)));
  TEST_INSTRUCTION("4174400C", ld1(v1.h4(), ptr(x2)));
  TEST_INSTRUCTION("4174DF0C", ld1(v1.h4(), ptr_post(x2, 8)));
  TEST_INSTRUCTION("4174404C", ld1(v1.h8(), ptr(x2)));
  TEST_INSTRUCTION("4174DF4C", ld1(v1.h8(), ptr_post(x2, 16)));
  TEST_INSTRUCTION("61A4400C", ld1(v1.h4(), v2.h4(), ptr(x3)));
  TEST_INSTRUCTION("61A4DF0C", ld1(v1.h4(), v2.h4(), ptr_post(x3, 16)));
  TEST_INSTRUCTION("61A4404C", ld1(v1.h8(), v2.h8(), ptr(x3)));
  TEST_INSTRUCTION("61A4DF4C", ld1(v1.h8(), v2.h8(), ptr_post(x3, 32)));
  TEST_INSTRUCTION("8164400C", ld1(v1.h4(), v2.h4(), v3.h4(), ptr(x4)));
  TEST_INSTRUCTION("8164DF0C", ld1(v1.h4(), v2.h4(), v3.h4(), ptr_post(x4, 24)));
  TEST_INSTRUCTION("8164404C", ld1(v1.h8(), v2.h8(), v3.h8(), ptr(x4)));
  TEST_INSTRUCTION("8164DF4C", ld1(v1.h8(), v2.h8(), v3.h8(), ptr_post(x4, 48)));
  TEST_INSTRUCTION("A124400C", ld1(v1.h4(), v2.h4(), v3.h4(), v4.h4(), ptr(x5)));
  TEST_INSTRUCTION("A124DF0C", ld1(v1.h4(), v2.h4(), v3.h4(), v4.h4(), ptr_post(x5, 32)));
  TEST_INSTRUCTION("A124404C", ld1(v1.h8(), v2.h8(), v3.h8(), v4.h8(), ptr(x5)));
  TEST_INSTRUCTION("A124DF4C", ld1(v1.h8(), v2.h8(), v3.h8(), v4.h8(), ptr_post(x5, 64)));
  TEST_INSTRUCTION("4178400C", ld1(v1.s2(), ptr(x2)));
  TEST_INSTRUCTION("4178DF0C", ld1(v1.s2(), ptr_post(x2, 8)));
  TEST_INSTRUCTION("4178404C", ld1(v1.s4(), ptr(x2)));
  TEST_INSTRUCTION("4178DF4C", ld1(v1.s4(), ptr_post(x2, 16)));
  TEST_INSTRUCTION("61A8400C", ld1(v1.s2(), v2.s2(), ptr(x3)));
  TEST_INSTRUCTION("61A8DF0C", ld1(v1.s2(), v2.s2(), ptr_post(x3, 16)));
  TEST_INSTRUCTION("61A8404C", ld1(v1.s4(), v2.s4(), ptr(x3)));
  TEST_INSTRUCTION("61A8DF4C", ld1(v1.s4(), v2.s4(), ptr_post(x3, 32)));
  TEST_INSTRUCTION("8168400C", ld1(v1.s2(), v2.s2(), v3.s2(), ptr(x4)));
  TEST_INSTRUCTION("8168DF0C", ld1(v1.s2(), v2.s2(), v3.s2(), ptr_post(x4, 24)));
  TEST_INSTRUCTION("8168404C", ld1(v1.s4(), v2.s4(), v3.s4(), ptr(x4)));
  TEST_INSTRUCTION("8168DF4C", ld1(v1.s4(), v2.s4(), v3.s4(), ptr_post(x4, 48)));
  TEST_INSTRUCTION("A128400C", ld1(v1.s2(), v2.s2(), v3.s2(), v4.s2(), ptr(x5)));
  TEST_INSTRUCTION("A128DF0C", ld1(v1.s2(), v2.s2(), v3.s2(), v4.s2(), ptr_post(x5, 32)));
  TEST_INSTRUCTION("A128404C", ld1(v1.s4(), v2.s4(), v3.s4(), v4.s4(), ptr(x5)));
  TEST_INSTRUCTION("A128DF4C", ld1(v1.s4(), v2.s4(), v3.s4(), v4.s4(), ptr_post(x5, 64)));
  TEST_INSTRUCTION("417C404C", ld1(v1.d2(), ptr(x2)));
  TEST_INSTRUCTION("417CDF4C", ld1(v1.d2(), ptr_post(x2, 16)));
  TEST_INSTRUCTION("61AC404C", ld1(v1.d2(), v2.d2(), ptr(x3)));
  TEST_INSTRUCTION("61ACDF4C", ld1(v1.d2(), v2.d2(), ptr_post(x3, 32)));
  TEST_INSTRUCTION("816C404C", ld1(v1.d2(), v2.d2(), v3.d2(), ptr(x4)));
  TEST_INSTRUCTION("816CDF4C", ld1(v1.d2(), v2.d2(), v3.d2(), ptr_post(x4, 48)));
  TEST_INSTRUCTION("A12C404C", ld1(v1.d2(), v2.d2(), v3.d2(), v4.d2(), ptr(x5)));
  TEST_INSTRUCTION("A12CDF4C", ld1(v1.d2(), v2.d2(), v3.d2(), v4.d2(), ptr_post(x5, 64)));
  TEST_INSTRUCTION("41C0400D", ld1r(v1.b8(), ptr(x2)));
  TEST_INSTRUCTION("41C0DF0D", ld1r(v1.b8(), ptr_post(x2, 1)));
  TEST_INSTRUCTION("41C0CB0D", ld1r(v1.b8(), ptr_post(x2, x11)));
  TEST_INSTRUCTION("41C0404D", ld1r(v1.b16(), ptr(x2)));
  TEST_INSTRUCTION("41C0DF4D", ld1r(v1.b16(), ptr_post(x2, 1)));
  TEST_INSTRUCTION("41C0CB4D", ld1r(v1.b16(), ptr_post(x2, x11)));
  TEST_INSTRUCTION("41C4400D", ld1r(v1.h4(), ptr(x2)));
  TEST_INSTRUCTION("41C4DF0D", ld1r(v1.h4(), ptr_post(x2, 2)));
  TEST_INSTRUCTION("41C4CB0D", ld1r(v1.h4(), ptr_post(x2, x11)));
  TEST_INSTRUCTION("41C4404D", ld1r(v1.h8(), ptr(x2)));
  TEST_INSTRUCTION("41C4DF4D", ld1r(v1.h8(), ptr_post(x2, 2)));
  TEST_INSTRUCTION("41C4CB4D", ld1r(v1.h8(), ptr_post(x2, x11)));
  TEST_INSTRUCTION("41C8400D", ld1r(v1.s2(), ptr(x2)));
  TEST_INSTRUCTION("41C8DF0D", ld1r(v1.s2(), ptr_post(x2, 4)));
  TEST_INSTRUCTION("41C8CB0D", ld1r(v1.s2(), ptr_post(x2, x11)));
  TEST_INSTRUCTION("41C8404D", ld1r(v1.s4(), ptr(x2)));
  TEST_INSTRUCTION("41C8DF4D", ld1r(v1.s4(), ptr_post(x2, 4)));
  TEST_INSTRUCTION("41C8CB4D", ld1r(v1.s4(), ptr_post(x2, x11)));
  TEST_INSTRUCTION("41CC404D", ld1r(v1.d2(), ptr(x2)));
  TEST_INSTRUCTION("41CCDF4D", ld1r(v1.d2(), ptr_post(x2, 8)));
  TEST_INSTRUCTION("41CCCB4D", ld1r(v1.d2(), ptr_post(x2, x11)));
  TEST_INSTRUCTION("6100600D", ld2(v1.b(0), v2.b(0), ptr(x3)));
  TEST_INSTRUCTION("6100FF0D", ld2(v1.b(0), v2.b(0), ptr_post(x3, 2)));
  TEST_INSTRUCTION("6100EB0D", ld2(v1.b(0), v2.b(0), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6140600D", ld2(v1.h(0), v2.h(0), ptr(x3)));
  TEST_INSTRUCTION("6140FF0D", ld2(v1.h(0), v2.h(0), ptr_post(x3, 4)));
  TEST_INSTRUCTION("6140EB0D", ld2(v1.h(0), v2.h(0), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6180600D", ld2(v1.s(0), v2.s(0), ptr(x3)));
  TEST_INSTRUCTION("6180FF0D", ld2(v1.s(0), v2.s(0), ptr_post(x3, 8)));
  TEST_INSTRUCTION("6180EB0D", ld2(v1.s(0), v2.s(0), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6184600D", ld2(v1.d(0), v2.d(0), ptr(x3)));
  TEST_INSTRUCTION("6184FF0D", ld2(v1.d(0), v2.d(0), ptr_post(x3, 16)));
  TEST_INSTRUCTION("6184EB0D", ld2(v1.d(0), v2.d(0), ptr_post(x3, x11)));
  TEST_INSTRUCTION("611C604D", ld2(v1.b(15), v2.b(15), ptr(x3)));
  TEST_INSTRUCTION("611CFF4D", ld2(v1.b(15), v2.b(15), ptr_post(x3, 2)));
  TEST_INSTRUCTION("611CEB4D", ld2(v1.b(15), v2.b(15), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6158604D", ld2(v1.h(7), v2.h(7), ptr(x3)));
  TEST_INSTRUCTION("6158FF4D", ld2(v1.h(7), v2.h(7), ptr_post(x3, 4)));
  TEST_INSTRUCTION("6158EB4D", ld2(v1.h(7), v2.h(7), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6190604D", ld2(v1.s(3), v2.s(3), ptr(x3)));
  TEST_INSTRUCTION("6190FF4D", ld2(v1.s(3), v2.s(3), ptr_post(x3, 8)));
  TEST_INSTRUCTION("6190EB4D", ld2(v1.s(3), v2.s(3), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6184604D", ld2(v1.d(1), v2.d(1), ptr(x3)));
  TEST_INSTRUCTION("6184FF4D", ld2(v1.d(1), v2.d(1), ptr_post(x3, 16)));
  TEST_INSTRUCTION("6184EB4D", ld2(v1.d(1), v2.d(1), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6180400C", ld2(v1.b8(), v2.b8(), ptr(x3)));
  TEST_INSTRUCTION("6180DF0C", ld2(v1.b8(), v2.b8(), ptr_post(x3, 16)));
  TEST_INSTRUCTION("6180CB0C", ld2(v1.b8(), v2.b8(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6180404C", ld2(v1.b16(), v2.b16(), ptr(x3)));
  TEST_INSTRUCTION("6180DF4C", ld2(v1.b16(), v2.b16(), ptr_post(x3, 32)));
  TEST_INSTRUCTION("6180CB4C", ld2(v1.b16(), v2.b16(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6184400C", ld2(v1.h4(), v2.h4(), ptr(x3)));
  TEST_INSTRUCTION("6184DF0C", ld2(v1.h4(), v2.h4(), ptr_post(x3, 16)));
  TEST_INSTRUCTION("6184CB0C", ld2(v1.h4(), v2.h4(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6184404C", ld2(v1.h8(), v2.h8(), ptr(x3)));
  TEST_INSTRUCTION("6184DF4C", ld2(v1.h8(), v2.h8(), ptr_post(x3, 32)));
  TEST_INSTRUCTION("6184CB4C", ld2(v1.h8(), v2.h8(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6188400C", ld2(v1.s2(), v2.s2(), ptr(x3)));
  TEST_INSTRUCTION("6188DF0C", ld2(v1.s2(), v2.s2(), ptr_post(x3, 16)));
  TEST_INSTRUCTION("6188CB0C", ld2(v1.s2(), v2.s2(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6188404C", ld2(v1.s4(), v2.s4(), ptr(x3)));
  TEST_INSTRUCTION("6188DF4C", ld2(v1.s4(), v2.s4(), ptr_post(x3, 32)));
  TEST_INSTRUCTION("6188CB4C", ld2(v1.s4(), v2.s4(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("618C404C", ld2(v1.d2(), v2.d2(), ptr(x3)));
  TEST_INSTRUCTION("618CDF4C", ld2(v1.d2(), v2.d2(), ptr_post(x3, 32)));
  TEST_INSTRUCTION("618CCB4C", ld2(v1.d2(), v2.d2(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("61C0600D", ld2r(v1.b8(), v2.b8(), ptr(x3)));
  TEST_INSTRUCTION("61C0FF0D", ld2r(v1.b8(), v2.b8(), ptr_post(x3, 2)));
  TEST_INSTRUCTION("61C0EB0D", ld2r(v1.b8(), v2.b8(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("61C0604D", ld2r(v1.b16(), v2.b16(), ptr(x3)));
  TEST_INSTRUCTION("61C0FF4D", ld2r(v1.b16(), v2.b16(), ptr_post(x3, 2)));
  TEST_INSTRUCTION("61C0EB4D", ld2r(v1.b16(), v2.b16(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("61C4600D", ld2r(v1.h4(), v2.h4(), ptr(x3)));
  TEST_INSTRUCTION("61C4FF0D", ld2r(v1.h4(), v2.h4(), ptr_post(x3, 4)));
  TEST_INSTRUCTION("61C4EB0D", ld2r(v1.h4(), v2.h4(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("61C4604D", ld2r(v1.h8(), v2.h8(), ptr(x3)));
  TEST_INSTRUCTION("61C4FF4D", ld2r(v1.h8(), v2.h8(), ptr_post(x3, 4)));
  TEST_INSTRUCTION("61C4EB4D", ld2r(v1.h8(), v2.h8(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("61C8600D", ld2r(v1.s2(), v2.s2(), ptr(x3)));
  TEST_INSTRUCTION("61C8FF0D", ld2r(v1.s2(), v2.s2(), ptr_post(x3, 8)));
  TEST_INSTRUCTION("61C8EB0D", ld2r(v1.s2(), v2.s2(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("61C8604D", ld2r(v1.s4(), v2.s4(), ptr(x3)));
  TEST_INSTRUCTION("61C8FF4D", ld2r(v1.s4(), v2.s4(), ptr_post(x3, 8)));
  TEST_INSTRUCTION("61C8EB4D", ld2r(v1.s4(), v2.s4(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("61CC604D", ld2r(v1.d2(), v2.d2(), ptr(x3)));
  TEST_INSTRUCTION("61CCFF4D", ld2r(v1.d2(), v2.d2(), ptr_post(x3, 16)));
  TEST_INSTRUCTION("61CCEB4D", ld2r(v1.d2(), v2.d2(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("8120400D", ld3(v1.b(0), v2.b(0), v3.b(0), ptr(x4)));
  TEST_INSTRUCTION("8120DF0D", ld3(v1.b(0), v2.b(0), v3.b(0), ptr_post(x4, 3)));
  TEST_INSTRUCTION("8120CB0D", ld3(v1.b(0), v2.b(0), v3.b(0), ptr_post(x4, x11)));
  TEST_INSTRUCTION("8160400D", ld3(v1.h(0), v2.h(0), v3.h(0), ptr(x4)));
  TEST_INSTRUCTION("8160DF0D", ld3(v1.h(0), v2.h(0), v3.h(0), ptr_post(x4, 6)));
  TEST_INSTRUCTION("8160CB0D", ld3(v1.h(0), v2.h(0), v3.h(0), ptr_post(x4, x11)));
  TEST_INSTRUCTION("81A0400D", ld3(v1.s(0), v2.s(0), v3.s(0), ptr(x4)));
  TEST_INSTRUCTION("81A0DF0D", ld3(v1.s(0), v2.s(0), v3.s(0), ptr_post(x4, 12)));
  TEST_INSTRUCTION("81A0CB0D", ld3(v1.s(0), v2.s(0), v3.s(0), ptr_post(x4, x11)));
  TEST_INSTRUCTION("81A4400D", ld3(v1.d(0), v2.d(0), v3.d(0), ptr(x4)));
  TEST_INSTRUCTION("81A4DF0D", ld3(v1.d(0), v2.d(0), v3.d(0), ptr_post(x4, 24)));
  TEST_INSTRUCTION("81A4CB0D", ld3(v1.d(0), v2.d(0), v3.d(0), ptr_post(x4, x11)));
  TEST_INSTRUCTION("813C404D", ld3(v1.b(15), v2.b(15), v3.b(15), ptr(x4)));
  TEST_INSTRUCTION("813CDF4D", ld3(v1.b(15), v2.b(15), v3.b(15), ptr_post(x4, 3)));
  TEST_INSTRUCTION("813CCB4D", ld3(v1.b(15), v2.b(15), v3.b(15), ptr_post(x4, x11)));
  TEST_INSTRUCTION("8178404D", ld3(v1.h(7), v2.h(7), v3.h(7), ptr(x4)));
  TEST_INSTRUCTION("8178DF4D", ld3(v1.h(7), v2.h(7), v3.h(7), ptr_post(x4, 6)));
  TEST_INSTRUCTION("8178CB4D", ld3(v1.h(7), v2.h(7), v3.h(7), ptr_post(x4, x11)));
  TEST_INSTRUCTION("81B0404D", ld3(v1.s(3), v2.s(3), v3.s(3), ptr(x4)));
  TEST_INSTRUCTION("81B0DF4D", ld3(v1.s(3), v2.s(3), v3.s(3), ptr_post(x4, 12)));
  TEST_INSTRUCTION("81B0CB4D", ld3(v1.s(3), v2.s(3), v3.s(3), ptr_post(x4, x11)));
  TEST_INSTRUCTION("81A4404D", ld3(v1.d(1), v2.d(1), v3.d(1), ptr(x4)));
  TEST_INSTRUCTION("81A4DF4D", ld3(v1.d(1), v2.d(1), v3.d(1), ptr_post(x4, 24)));
  TEST_INSTRUCTION("81A4CB4D", ld3(v1.d(1), v2.d(1), v3.d(1), ptr_post(x4, x11)));
  TEST_INSTRUCTION("8140400C", ld3(v1.b8(), v2.b8(), v3.b8(), ptr(x4)));
  TEST_INSTRUCTION("8140DF0C", ld3(v1.b8(), v2.b8(), v3.b8(), ptr_post(x4, 24)));
  TEST_INSTRUCTION("8140CB0C", ld3(v1.b8(), v2.b8(), v3.b8(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("8140404C", ld3(v1.b16(), v2.b16(), v3.b16(), ptr(x4)));
  TEST_INSTRUCTION("8140DF4C", ld3(v1.b16(), v2.b16(), v3.b16(), ptr_post(x4, 48)));
  TEST_INSTRUCTION("8140CB4C", ld3(v1.b16(), v2.b16(), v3.b16(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("8144400C", ld3(v1.h4(), v2.h4(), v3.h4(), ptr(x4)));
  TEST_INSTRUCTION("8144DF0C", ld3(v1.h4(), v2.h4(), v3.h4(), ptr_post(x4, 24)));
  TEST_INSTRUCTION("8144CB0C", ld3(v1.h4(), v2.h4(), v3.h4(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("8144404C", ld3(v1.h8(), v2.h8(), v3.h8(), ptr(x4)));
  TEST_INSTRUCTION("8144DF4C", ld3(v1.h8(), v2.h8(), v3.h8(), ptr_post(x4, 48)));
  TEST_INSTRUCTION("8144CB4C", ld3(v1.h8(), v2.h8(), v3.h8(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("8148400C", ld3(v1.s2(), v2.s2(), v3.s2(), ptr(x4)));
  TEST_INSTRUCTION("8148DF0C", ld3(v1.s2(), v2.s2(), v3.s2(), ptr_post(x4, 24)));
  TEST_INSTRUCTION("8148CB0C", ld3(v1.s2(), v2.s2(), v3.s2(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("8148404C", ld3(v1.s4(), v2.s4(), v3.s4(), ptr(x4)));
  TEST_INSTRUCTION("8148DF4C", ld3(v1.s4(), v2.s4(), v3.s4(), ptr_post(x4, 48)));
  TEST_INSTRUCTION("8148CB4C", ld3(v1.s4(), v2.s4(), v3.s4(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("814C404C", ld3(v1.d2(), v2.d2(), v3.d2(), ptr(x4)));
  TEST_INSTRUCTION("814CDF4C", ld3(v1.d2(), v2.d2(), v3.d2(), ptr_post(x4, 48)));
  TEST_INSTRUCTION("814CCB4C", ld3(v1.d2(), v2.d2(), v3.d2(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("81E0400D", ld3r(v1.b8(), v2.b8(), v3.b8(), ptr(x4)));
  TEST_INSTRUCTION("81E0DF0D", ld3r(v1.b8(), v2.b8(), v3.b8(), ptr_post(x4, 3)));
  TEST_INSTRUCTION("81E0CB0D", ld3r(v1.b8(), v2.b8(), v3.b8(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("81E0404D", ld3r(v1.b16(), v2.b16(), v3.b16(), ptr(x4)));
  TEST_INSTRUCTION("81E0DF4D", ld3r(v1.b16(), v2.b16(), v3.b16(), ptr_post(x4, 3)));
  TEST_INSTRUCTION("81E0CB4D", ld3r(v1.b16(), v2.b16(), v3.b16(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("81E4400D", ld3r(v1.h4(), v2.h4(), v3.h4(), ptr(x4)));
  TEST_INSTRUCTION("81E4DF0D", ld3r(v1.h4(), v2.h4(), v3.h4(), ptr_post(x4, 6)));
  TEST_INSTRUCTION("81E4CB0D", ld3r(v1.h4(), v2.h4(), v3.h4(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("81E4404D", ld3r(v1.h8(), v2.h8(), v3.h8(), ptr(x4)));
  TEST_INSTRUCTION("81E4DF4D", ld3r(v1.h8(), v2.h8(), v3.h8(), ptr_post(x4, 6)));
  TEST_INSTRUCTION("81E4CB4D", ld3r(v1.h8(), v2.h8(), v3.h8(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("81E8400D", ld3r(v1.s2(), v2.s2(), v3.s2(), ptr(x4)));
  TEST_INSTRUCTION("81E8DF0D", ld3r(v1.s2(), v2.s2(), v3.s2(), ptr_post(x4, 12)));
  TEST_INSTRUCTION("81E8CB0D", ld3r(v1.s2(), v2.s2(), v3.s2(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("81E8404D", ld3r(v1.s4(), v2.s4(), v3.s4(), ptr(x4)));
  TEST_INSTRUCTION("81E8DF4D", ld3r(v1.s4(), v2.s4(), v3.s4(), ptr_post(x4, 12)));
  TEST_INSTRUCTION("81E8CB4D", ld3r(v1.s4(), v2.s4(), v3.s4(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("81EC404D", ld3r(v1.d2(), v2.d2(), v3.d2(), ptr(x4)));
  TEST_INSTRUCTION("81ECDF4D", ld3r(v1.d2(), v2.d2(), v3.d2(), ptr_post(x4, 24)));
  TEST_INSTRUCTION("81ECCB4D", ld3r(v1.d2(), v2.d2(), v3.d2(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("A120600D", ld4(v1.b(0), v2.b(0), v3.b(0), v4.b(0), ptr(x5)));
  TEST_INSTRUCTION("A120FF0D", ld4(v1.b(0), v2.b(0), v3.b(0), v4.b(0), ptr_post(x5, 4)));
  TEST_INSTRUCTION("A120EB0D", ld4(v1.b(0), v2.b(0), v3.b(0), v4.b(0), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A160600D", ld4(v1.h(0), v2.h(0), v3.h(0), v4.h(0), ptr(x5)));
  TEST_INSTRUCTION("A160FF0D", ld4(v1.h(0), v2.h(0), v3.h(0), v4.h(0), ptr_post(x5, 8)));
  TEST_INSTRUCTION("A160EB0D", ld4(v1.h(0), v2.h(0), v3.h(0), v4.h(0), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A1A0600D", ld4(v1.s(0), v2.s(0), v3.s(0), v4.s(0), ptr(x5)));
  TEST_INSTRUCTION("A1A0FF0D", ld4(v1.s(0), v2.s(0), v3.s(0), v4.s(0), ptr_post(x5, 16)));
  TEST_INSTRUCTION("A1A0EB0D", ld4(v1.s(0), v2.s(0), v3.s(0), v4.s(0), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A1A4600D", ld4(v1.d(0), v2.d(0), v3.d(0), v4.d(0), ptr(x5)));
  TEST_INSTRUCTION("A1A4FF0D", ld4(v1.d(0), v2.d(0), v3.d(0), v4.d(0), ptr_post(x5, 32)));
  TEST_INSTRUCTION("A1A4EB0D", ld4(v1.d(0), v2.d(0), v3.d(0), v4.d(0), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A13C604D", ld4(v1.b(15), v2.b(15), v3.b(15), v4.b(15), ptr(x5)));
  TEST_INSTRUCTION("A13CFF4D", ld4(v1.b(15), v2.b(15), v3.b(15), v4.b(15), ptr_post(x5, 4)));
  TEST_INSTRUCTION("A13CEB4D", ld4(v1.b(15), v2.b(15), v3.b(15), v4.b(15), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A178604D", ld4(v1.h(7), v2.h(7), v3.h(7), v4.h(7), ptr(x5)));
  TEST_INSTRUCTION("A178FF4D", ld4(v1.h(7), v2.h(7), v3.h(7), v4.h(7), ptr_post(x5, 8)));
  TEST_INSTRUCTION("A178EB4D", ld4(v1.h(7), v2.h(7), v3.h(7), v4.h(7), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A1B0604D", ld4(v1.s(3), v2.s(3), v3.s(3), v4.s(3), ptr(x5)));
  TEST_INSTRUCTION("A1B0FF4D", ld4(v1.s(3), v2.s(3), v3.s(3), v4.s(3), ptr_post(x5, 16)));
  TEST_INSTRUCTION("A1B0EB4D", ld4(v1.s(3), v2.s(3), v3.s(3), v4.s(3), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A1A4604D", ld4(v1.d(1), v2.d(1), v3.d(1), v4.d(1), ptr(x5)));
  TEST_INSTRUCTION("A1A4FF4D", ld4(v1.d(1), v2.d(1), v3.d(1), v4.d(1), ptr_post(x5, 32)));
  TEST_INSTRUCTION("A1A4EB4D", ld4(v1.d(1), v2.d(1), v3.d(1), v4.d(1), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A100400C", ld4(v1.b8(), v2.b8(), v3.b8(), v4.b8(), ptr(x5)));
  TEST_INSTRUCTION("A100DF0C", ld4(v1.b8(), v2.b8(), v3.b8(), v4.b8(), ptr_post(x5, 32)));
  TEST_INSTRUCTION("A100CB0C", ld4(v1.b8(), v2.b8(), v3.b8(), v4.b8(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A100404C", ld4(v1.b16(), v2.b16(), v3.b16(), v4.b16(), ptr(x5)));
  TEST_INSTRUCTION("A100DF4C", ld4(v1.b16(), v2.b16(), v3.b16(), v4.b16(), ptr_post(x5, 64)));
  TEST_INSTRUCTION("A100CB4C", ld4(v1.b16(), v2.b16(), v3.b16(), v4.b16(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A104400C", ld4(v1.h4(), v2.h4(), v3.h4(), v4.h4(), ptr(x5)));
  TEST_INSTRUCTION("A104DF0C", ld4(v1.h4(), v2.h4(), v3.h4(), v4.h4(), ptr_post(x5, 32)));
  TEST_INSTRUCTION("A104CB0C", ld4(v1.h4(), v2.h4(), v3.h4(), v4.h4(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A104404C", ld4(v1.h8(), v2.h8(), v3.h8(), v4.h8(), ptr(x5)));
  TEST_INSTRUCTION("A104DF4C", ld4(v1.h8(), v2.h8(), v3.h8(), v4.h8(), ptr_post(x5, 64)));
  TEST_INSTRUCTION("A104CB4C", ld4(v1.h8(), v2.h8(), v3.h8(), v4.h8(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A108400C", ld4(v1.s2(), v2.s2(), v3.s2(), v4.s2(), ptr(x5)));
  TEST_INSTRUCTION("A108DF0C", ld4(v1.s2(), v2.s2(), v3.s2(), v4.s2(), ptr_post(x5, 32)));
  TEST_INSTRUCTION("A108CB0C", ld4(v1.s2(), v2.s2(), v3.s2(), v4.s2(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A108404C", ld4(v1.s4(), v2.s4(), v3.s4(), v4.s4(), ptr(x5)));
  TEST_INSTRUCTION("A108DF4C", ld4(v1.s4(), v2.s4(), v3.s4(), v4.s4(), ptr_post(x5, 64)));
  TEST_INSTRUCTION("A108CB4C", ld4(v1.s4(), v2.s4(), v3.s4(), v4.s4(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A10C404C", ld4(v1.d2(), v2.d2(), v3.d2(), v4.d2(), ptr(x5)));
  TEST_INSTRUCTION("A10CDF4C", ld4(v1.d2(), v2.d2(), v3.d2(), v4.d2(), ptr_post(x5, 64)));
  TEST_INSTRUCTION("A10CCB4C", ld4(v1.d2(), v2.d2(), v3.d2(), v4.d2(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A1E0600D", ld4r(v1.b8(), v2.b8(), v3.b8(), v4.b8(), ptr(x5)));
  TEST_INSTRUCTION("A1E0FF0D", ld4r(v1.b8(), v2.b8(), v3.b8(), v4.b8(), ptr_post(x5, 4)));
  TEST_INSTRUCTION("A1E0EB0D", ld4r(v1.b8(), v2.b8(), v3.b8(), v4.b8(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A1E0604D", ld4r(v1.b16(), v2.b16(), v3.b16(), v4.b16(), ptr(x5)));
  TEST_INSTRUCTION("A1E0FF4D", ld4r(v1.b16(), v2.b16(), v3.b16(), v4.b16(), ptr_post(x5, 4)));
  TEST_INSTRUCTION("A1E0EB4D", ld4r(v1.b16(), v2.b16(), v3.b16(), v4.b16(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A1E4600D", ld4r(v1.h4(), v2.h4(), v3.h4(), v4.h4(), ptr(x5)));
  TEST_INSTRUCTION("A1E4FF0D", ld4r(v1.h4(), v2.h4(), v3.h4(), v4.h4(), ptr_post(x5, 8)));
  TEST_INSTRUCTION("A1E4EB0D", ld4r(v1.h4(), v2.h4(), v3.h4(), v4.h4(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A1E4604D", ld4r(v1.h8(), v2.h8(), v3.h8(), v4.h8(), ptr(x5)));
  TEST_INSTRUCTION("A1E4FF4D", ld4r(v1.h8(), v2.h8(), v3.h8(), v4.h8(), ptr_post(x5, 8)));
  TEST_INSTRUCTION("A1E4EB4D", ld4r(v1.h8(), v2.h8(), v3.h8(), v4.h8(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A1E8600D", ld4r(v1.s2(), v2.s2(), v3.s2(), v4.s2(), ptr(x5)));
  TEST_INSTRUCTION("A1E8FF0D", ld4r(v1.s2(), v2.s2(), v3.s2(), v4.s2(), ptr_post(x5, 16)));
  TEST_INSTRUCTION("A1E8EB0D", ld4r(v1.s2(), v2.s2(), v3.s2(), v4.s2(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A1E8604D", ld4r(v1.s4(), v2.s4(), v3.s4(), v4.s4(), ptr(x5)));
  TEST_INSTRUCTION("A1E8FF4D", ld4r(v1.s4(), v2.s4(), v3.s4(), v4.s4(), ptr_post(x5, 16)));
  TEST_INSTRUCTION("A1E8EB4D", ld4r(v1.s4(), v2.s4(), v3.s4(), v4.s4(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A1EC604D", ld4r(v1.d2(), v2.d2(), v3.d2(), v4.d2(), ptr(x5)));
  TEST_INSTRUCTION("A1ECFF4D", ld4r(v1.d2(), v2.d2(), v3.d2(), v4.d2(), ptr_post(x5, 32)));
  TEST_INSTRUCTION("A1ECEB4D", ld4r(v1.d2(), v2.d2(), v3.d2(), v4.d2(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("8109402C", ldnp(s1, s2, ptr(x12)));
  TEST_INSTRUCTION("8189402C", ldnp(s1, s2, ptr(x12, 4)));
  TEST_INSTRUCTION("8109702C", ldnp(s1, s2, ptr(x12, -128)));
  TEST_INSTRUCTION("E10B402C", ldnp(s1, s2, ptr(sp)));
  TEST_INSTRUCTION("E18B402C", ldnp(s1, s2, ptr(sp, 4)));
  TEST_INSTRUCTION("E10B502C", ldnp(s1, s2, ptr(sp, 128)));
  TEST_INSTRUCTION("8109406C", ldnp(d1, d2, ptr(x12)));
  TEST_INSTRUCTION("8189406C", ldnp(d1, d2, ptr(x12, 8)));
  TEST_INSTRUCTION("8109786C", ldnp(d1, d2, ptr(x12, -128)));
  TEST_INSTRUCTION("E10B406C", ldnp(d1, d2, ptr(sp)));
  TEST_INSTRUCTION("E18B406C", ldnp(d1, d2, ptr(sp, 8)));
  TEST_INSTRUCTION("E10B486C", ldnp(d1, d2, ptr(sp, 128)));
  TEST_INSTRUCTION("810940AC", ldnp(q1, q2, ptr(x12)));
  TEST_INSTRUCTION("818940AC", ldnp(q1, q2, ptr(x12, 16)));
  TEST_INSTRUCTION("81097CAC", ldnp(q1, q2, ptr(x12, -128)));
  TEST_INSTRUCTION("E10B40AC", ldnp(q1, q2, ptr(sp)));
  TEST_INSTRUCTION("E18B40AC", ldnp(q1, q2, ptr(sp, 16)));
  TEST_INSTRUCTION("E10B44AC", ldnp(q1, q2, ptr(sp, 128)));
  TEST_INSTRUCTION("8109402D", ldp(s1, s2, ptr(x12)));
  TEST_INSTRUCTION("8189402D", ldp(s1, s2, ptr(x12, 4)));
  TEST_INSTRUCTION("8109702D", ldp(s1, s2, ptr(x12, -128)));
  TEST_INSTRUCTION("8189C02D", ldp(s1, s2, ptr_pre(x12, 4)));
  TEST_INSTRUCTION("8189C02C", ldp(s1, s2, ptr_post(x12, 4)));
  TEST_INSTRUCTION("E10B402D", ldp(s1, s2, ptr(sp)));
  TEST_INSTRUCTION("E18B402D", ldp(s1, s2, ptr(sp, 4)));
  TEST_INSTRUCTION("E10B502D", ldp(s1, s2, ptr(sp, 128)));
  TEST_INSTRUCTION("E18BC02C", ldp(s1, s2, ptr_post(sp, 4)));
  TEST_INSTRUCTION("E18BC02D", ldp(s1, s2, ptr_pre(sp, 4)));
  TEST_INSTRUCTION("8109406D", ldp(d1, d2, ptr(x12)));
  TEST_INSTRUCTION("8189406D", ldp(d1, d2, ptr(x12, 8)));
  TEST_INSTRUCTION("8109786D", ldp(d1, d2, ptr(x12, -128)));
  TEST_INSTRUCTION("8189C06D", ldp(d1, d2, ptr_pre(x12, 8)));
  TEST_INSTRUCTION("8189C06C", ldp(d1, d2, ptr_post(x12, 8)));
  TEST_INSTRUCTION("E10B406D", ldp(d1, d2, ptr(sp)));
  TEST_INSTRUCTION("E18B406D", ldp(d1, d2, ptr(sp, 8)));
  TEST_INSTRUCTION("E10B486D", ldp(d1, d2, ptr(sp, 128)));
  TEST_INSTRUCTION("E18BC06D", ldp(d1, d2, ptr_pre(sp, 8)));
  TEST_INSTRUCTION("E18BC06C", ldp(d1, d2, ptr_post(sp, 8)));
  TEST_INSTRUCTION("810940AD", ldp(q1, q2, ptr(x12)));
  TEST_INSTRUCTION("818940AD", ldp(q1, q2, ptr(x12, 16)));
  TEST_INSTRUCTION("81097CAD", ldp(q1, q2, ptr(x12, -128)));
  TEST_INSTRUCTION("8189C0AD", ldp(q1, q2, ptr_pre(x12, 16)));
  TEST_INSTRUCTION("8189C0AC", ldp(q1, q2, ptr_post(x12, 16)));
  TEST_INSTRUCTION("E10B40AD", ldp(q1, q2, ptr(sp)));
  TEST_INSTRUCTION("E18B40AD", ldp(q1, q2, ptr(sp, 16)));
  TEST_INSTRUCTION("E10B44AD", ldp(q1, q2, ptr(sp, 128)));
  TEST_INSTRUCTION("E18BC0AD", ldp(q1, q2, ptr_pre(sp, 16)));
  TEST_INSTRUCTION("E18BC0AC", ldp(q1, q2, ptr_post(sp, 16)));
  TEST_INSTRUCTION("4100403D", ldr(b1, ptr(x2)));
  TEST_INSTRUCTION("4114403C", ldr(b1, ptr_post(x2, 1)));
  TEST_INSTRUCTION("4104403D", ldr(b1, ptr(x2, 1)));
  TEST_INSTRUCTION("411C403C", ldr(b1, ptr_pre(x2, 1)));
  TEST_INSTRUCTION("4114483C", ldr(b1, ptr_post(x2, 129)));
  TEST_INSTRUCTION("4100407D", ldr(h1, ptr(x2)));
  TEST_INSTRUCTION("4124407C", ldr(h1, ptr_post(x2, 2)));
  TEST_INSTRUCTION("4104407D", ldr(h1, ptr(x2, 2)));
  TEST_INSTRUCTION("412C407C", ldr(h1, ptr_pre(x2, 2)));
  TEST_INSTRUCTION("4124487C", ldr(h1, ptr_post(x2, 130)));
  TEST_INSTRUCTION("410040BD", ldr(s1, ptr(x2)));
  TEST_INSTRUCTION("414440BC", ldr(s1, ptr_post(x2, 4)));
  TEST_INSTRUCTION("410440BD", ldr(s1, ptr(x2, 4)));
  TEST_INSTRUCTION("414C40BC", ldr(s1, ptr_pre(x2, 4)));
  TEST_INSTRUCTION("414448BC", ldr(s1, ptr_post(x2, 132)));
  TEST_INSTRUCTION("410040FD", ldr(d1, ptr(x2)));
  TEST_INSTRUCTION("418440FC", ldr(d1, ptr_post(x2, 8)));
  TEST_INSTRUCTION("410440FD", ldr(d1, ptr(x2, 8)));
  TEST_INSTRUCTION("418C40FC", ldr(d1, ptr_pre(x2, 8)));
  TEST_INSTRUCTION("414448FC", ldr(d1, ptr_post(x2, 132)));
  TEST_INSTRUCTION("4168633C", ldr(b1, ptr(x2, x3)));
  TEST_INSTRUCTION("4148633C", ldr(b1, ptr(x2, w3, uxtw(0))));
  TEST_INSTRUCTION("41C8633C", ldr(b1, ptr(x2, w3, sxtw(0))));
  TEST_INSTRUCTION("4168637C", ldr(h1, ptr(x2, x3)));
  TEST_INSTRUCTION("4178637C", ldr(h1, ptr(x2, x3, lsl(1))));
  TEST_INSTRUCTION("4148637C", ldr(h1, ptr(x2, w3, uxtw(0))));
  TEST_INSTRUCTION("4158637C", ldr(h1, ptr(x2, w3, uxtw(1))));
  TEST_INSTRUCTION("41C8637C", ldr(h1, ptr(x2, w3, sxtw(0))));
  TEST_INSTRUCTION("41D8637C", ldr(h1, ptr(x2, w3, sxtw(1))));
  TEST_INSTRUCTION("416863BC", ldr(s1, ptr(x2, x3)));
  TEST_INSTRUCTION("417863BC", ldr(s1, ptr(x2, x3, lsl(2))));
  TEST_INSTRUCTION("414863BC", ldr(s1, ptr(x2, w3, uxtw(0))));
  TEST_INSTRUCTION("415863BC", ldr(s1, ptr(x2, w3, uxtw(2))));
  TEST_INSTRUCTION("41C863BC", ldr(s1, ptr(x2, w3, sxtw(0))));
  TEST_INSTRUCTION("41D863BC", ldr(s1, ptr(x2, w3, sxtw(2))));
  TEST_INSTRUCTION("416863FC", ldr(d1, ptr(x2, x3)));
  TEST_INSTRUCTION("417863FC", ldr(d1, ptr(x2, x3, lsl(3))));
  TEST_INSTRUCTION("414863FC", ldr(d1, ptr(x2, w3, uxtw(0))));
  TEST_INSTRUCTION("415863FC", ldr(d1, ptr(x2, w3, uxtw(3))));
  TEST_INSTRUCTION("41C863FC", ldr(d1, ptr(x2, w3, sxtw(0))));
  TEST_INSTRUCTION("41D863FC", ldr(d1, ptr(x2, w3, sxtw(3))));
  TEST_INSTRUCTION("4104403D", ldr(b1, ptr(x2, 1)));
  TEST_INSTRUCTION("41F05F3C", ldr(b1, ptr(x2, -1))); // LDUR
  TEST_INSTRUCTION("4110407C", ldr(h1, ptr(x2, 1)));  // LDUR
  TEST_INSTRUCTION("41F05F7C", ldr(h1, ptr(x2, -1))); // LDUR
  TEST_INSTRUCTION("411040BC", ldr(s1, ptr(x2, 1)));  // LDUR
  TEST_INSTRUCTION("41F05FBC", ldr(s1, ptr(x2, -1))); // LDUR
  TEST_INSTRUCTION("411040FC", ldr(d1, ptr(x2, 1)));  // LDUR
  TEST_INSTRUCTION("41F05FFC", ldr(d1, ptr(x2, -1))); // LDUR
  TEST_INSTRUCTION("8101403C", ldur(b1, ptr(x12)));
  TEST_INSTRUCTION("8131403C", ldur(b1, ptr(x12, 3)));
  TEST_INSTRUCTION("8131463C", ldur(b1, ptr(x12, 99)));
  TEST_INSTRUCTION("81F14F3C", ldur(b1, ptr(x12, 255)));
  TEST_INSTRUCTION("8101503C", ldur(b1, ptr(x12, -256)));
  TEST_INSTRUCTION("E103403C", ldur(b1, ptr(sp)));
  TEST_INSTRUCTION("E153483C", ldur(b1, ptr(sp, 133)));
  TEST_INSTRUCTION("8101407C", ldur(h1, ptr(x12)));
  TEST_INSTRUCTION("8131407C", ldur(h1, ptr(x12, 3)));
  TEST_INSTRUCTION("8131467C", ldur(h1, ptr(x12, 99)));
  TEST_INSTRUCTION("81F14F7C", ldur(h1, ptr(x12, 255)));
  TEST_INSTRUCTION("8101507C", ldur(h1, ptr(x12, -256)));
  TEST_INSTRUCTION("E103407C", ldur(h1, ptr(sp)));
  TEST_INSTRUCTION("E153487C", ldur(h1, ptr(sp, 133)));
  TEST_INSTRUCTION("810140BC", ldur(s1, ptr(x12)));
  TEST_INSTRUCTION("813140BC", ldur(s1, ptr(x12, 3)));
  TEST_INSTRUCTION("813146BC", ldur(s1, ptr(x12, 99)));
  TEST_INSTRUCTION("81F14FBC", ldur(s1, ptr(x12, 255)));
  TEST_INSTRUCTION("810150BC", ldur(s1, ptr(x12, -256)));
  TEST_INSTRUCTION("E10340BC", ldur(s1, ptr(sp)));
  TEST_INSTRUCTION("E15348BC", ldur(s1, ptr(sp, 133)));
  TEST_INSTRUCTION("810140FC", ldur(d1, ptr(x12)));
  TEST_INSTRUCTION("813140FC", ldur(d1, ptr(x12, 3)));
  TEST_INSTRUCTION("813146FC", ldur(d1, ptr(x12, 99)));
  TEST_INSTRUCTION("81F14FFC", ldur(d1, ptr(x12, 255)));
  TEST_INSTRUCTION("810150FC", ldur(d1, ptr(x12, -256)));
  TEST_INSTRUCTION("E10340FC", ldur(d1, ptr(sp)));
  TEST_INSTRUCTION("E15348FC", ldur(d1, ptr(sp, 133)));
  TEST_INSTRUCTION("8101C03C", ldur(q1, ptr(x12)));
  TEST_INSTRUCTION("8131C03C", ldur(q1, ptr(x12, 3)));
  TEST_INSTRUCTION("8131C63C", ldur(q1, ptr(x12, 99)));
  TEST_INSTRUCTION("81F1CF3C", ldur(q1, ptr(x12, 255)));
  TEST_INSTRUCTION("8101D03C", ldur(q1, ptr(x12, -256)));
  TEST_INSTRUCTION("E103C03C", ldur(q1, ptr(sp)));
  TEST_INSTRUCTION("E153C83C", ldur(q1, ptr(sp, 133)));
  TEST_INSTRUCTION("4194230E", mla(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4194630E", mla(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4194A30E", mla(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4194234E", mla(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4194634E", mla(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4194A34E", mla(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4100432F", mla(v1.h4(), v2.h4(), v3.h(0)));
  TEST_INSTRUCTION("4100532F", mla(v1.h4(), v2.h4(), v3.h(1)));
  TEST_INSTRUCTION("4100632F", mla(v1.h4(), v2.h4(), v3.h(2)));
  TEST_INSTRUCTION("4100732F", mla(v1.h4(), v2.h4(), v3.h(3)));
  TEST_INSTRUCTION("4108436F", mla(v1.h8(), v2.h8(), v3.h(4)));
  TEST_INSTRUCTION("4108536F", mla(v1.h8(), v2.h8(), v3.h(5)));
  TEST_INSTRUCTION("4108636F", mla(v1.h8(), v2.h8(), v3.h(6)));
  TEST_INSTRUCTION("4108736F", mla(v1.h8(), v2.h8(), v3.h(7)));
  TEST_INSTRUCTION("4100832F", mla(v1.s2(), v2.s2(), v3.s(0)));
  TEST_INSTRUCTION("4100A32F", mla(v1.s2(), v2.s2(), v3.s(1)));
  TEST_INSTRUCTION("4108836F", mla(v1.s4(), v2.s4(), v3.s(2)));
  TEST_INSTRUCTION("4108A36F", mla(v1.s4(), v2.s4(), v3.s(3)));
  TEST_INSTRUCTION("4194232E", mls(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4194632E", mls(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4194A32E", mls(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4194236E", mls(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4194636E", mls(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4194A36E", mls(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4140432F", mls(v1.h4(), v2.h4(), v3.h(0)));
  TEST_INSTRUCTION("4140532F", mls(v1.h4(), v2.h4(), v3.h(1)));
  TEST_INSTRUCTION("4140632F", mls(v1.h4(), v2.h4(), v3.h(2)));
  TEST_INSTRUCTION("4140732F", mls(v1.h4(), v2.h4(), v3.h(3)));
  TEST_INSTRUCTION("4148436F", mls(v1.h8(), v2.h8(), v3.h(4)));
  TEST_INSTRUCTION("4148536F", mls(v1.h8(), v2.h8(), v3.h(5)));
  TEST_INSTRUCTION("4148636F", mls(v1.h8(), v2.h8(), v3.h(6)));
  TEST_INSTRUCTION("4148736F", mls(v1.h8(), v2.h8(), v3.h(7)));
  TEST_INSTRUCTION("4140832F", mls(v1.s2(), v2.s2(), v3.s(0)));
  TEST_INSTRUCTION("4140A32F", mls(v1.s2(), v2.s2(), v3.s(1)));
  TEST_INSTRUCTION("4148836F", mls(v1.s4(), v2.s4(), v3.s(2)));
  TEST_INSTRUCTION("4148A36F", mls(v1.s4(), v2.s4(), v3.s(3)));
  TEST_INSTRUCTION("4F04035E", mov(b15, v2.b(1)));
  TEST_INSTRUCTION("4F04065E", mov(h15, v2.h(1)));
  TEST_INSTRUCTION("4F040C5E", mov(s15, v2.s(1)));
  TEST_INSTRUCTION("4F04185E", mov(d15, v2.d(1)));
  TEST_INSTRUCTION("411C014E", mov(v1.b(0), w2));
  TEST_INSTRUCTION("411C074E", mov(v1.b(3), w2));
  TEST_INSTRUCTION("411C0D4E", mov(v1.b(6), w2));
  TEST_INSTRUCTION("411C134E", mov(v1.b(9), w2));
  TEST_INSTRUCTION("411C1F4E", mov(v1.b(15), w2));
  TEST_INSTRUCTION("411C024E", mov(v1.h(0), w2));
  TEST_INSTRUCTION("411C0E4E", mov(v1.h(3), w2));
  TEST_INSTRUCTION("411C1E4E", mov(v1.h(7), w2));
  TEST_INSTRUCTION("411C044E", mov(v1.s(0), w2));
  TEST_INSTRUCTION("411C0C4E", mov(v1.s(1), w2));
  TEST_INSTRUCTION("411C144E", mov(v1.s(2), w2));
  TEST_INSTRUCTION("411C1C4E", mov(v1.s(3), w2));
  TEST_INSTRUCTION("411C084E", mov(v1.d(0), x2));
  TEST_INSTRUCTION("411C184E", mov(v1.d(1), x2));
  TEST_INSTRUCTION("417C016E", mov(v1.b(0), v2.b(15)));
  TEST_INSTRUCTION("4174036E", mov(v1.b(1), v2.b(14)));
  TEST_INSTRUCTION("4174026E", mov(v1.h(0), v2.h(7)));
  TEST_INSTRUCTION("4164066E", mov(v1.h(1), v2.h(6)));
  TEST_INSTRUCTION("4164046E", mov(v1.s(0), v2.s(3)));
  TEST_INSTRUCTION("41440C6E", mov(v1.s(1), v2.s(2)));
  TEST_INSTRUCTION("4144086E", mov(v1.d(0), v2.d(1)));
  TEST_INSTRUCTION("4104186E", mov(v1.d(1), v2.d(0)));
  TEST_INSTRUCTION("41E5010F", movi(v1.b8(), 42));
  TEST_INSTRUCTION("4185010F", movi(v1.h4(), 42));
  TEST_INSTRUCTION("4105010F", movi(v1.s2(), 42));
  TEST_INSTRUCTION("C1E5022F", movi(d1, 0x00FF0000FFFFFF00u));
  TEST_INSTRUCTION("41E5014F", movi(v1.b16(), 42));
  TEST_INSTRUCTION("4185014F", movi(v1.h8(), 42));
  TEST_INSTRUCTION("4105014F", movi(v1.s4(), 42));
  TEST_INSTRUCTION("E167074F", movi(v1.s4(), 0xFF, lsl(24)));
  TEST_INSTRUCTION("E1D7074F", movi(v1.s4(), 0xFF, msl(16)));
  TEST_INSTRUCTION("C1E5026F", movi(v1.d2(), 0x00FF0000FFFFFF00u));
  TEST_INSTRUCTION("419C230E", mul(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("419C630E", mul(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("419CA30E", mul(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("419C234E", mul(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("419C634E", mul(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("419CA34E", mul(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4158202E", mvn(v1.b8(), v2.b8()));
  TEST_INSTRUCTION("4158206E", mvn(v1.b16(), v2.b16()));
  TEST_INSTRUCTION("4185012F", mvni(v1.h4(), 42));
  TEST_INSTRUCTION("4105012F", mvni(v1.s2(), 42));
  TEST_INSTRUCTION("4185016F", mvni(v1.h8(), 42));
  TEST_INSTRUCTION("4105016F", mvni(v1.s4(), 42));
  TEST_INSTRUCTION("41B8202E", neg(v1.b8(), v2.b8()));
  TEST_INSTRUCTION("41B8602E", neg(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("41B8A02E", neg(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41B8E07E", neg(d1, d2));
  TEST_INSTRUCTION("41B8206E", neg(v1.b16(), v2.b16()));
  TEST_INSTRUCTION("41B8606E", neg(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("41B8A06E", neg(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41B8E06E", neg(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("4158202E", not_(v1.b8(), v2.b8()));
  TEST_INSTRUCTION("4158206E", not_(v1.b16(), v2.b16()));
  TEST_INSTRUCTION("411CE30E", orn(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("411CE34E", orn(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("411CA30E", orr(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("411CA34E", orr(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("E197070F", orr(v1.h4(), 255));
  TEST_INSTRUCTION("E1B7070F", orr(v1.h4(), 255, lsl(8)));
  TEST_INSTRUCTION("E197074F", orr(v1.h8(), 255));
  TEST_INSTRUCTION("E1B7074F", orr(v1.h8(), 255, lsl(8)));
  TEST_INSTRUCTION("E117070F", orr(v1.s2(), 255));
  TEST_INSTRUCTION("E137070F", orr(v1.s2(), 255, lsl(8)));
  TEST_INSTRUCTION("E117074F", orr(v1.s4(), 255));
  TEST_INSTRUCTION("E177074F", orr(v1.s4(), 255, lsl(24)));
  TEST_INSTRUCTION("419C232E", pmul(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("419C236E", pmul(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("41E0230E", pmull(v1.h8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("41E0E30E", pmull(q1, d2, d3));
  TEST_INSTRUCTION("41E0234E", pmull2(v1.h8(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("41E0E34E", pmull2(q1, v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4140232E", raddhn(v1.b8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4140632E", raddhn(v1.h4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4140A32E", raddhn(v1.s2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4140236E", raddhn2(v1.b16(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4140636E", raddhn2(v1.h8(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4140A36E", raddhn2(v1.s4(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("418C63CE", rax1(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4158602E", rbit(v1.b8(), v2.b8()));
  TEST_INSTRUCTION("4158606E", rbit(v1.b16(), v2.b16()));
  TEST_INSTRUCTION("4118200E", rev16(v1.b8(), v2.b8()));
  TEST_INSTRUCTION("4118204E", rev16(v1.b16(), v2.b16()));
  TEST_INSTRUCTION("4108202E", rev32(v1.b8(), v2.b8()));
  TEST_INSTRUCTION("4108206E", rev32(v1.b16(), v2.b16()));
  TEST_INSTRUCTION("4108602E", rev32(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("4108606E", rev32(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("4108200E", rev64(v1.b8(), v2.b8()));
  TEST_INSTRUCTION("4108204E", rev64(v1.b16(), v2.b16()));
  TEST_INSTRUCTION("4108600E", rev64(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("4108604E", rev64(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("4108A00E", rev64(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("4108A04E", rev64(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("418C090F", rshrn(v1.b8(), v2.h8(), 7));
  TEST_INSTRUCTION("418C110F", rshrn(v1.h4(), v2.s4(), 15));
  TEST_INSTRUCTION("418C210F", rshrn(v1.s2(), v2.d2(), 31));
  TEST_INSTRUCTION("418C094F", rshrn2(v1.b16(), v2.h8(), 7));
  TEST_INSTRUCTION("418C114F", rshrn2(v1.h8(), v2.s4(), 15));
  TEST_INSTRUCTION("418C214F", rshrn2(v1.s4(), v2.d2(), 31));
  TEST_INSTRUCTION("4160232E", rsubhn(v1.b8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4160632E", rsubhn(v1.h4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4160A32E", rsubhn(v1.s2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4160236E", rsubhn2(v1.b16(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4160636E", rsubhn2(v1.h8(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4160A36E", rsubhn2(v1.s4(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("417C230E", saba(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("417C630E", saba(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("417CA30E", saba(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("417C234E", saba(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("417C634E", saba(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("417CA34E", saba(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4150230E", sabal(v1.h8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4150630E", sabal(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4150A30E", sabal(v1.d2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4150234E", sabal2(v1.h8(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4150634E", sabal2(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4150A34E", sabal2(v1.d2(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4174230E", sabd(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4174630E", sabd(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4174A30E", sabd(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4174234E", sabd(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4174634E", sabd(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4174A34E", sabd(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4170230E", sabdl(v1.h8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4170630E", sabdl(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4170A30E", sabdl(v1.d2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4170234E", sabdl2(v1.h8(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4170634E", sabdl2(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4170A34E", sabdl2(v1.d2(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4168200E", sadalp(v1.h4(), v2.b8()));
  TEST_INSTRUCTION("4168600E", sadalp(v1.s2(), v2.h4()));
  TEST_INSTRUCTION("4168A00E", sadalp(d1, v2.s2()));
  TEST_INSTRUCTION("4168204E", sadalp(v1.h8(), v2.b16()));
  TEST_INSTRUCTION("4168604E", sadalp(v1.s4(), v2.h8()));
  TEST_INSTRUCTION("4168A04E", sadalp(v1.d2(), v2.s4()));
  TEST_INSTRUCTION("4100230E", saddl(v1.h8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4100630E", saddl(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4100A30E", saddl(v1.d2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4100234E", saddl2(v1.h8(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4100634E", saddl2(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4100A34E", saddl2(v1.d2(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4128200E", saddlp(v1.h4(), v2.b8()));
  TEST_INSTRUCTION("4128600E", saddlp(v1.s2(), v2.h4()));
  TEST_INSTRUCTION("4128A00E", saddlp(d1, v2.s2()));
  TEST_INSTRUCTION("4128204E", saddlp(v1.h8(), v2.b16()));
  TEST_INSTRUCTION("4128604E", saddlp(v1.s4(), v2.h8()));
  TEST_INSTRUCTION("4128A04E", saddlp(v1.d2(), v2.s4()));
  TEST_INSTRUCTION("4138300E", saddlv(h1, v2.b8()));
  TEST_INSTRUCTION("4138304E", saddlv(h1, v2.b16()));
  TEST_INSTRUCTION("4138700E", saddlv(s1, v2.h4()));
  TEST_INSTRUCTION("4138704E", saddlv(s1, v2.h8()));
  TEST_INSTRUCTION("4138B04E", saddlv(d1, v2.s4()));
  TEST_INSTRUCTION("4110230E", saddw(v1.h8(), v2.h8(), v3.b8()));
  TEST_INSTRUCTION("4110630E", saddw(v1.s4(), v2.s4(), v3.h4()));
  TEST_INSTRUCTION("4110A30E", saddw(v1.d2(), v2.d2(), v3.s2()));
  TEST_INSTRUCTION("4110234E", saddw2(v1.h8(), v2.h8(), v3.b16()));
  TEST_INSTRUCTION("4110634E", saddw2(v1.s4(), v2.s4(), v3.h8()));
  TEST_INSTRUCTION("4110A34E", saddw2(v1.d2(), v2.d2(), v3.s4()));
  TEST_INSTRUCTION("4100E21E", scvtf(h1, w2));
  TEST_INSTRUCTION("4100221E", scvtf(s1, w2));
  TEST_INSTRUCTION("4100621E", scvtf(d1, w2));
  TEST_INSTRUCTION("4100E29E", scvtf(h1, x2));
  TEST_INSTRUCTION("4100229E", scvtf(s1, x2));
  TEST_INSTRUCTION("4100629E", scvtf(d1, x2));
  TEST_INSTRUCTION("41D8795E", scvtf(h1, h2));
  TEST_INSTRUCTION("41D8215E", scvtf(s1, s2));
  TEST_INSTRUCTION("41D8615E", scvtf(d1, d2));
  TEST_INSTRUCTION("41D8790E", scvtf(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("41D8210E", scvtf(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41D8794E", scvtf(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("41D8214E", scvtf(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41D8614E", scvtf(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("41E0C21E", scvtf(h1, w2, 8));
  TEST_INSTRUCTION("41E0021E", scvtf(s1, w2, 8));
  TEST_INSTRUCTION("41E0421E", scvtf(d1, w2, 8));
  TEST_INSTRUCTION("41E0C29E", scvtf(h1, x2, 8));
  TEST_INSTRUCTION("41E0029E", scvtf(s1, x2, 8));
  TEST_INSTRUCTION("41E0429E", scvtf(d1, x2, 8));
  TEST_INSTRUCTION("41E4185F", scvtf(h1, h2, 8));
  TEST_INSTRUCTION("41E4385F", scvtf(s1, s2, 8));
  TEST_INSTRUCTION("41E4785F", scvtf(d1, d2, 8));
  TEST_INSTRUCTION("41E4180F", scvtf(v1.h4(), v2.h4(), 8));
  TEST_INSTRUCTION("41E4380F", scvtf(v1.s2(), v2.s2(), 8));
  TEST_INSTRUCTION("41E4184F", scvtf(v1.h8(), v2.h8(), 8));
  TEST_INSTRUCTION("41E4384F", scvtf(v1.s4(), v2.s4(), 8));
  TEST_INSTRUCTION("41E4784F", scvtf(v1.d2(), v2.d2(), 8));
  TEST_INSTRUCTION("4194830E", sdot(v1.s2(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4194834E", sdot(v1.s4(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("41E0830F", sdot(v1.s2(), v2.b8(), v3.b4(0)));
  TEST_INSTRUCTION("41E0A30F", sdot(v1.s2(), v2.b8(), v3.b4(1)));
  TEST_INSTRUCTION("41E8830F", sdot(v1.s2(), v2.b8(), v3.b4(2)));
  TEST_INSTRUCTION("41E8A30F", sdot(v1.s2(), v2.b8(), v3.b4(3)));
  TEST_INSTRUCTION("41E0834F", sdot(v1.s4(), v2.b16(), v3.b4(0)));
  TEST_INSTRUCTION("41E0A34F", sdot(v1.s4(), v2.b16(), v3.b4(1)));
  TEST_INSTRUCTION("41E8834F", sdot(v1.s4(), v2.b16(), v3.b4(2)));
  TEST_INSTRUCTION("41E8A34F", sdot(v1.s4(), v2.b16(), v3.b4(3)));
  TEST_INSTRUCTION("4100035E", sha1c(q1, s2, v3.s4()));
  TEST_INSTRUCTION("4108285E", sha1h(s1, s2));
  TEST_INSTRUCTION("4120035E", sha1m(q1, s2, v3.s4()));
  TEST_INSTRUCTION("4110035E", sha1p(q1, s2, v3.s4()));
  TEST_INSTRUCTION("4130035E", sha1su0(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4118285E", sha1su1(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("4140035E", sha256h(q1, q2, v3.s4()));
  TEST_INSTRUCTION("4150035E", sha256h2(q1, q2, v3.s4()));
  TEST_INSTRUCTION("4128285E", sha256su0(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("4160035E", sha256su1(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4104230E", shadd(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4104630E", shadd(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4104A30E", shadd(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4104234E", shadd(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4104634E", shadd(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4104A34E", shadd(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41540F0F", shl(v1.b8(), v2.b8(), 7));
  TEST_INSTRUCTION("41541F0F", shl(v1.h4(), v2.h4(), 15));
  TEST_INSTRUCTION("41543F0F", shl(v1.s2(), v2.s2(), 31));
  TEST_INSTRUCTION("41547F5F", shl(d1, d2, 63));
  TEST_INSTRUCTION("41540F4F", shl(v1.b16(), v2.b16(), 7));
  TEST_INSTRUCTION("41541F4F", shl(v1.h8(), v2.h8(), 15));
  TEST_INSTRUCTION("41543F4F", shl(v1.s4(), v2.s4(), 31));
  TEST_INSTRUCTION("41547F4F", shl(v1.d2(), v2.d2(), 63));
  TEST_INSTRUCTION("4138212E", shll(v1.h8(), v2.b8(), 8));
  TEST_INSTRUCTION("4138612E", shll(v1.s4(), v2.h4(), 16));
  TEST_INSTRUCTION("4138A12E", shll(v1.d2(), v2.s2(), 32));
  TEST_INSTRUCTION("4138216E", shll2(v1.h8(), v2.b16(), 8));
  TEST_INSTRUCTION("4138616E", shll2(v1.s4(), v2.h8(), 16));
  TEST_INSTRUCTION("4138A16E", shll2(v1.d2(), v2.s4(), 32));
  TEST_INSTRUCTION("4184090F", shrn(v1.b8(), v2.h8(), 7));
  TEST_INSTRUCTION("4184110F", shrn(v1.h4(), v2.s4(), 15));
  TEST_INSTRUCTION("4184210F", shrn(v1.s2(), v2.d2(), 31));
  TEST_INSTRUCTION("4184094F", shrn2(v1.b16(), v2.h8(), 7));
  TEST_INSTRUCTION("4184114F", shrn2(v1.h8(), v2.s4(), 15));
  TEST_INSTRUCTION("4184214F", shrn2(v1.s4(), v2.d2(), 31));
  TEST_INSTRUCTION("4124230E", shsub(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4124630E", shsub(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4124A30E", shsub(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4124234E", shsub(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4124634E", shsub(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4124A34E", shsub(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41540F2F", sli(v1.b8(), v2.b8(), 7));
  TEST_INSTRUCTION("41541F2F", sli(v1.h4(), v2.h4(), 15));
  TEST_INSTRUCTION("41543F2F", sli(v1.s2(), v2.s2(), 31));
  TEST_INSTRUCTION("41547F7F", sli(d1, d2, 63));
  TEST_INSTRUCTION("41540F6F", sli(v1.b16(), v2.b16(), 7));
  TEST_INSTRUCTION("41541F6F", sli(v1.h8(), v2.h8(), 15));
  TEST_INSTRUCTION("41543F6F", sli(v1.s4(), v2.s4(), 31));
  TEST_INSTRUCTION("41547F6F", sli(v1.d2(), v2.d2(), 63));
  TEST_INSTRUCTION("41C063CE", sm3partw1(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41C463CE", sm3partw2(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("411043CE", sm3ss1(v1.s4(), v2.s4(), v3.s4(), v4.s4()));
  TEST_INSTRUCTION("418044CE", sm3tt1a(v1.s4(), v2.s4(), v4.s(0)));
  TEST_INSTRUCTION("41B044CE", sm3tt1a(v1.s4(), v2.s4(), v4.s(3)));
  TEST_INSTRUCTION("418444CE", sm3tt1b(v1.s4(), v2.s4(), v4.s(0)));
  TEST_INSTRUCTION("41B444CE", sm3tt1b(v1.s4(), v2.s4(), v4.s(3)));
  TEST_INSTRUCTION("418844CE", sm3tt2a(v1.s4(), v2.s4(), v4.s(0)));
  TEST_INSTRUCTION("41B844CE", sm3tt2a(v1.s4(), v2.s4(), v4.s(3)));
  TEST_INSTRUCTION("418C44CE", sm3tt2b(v1.s4(), v2.s4(), v4.s(0)));
  TEST_INSTRUCTION("41BC44CE", sm3tt2b(v1.s4(), v2.s4(), v4.s(3)));
  TEST_INSTRUCTION("4184C0CE", sm4e(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41C863CE", sm4ekey(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4164230E", smax(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4164630E", smax(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4164A30E", smax(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4164234E", smax(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4164634E", smax(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4164A34E", smax(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41A4230E", smaxp(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("41A4630E", smaxp(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41A4A30E", smaxp(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("41A4234E", smaxp(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("41A4634E", smaxp(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41A4A34E", smaxp(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41A8300E", smaxv(b1, v2.b8()));
  TEST_INSTRUCTION("41A8304E", smaxv(b1, v2.b16()));
  TEST_INSTRUCTION("41A8700E", smaxv(h1, v2.h4()));
  TEST_INSTRUCTION("41A8704E", smaxv(h1, v2.h8()));
  TEST_INSTRUCTION("41A8B04E", smaxv(s1, v2.s4()));
  TEST_INSTRUCTION("416C230E", smin(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("416C630E", smin(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("416CA30E", smin(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("416C234E", smin(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("416C634E", smin(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("416CA34E", smin(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41AC230E", sminp(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("41AC630E", sminp(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41ACA30E", sminp(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("41AC234E", sminp(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("41AC634E", sminp(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41ACA34E", sminp(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41A8310E", sminv(b1, v2.b8()));
  TEST_INSTRUCTION("41A8314E", sminv(b1, v2.b16()));
  TEST_INSTRUCTION("41A8710E", sminv(h1, v2.h4()));
  TEST_INSTRUCTION("41A8714E", sminv(h1, v2.h8()));
  TEST_INSTRUCTION("41A8B14E", sminv(s1, v2.s4()));
  TEST_INSTRUCTION("4180230E", smlal(v1.h8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4180630E", smlal(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4180A30E", smlal(v1.d2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4120730F", smlal(v1.s4(), v2.h4(), v3.h(3)));
  TEST_INSTRUCTION("4128A30F", smlal(v1.d2(), v2.s2(), v3.s(3)));
  TEST_INSTRUCTION("4180234E", smlal2(v1.h8(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4180634E", smlal2(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4180A34E", smlal2(v1.d2(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4120734F", smlal2(v1.s4(), v2.h8(), v3.h(3)));
  TEST_INSTRUCTION("4128A34F", smlal2(v1.d2(), v2.s4(), v3.s(3)));
  TEST_INSTRUCTION("41A0230E", smlsl(v1.h8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("41A0630E", smlsl(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41A0A30E", smlsl(v1.d2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4160730F", smlsl(v1.s4(), v2.h4(), v3.h(3)));
  TEST_INSTRUCTION("4168A30F", smlsl(v1.d2(), v2.s2(), v3.s(3)));
  TEST_INSTRUCTION("41A0234E", smlsl2(v1.h8(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("41A0634E", smlsl2(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41A0A34E", smlsl2(v1.d2(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4160734F", smlsl2(v1.s4(), v2.h8(), v3.h(3)));
  TEST_INSTRUCTION("4168A34F", smlsl2(v1.d2(), v2.s4(), v3.s(3)));
  TEST_INSTRUCTION("41A4834E", smmla(v1.s4(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("412C010E", smov(w1, v2.b(0)));
  TEST_INSTRUCTION("412C1F0E", smov(w1, v2.b(15)));
  TEST_INSTRUCTION("412C020E", smov(w1, v2.h(0)));
  TEST_INSTRUCTION("412C1E0E", smov(w1, v2.h(7)));
  TEST_INSTRUCTION("412C014E", smov(x1, v2.b(0)));
  TEST_INSTRUCTION("412C1F4E", smov(x1, v2.b(15)));
  TEST_INSTRUCTION("412C024E", smov(x1, v2.h(0)));
  TEST_INSTRUCTION("412C1E4E", smov(x1, v2.h(7)));
  TEST_INSTRUCTION("412C044E", smov(x1, v2.s(0)));
  TEST_INSTRUCTION("412C1C4E", smov(x1, v2.s(3)));
  TEST_INSTRUCTION("41C0230E", smull(v1.h8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("41C0630E", smull(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41C0A30E", smull(v1.d2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("41A0730F", smull(v1.s4(), v2.h4(), v3.h(3)));
  TEST_INSTRUCTION("41A8A30F", smull(v1.d2(), v2.s2(), v3.s(3)));
  TEST_INSTRUCTION("41C0234E", smull2(v1.h8(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("41C0634E", smull2(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41C0A34E", smull2(v1.d2(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41A0734F", smull2(v1.s4(), v2.h8(), v3.h(3)));
  TEST_INSTRUCTION("41A8A34F", smull2(v1.d2(), v2.s4(), v3.s(3)));
  TEST_INSTRUCTION("4178205E", sqabs(b1, b2));
  TEST_INSTRUCTION("4178605E", sqabs(h1, h2));
  TEST_INSTRUCTION("4178A05E", sqabs(s1, s2));
  TEST_INSTRUCTION("4178E05E", sqabs(d1, d2));
  TEST_INSTRUCTION("4178200E", sqabs(v1.b8(), v2.b8()));
  TEST_INSTRUCTION("4178600E", sqabs(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("4178A00E", sqabs(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("4178204E", sqabs(v1.b16(), v2.b16()));
  TEST_INSTRUCTION("4178604E", sqabs(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("4178A04E", sqabs(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("4178E04E", sqabs(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("410C235E", sqadd(b1, b2, b3));
  TEST_INSTRUCTION("410C635E", sqadd(h1, h2, h3));
  TEST_INSTRUCTION("410CA35E", sqadd(s1, s2, s3));
  TEST_INSTRUCTION("410CE35E", sqadd(d1, d2, d3));
  TEST_INSTRUCTION("410C230E", sqadd(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("410C630E", sqadd(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("410CA30E", sqadd(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("410C234E", sqadd(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("410C634E", sqadd(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("410CA34E", sqadd(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("410CE34E", sqadd(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4190635E", sqdmlal(s1, h2, h3));
  TEST_INSTRUCTION("4190A35E", sqdmlal(d1, s2, s3));
  TEST_INSTRUCTION("4190630E", sqdmlal(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4190A30E", sqdmlal(v1.d2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4130730F", sqdmlal(v1.s4(), v2.h4(), v3.h(3)));
  TEST_INSTRUCTION("4138A30F", sqdmlal(v1.d2(), v2.s2(), v3.s(3)));
  TEST_INSTRUCTION("4190634E", sqdmlal2(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4190A34E", sqdmlal2(v1.d2(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4130734F", sqdmlal2(v1.s4(), v2.h8(), v3.h(3)));
  TEST_INSTRUCTION("4138A34F", sqdmlal2(v1.d2(), v2.s4(), v3.s(3)));
  TEST_INSTRUCTION("41B0635E", sqdmlsl(s1, h2, h3));
  TEST_INSTRUCTION("41B0A35E", sqdmlsl(d1, s2, s3));
  TEST_INSTRUCTION("41B0630E", sqdmlsl(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41B0A30E", sqdmlsl(v1.d2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4170730F", sqdmlsl(v1.s4(), v2.h4(), v3.h(3)));
  TEST_INSTRUCTION("4178A30F", sqdmlsl(v1.d2(), v2.s2(), v3.s(3)));
  TEST_INSTRUCTION("41B0634E", sqdmlsl2(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41B0A34E", sqdmlsl2(v1.d2(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4170734F", sqdmlsl2(v1.s4(), v2.h8(), v3.h(3)));
  TEST_INSTRUCTION("4178A34F", sqdmlsl2(v1.d2(), v2.s4(), v3.s(3)));
  TEST_INSTRUCTION("41B4635E", sqdmulh(h1, h2, h3));
  TEST_INSTRUCTION("41B4A35E", sqdmulh(s1, s2, s3));
  TEST_INSTRUCTION("41B4630E", sqdmulh(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41B4A30E", sqdmulh(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("41B4634E", sqdmulh(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41B4A34E", sqdmulh(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41C0730F", sqdmulh(v1.h4(), v2.h4(), v3.h(3)));
  TEST_INSTRUCTION("41C8A30F", sqdmulh(v1.s2(), v2.s2(), v3.s(3)));
  TEST_INSTRUCTION("41C0734F", sqdmulh(v1.h8(), v2.h8(), v3.h(3)));
  TEST_INSTRUCTION("41C8A34F", sqdmulh(v1.s4(), v2.s4(), v3.s(3)));
  TEST_INSTRUCTION("41D0635E", sqdmull(s1, h2, h3));
  TEST_INSTRUCTION("41D0A35E", sqdmull(d1, s2, s3));
  TEST_INSTRUCTION("41D0630E", sqdmull(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41D0A30E", sqdmull(v1.d2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("41B0730F", sqdmull(v1.s4(), v2.h4(), v3.h(3)));
  TEST_INSTRUCTION("41B8A30F", sqdmull(v1.d2(), v2.s2(), v3.s(3)));
  TEST_INSTRUCTION("41D0634E", sqdmull2(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41D0A34E", sqdmull2(v1.d2(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41B0734F", sqdmull2(v1.s4(), v2.h8(), v3.h(3)));
  TEST_INSTRUCTION("41B8A34F", sqdmull2(v1.d2(), v2.s4(), v3.s(3)));
  TEST_INSTRUCTION("4178207E", sqneg(b1, b2));
  TEST_INSTRUCTION("4178607E", sqneg(h1, h2));
  TEST_INSTRUCTION("4178A07E", sqneg(s1, s2));
  TEST_INSTRUCTION("4178E07E", sqneg(d1, d2));
  TEST_INSTRUCTION("4178202E", sqneg(v1.b8(), v2.b8()));
  TEST_INSTRUCTION("4178602E", sqneg(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("4178A02E", sqneg(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("4178206E", sqneg(v1.b16(), v2.b16()));
  TEST_INSTRUCTION("4178606E", sqneg(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("4178A06E", sqneg(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("4178E06E", sqneg(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("4184437E", sqrdmlah(h1, h2, h3));
  TEST_INSTRUCTION("4184837E", sqrdmlah(s1, s2, s3));
  TEST_INSTRUCTION("4184432E", sqrdmlah(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4184832E", sqrdmlah(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("41D0732F", sqrdmlah(v1.h4(), v2.h4(), v3.h(3)));
  TEST_INSTRUCTION("41D8A32F", sqrdmlah(v1.s2(), v2.s2(), v3.s(3)));
  TEST_INSTRUCTION("4184436E", sqrdmlah(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4184836E", sqrdmlah(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41D0736F", sqrdmlah(v1.h8(), v2.h8(), v3.h(3)));
  TEST_INSTRUCTION("41D8A36F", sqrdmlah(v1.s4(), v2.s4(), v3.s(3)));
  TEST_INSTRUCTION("418C437E", sqrdmlsh(h1, h2, h3));
  TEST_INSTRUCTION("418C837E", sqrdmlsh(s1, s2, s3));
  TEST_INSTRUCTION("418C432E", sqrdmlsh(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("418C832E", sqrdmlsh(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("41F0732F", sqrdmlsh(v1.h4(), v2.h4(), v3.h(3)));
  TEST_INSTRUCTION("41F8A32F", sqrdmlsh(v1.s2(), v2.s2(), v3.s(3)));
  TEST_INSTRUCTION("418C436E", sqrdmlsh(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("418C836E", sqrdmlsh(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41F0736F", sqrdmlsh(v1.h8(), v2.h8(), v3.h(3)));
  TEST_INSTRUCTION("41F8A36F", sqrdmlsh(v1.s4(), v2.s4(), v3.s(3)));
  TEST_INSTRUCTION("41B4637E", sqrdmulh(h1, h2, h3));
  TEST_INSTRUCTION("41B4A37E", sqrdmulh(s1, s2, s3));
  TEST_INSTRUCTION("41B4632E", sqrdmulh(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41B4A32E", sqrdmulh(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("41D0730F", sqrdmulh(v1.h4(), v2.h4(), v3.h(3)));
  TEST_INSTRUCTION("41D8A30F", sqrdmulh(v1.s2(), v2.s2(), v3.s(3)));
  TEST_INSTRUCTION("41B4636E", sqrdmulh(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41B4A36E", sqrdmulh(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41D0734F", sqrdmulh(v1.h8(), v2.h8(), v3.h(3)));
  TEST_INSTRUCTION("41D8A34F", sqrdmulh(v1.s4(), v2.s4(), v3.s(3)));
  TEST_INSTRUCTION("415C235E", sqrshl(b1, b2, b3));
  TEST_INSTRUCTION("415C635E", sqrshl(h1, h2, h3));
  TEST_INSTRUCTION("415CA35E", sqrshl(s1, s2, s3));
  TEST_INSTRUCTION("415C230E", sqrshl(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("415C630E", sqrshl(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("415CA30E", sqrshl(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("415CE35E", sqrshl(d1, d2, d3));
  TEST_INSTRUCTION("415C234E", sqrshl(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("415C634E", sqrshl(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("415CA34E", sqrshl(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("415CE34E", sqrshl(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("419C085F", sqrshrn(b1, h2, 8));
  TEST_INSTRUCTION("419C105F", sqrshrn(h1, s2, 16));
  TEST_INSTRUCTION("419C205F", sqrshrn(s1, d2, 32));
  TEST_INSTRUCTION("419C080F", sqrshrn(v1.b8(), v2.h8(), 8));
  TEST_INSTRUCTION("419C100F", sqrshrn(v1.h4(), v2.s4(), 16));
  TEST_INSTRUCTION("419C200F", sqrshrn(v1.s2(), v2.d2(), 32));
  TEST_INSTRUCTION("419C084F", sqrshrn2(v1.b16(), v2.h8(), 8));
  TEST_INSTRUCTION("419C104F", sqrshrn2(v1.h8(), v2.s4(), 16));
  TEST_INSTRUCTION("419C204F", sqrshrn2(v1.s4(), v2.d2(), 32));
  TEST_INSTRUCTION("418C087F", sqrshrun(b1, h2, 8));
  TEST_INSTRUCTION("418C107F", sqrshrun(h1, s2, 16));
  TEST_INSTRUCTION("418C207F", sqrshrun(s1, d2, 32));
  TEST_INSTRUCTION("418C082F", sqrshrun(v1.b8(), v2.h8(), 8));
  TEST_INSTRUCTION("418C102F", sqrshrun(v1.h4(), v2.s4(), 16));
  TEST_INSTRUCTION("418C202F", sqrshrun(v1.s2(), v2.d2(), 32));
  TEST_INSTRUCTION("418C086F", sqrshrun2(v1.b16(), v2.h8(), 8));
  TEST_INSTRUCTION("418C106F", sqrshrun2(v1.h8(), v2.s4(), 16));
  TEST_INSTRUCTION("418C206F", sqrshrun2(v1.s4(), v2.d2(), 32));
  TEST_INSTRUCTION("4174095F", sqshl(b1, b2, 1));
  TEST_INSTRUCTION("4174125F", sqshl(h1, h2, 2));
  TEST_INSTRUCTION("4174235F", sqshl(s1, s2, 3));
  TEST_INSTRUCTION("41740F0F", sqshl(v1.b8(), v2.b8(), 7));
  TEST_INSTRUCTION("41741F0F", sqshl(v1.h4(), v2.h4(), 15));
  TEST_INSTRUCTION("41743F0F", sqshl(v1.s2(), v2.s2(), 31));
  TEST_INSTRUCTION("41747F5F", sqshl(d1, d2, 63));
  TEST_INSTRUCTION("41740F4F", sqshl(v1.b16(), v2.b16(), 7));
  TEST_INSTRUCTION("41741F4F", sqshl(v1.h8(), v2.h8(), 15));
  TEST_INSTRUCTION("41743F4F", sqshl(v1.s4(), v2.s4(), 31));
  TEST_INSTRUCTION("41747F4F", sqshl(v1.d2(), v2.d2(), 63));
  TEST_INSTRUCTION("414C235E", sqshl(b1, b2, b3));
  TEST_INSTRUCTION("414C635E", sqshl(h1, h2, h3));
  TEST_INSTRUCTION("414CA35E", sqshl(s1, s2, s3));
  TEST_INSTRUCTION("414C230E", sqshl(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("414C630E", sqshl(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("414CA30E", sqshl(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("414CE35E", sqshl(d1, d2, d3));
  TEST_INSTRUCTION("414C234E", sqshl(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("414C634E", sqshl(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("414CA34E", sqshl(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("414CE34E", sqshl(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4164097F", sqshlu(b1, b2, 1));
  TEST_INSTRUCTION("4164127F", sqshlu(h1, h2, 2));
  TEST_INSTRUCTION("4164237F", sqshlu(s1, s2, 3));
  TEST_INSTRUCTION("41640F2F", sqshlu(v1.b8(), v2.b8(), 7));
  TEST_INSTRUCTION("41641F2F", sqshlu(v1.h4(), v2.h4(), 15));
  TEST_INSTRUCTION("41643F2F", sqshlu(v1.s2(), v2.s2(), 31));
  TEST_INSTRUCTION("41647F7F", sqshlu(d1, d2, 63));
  TEST_INSTRUCTION("41640F6F", sqshlu(v1.b16(), v2.b16(), 7));
  TEST_INSTRUCTION("41641F6F", sqshlu(v1.h8(), v2.h8(), 15));
  TEST_INSTRUCTION("41643F6F", sqshlu(v1.s4(), v2.s4(), 31));
  TEST_INSTRUCTION("41647F6F", sqshlu(v1.d2(), v2.d2(), 63));
  TEST_INSTRUCTION("4194085F", sqshrn(b1, h2, 8));
  TEST_INSTRUCTION("4194105F", sqshrn(h1, s2, 16));
  TEST_INSTRUCTION("4194205F", sqshrn(s1, d2, 32));
  TEST_INSTRUCTION("4194080F", sqshrn(v1.b8(), v2.h8(), 8));
  TEST_INSTRUCTION("4194100F", sqshrn(v1.h4(), v2.s4(), 16));
  TEST_INSTRUCTION("4194200F", sqshrn(v1.s2(), v2.d2(), 32));
  TEST_INSTRUCTION("4194084F", sqshrn2(v1.b16(), v2.h8(), 8));
  TEST_INSTRUCTION("4194104F", sqshrn2(v1.h8(), v2.s4(), 16));
  TEST_INSTRUCTION("4194204F", sqshrn2(v1.s4(), v2.d2(), 32));
  TEST_INSTRUCTION("4184087F", sqshrun(b1, h2, 8));
  TEST_INSTRUCTION("4184107F", sqshrun(h1, s2, 16));
  TEST_INSTRUCTION("4184207F", sqshrun(s1, d2, 32));
  TEST_INSTRUCTION("4184082F", sqshrun(v1.b8(), v2.h8(), 8));
  TEST_INSTRUCTION("4184102F", sqshrun(v1.h4(), v2.s4(), 16));
  TEST_INSTRUCTION("4184202F", sqshrun(v1.s2(), v2.d2(), 32));
  TEST_INSTRUCTION("4184086F", sqshrun2(v1.b16(), v2.h8(), 8));
  TEST_INSTRUCTION("4184106F", sqshrun2(v1.h8(), v2.s4(), 16));
  TEST_INSTRUCTION("4184206F", sqshrun2(v1.s4(), v2.d2(), 32));
  TEST_INSTRUCTION("412C235E", sqsub(b1, b2, b3));
  TEST_INSTRUCTION("412C635E", sqsub(h1, h2, h3));
  TEST_INSTRUCTION("412CA35E", sqsub(s1, s2, s3));
  TEST_INSTRUCTION("412CE35E", sqsub(d1, d2, d3));
  TEST_INSTRUCTION("412C230E", sqsub(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("412C630E", sqsub(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("412CA30E", sqsub(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("412C234E", sqsub(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("412C634E", sqsub(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("412CA34E", sqsub(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("412CE34E", sqsub(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4148215E", sqxtn(b1, h2));
  TEST_INSTRUCTION("4148615E", sqxtn(h1, s2));
  TEST_INSTRUCTION("4148A15E", sqxtn(s1, d2));
  TEST_INSTRUCTION("4148210E", sqxtn(v1.b8(), v2.h8()));
  TEST_INSTRUCTION("4148610E", sqxtn(v1.h4(), v2.s4()));
  TEST_INSTRUCTION("4148A10E", sqxtn(v1.s2(), v2.d2()));
  TEST_INSTRUCTION("4148214E", sqxtn2(v1.b16(), v2.h8()));
  TEST_INSTRUCTION("4148614E", sqxtn2(v1.h8(), v2.s4()));
  TEST_INSTRUCTION("4148A14E", sqxtn2(v1.s4(), v2.d2()));
  TEST_INSTRUCTION("4128217E", sqxtun(b1, h2));
  TEST_INSTRUCTION("4128617E", sqxtun(h1, s2));
  TEST_INSTRUCTION("4128A17E", sqxtun(s1, d2));
  TEST_INSTRUCTION("4128212E", sqxtun(v1.b8(), v2.h8()));
  TEST_INSTRUCTION("4128612E", sqxtun(v1.h4(), v2.s4()));
  TEST_INSTRUCTION("4128A12E", sqxtun(v1.s2(), v2.d2()));
  TEST_INSTRUCTION("4128216E", sqxtun2(v1.b16(), v2.h8()));
  TEST_INSTRUCTION("4128616E", sqxtun2(v1.h8(), v2.s4()));
  TEST_INSTRUCTION("4128A16E", sqxtun2(v1.s4(), v2.d2()));
  TEST_INSTRUCTION("4114230E", srhadd(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4114630E", srhadd(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4114A30E", srhadd(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4114234E", srhadd(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4114634E", srhadd(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4114A34E", srhadd(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4144092F", sri(v1.b8(), v2.b8(), 7));
  TEST_INSTRUCTION("4144112F", sri(v1.h4(), v2.h4(), 15));
  TEST_INSTRUCTION("4144212F", sri(v1.s2(), v2.s2(), 31));
  TEST_INSTRUCTION("4144417F", sri(d1, d2, 63));
  TEST_INSTRUCTION("4144096F", sri(v1.b16(), v2.b16(), 7));
  TEST_INSTRUCTION("4144116F", sri(v1.h8(), v2.h8(), 15));
  TEST_INSTRUCTION("4144216F", sri(v1.s4(), v2.s4(), 31));
  TEST_INSTRUCTION("4144416F", sri(v1.d2(), v2.d2(), 63));
  TEST_INSTRUCTION("4154230E", srshl(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4154630E", srshl(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4154A30E", srshl(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4154E35E", srshl(d1, d2, d3));
  TEST_INSTRUCTION("4154234E", srshl(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4154634E", srshl(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4154A34E", srshl(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4154E34E", srshl(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4124090F", srshr(v1.b8(), v2.b8(), 7));
  TEST_INSTRUCTION("4124110F", srshr(v1.h4(), v2.h4(), 15));
  TEST_INSTRUCTION("4124210F", srshr(v1.s2(), v2.s2(), 31));
  TEST_INSTRUCTION("4124415F", srshr(d1, d2, 63));
  TEST_INSTRUCTION("4124094F", srshr(v1.b16(), v2.b16(), 7));
  TEST_INSTRUCTION("4124114F", srshr(v1.h8(), v2.h8(), 15));
  TEST_INSTRUCTION("4124214F", srshr(v1.s4(), v2.s4(), 31));
  TEST_INSTRUCTION("4124414F", srshr(v1.d2(), v2.d2(), 63));
  TEST_INSTRUCTION("4134090F", srsra(v1.b8(), v2.b8(), 7));
  TEST_INSTRUCTION("4134110F", srsra(v1.h4(), v2.h4(), 15));
  TEST_INSTRUCTION("4134210F", srsra(v1.s2(), v2.s2(), 31));
  TEST_INSTRUCTION("4134415F", srsra(d1, d2, 63));
  TEST_INSTRUCTION("4134094F", srsra(v1.b16(), v2.b16(), 7));
  TEST_INSTRUCTION("4134114F", srsra(v1.h8(), v2.h8(), 15));
  TEST_INSTRUCTION("4134214F", srsra(v1.s4(), v2.s4(), 31));
  TEST_INSTRUCTION("4134414F", srsra(v1.d2(), v2.d2(), 63));
  TEST_INSTRUCTION("4144230E", sshl(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4144630E", sshl(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4144A30E", sshl(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4144E35E", sshl(d1, d2, d3));
  TEST_INSTRUCTION("4144234E", sshl(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4144634E", sshl(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4144A34E", sshl(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4144E34E", sshl(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41A40F0F", sshll(v1.h8(), v2.b8(), 7));
  TEST_INSTRUCTION("41A41F0F", sshll(v1.s4(), v2.h4(), 15));
  TEST_INSTRUCTION("41A43F0F", sshll(v1.d2(), v2.s2(), 31));
  TEST_INSTRUCTION("41A40F4F", sshll2(v1.h8(), v2.b16(), 7));
  TEST_INSTRUCTION("41A41F4F", sshll2(v1.s4(), v2.h8(), 15));
  TEST_INSTRUCTION("41A43F4F", sshll2(v1.s2(), v2.s4(), 31));
  TEST_INSTRUCTION("4104090F", sshr(v1.b8(), v2.b8(), 7));
  TEST_INSTRUCTION("4104110F", sshr(v1.h4(), v2.h4(), 15));
  TEST_INSTRUCTION("4104210F", sshr(v1.s2(), v2.s2(), 31));
  TEST_INSTRUCTION("4104415F", sshr(d1, d2, 63));
  TEST_INSTRUCTION("4104094F", sshr(v1.b16(), v2.b16(), 7));
  TEST_INSTRUCTION("4104114F", sshr(v1.h8(), v2.h8(), 15));
  TEST_INSTRUCTION("4104214F", sshr(v1.s4(), v2.s4(), 31));
  TEST_INSTRUCTION("4104414F", sshr(v1.d2(), v2.d2(), 63));
  TEST_INSTRUCTION("4114090F", ssra(v1.b8(), v2.b8(), 7));
  TEST_INSTRUCTION("4114110F", ssra(v1.h4(), v2.h4(), 15));
  TEST_INSTRUCTION("4114210F", ssra(v1.s2(), v2.s2(), 31));
  TEST_INSTRUCTION("4114415F", ssra(d1, d2, 63));
  TEST_INSTRUCTION("4114094F", ssra(v1.b16(), v2.b16(), 7));
  TEST_INSTRUCTION("4114114F", ssra(v1.h8(), v2.h8(), 15));
  TEST_INSTRUCTION("4114214F", ssra(v1.s4(), v2.s4(), 31));
  TEST_INSTRUCTION("4114414F", ssra(v1.d2(), v2.d2(), 63));
  TEST_INSTRUCTION("4120230E", ssubl(v1.h8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4120630E", ssubl(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4120A30E", ssubl(v1.d2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4120234E", ssubl2(v1.h8(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4120634E", ssubl2(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4120A34E", ssubl2(v1.d2(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4130230E", ssubw(v1.h8(), v2.h8(), v3.b8()));
  TEST_INSTRUCTION("4130630E", ssubw(v1.s4(), v2.s4(), v3.h4()));
  TEST_INSTRUCTION("4130A30E", ssubw(v1.d2(), v2.d2(), v3.s2()));
  TEST_INSTRUCTION("4130234E", ssubw2(v1.h8(), v2.h8(), v3.b16()));
  TEST_INSTRUCTION("4130634E", ssubw2(v1.s4(), v2.s4(), v3.h8()));
  TEST_INSTRUCTION("4130A34E", ssubw2(v1.d2(), v2.d2(), v3.s4()));
  TEST_INSTRUCTION("4100000D", st1(v1.b(0), ptr(x2)));
  TEST_INSTRUCTION("41009F0D", st1(v1.b(0), ptr_post(x2, 1)));
  TEST_INSTRUCTION("4140000D", st1(v1.h(0), ptr(x2)));
  TEST_INSTRUCTION("41409F0D", st1(v1.h(0), ptr_post(x2, 2)));
  TEST_INSTRUCTION("4180000D", st1(v1.s(0), ptr(x2)));
  TEST_INSTRUCTION("41809F0D", st1(v1.s(0), ptr_post(x2, 4)));
  TEST_INSTRUCTION("4184000D", st1(v1.d(0), ptr(x2)));
  TEST_INSTRUCTION("41849F0D", st1(v1.d(0), ptr_post(x2, 8)));
  TEST_INSTRUCTION("411C004D", st1(v1.b(15), ptr(x2)));
  TEST_INSTRUCTION("411C9F4D", st1(v1.b(15), ptr_post(x2, 1)));
  TEST_INSTRUCTION("4158004D", st1(v1.h(7), ptr(x2)));
  TEST_INSTRUCTION("41589F4D", st1(v1.h(7), ptr_post(x2, 2)));
  TEST_INSTRUCTION("4190004D", st1(v1.s(3), ptr(x2)));
  TEST_INSTRUCTION("41909F4D", st1(v1.s(3), ptr_post(x2, 4)));
  TEST_INSTRUCTION("4184004D", st1(v1.d(1), ptr(x2)));
  TEST_INSTRUCTION("41849F4D", st1(v1.d(1), ptr_post(x2, 8)));
  TEST_INSTRUCTION("4170000C", st1(v1.b8(), ptr(x2)));
  TEST_INSTRUCTION("41709F0C", st1(v1.b8(), ptr_post(x2, 8)));
  TEST_INSTRUCTION("4170004C", st1(v1.b16(), ptr(x2)));
  TEST_INSTRUCTION("41709F4C", st1(v1.b16(), ptr_post(x2, 16)));
  TEST_INSTRUCTION("61A0000C", st1(v1.b8(), v2.b8(), ptr(x3)));
  TEST_INSTRUCTION("61A09F0C", st1(v1.b8(), v2.b8(), ptr_post(x3, 16)));
  TEST_INSTRUCTION("61A0004C", st1(v1.b16(), v2.b16(), ptr(x3)));
  TEST_INSTRUCTION("61A09F4C", st1(v1.b16(), v2.b16(), ptr_post(x3, 32)));
  TEST_INSTRUCTION("8160000C", st1(v1.b8(), v2.b8(), v3.b8(), ptr(x4)));
  TEST_INSTRUCTION("81609F0C", st1(v1.b8(), v2.b8(), v3.b8(), ptr_post(x4, 24)));
  TEST_INSTRUCTION("8160004C", st1(v1.b16(), v2.b16(), v3.b16(), ptr(x4)));
  TEST_INSTRUCTION("81609F4C", st1(v1.b16(), v2.b16(), v3.b16(), ptr_post(x4, 48)));
  TEST_INSTRUCTION("A120000C", st1(v1.b8(), v2.b8(), v3.b8(), v4.b8(), ptr(x5)));
  TEST_INSTRUCTION("A1209F0C", st1(v1.b8(), v2.b8(), v3.b8(), v4.b8(), ptr_post(x5, 32)));
  TEST_INSTRUCTION("A120004C", st1(v1.b16(), v2.b16(), v3.b16(), v4.b16(), ptr(x5)));
  TEST_INSTRUCTION("A1209F4C", st1(v1.b16(), v2.b16(), v3.b16(), v4.b16(), ptr_post(x5, 64)));
  TEST_INSTRUCTION("4174000C", st1(v1.h4(), ptr(x2)));
  TEST_INSTRUCTION("41749F0C", st1(v1.h4(), ptr_post(x2, 8)));
  TEST_INSTRUCTION("4174004C", st1(v1.h8(), ptr(x2)));
  TEST_INSTRUCTION("41749F4C", st1(v1.h8(), ptr_post(x2, 16)));
  TEST_INSTRUCTION("61A4000C", st1(v1.h4(), v2.h4(), ptr(x3)));
  TEST_INSTRUCTION("61A49F0C", st1(v1.h4(), v2.h4(), ptr_post(x3, 16)));
  TEST_INSTRUCTION("61A4004C", st1(v1.h8(), v2.h8(), ptr(x3)));
  TEST_INSTRUCTION("61A49F4C", st1(v1.h8(), v2.h8(), ptr_post(x3, 32)));
  TEST_INSTRUCTION("8164000C", st1(v1.h4(), v2.h4(), v3.h4(), ptr(x4)));
  TEST_INSTRUCTION("81649F0C", st1(v1.h4(), v2.h4(), v3.h4(), ptr_post(x4, 24)));
  TEST_INSTRUCTION("8164004C", st1(v1.h8(), v2.h8(), v3.h8(), ptr(x4)));
  TEST_INSTRUCTION("81649F4C", st1(v1.h8(), v2.h8(), v3.h8(), ptr_post(x4, 48)));
  TEST_INSTRUCTION("A124000C", st1(v1.h4(), v2.h4(), v3.h4(), v4.h4(), ptr(x5)));
  TEST_INSTRUCTION("A1249F0C", st1(v1.h4(), v2.h4(), v3.h4(), v4.h4(), ptr_post(x5, 32)));
  TEST_INSTRUCTION("A124004C", st1(v1.h8(), v2.h8(), v3.h8(), v4.h8(), ptr(x5)));
  TEST_INSTRUCTION("A1249F4C", st1(v1.h8(), v2.h8(), v3.h8(), v4.h8(), ptr_post(x5, 64)));
  TEST_INSTRUCTION("4178000C", st1(v1.s2(), ptr(x2)));
  TEST_INSTRUCTION("41789F0C", st1(v1.s2(), ptr_post(x2, 8)));
  TEST_INSTRUCTION("4178004C", st1(v1.s4(), ptr(x2)));
  TEST_INSTRUCTION("41789F4C", st1(v1.s4(), ptr_post(x2, 16)));
  TEST_INSTRUCTION("61A8000C", st1(v1.s2(), v2.s2(), ptr(x3)));
  TEST_INSTRUCTION("61A89F0C", st1(v1.s2(), v2.s2(), ptr_post(x3, 16)));
  TEST_INSTRUCTION("61A8004C", st1(v1.s4(), v2.s4(), ptr(x3)));
  TEST_INSTRUCTION("61A89F4C", st1(v1.s4(), v2.s4(), ptr_post(x3, 32)));
  TEST_INSTRUCTION("8168000C", st1(v1.s2(), v2.s2(), v3.s2(), ptr(x4)));
  TEST_INSTRUCTION("81689F0C", st1(v1.s2(), v2.s2(), v3.s2(), ptr_post(x4, 24)));
  TEST_INSTRUCTION("8168004C", st1(v1.s4(), v2.s4(), v3.s4(), ptr(x4)));
  TEST_INSTRUCTION("81689F4C", st1(v1.s4(), v2.s4(), v3.s4(), ptr_post(x4, 48)));
  TEST_INSTRUCTION("A128000C", st1(v1.s2(), v2.s2(), v3.s2(), v4.s2(), ptr(x5)));
  TEST_INSTRUCTION("A1289F0C", st1(v1.s2(), v2.s2(), v3.s2(), v4.s2(), ptr_post(x5, 32)));
  TEST_INSTRUCTION("A128004C", st1(v1.s4(), v2.s4(), v3.s4(), v4.s4(), ptr(x5)));
  TEST_INSTRUCTION("A1289F4C", st1(v1.s4(), v2.s4(), v3.s4(), v4.s4(), ptr_post(x5, 64)));
  TEST_INSTRUCTION("417C004C", st1(v1.d2(), ptr(x2)));
  TEST_INSTRUCTION("417C9F4C", st1(v1.d2(), ptr_post(x2, 16)));
  TEST_INSTRUCTION("61AC004C", st1(v1.d2(), v2.d2(), ptr(x3)));
  TEST_INSTRUCTION("61AC9F4C", st1(v1.d2(), v2.d2(), ptr_post(x3, 32)));
  TEST_INSTRUCTION("816C004C", st1(v1.d2(), v2.d2(), v3.d2(), ptr(x4)));
  TEST_INSTRUCTION("816C9F4C", st1(v1.d2(), v2.d2(), v3.d2(), ptr_post(x4, 48)));
  TEST_INSTRUCTION("A12C004C", st1(v1.d2(), v2.d2(), v3.d2(), v4.d2(), ptr(x5)));
  TEST_INSTRUCTION("A12C9F4C", st1(v1.d2(), v2.d2(), v3.d2(), v4.d2(), ptr_post(x5, 64)));
  TEST_INSTRUCTION("6100200D", st2(v1.b(0), v2.b(0), ptr(x3)));
  TEST_INSTRUCTION("6100BF0D", st2(v1.b(0), v2.b(0), ptr_post(x3, 2)));
  TEST_INSTRUCTION("6100AB0D", st2(v1.b(0), v2.b(0), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6140200D", st2(v1.h(0), v2.h(0), ptr(x3)));
  TEST_INSTRUCTION("6140BF0D", st2(v1.h(0), v2.h(0), ptr_post(x3, 4)));
  TEST_INSTRUCTION("6140AB0D", st2(v1.h(0), v2.h(0), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6180200D", st2(v1.s(0), v2.s(0), ptr(x3)));
  TEST_INSTRUCTION("6180BF0D", st2(v1.s(0), v2.s(0), ptr_post(x3, 8)));
  TEST_INSTRUCTION("6180AB0D", st2(v1.s(0), v2.s(0), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6184200D", st2(v1.d(0), v2.d(0), ptr(x3)));
  TEST_INSTRUCTION("6184BF0D", st2(v1.d(0), v2.d(0), ptr_post(x3, 16)));
  TEST_INSTRUCTION("6184AB0D", st2(v1.d(0), v2.d(0), ptr_post(x3, x11)));
  TEST_INSTRUCTION("611C204D", st2(v1.b(15), v2.b(15), ptr(x3)));
  TEST_INSTRUCTION("611CBF4D", st2(v1.b(15), v2.b(15), ptr_post(x3, 2)));
  TEST_INSTRUCTION("611CAB4D", st2(v1.b(15), v2.b(15), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6158204D", st2(v1.h(7), v2.h(7), ptr(x3)));
  TEST_INSTRUCTION("6158BF4D", st2(v1.h(7), v2.h(7), ptr_post(x3, 4)));
  TEST_INSTRUCTION("6158AB4D", st2(v1.h(7), v2.h(7), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6190204D", st2(v1.s(3), v2.s(3), ptr(x3)));
  TEST_INSTRUCTION("6190BF4D", st2(v1.s(3), v2.s(3), ptr_post(x3, 8)));
  TEST_INSTRUCTION("6190AB4D", st2(v1.s(3), v2.s(3), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6184204D", st2(v1.d(1), v2.d(1), ptr(x3)));
  TEST_INSTRUCTION("6184BF4D", st2(v1.d(1), v2.d(1), ptr_post(x3, 16)));
  TEST_INSTRUCTION("6184AB4D", st2(v1.d(1), v2.d(1), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6180000C", st2(v1.b8(), v2.b8(), ptr(x3)));
  TEST_INSTRUCTION("61809F0C", st2(v1.b8(), v2.b8(), ptr_post(x3, 16)));
  TEST_INSTRUCTION("61808B0C", st2(v1.b8(), v2.b8(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6180004C", st2(v1.b16(), v2.b16(), ptr(x3)));
  TEST_INSTRUCTION("61809F4C", st2(v1.b16(), v2.b16(), ptr_post(x3, 32)));
  TEST_INSTRUCTION("61808B4C", st2(v1.b16(), v2.b16(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6184000C", st2(v1.h4(), v2.h4(), ptr(x3)));
  TEST_INSTRUCTION("61849F0C", st2(v1.h4(), v2.h4(), ptr_post(x3, 16)));
  TEST_INSTRUCTION("61848B0C", st2(v1.h4(), v2.h4(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6184004C", st2(v1.h8(), v2.h8(), ptr(x3)));
  TEST_INSTRUCTION("61849F4C", st2(v1.h8(), v2.h8(), ptr_post(x3, 32)));
  TEST_INSTRUCTION("61848B4C", st2(v1.h8(), v2.h8(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6188000C", st2(v1.s2(), v2.s2(), ptr(x3)));
  TEST_INSTRUCTION("61889F0C", st2(v1.s2(), v2.s2(), ptr_post(x3, 16)));
  TEST_INSTRUCTION("61888B0C", st2(v1.s2(), v2.s2(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("6188004C", st2(v1.s4(), v2.s4(), ptr(x3)));
  TEST_INSTRUCTION("61889F4C", st2(v1.s4(), v2.s4(), ptr_post(x3, 32)));
  TEST_INSTRUCTION("61888B4C", st2(v1.s4(), v2.s4(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("618C004C", st2(v1.d2(), v2.d2(), ptr(x3)));
  TEST_INSTRUCTION("618C9F4C", st2(v1.d2(), v2.d2(), ptr_post(x3, 32)));
  TEST_INSTRUCTION("618C8B4C", st2(v1.d2(), v2.d2(), ptr_post(x3, x11)));
  TEST_INSTRUCTION("8120000D", st3(v1.b(0), v2.b(0), v3.b(0), ptr(x4)));
  TEST_INSTRUCTION("81209F0D", st3(v1.b(0), v2.b(0), v3.b(0), ptr_post(x4, 3)));
  TEST_INSTRUCTION("81208B0D", st3(v1.b(0), v2.b(0), v3.b(0), ptr_post(x4, x11)));
  TEST_INSTRUCTION("8160000D", st3(v1.h(0), v2.h(0), v3.h(0), ptr(x4)));
  TEST_INSTRUCTION("81609F0D", st3(v1.h(0), v2.h(0), v3.h(0), ptr_post(x4, 6)));
  TEST_INSTRUCTION("81608B0D", st3(v1.h(0), v2.h(0), v3.h(0), ptr_post(x4, x11)));
  TEST_INSTRUCTION("81A0000D", st3(v1.s(0), v2.s(0), v3.s(0), ptr(x4)));
  TEST_INSTRUCTION("81A09F0D", st3(v1.s(0), v2.s(0), v3.s(0), ptr_post(x4, 12)));
  TEST_INSTRUCTION("81A08B0D", st3(v1.s(0), v2.s(0), v3.s(0), ptr_post(x4, x11)));
  TEST_INSTRUCTION("81A4000D", st3(v1.d(0), v2.d(0), v3.d(0), ptr(x4)));
  TEST_INSTRUCTION("81A49F0D", st3(v1.d(0), v2.d(0), v3.d(0), ptr_post(x4, 24)));
  TEST_INSTRUCTION("81A48B0D", st3(v1.d(0), v2.d(0), v3.d(0), ptr_post(x4, x11)));
  TEST_INSTRUCTION("813C004D", st3(v1.b(15), v2.b(15), v3.b(15), ptr(x4)));
  TEST_INSTRUCTION("813C9F4D", st3(v1.b(15), v2.b(15), v3.b(15), ptr_post(x4, 3)));
  TEST_INSTRUCTION("813C8B4D", st3(v1.b(15), v2.b(15), v3.b(15), ptr_post(x4, x11)));
  TEST_INSTRUCTION("8178004D", st3(v1.h(7), v2.h(7), v3.h(7), ptr(x4)));
  TEST_INSTRUCTION("81789F4D", st3(v1.h(7), v2.h(7), v3.h(7), ptr_post(x4, 6)));
  TEST_INSTRUCTION("81788B4D", st3(v1.h(7), v2.h(7), v3.h(7), ptr_post(x4, x11)));
  TEST_INSTRUCTION("81B0004D", st3(v1.s(3), v2.s(3), v3.s(3), ptr(x4)));
  TEST_INSTRUCTION("81B09F4D", st3(v1.s(3), v2.s(3), v3.s(3), ptr_post(x4, 12)));
  TEST_INSTRUCTION("81B08B4D", st3(v1.s(3), v2.s(3), v3.s(3), ptr_post(x4, x11)));
  TEST_INSTRUCTION("81A4004D", st3(v1.d(1), v2.d(1), v3.d(1), ptr(x4)));
  TEST_INSTRUCTION("81A49F4D", st3(v1.d(1), v2.d(1), v3.d(1), ptr_post(x4, 24)));
  TEST_INSTRUCTION("81A48B4D", st3(v1.d(1), v2.d(1), v3.d(1), ptr_post(x4, x11)));
  TEST_INSTRUCTION("8140000C", st3(v1.b8(), v2.b8(), v3.b8(), ptr(x4)));
  TEST_INSTRUCTION("81409F0C", st3(v1.b8(), v2.b8(), v3.b8(), ptr_post(x4, 24)));
  TEST_INSTRUCTION("81408B0C", st3(v1.b8(), v2.b8(), v3.b8(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("8140004C", st3(v1.b16(), v2.b16(), v3.b16(), ptr(x4)));
  TEST_INSTRUCTION("81409F4C", st3(v1.b16(), v2.b16(), v3.b16(), ptr_post(x4, 48)));
  TEST_INSTRUCTION("81408B4C", st3(v1.b16(), v2.b16(), v3.b16(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("8144000C", st3(v1.h4(), v2.h4(), v3.h4(), ptr(x4)));
  TEST_INSTRUCTION("81449F0C", st3(v1.h4(), v2.h4(), v3.h4(), ptr_post(x4, 24)));
  TEST_INSTRUCTION("81448B0C", st3(v1.h4(), v2.h4(), v3.h4(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("8144004C", st3(v1.h8(), v2.h8(), v3.h8(), ptr(x4)));
  TEST_INSTRUCTION("81449F4C", st3(v1.h8(), v2.h8(), v3.h8(), ptr_post(x4, 48)));
  TEST_INSTRUCTION("81448B4C", st3(v1.h8(), v2.h8(), v3.h8(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("8148000C", st3(v1.s2(), v2.s2(), v3.s2(), ptr(x4)));
  TEST_INSTRUCTION("81489F0C", st3(v1.s2(), v2.s2(), v3.s2(), ptr_post(x4, 24)));
  TEST_INSTRUCTION("81488B0C", st3(v1.s2(), v2.s2(), v3.s2(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("8148004C", st3(v1.s4(), v2.s4(), v3.s4(), ptr(x4)));
  TEST_INSTRUCTION("81489F4C", st3(v1.s4(), v2.s4(), v3.s4(), ptr_post(x4, 48)));
  TEST_INSTRUCTION("81488B4C", st3(v1.s4(), v2.s4(), v3.s4(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("814C004C", st3(v1.d2(), v2.d2(), v3.d2(), ptr(x4)));
  TEST_INSTRUCTION("814C9F4C", st3(v1.d2(), v2.d2(), v3.d2(), ptr_post(x4, 48)));
  TEST_INSTRUCTION("814C8B4C", st3(v1.d2(), v2.d2(), v3.d2(), ptr_post(x4, x11)));
  TEST_INSTRUCTION("A120200D", st4(v1.b(0), v2.b(0), v3.b(0), v4.b(0), ptr(x5)));
  TEST_INSTRUCTION("A120BF0D", st4(v1.b(0), v2.b(0), v3.b(0), v4.b(0), ptr_post(x5, 4)));
  TEST_INSTRUCTION("A120AB0D", st4(v1.b(0), v2.b(0), v3.b(0), v4.b(0), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A160200D", st4(v1.h(0), v2.h(0), v3.h(0), v4.h(0), ptr(x5)));
  TEST_INSTRUCTION("A160BF0D", st4(v1.h(0), v2.h(0), v3.h(0), v4.h(0), ptr_post(x5, 8)));
  TEST_INSTRUCTION("A160AB0D", st4(v1.h(0), v2.h(0), v3.h(0), v4.h(0), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A1A0200D", st4(v1.s(0), v2.s(0), v3.s(0), v4.s(0), ptr(x5)));
  TEST_INSTRUCTION("A1A0BF0D", st4(v1.s(0), v2.s(0), v3.s(0), v4.s(0), ptr_post(x5, 16)));
  TEST_INSTRUCTION("A1A0AB0D", st4(v1.s(0), v2.s(0), v3.s(0), v4.s(0), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A1A4200D", st4(v1.d(0), v2.d(0), v3.d(0), v4.d(0), ptr(x5)));
  TEST_INSTRUCTION("A1A4BF0D", st4(v1.d(0), v2.d(0), v3.d(0), v4.d(0), ptr_post(x5, 32)));
  TEST_INSTRUCTION("A1A4AB0D", st4(v1.d(0), v2.d(0), v3.d(0), v4.d(0), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A13C204D", st4(v1.b(15), v2.b(15), v3.b(15), v4.b(15), ptr(x5)));
  TEST_INSTRUCTION("A13CBF4D", st4(v1.b(15), v2.b(15), v3.b(15), v4.b(15), ptr_post(x5, 4)));
  TEST_INSTRUCTION("A13CAB4D", st4(v1.b(15), v2.b(15), v3.b(15), v4.b(15), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A178204D", st4(v1.h(7), v2.h(7), v3.h(7), v4.h(7), ptr(x5)));
  TEST_INSTRUCTION("A178BF4D", st4(v1.h(7), v2.h(7), v3.h(7), v4.h(7), ptr_post(x5, 8)));
  TEST_INSTRUCTION("A178AB4D", st4(v1.h(7), v2.h(7), v3.h(7), v4.h(7), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A1B0204D", st4(v1.s(3), v2.s(3), v3.s(3), v4.s(3), ptr(x5)));
  TEST_INSTRUCTION("A1B0BF4D", st4(v1.s(3), v2.s(3), v3.s(3), v4.s(3), ptr_post(x5, 16)));
  TEST_INSTRUCTION("A1B0AB4D", st4(v1.s(3), v2.s(3), v3.s(3), v4.s(3), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A1A4204D", st4(v1.d(1), v2.d(1), v3.d(1), v4.d(1), ptr(x5)));
  TEST_INSTRUCTION("A1A4BF4D", st4(v1.d(1), v2.d(1), v3.d(1), v4.d(1), ptr_post(x5, 32)));
  TEST_INSTRUCTION("A1A4AB4D", st4(v1.d(1), v2.d(1), v3.d(1), v4.d(1), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A100000C", st4(v1.b8(), v2.b8(), v3.b8(), v4.b8(), ptr(x5)));
  TEST_INSTRUCTION("A1009F0C", st4(v1.b8(), v2.b8(), v3.b8(), v4.b8(), ptr_post(x5, 32)));
  TEST_INSTRUCTION("A1008B0C", st4(v1.b8(), v2.b8(), v3.b8(), v4.b8(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A100004C", st4(v1.b16(), v2.b16(), v3.b16(), v4.b16(), ptr(x5)));
  TEST_INSTRUCTION("A1009F4C", st4(v1.b16(), v2.b16(), v3.b16(), v4.b16(), ptr_post(x5, 64)));
  TEST_INSTRUCTION("A1008B4C", st4(v1.b16(), v2.b16(), v3.b16(), v4.b16(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A104000C", st4(v1.h4(), v2.h4(), v3.h4(), v4.h4(), ptr(x5)));
  TEST_INSTRUCTION("A1049F0C", st4(v1.h4(), v2.h4(), v3.h4(), v4.h4(), ptr_post(x5, 32)));
  TEST_INSTRUCTION("A1048B0C", st4(v1.h4(), v2.h4(), v3.h4(), v4.h4(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A104004C", st4(v1.h8(), v2.h8(), v3.h8(), v4.h8(), ptr(x5)));
  TEST_INSTRUCTION("A1049F4C", st4(v1.h8(), v2.h8(), v3.h8(), v4.h8(), ptr_post(x5, 64)));
  TEST_INSTRUCTION("A1048B4C", st4(v1.h8(), v2.h8(), v3.h8(), v4.h8(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A108000C", st4(v1.s2(), v2.s2(), v3.s2(), v4.s2(), ptr(x5)));
  TEST_INSTRUCTION("A1089F0C", st4(v1.s2(), v2.s2(), v3.s2(), v4.s2(), ptr_post(x5, 32)));
  TEST_INSTRUCTION("A1088B0C", st4(v1.s2(), v2.s2(), v3.s2(), v4.s2(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A108004C", st4(v1.s4(), v2.s4(), v3.s4(), v4.s4(), ptr(x5)));
  TEST_INSTRUCTION("A1089F4C", st4(v1.s4(), v2.s4(), v3.s4(), v4.s4(), ptr_post(x5, 64)));
  TEST_INSTRUCTION("A1088B4C", st4(v1.s4(), v2.s4(), v3.s4(), v4.s4(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("A10C004C", st4(v1.d2(), v2.d2(), v3.d2(), v4.d2(), ptr(x5)));
  TEST_INSTRUCTION("A10C9F4C", st4(v1.d2(), v2.d2(), v3.d2(), v4.d2(), ptr_post(x5, 64)));
  TEST_INSTRUCTION("A10C8B4C", st4(v1.d2(), v2.d2(), v3.d2(), v4.d2(), ptr_post(x5, x11)));
  TEST_INSTRUCTION("8109002C", stnp(s1, s2, ptr(x12)));
  TEST_INSTRUCTION("8189002C", stnp(s1, s2, ptr(x12, 4)));
  TEST_INSTRUCTION("8109302C", stnp(s1, s2, ptr(x12, -128)));
  TEST_INSTRUCTION("E10B002C", stnp(s1, s2, ptr(sp)));
  TEST_INSTRUCTION("E18B002C", stnp(s1, s2, ptr(sp, 4)));
  TEST_INSTRUCTION("E10B102C", stnp(s1, s2, ptr(sp, 128)));
  TEST_INSTRUCTION("8109006C", stnp(d1, d2, ptr(x12)));
  TEST_INSTRUCTION("8189006C", stnp(d1, d2, ptr(x12, 8)));
  TEST_INSTRUCTION("8109386C", stnp(d1, d2, ptr(x12, -128)));
  TEST_INSTRUCTION("E10B006C", stnp(d1, d2, ptr(sp)));
  TEST_INSTRUCTION("E18B006C", stnp(d1, d2, ptr(sp, 8)));
  TEST_INSTRUCTION("E10B086C", stnp(d1, d2, ptr(sp, 128)));
  TEST_INSTRUCTION("810900AC", stnp(q1, q2, ptr(x12)));
  TEST_INSTRUCTION("818900AC", stnp(q1, q2, ptr(x12, 16)));
  TEST_INSTRUCTION("81093CAC", stnp(q1, q2, ptr(x12, -128)));
  TEST_INSTRUCTION("E10B00AC", stnp(q1, q2, ptr(sp)));
  TEST_INSTRUCTION("E18B00AC", stnp(q1, q2, ptr(sp, 16)));
  TEST_INSTRUCTION("E10B04AC", stnp(q1, q2, ptr(sp, 128)));
  TEST_INSTRUCTION("8109002D", stp(s1, s2, ptr(x12)));
  TEST_INSTRUCTION("8189002D", stp(s1, s2, ptr(x12, 4)));
  TEST_INSTRUCTION("8109302D", stp(s1, s2, ptr(x12, -128)));
  TEST_INSTRUCTION("8189802D", stp(s1, s2, ptr_pre(x12, 4)));
  TEST_INSTRUCTION("8189802C", stp(s1, s2, ptr_post(x12, 4)));
  TEST_INSTRUCTION("E10B002D", stp(s1, s2, ptr(sp)));
  TEST_INSTRUCTION("E18B002D", stp(s1, s2, ptr(sp, 4)));
  TEST_INSTRUCTION("E10B102D", stp(s1, s2, ptr(sp, 128)));
  TEST_INSTRUCTION("E18B802D", stp(s1, s2, ptr_pre(sp, 4)));
  TEST_INSTRUCTION("E18B802C", stp(s1, s2, ptr_post(sp, 4)));
  TEST_INSTRUCTION("8109006D", stp(d1, d2, ptr(x12)));
  TEST_INSTRUCTION("8189006D", stp(d1, d2, ptr(x12, 8)));
  TEST_INSTRUCTION("8109386D", stp(d1, d2, ptr(x12, -128)));
  TEST_INSTRUCTION("8189806D", stp(d1, d2, ptr_pre(x12, 8)));
  TEST_INSTRUCTION("8189806C", stp(d1, d2, ptr_post(x12, 8)));
  TEST_INSTRUCTION("E10B006D", stp(d1, d2, ptr(sp)));
  TEST_INSTRUCTION("E18B006D", stp(d1, d2, ptr(sp, 8)));
  TEST_INSTRUCTION("E10B086D", stp(d1, d2, ptr(sp, 128)));
  TEST_INSTRUCTION("E18B806D", stp(d1, d2, ptr_pre(sp, 8)));
  TEST_INSTRUCTION("E18B806C", stp(d1, d2, ptr_post(sp, 8)));
  TEST_INSTRUCTION("810900AD", stp(q1, q2, ptr(x12)));
  TEST_INSTRUCTION("818900AD", stp(q1, q2, ptr(x12, 16)));
  TEST_INSTRUCTION("81093CAD", stp(q1, q2, ptr(x12, -128)));
  TEST_INSTRUCTION("818980AD", stp(q1, q2, ptr_pre(x12, 16)));
  TEST_INSTRUCTION("818980AC", stp(q1, q2, ptr_post(x12, 16)));
  TEST_INSTRUCTION("E10B00AD", stp(q1, q2, ptr(sp)));
  TEST_INSTRUCTION("E18B00AD", stp(q1, q2, ptr(sp, 16)));
  TEST_INSTRUCTION("E10B04AD", stp(q1, q2, ptr(sp, 128)));
  TEST_INSTRUCTION("E18B80AD", stp(q1, q2, ptr_pre(sp, 16)));
  TEST_INSTRUCTION("E18B80AC", stp(q1, q2, ptr_post(sp, 16)));
  TEST_INSTRUCTION("4100003D", str(b1, ptr(x2)));
  TEST_INSTRUCTION("4114003C", str(b1, ptr_post(x2, 1)));
  TEST_INSTRUCTION("4104003D", str(b1, ptr(x2, 1)));
  TEST_INSTRUCTION("411C003C", str(b1, ptr_pre(x2, 1)));
  TEST_INSTRUCTION("4114083C", str(b1, ptr_post(x2, 129)));
  TEST_INSTRUCTION("4100007D", str(h1, ptr(x2)));
  TEST_INSTRUCTION("4124007C", str(h1, ptr_post(x2, 2)));
  TEST_INSTRUCTION("4104007D", str(h1, ptr(x2, 2)));
  TEST_INSTRUCTION("412C007C", str(h1, ptr_pre(x2, 2)));
  TEST_INSTRUCTION("4124087C", str(h1, ptr_post(x2, 130)));
  TEST_INSTRUCTION("410000BD", str(s1, ptr(x2)));
  TEST_INSTRUCTION("414400BC", str(s1, ptr_post(x2, 4)));
  TEST_INSTRUCTION("410400BD", str(s1, ptr(x2, 4)));
  TEST_INSTRUCTION("414C00BC", str(s1, ptr_pre(x2, 4)));
  TEST_INSTRUCTION("414408BC", str(s1, ptr_post(x2, 132)));
  TEST_INSTRUCTION("410000FD", str(d1, ptr(x2)));
  TEST_INSTRUCTION("418400FC", str(d1, ptr_post(x2, 8)));
  TEST_INSTRUCTION("410400FD", str(d1, ptr(x2, 8)));
  TEST_INSTRUCTION("418C00FC", str(d1, ptr_pre(x2, 8)));
  TEST_INSTRUCTION("414408FC", str(d1, ptr_post(x2, 132)));
  TEST_INSTRUCTION("4168233C", str(b1, ptr(x2, x3)));
  TEST_INSTRUCTION("4148233C", str(b1, ptr(x2, w3, uxtw(0))));
  TEST_INSTRUCTION("41C8233C", str(b1, ptr(x2, w3, sxtw(0))));
  TEST_INSTRUCTION("4168237C", str(h1, ptr(x2, x3)));
  TEST_INSTRUCTION("4178237C", str(h1, ptr(x2, x3, lsl(1))));
  TEST_INSTRUCTION("4148237C", str(h1, ptr(x2, w3, uxtw(0))));
  TEST_INSTRUCTION("4158237C", str(h1, ptr(x2, w3, uxtw(1))));
  TEST_INSTRUCTION("41C8237C", str(h1, ptr(x2, w3, sxtw(0))));
  TEST_INSTRUCTION("41D8237C", str(h1, ptr(x2, w3, sxtw(1))));
  TEST_INSTRUCTION("416823BC", str(s1, ptr(x2, x3)));
  TEST_INSTRUCTION("417823BC", str(s1, ptr(x2, x3, lsl(2))));
  TEST_INSTRUCTION("414823BC", str(s1, ptr(x2, w3, uxtw(0))));
  TEST_INSTRUCTION("415823BC", str(s1, ptr(x2, w3, uxtw(2))));
  TEST_INSTRUCTION("41C823BC", str(s1, ptr(x2, w3, sxtw(0))));
  TEST_INSTRUCTION("41D823BC", str(s1, ptr(x2, w3, sxtw(2))));
  TEST_INSTRUCTION("416823FC", str(d1, ptr(x2, x3)));
  TEST_INSTRUCTION("417823FC", str(d1, ptr(x2, x3, lsl(3))));
  TEST_INSTRUCTION("414823FC", str(d1, ptr(x2, w3, uxtw(0))));
  TEST_INSTRUCTION("415823FC", str(d1, ptr(x2, w3, uxtw(3))));
  TEST_INSTRUCTION("41C823FC", str(d1, ptr(x2, w3, sxtw(0))));
  TEST_INSTRUCTION("41D823FC", str(d1, ptr(x2, w3, sxtw(3))));
  TEST_INSTRUCTION("4104003D", str(b1, ptr(x2, 1)));
  TEST_INSTRUCTION("41F01F3C", str(b1, ptr(x2, -1))); // STUR
  TEST_INSTRUCTION("4110007C", str(h1, ptr(x2, 1)));  // STUR
  TEST_INSTRUCTION("41F01F7C", str(h1, ptr(x2, -1))); // STUR
  TEST_INSTRUCTION("411000BC", str(s1, ptr(x2, 1)));  // STUR
  TEST_INSTRUCTION("41F01FBC", str(s1, ptr(x2, -1))); // STUR
  TEST_INSTRUCTION("411000FC", str(d1, ptr(x2, 1)));  // STUR
  TEST_INSTRUCTION("41F01FFC", str(d1, ptr(x2, -1))); // STUR
  TEST_INSTRUCTION("8101003C", stur(b1, ptr(x12)));
  TEST_INSTRUCTION("8131003C", stur(b1, ptr(x12, 3)));
  TEST_INSTRUCTION("8131063C", stur(b1, ptr(x12, 99)));
  TEST_INSTRUCTION("81F10F3C", stur(b1, ptr(x12, 255)));
  TEST_INSTRUCTION("8101103C", stur(b1, ptr(x12, -256)));
  TEST_INSTRUCTION("E103003C", stur(b1, ptr(sp)));
  TEST_INSTRUCTION("E153083C", stur(b1, ptr(sp, 133)));
  TEST_INSTRUCTION("8101007C", stur(h1, ptr(x12)));
  TEST_INSTRUCTION("8131007C", stur(h1, ptr(x12, 3)));
  TEST_INSTRUCTION("8131067C", stur(h1, ptr(x12, 99)));
  TEST_INSTRUCTION("81F10F7C", stur(h1, ptr(x12, 255)));
  TEST_INSTRUCTION("8101107C", stur(h1, ptr(x12, -256)));
  TEST_INSTRUCTION("E103007C", stur(h1, ptr(sp)));
  TEST_INSTRUCTION("E153087C", stur(h1, ptr(sp, 133)));
  TEST_INSTRUCTION("810100BC", stur(s1, ptr(x12)));
  TEST_INSTRUCTION("813100BC", stur(s1, ptr(x12, 3)));
  TEST_INSTRUCTION("813106BC", stur(s1, ptr(x12, 99)));
  TEST_INSTRUCTION("81F10FBC", stur(s1, ptr(x12, 255)));
  TEST_INSTRUCTION("810110BC", stur(s1, ptr(x12, -256)));
  TEST_INSTRUCTION("E10300BC", stur(s1, ptr(sp)));
  TEST_INSTRUCTION("E15308BC", stur(s1, ptr(sp, 133)));
  TEST_INSTRUCTION("810100FC", stur(d1, ptr(x12)));
  TEST_INSTRUCTION("813100FC", stur(d1, ptr(x12, 3)));
  TEST_INSTRUCTION("813106FC", stur(d1, ptr(x12, 99)));
  TEST_INSTRUCTION("81F10FFC", stur(d1, ptr(x12, 255)));
  TEST_INSTRUCTION("810110FC", stur(d1, ptr(x12, -256)));
  TEST_INSTRUCTION("E10300FC", stur(d1, ptr(sp)));
  TEST_INSTRUCTION("E15308FC", stur(d1, ptr(sp, 133)));
  TEST_INSTRUCTION("8101803C", stur(q1, ptr(x12)));
  TEST_INSTRUCTION("8131803C", stur(q1, ptr(x12, 3)));
  TEST_INSTRUCTION("8131863C", stur(q1, ptr(x12, 99)));
  TEST_INSTRUCTION("81F18F3C", stur(q1, ptr(x12, 255)));
  TEST_INSTRUCTION("8101903C", stur(q1, ptr(x12, -256)));
  TEST_INSTRUCTION("E103803C", stur(q1, ptr(sp)));
  TEST_INSTRUCTION("E153883C", stur(q1, ptr(sp, 133)));
  TEST_INSTRUCTION("4184232E", sub(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4184632E", sub(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4184A32E", sub(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4184E37E", sub(d1, d2, d3));
  TEST_INSTRUCTION("4184236E", sub(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4184636E", sub(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4184A36E", sub(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4184E36E", sub(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4160230E", subhn(v1.b8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4160630E", subhn(v1.h4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4160A30E", subhn(v1.s2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4160234E", subhn2(v1.b16(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4160634E", subhn2(v1.h8(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4160A34E", subhn2(v1.s4(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41F0030F", sudot(v1.s2(), v2.b8(), v3.b4(0)));
  TEST_INSTRUCTION("41F0230F", sudot(v1.s2(), v2.b8(), v3.b4(1)));
  TEST_INSTRUCTION("41F8030F", sudot(v1.s2(), v2.b8(), v3.b4(2)));
  TEST_INSTRUCTION("41F8230F", sudot(v1.s2(), v2.b8(), v3.b4(3)));
  TEST_INSTRUCTION("41F0034F", sudot(v1.s4(), v2.b16(), v3.b4(0)));
  TEST_INSTRUCTION("41F0234F", sudot(v1.s4(), v2.b16(), v3.b4(1)));
  TEST_INSTRUCTION("41F8034F", sudot(v1.s4(), v2.b16(), v3.b4(2)));
  TEST_INSTRUCTION("41F8234F", sudot(v1.s4(), v2.b16(), v3.b4(3)));
  TEST_INSTRUCTION("4138205E", suqadd(b1, b2));
  TEST_INSTRUCTION("4138605E", suqadd(h1, h2));
  TEST_INSTRUCTION("4138A05E", suqadd(s1, s2));
  TEST_INSTRUCTION("4138E05E", suqadd(d1, d2));
  TEST_INSTRUCTION("4138200E", suqadd(v1.b8(), v2.b8()));
  TEST_INSTRUCTION("4138600E", suqadd(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("4138A00E", suqadd(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("4138204E", suqadd(v1.b16(), v2.b16()));
  TEST_INSTRUCTION("4138604E", suqadd(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("4138A04E", suqadd(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("4138E04E", suqadd(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("41A4080F", sxtl(v1.h8(), v2.b8()));
  TEST_INSTRUCTION("41A4100F", sxtl(v1.s4(), v2.h4()));
  TEST_INSTRUCTION("41A4200F", sxtl(v1.d2(), v2.s2()));
  TEST_INSTRUCTION("41A4084F", sxtl2(v1.h8(), v2.b16()));
  TEST_INSTRUCTION("41A4104F", sxtl2(v1.s4(), v2.h8()));
  TEST_INSTRUCTION("41A4204F", sxtl2(v1.d2(), v2.s4()));
  TEST_INSTRUCTION("4100030E", tbl(v1.b8(), v2.b16(), v3.b8()));
  TEST_INSTRUCTION("4120040E", tbl(v1.b8(), v2.b16(), v3.b16(), v4.b8()));
  TEST_INSTRUCTION("4140050E", tbl(v1.b8(), v2.b16(), v3.b16(), v4.b16(), v5.b8()));
  TEST_INSTRUCTION("4160060E", tbl(v1.b8(), v2.b16(), v3.b16(), v4.b16(), v5.b16(), v6.b8()));
  TEST_INSTRUCTION("4100034E", tbl(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4120044E", tbl(v1.b16(), v2.b16(), v3.b16(), v4.b16()));
  TEST_INSTRUCTION("4140054E", tbl(v1.b16(), v2.b16(), v3.b16(), v4.b16(), v5.b16()));
  TEST_INSTRUCTION("4160064E", tbl(v1.b16(), v2.b16(), v3.b16(), v4.b16(), v5.b16(), v6.b16()));
  TEST_INSTRUCTION("4110030E", tbx(v1.b8(), v2.b16(), v3.b8()));
  TEST_INSTRUCTION("4130040E", tbx(v1.b8(), v2.b16(), v3.b16(), v4.b8()));
  TEST_INSTRUCTION("4150050E", tbx(v1.b8(), v2.b16(), v3.b16(), v4.b16(), v5.b8()));
  TEST_INSTRUCTION("4170060E", tbx(v1.b8(), v2.b16(), v3.b16(), v4.b16(), v5.b16(), v6.b8()));
  TEST_INSTRUCTION("4110034E", tbx(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4130044E", tbx(v1.b16(), v2.b16(), v3.b16(), v4.b16()));
  TEST_INSTRUCTION("4150054E", tbx(v1.b16(), v2.b16(), v3.b16(), v4.b16(), v5.b16()));
  TEST_INSTRUCTION("4170064E", tbx(v1.b16(), v2.b16(), v3.b16(), v4.b16(), v5.b16(), v6.b16()));
  TEST_INSTRUCTION("4128030E", trn1(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4128430E", trn1(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4128830E", trn1(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4128034E", trn1(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4128434E", trn1(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4128834E", trn1(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4128C34E", trn1(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4168030E", trn2(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4168430E", trn2(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4168830E", trn2(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4168034E", trn2(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4168434E", trn2(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4168834E", trn2(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4168C34E", trn2(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("417C232E", uaba(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("417C632E", uaba(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("417CA32E", uaba(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("417C236E", uaba(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("417C636E", uaba(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("417CA36E", uaba(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4150232E", uabal(v1.h8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4150632E", uabal(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4150A32E", uabal(v1.d2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4150236E", uabal2(v1.h8(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4150636E", uabal2(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4150A36E", uabal2(v1.d2(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4174232E", uabd(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4174632E", uabd(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4174A32E", uabd(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4174236E", uabd(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4174636E", uabd(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4174A36E", uabd(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4170232E", uabdl(v1.h8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4170632E", uabdl(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4170A32E", uabdl(v1.d2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4170236E", uabdl2(v1.h8(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4170636E", uabdl2(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4170A36E", uabdl2(v1.d2(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4168202E", uadalp(v1.h4(), v2.b8()));
  TEST_INSTRUCTION("4168602E", uadalp(v1.s2(), v2.h4()));
  TEST_INSTRUCTION("4168A02E", uadalp(d1, v2.s2()));
  TEST_INSTRUCTION("4168206E", uadalp(v1.h8(), v2.b16()));
  TEST_INSTRUCTION("4168606E", uadalp(v1.s4(), v2.h8()));
  TEST_INSTRUCTION("4168A06E", uadalp(v1.d2(), v2.s4()));
  TEST_INSTRUCTION("4100232E", uaddl(v1.h8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4100632E", uaddl(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4100A32E", uaddl(v1.d2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4100236E", uaddl2(v1.h8(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4100636E", uaddl2(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4100A36E", uaddl2(v1.d2(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4128202E", uaddlp(v1.h4(), v2.b8()));
  TEST_INSTRUCTION("4128602E", uaddlp(v1.s2(), v2.h4()));
  TEST_INSTRUCTION("4128A02E", uaddlp(d1, v2.s2()));
  TEST_INSTRUCTION("4128206E", uaddlp(v1.h8(), v2.b16()));
  TEST_INSTRUCTION("4128606E", uaddlp(v1.s4(), v2.h8()));
  TEST_INSTRUCTION("4128A06E", uaddlp(v1.d2(), v2.s4()));
  TEST_INSTRUCTION("4138302E", uaddlv(h1, v2.b8()));
  TEST_INSTRUCTION("4138306E", uaddlv(h1, v2.b16()));
  TEST_INSTRUCTION("4138702E", uaddlv(s1, v2.h4()));
  TEST_INSTRUCTION("4138706E", uaddlv(s1, v2.h8()));
  TEST_INSTRUCTION("4138B06E", uaddlv(d1, v2.s4()));
  TEST_INSTRUCTION("4110232E", uaddw(v1.h8(), v2.h8(), v3.b8()));
  TEST_INSTRUCTION("4110632E", uaddw(v1.s4(), v2.s4(), v3.h4()));
  TEST_INSTRUCTION("4110A32E", uaddw(v1.d2(), v2.d2(), v3.s2()));
  TEST_INSTRUCTION("4110236E", uaddw2(v1.h8(), v2.h8(), v3.b16()));
  TEST_INSTRUCTION("4110636E", uaddw2(v1.s4(), v2.s4(), v3.h8()));
  TEST_INSTRUCTION("4110A36E", uaddw2(v1.d2(), v2.d2(), v3.s4()));
  TEST_INSTRUCTION("4100E31E", ucvtf(h1, w2));
  TEST_INSTRUCTION("4100231E", ucvtf(s1, w2));
  TEST_INSTRUCTION("4100631E", ucvtf(d1, w2));
  TEST_INSTRUCTION("4100E39E", ucvtf(h1, x2));
  TEST_INSTRUCTION("4100239E", ucvtf(s1, x2));
  TEST_INSTRUCTION("4100639E", ucvtf(d1, x2));
  TEST_INSTRUCTION("41D8797E", ucvtf(h1, h2));
  TEST_INSTRUCTION("41D8217E", ucvtf(s1, s2));
  TEST_INSTRUCTION("41D8617E", ucvtf(d1, d2));
  TEST_INSTRUCTION("41D8792E", ucvtf(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("41D8212E", ucvtf(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41D8796E", ucvtf(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("41D8216E", ucvtf(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("41D8616E", ucvtf(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("41E0C31E", ucvtf(h1, w2, 8));
  TEST_INSTRUCTION("41E0031E", ucvtf(s1, w2, 8));
  TEST_INSTRUCTION("41E0431E", ucvtf(d1, w2, 8));
  TEST_INSTRUCTION("41E0C39E", ucvtf(h1, x2, 8));
  TEST_INSTRUCTION("41E0039E", ucvtf(s1, x2, 8));
  TEST_INSTRUCTION("41E0439E", ucvtf(d1, x2, 8));
  TEST_INSTRUCTION("41E4187F", ucvtf(h1, h2, 8));
  TEST_INSTRUCTION("41E4387F", ucvtf(s1, s2, 8));
  TEST_INSTRUCTION("41E4787F", ucvtf(d1, d2, 8));
  TEST_INSTRUCTION("41E4182F", ucvtf(v1.h4(), v2.h4(), 8));
  TEST_INSTRUCTION("41E4382F", ucvtf(v1.s2(), v2.s2(), 8));
  TEST_INSTRUCTION("41E4186F", ucvtf(v1.h8(), v2.h8(), 8));
  TEST_INSTRUCTION("41E4386F", ucvtf(v1.s4(), v2.s4(), 8));
  TEST_INSTRUCTION("41E4786F", ucvtf(v1.d2(), v2.d2(), 8));
  TEST_INSTRUCTION("4194832E", udot(v1.s2(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4194836E", udot(v1.s4(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("41E0832F", udot(v1.s2(), v2.b8(), v3.b4(0)));
  TEST_INSTRUCTION("41E0A32F", udot(v1.s2(), v2.b8(), v3.b4(1)));
  TEST_INSTRUCTION("41E8832F", udot(v1.s2(), v2.b8(), v3.b4(2)));
  TEST_INSTRUCTION("41E8A32F", udot(v1.s2(), v2.b8(), v3.b4(3)));
  TEST_INSTRUCTION("41E0836F", udot(v1.s4(), v2.b16(), v3.b4(0)));
  TEST_INSTRUCTION("41E0A36F", udot(v1.s4(), v2.b16(), v3.b4(1)));
  TEST_INSTRUCTION("41E8836F", udot(v1.s4(), v2.b16(), v3.b4(2)));
  TEST_INSTRUCTION("41E8A36F", udot(v1.s4(), v2.b16(), v3.b4(3)));
  TEST_INSTRUCTION("4104232E", uhadd(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4104632E", uhadd(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4104A32E", uhadd(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4104236E", uhadd(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4104636E", uhadd(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4104A36E", uhadd(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4124232E", uhsub(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4124632E", uhsub(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4124A32E", uhsub(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4124236E", uhsub(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4124636E", uhsub(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4124A36E", uhsub(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4164232E", umax(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4164632E", umax(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4164A32E", umax(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4164236E", umax(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4164636E", umax(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4164A36E", umax(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41A4232E", umaxp(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("41A4632E", umaxp(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41A4A32E", umaxp(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("41A4236E", umaxp(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("41A4636E", umaxp(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41A4A36E", umaxp(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41A8302E", umaxv(b1, v2.b8()));
  TEST_INSTRUCTION("41A8306E", umaxv(b1, v2.b16()));
  TEST_INSTRUCTION("41A8702E", umaxv(h1, v2.h4()));
  TEST_INSTRUCTION("41A8706E", umaxv(h1, v2.h8()));
  TEST_INSTRUCTION("41A8B06E", umaxv(s1, v2.s4()));
  TEST_INSTRUCTION("416C232E", umin(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("416C632E", umin(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("416CA32E", umin(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("416C236E", umin(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("416C636E", umin(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("416CA36E", umin(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41AC232E", uminp(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("41AC632E", uminp(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41ACA32E", uminp(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("41AC236E", uminp(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("41AC636E", uminp(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41ACA36E", uminp(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41A8312E", uminv(b1, v2.b8()));
  TEST_INSTRUCTION("41A8316E", uminv(b1, v2.b16()));
  TEST_INSTRUCTION("41A8712E", uminv(h1, v2.h4()));
  TEST_INSTRUCTION("41A8716E", uminv(h1, v2.h8()));
  TEST_INSTRUCTION("41A8B16E", uminv(s1, v2.s4()));
  TEST_INSTRUCTION("4180232E", umlal(v1.h8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4180632E", umlal(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4180A32E", umlal(v1.d2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4120732F", umlal(v1.s4(), v2.h4(), v3.h(3)));
  TEST_INSTRUCTION("4128A32F", umlal(v1.d2(), v2.s2(), v3.s(3)));
  TEST_INSTRUCTION("4180236E", umlal2(v1.h8(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4180636E", umlal2(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4180A36E", umlal2(v1.d2(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4120736F", umlal2(v1.s4(), v2.h8(), v3.h(3)));
  TEST_INSTRUCTION("4128A36F", umlal2(v1.d2(), v2.s4(), v3.s(3)));
  TEST_INSTRUCTION("41A0232E", umlsl(v1.h8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("41A0632E", umlsl(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41A0A32E", umlsl(v1.d2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4160732F", umlsl(v1.s4(), v2.h4(), v3.h(3)));
  TEST_INSTRUCTION("4168A32F", umlsl(v1.d2(), v2.s2(), v3.s(3)));
  TEST_INSTRUCTION("41A0236E", umlsl2(v1.h8(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("41A0636E", umlsl2(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41A0A36E", umlsl2(v1.d2(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4160736F", umlsl2(v1.s4(), v2.h8(), v3.h(3)));
  TEST_INSTRUCTION("4168A36F", umlsl2(v1.d2(), v2.s4(), v3.s(3)));
  TEST_INSTRUCTION("41A4836E", ummla(v1.s4(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("413C010E", umov(w1, v2.b(0)));
  TEST_INSTRUCTION("413C1F0E", umov(w1, v2.b(15)));
  TEST_INSTRUCTION("413C020E", umov(w1, v2.h(0)));
  TEST_INSTRUCTION("413C1E0E", umov(w1, v2.h(7)));
  TEST_INSTRUCTION("413C040E", umov(w1, v2.s(0)));
  TEST_INSTRUCTION("413C1C0E", umov(w1, v2.s(3)));
  TEST_INSTRUCTION("413C084E", umov(x1, v2.d(0)));
  TEST_INSTRUCTION("413C184E", umov(x1, v2.d(1)));
  TEST_INSTRUCTION("41C0232E", umull(v1.h8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("41C0632E", umull(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("41C0A32E", umull(v1.d2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("41A0732F", umull(v1.s4(), v2.h4(), v3.h(3)));
  TEST_INSTRUCTION("41A8A32F", umull(v1.d2(), v2.s2(), v3.s(3)));
  TEST_INSTRUCTION("41C0236E", umull2(v1.h8(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("41C0636E", umull2(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("41C0A36E", umull2(v1.d2(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("41A0736F", umull2(v1.s4(), v2.h8(), v3.h(3)));
  TEST_INSTRUCTION("41A8A36F", umull2(v1.d2(), v2.s4(), v3.s(3)));
  TEST_INSTRUCTION("410C237E", uqadd(b1, b2, b3));
  TEST_INSTRUCTION("410C637E", uqadd(h1, h2, h3));
  TEST_INSTRUCTION("410CA37E", uqadd(s1, s2, s3));
  TEST_INSTRUCTION("410CE37E", uqadd(d1, d2, d3));
  TEST_INSTRUCTION("410C232E", uqadd(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("410C632E", uqadd(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("410CA32E", uqadd(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("410C236E", uqadd(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("410C636E", uqadd(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("410CA36E", uqadd(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("410CE36E", uqadd(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("415C237E", uqrshl(b1, b2, b3));
  TEST_INSTRUCTION("415C637E", uqrshl(h1, h2, h3));
  TEST_INSTRUCTION("415CA37E", uqrshl(s1, s2, s3));
  TEST_INSTRUCTION("415C232E", uqrshl(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("415C632E", uqrshl(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("415CA32E", uqrshl(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("415CE37E", uqrshl(d1, d2, d3));
  TEST_INSTRUCTION("415C236E", uqrshl(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("415C636E", uqrshl(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("415CA36E", uqrshl(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("415CE36E", uqrshl(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("419C087F", uqrshrn(b1, h2, 8));
  TEST_INSTRUCTION("419C107F", uqrshrn(h1, s2, 16));
  TEST_INSTRUCTION("419C207F", uqrshrn(s1, d2, 32));
  TEST_INSTRUCTION("419C082F", uqrshrn(v1.b8(), v2.h8(), 8));
  TEST_INSTRUCTION("419C102F", uqrshrn(v1.h4(), v2.s4(), 16));
  TEST_INSTRUCTION("419C202F", uqrshrn(v1.s2(), v2.d2(), 32));
  TEST_INSTRUCTION("419C086F", uqrshrn2(v1.b16(), v2.h8(), 8));
  TEST_INSTRUCTION("419C106F", uqrshrn2(v1.h8(), v2.s4(), 16));
  TEST_INSTRUCTION("419C206F", uqrshrn2(v1.s4(), v2.d2(), 32));
  TEST_INSTRUCTION("4174097F", uqshl(b1, b2, 1));
  TEST_INSTRUCTION("4174127F", uqshl(h1, h2, 2));
  TEST_INSTRUCTION("4174237F", uqshl(s1, s2, 3));
  TEST_INSTRUCTION("41740F2F", uqshl(v1.b8(), v2.b8(), 7));
  TEST_INSTRUCTION("41741F2F", uqshl(v1.h4(), v2.h4(), 15));
  TEST_INSTRUCTION("41743F2F", uqshl(v1.s2(), v2.s2(), 31));
  TEST_INSTRUCTION("41747F7F", uqshl(d1, d2, 63));
  TEST_INSTRUCTION("41740F6F", uqshl(v1.b16(), v2.b16(), 7));
  TEST_INSTRUCTION("41741F6F", uqshl(v1.h8(), v2.h8(), 15));
  TEST_INSTRUCTION("41743F6F", uqshl(v1.s4(), v2.s4(), 31));
  TEST_INSTRUCTION("41747F6F", uqshl(v1.d2(), v2.d2(), 63));
  TEST_INSTRUCTION("414C237E", uqshl(b1, b2, b3));
  TEST_INSTRUCTION("414C637E", uqshl(h1, h2, h3));
  TEST_INSTRUCTION("414CA37E", uqshl(s1, s2, s3));
  TEST_INSTRUCTION("414C232E", uqshl(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("414C632E", uqshl(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("414CA32E", uqshl(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("414CE37E", uqshl(d1, d2, d3));
  TEST_INSTRUCTION("414C236E", uqshl(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("414C636E", uqshl(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("414CA36E", uqshl(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("414CE36E", uqshl(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4194087F", uqshrn(b1, h2, 8));
  TEST_INSTRUCTION("4194107F", uqshrn(h1, s2, 16));
  TEST_INSTRUCTION("4194207F", uqshrn(s1, d2, 32));
  TEST_INSTRUCTION("4194082F", uqshrn(v1.b8(), v2.h8(), 8));
  TEST_INSTRUCTION("4194102F", uqshrn(v1.h4(), v2.s4(), 16));
  TEST_INSTRUCTION("4194202F", uqshrn(v1.s2(), v2.d2(), 32));
  TEST_INSTRUCTION("4194086F", uqshrn2(v1.b16(), v2.h8(), 8));
  TEST_INSTRUCTION("4194106F", uqshrn2(v1.h8(), v2.s4(), 16));
  TEST_INSTRUCTION("4194206F", uqshrn2(v1.s4(), v2.d2(), 32));
  TEST_INSTRUCTION("412C237E", uqsub(b1, b2, b3));
  TEST_INSTRUCTION("412C637E", uqsub(h1, h2, h3));
  TEST_INSTRUCTION("412CA37E", uqsub(s1, s2, s3));
  TEST_INSTRUCTION("412CE37E", uqsub(d1, d2, d3));
  TEST_INSTRUCTION("412C232E", uqsub(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("412C632E", uqsub(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("412CA32E", uqsub(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("412C236E", uqsub(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("412C636E", uqsub(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("412CA36E", uqsub(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("412CE36E", uqsub(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4148217E", uqxtn(b1, h2));
  TEST_INSTRUCTION("4148617E", uqxtn(h1, s2));
  TEST_INSTRUCTION("4148A17E", uqxtn(s1, d2));
  TEST_INSTRUCTION("4148212E", uqxtn(v1.b8(), v2.h8()));
  TEST_INSTRUCTION("4148612E", uqxtn(v1.h4(), v2.s4()));
  TEST_INSTRUCTION("4148A12E", uqxtn(v1.s2(), v2.d2()));
  TEST_INSTRUCTION("4148216E", uqxtn2(v1.b16(), v2.h8()));
  TEST_INSTRUCTION("4148616E", uqxtn2(v1.h8(), v2.s4()));
  TEST_INSTRUCTION("4148A16E", uqxtn2(v1.s4(), v2.d2()));
  TEST_INSTRUCTION("41C8A10E", urecpe(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41C8A14E", urecpe(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("4114232E", urhadd(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4114632E", urhadd(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4114A32E", urhadd(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4114236E", urhadd(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4114636E", urhadd(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4114A36E", urhadd(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4154232E", urshl(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4154632E", urshl(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4154A32E", urshl(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4154E37E", urshl(d1, d2, d3));
  TEST_INSTRUCTION("4154236E", urshl(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4154636E", urshl(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4154A36E", urshl(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4154E36E", urshl(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4124092F", urshr(v1.b8(), v2.b8(), 7));
  TEST_INSTRUCTION("4124112F", urshr(v1.h4(), v2.h4(), 15));
  TEST_INSTRUCTION("4124212F", urshr(v1.s2(), v2.s2(), 31));
  TEST_INSTRUCTION("4124417F", urshr(d1, d2, 63));
  TEST_INSTRUCTION("4124096F", urshr(v1.b16(), v2.b16(), 7));
  TEST_INSTRUCTION("4124116F", urshr(v1.h8(), v2.h8(), 15));
  TEST_INSTRUCTION("4124216F", urshr(v1.s4(), v2.s4(), 31));
  TEST_INSTRUCTION("4124416F", urshr(v1.d2(), v2.d2(), 63));
  TEST_INSTRUCTION("41C8A12E", ursqrte(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("41C8A16E", ursqrte(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("4134092F", ursra(v1.b8(), v2.b8(), 7));
  TEST_INSTRUCTION("4134112F", ursra(v1.h4(), v2.h4(), 15));
  TEST_INSTRUCTION("4134212F", ursra(v1.s2(), v2.s2(), 31));
  TEST_INSTRUCTION("4134417F", ursra(d1, d2, 63));
  TEST_INSTRUCTION("4134096F", ursra(v1.b16(), v2.b16(), 7));
  TEST_INSTRUCTION("4134116F", ursra(v1.h8(), v2.h8(), 15));
  TEST_INSTRUCTION("4134216F", ursra(v1.s4(), v2.s4(), 31));
  TEST_INSTRUCTION("4134416F", ursra(v1.d2(), v2.d2(), 63));
  TEST_INSTRUCTION("419C830E", usdot(v1.s2(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("419C834E", usdot(v1.s4(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("41F0830F", usdot(v1.s2(), v2.b8(), v3.b4(0)));
  TEST_INSTRUCTION("41F0A30F", usdot(v1.s2(), v2.b8(), v3.b4(1)));
  TEST_INSTRUCTION("41F8830F", usdot(v1.s2(), v2.b8(), v3.b4(2)));
  TEST_INSTRUCTION("41F8A30F", usdot(v1.s2(), v2.b8(), v3.b4(3)));
  TEST_INSTRUCTION("41F0834F", usdot(v1.s4(), v2.b16(), v3.b4(0)));
  TEST_INSTRUCTION("41F0A34F", usdot(v1.s4(), v2.b16(), v3.b4(1)));
  TEST_INSTRUCTION("41F8834F", usdot(v1.s4(), v2.b16(), v3.b4(2)));
  TEST_INSTRUCTION("41F8A34F", usdot(v1.s4(), v2.b16(), v3.b4(3)));
  TEST_INSTRUCTION("4144232E", ushl(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4144632E", ushl(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4144A32E", ushl(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4144E37E", ushl(d1, d2, d3));
  TEST_INSTRUCTION("4144236E", ushl(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4144636E", ushl(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4144A36E", ushl(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4144E36E", ushl(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("41A40F2F", ushll(v1.h8(), v2.b8(), 7));
  TEST_INSTRUCTION("41A41F2F", ushll(v1.s4(), v2.h4(), 15));
  TEST_INSTRUCTION("41A43F2F", ushll(v1.d2(), v2.s2(), 31));
  TEST_INSTRUCTION("41A40F6F", ushll2(v1.h8(), v2.b16(), 7));
  TEST_INSTRUCTION("41A41F6F", ushll2(v1.s4(), v2.h8(), 15));
  TEST_INSTRUCTION("41A43F6F", ushll2(v1.s2(), v2.s4(), 31));
  TEST_INSTRUCTION("4104092F", ushr(v1.b8(), v2.b8(), 7));
  TEST_INSTRUCTION("4104112F", ushr(v1.h4(), v2.h4(), 15));
  TEST_INSTRUCTION("4104212F", ushr(v1.s2(), v2.s2(), 31));
  TEST_INSTRUCTION("4104417F", ushr(d1, d2, 63));
  TEST_INSTRUCTION("4104096F", ushr(v1.b16(), v2.b16(), 7));
  TEST_INSTRUCTION("4104116F", ushr(v1.h8(), v2.h8(), 15));
  TEST_INSTRUCTION("4104216F", ushr(v1.s4(), v2.s4(), 31));
  TEST_INSTRUCTION("4104416F", ushr(v1.d2(), v2.d2(), 63));
  TEST_INSTRUCTION("41AC834E", usmmla(v1.s4(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4138207E", usqadd(b1, b2));
  TEST_INSTRUCTION("4138607E", usqadd(h1, h2));
  TEST_INSTRUCTION("4138A07E", usqadd(s1, s2));
  TEST_INSTRUCTION("4138E07E", usqadd(d1, d2));
  TEST_INSTRUCTION("4138202E", usqadd(v1.b8(), v2.b8()));
  TEST_INSTRUCTION("4138602E", usqadd(v1.h4(), v2.h4()));
  TEST_INSTRUCTION("4138A02E", usqadd(v1.s2(), v2.s2()));
  TEST_INSTRUCTION("4138206E", usqadd(v1.b16(), v2.b16()));
  TEST_INSTRUCTION("4138606E", usqadd(v1.h8(), v2.h8()));
  TEST_INSTRUCTION("4138A06E", usqadd(v1.s4(), v2.s4()));
  TEST_INSTRUCTION("4138E06E", usqadd(v1.d2(), v2.d2()));
  TEST_INSTRUCTION("4114092F", usra(v1.b8(), v2.b8(), 7));
  TEST_INSTRUCTION("4114112F", usra(v1.h4(), v2.h4(), 15));
  TEST_INSTRUCTION("4114212F", usra(v1.s2(), v2.s2(), 31));
  TEST_INSTRUCTION("4114417F", usra(d1, d2, 63));
  TEST_INSTRUCTION("4114096F", usra(v1.b16(), v2.b16(), 7));
  TEST_INSTRUCTION("4114116F", usra(v1.h8(), v2.h8(), 15));
  TEST_INSTRUCTION("4114216F", usra(v1.s4(), v2.s4(), 31));
  TEST_INSTRUCTION("4114416F", usra(v1.d2(), v2.d2(), 63));
  TEST_INSTRUCTION("4120232E", usubl(v1.h8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4120632E", usubl(v1.s4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4120A32E", usubl(v1.d2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4120236E", usubl2(v1.h8(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4120636E", usubl2(v1.s4(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4120A36E", usubl2(v1.d2(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4130232E", usubw(v1.h8(), v2.h8(), v3.b8()));
  TEST_INSTRUCTION("4130632E", usubw(v1.s4(), v2.s4(), v3.h4()));
  TEST_INSTRUCTION("4130A32E", usubw(v1.d2(), v2.d2(), v3.s2()));
  TEST_INSTRUCTION("4130236E", usubw2(v1.h8(), v2.h8(), v3.b16()));
  TEST_INSTRUCTION("4130636E", usubw2(v1.s4(), v2.s4(), v3.h8()));
  TEST_INSTRUCTION("4130A36E", usubw2(v1.d2(), v2.d2(), v3.s4()));
  TEST_INSTRUCTION("41A4082F", uxtl(v1.h8(), v2.b8()));
  TEST_INSTRUCTION("41A4102F", uxtl(v1.s4(), v2.h4()));
  TEST_INSTRUCTION("41A4202F", uxtl(v1.d2(), v2.s2()));
  TEST_INSTRUCTION("41A4086F", uxtl2(v1.h8(), v2.b16()));
  TEST_INSTRUCTION("41A4106F", uxtl2(v1.s4(), v2.h8()));
  TEST_INSTRUCTION("41A4206F", uxtl2(v1.d2(), v2.s4()));
  TEST_INSTRUCTION("4118030E", uzp1(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4118430E", uzp1(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4118830E", uzp1(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4118034E", uzp1(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4118434E", uzp1(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4118834E", uzp1(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4118C34E", uzp1(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4158030E", uzp2(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4158430E", uzp2(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4158830E", uzp2(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4158034E", uzp2(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4158434E", uzp2(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4158834E", uzp2(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4158C34E", uzp2(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4128210E", xtn(v1.b8(), v2.h8()));
  TEST_INSTRUCTION("4128610E", xtn(v1.h4(), v2.s4()));
  TEST_INSTRUCTION("4128A10E", xtn(v1.s2(), v2.d2()));
  TEST_INSTRUCTION("4128214E", xtn2(v1.b16(), v2.h8()));
  TEST_INSTRUCTION("4128614E", xtn2(v1.h8(), v2.s4()));
  TEST_INSTRUCTION("4128A14E", xtn2(v1.s4(), v2.d2()));
  TEST_INSTRUCTION("4138030E", zip1(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4138430E", zip1(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4138830E", zip1(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4138034E", zip1(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4138434E", zip1(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4138834E", zip1(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4138C34E", zip1(v1.d2(), v2.d2(), v3.d2()));
  TEST_INSTRUCTION("4178030E", zip2(v1.b8(), v2.b8(), v3.b8()));
  TEST_INSTRUCTION("4178430E", zip2(v1.h4(), v2.h4(), v3.h4()));
  TEST_INSTRUCTION("4178830E", zip2(v1.s2(), v2.s2(), v3.s2()));
  TEST_INSTRUCTION("4178034E", zip2(v1.b16(), v2.b16(), v3.b16()));
  TEST_INSTRUCTION("4178434E", zip2(v1.h8(), v2.h8(), v3.h8()));
  TEST_INSTRUCTION("4178834E", zip2(v1.s4(), v2.s4(), v3.s4()));
  TEST_INSTRUCTION("4178C34E", zip2(v1.d2(), v2.d2(), v3.d2()));
}

static void ASMJIT_NOINLINE testA64AssemblerExtras(AssemblerTester<a64::Assembler>& tester) noexcept {
  using namespace a64;

  // AsmJit additions - AArch64 assembler accepts variety of immediates in
  // MOVI instruction that it encodes by changing the size of its operands.
  TEST_INSTRUCTION("C1E7074F", movi(v1.b16(), 0xFE));
  TEST_INSTRUCTION("C1E7074F", movi(v1.h8(), 0xFEFE));
  TEST_INSTRUCTION("C1E7074F", movi(v1.s4(), 0xFEFEFEFE));
  TEST_INSTRUCTION("C1E7074F", movi(v1.d2(), 0xFEFEFEFEFEFEFEFE));
  TEST_INSTRUCTION("C1A7074F", movi(v1.h8(), 0xFE, lsl(8)));
  TEST_INSTRUCTION("C1A7074F", movi(v1.h8(), 0xFE00));
  TEST_INSTRUCTION("C1A7074F", movi(v1.s4(), 0xFE00FE00));
  TEST_INSTRUCTION("C1A7074F", movi(v1.d2(), 0xFE00FE00FE00FE00));
  TEST_INSTRUCTION("C147074F", movi(v1.s4(), 0xFE, lsl(16)));
  TEST_INSTRUCTION("C147074F", movi(v1.s4(), 0x00FE0000));
  TEST_INSTRUCTION("C147074F", movi(v1.d2(), 0x00FE000000FE0000));
  TEST_INSTRUCTION("C167074F", movi(v1.s4(), 0xFE, lsl(24)));
  TEST_INSTRUCTION("C167074F", movi(v1.s4(), 0xFE000000));
  TEST_INSTRUCTION("C167074F", movi(v1.d2(), 0xFE000000FE000000));
}

bool testA64Assembler(const TestSettings& settings) noexcept {
  using namespace a64;

  AssemblerTester<Assembler> tester(Arch::kAArch64, settings);
  tester.printHeader("AArch64");

  testA64AssemblerBase(tester);
  testA64AssemblerRel(tester);
  testA64AssemblerSIMD(tester);
  testA64AssemblerExtras(tester);

  tester.printSummary();
  return tester.didPass();
}

#undef TEST_INSTRUCTION

#endif // !ASMJIT_NO_AARCH64
