/*
 * libsysactivity
 * http://sourceforge.net/projects/libsysactivity/
 * Copyright (c) 2010-2011 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdio.h>
#include <unistd.h>
#include <pthread.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <inttypes.h>
#include <errno.h>
#include <sys/time.h>

int main() {
	int ret;
#ifdef SA_OPEN_PROCESS
	ret = sa_open_process();
	if (ret != 0) {
		printf("%s:%d ERROR: sa_open_process(): %s\n", __FILE__, __LINE__, strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif

	uint32_t number;
	ret = sa_count_processes(&number);
	if (ret != 0) {
		printf("%s:%d ERROR: sa_count_processes(): %s\n", __FILE__, __LINE__, strerror(ret));
		exit(EXIT_FAILURE);
	}
	size_t pids_size = number * 2;
	pid_t* pids = malloc(pids_size * sizeof(pid_t));

	int i;
	struct sa_process proc;
	struct sa_process_activity proc_activity;
	uint32_t written;

	for (i = 0; i < 22000; ++i) {
		ret = sa_count_processes(&number);
		if (ret != 0) {
			printf("%s:%d ERROR: sa_count_processes(): %s\n", __FILE__, __LINE__, strerror(ret));
			exit(EXIT_FAILURE);
		}

		ret = sa_get_processes_ids(pids, pids_size, &written);
		if (ret != 0) {
			printf("%s:%d ERROR: sa_get_processes_ids(): %s\n", __FILE__, __LINE__, strerror(ret));
			exit(EXIT_FAILURE);
		}

		ret = sa_get_process_activity(pids[2], &proc_activity);
		if (ret != 0) {
			printf("%s:%d ERROR: sa_get_process_activity(): %s\n", __FILE__, __LINE__, strerror(ret));
			exit(EXIT_FAILURE);
		}

		ret = sa_get_process(pids[3], &proc);
		if (ret != 0) {
			printf("%s:%d ERROR: sa_get_process(): %s\n", __FILE__, __LINE__, strerror(ret));
			exit(EXIT_FAILURE);
		}
	}
	free(pids);

#ifdef SA_CLOSE_PROCESS
	ret = sa_close_process();
	if (ret != 0) {
		printf("%s:%d ERROR: sa_close_process(): %s\n", __FILE__, __LINE__, strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif
	return EXIT_SUCCESS;
}
