package Locales::DB::Language::mr;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::mr::VERSION = '0.09';

$Locales::DB::Language::mr::cldr_version = '2.0';

%Locales::DB::Language::mr::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Language\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ आणि\ \{1\}",
            'end'    => "\{0\}\ आणि\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => "\"",
        'alternate_quotation_start' => "\"",
        'quotation_end'             => "\'",
        'quotation_start'           => "\'"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => 'नाहीःना',
        'yesstr' => 'होयःहो'
    },
);

%Locales::DB::Language::mr::code_to_name = (
    'aa'     => 'अफार',
    'ab'     => 'अबखेजियन',
    'ace'    => 'अचीनी',
    'ach'    => 'अकोली',
    'ada'    => 'अडांग्मे',
    'ady'    => 'अडिघे',
    'ae'     => 'अवेस्तन',
    'af'     => 'अफ्रिकान्स',
    'afa'    => "अफ्रो\-अशियाई\ भाषा",
    'afh'    => 'अफ्रिहिली',
    'agq'    => 'Aghem',
    'ain'    => 'ऐनू',
    'ak'     => 'अकन',
    'akk'    => 'अक्कादिआन',
    'ale'    => 'अलेउत',
    'alg'    => "अ‍ॅल्गोक्वियन\ भाषा",
    'alt'    => "दक्षिणात्य\ अल्ताई",
    'am'     => 'अम्हारिक',
    'an'     => 'अर्गोनीज',
    'ang'    => "पुरातन\ इंग्रजी",
    'anp'    => 'अंगिका',
    'apa'    => "अपाचे\ भाषा",
    'ar'     => 'अरबी',
    'arc'    => 'अ‍ॅरेमाइक',
    'arn'    => 'अ‍ॅरॉकॅनियन',
    'arp'    => 'अराफाओ',
    'art'    => "कृत्रिम\ भाषा",
    'arw'    => 'अरावक',
    'as'     => 'आसामी',
    'asa'    => 'Asu',
    'ast'    => 'अस्तुरियन',
    'ath'    => "अ‍ॅथापास्कान\ भाषा",
    'aus'    => "ऑस्ट्रेलियन\ भाषा",
    'av'     => 'अ‍ॅव्हेरिक',
    'awa'    => 'अवधी',
    'ay'     => 'ऐमरा',
    'az'     => 'अझेरी',
    'ba'     => 'बष्किर',
    'bad'    => 'बांदा',
    'bai'    => "बमिलेके\ भाषा",
    'bal'    => 'बलुची',
    'ban'    => 'बालिनीस',
    'bas'    => 'बसा',
    'bat'    => "बाल्टिक\ भाषा",
    'be'     => 'बेलारुशियन',
    'bej'    => 'बेजा',
    'bem'    => 'बेम्बा',
    'ber'    => 'बर्बर',
    'bez'    => 'Bena',
    'bg'     => 'बल्गेरियन',
    'bh'     => 'बिहारी',
    'bho'    => 'भोजपुरी',
    'bi'     => 'बिस्लामा',
    'bik'    => 'बिकोल',
    'bin'    => 'बिनी',
    'bla'    => 'सिक्सिका',
    'bm'     => 'बाम्बारा',
    'bn'     => 'बंगाली',
    'bnt'    => 'बन्टु',
    'bo'     => 'तिबेटी',
    'br'     => 'ब्रेटन',
    'bra'    => 'ब्रज',
    'brx'    => 'Bodo',
    'bs'     => 'बोस्नियन',
    'btk'    => 'बटाक',
    'bua'    => 'बुरियात',
    'bug'    => 'बगिनीस',
    'byn'    => 'ब्लिन',
    'ca'     => 'कॅटलान',
    'cad'    => 'कॅड्डो',
    'cai'    => "मध्य\ अमेरिकी\ इंडियन\ भाषा",
    'car'    => 'कॅरिब',
    'cau'    => "कॉकेशियन\ भाषा",
    'cay'    => 'Cayuga',
    'cch'    => 'अत्सम',
    'ce'     => 'चेचन',
    'ceb'    => 'सिबुआनो',
    'cel'    => "केल्टिक\ भाषा",
    'cgg'    => 'Chiga',
    'ch'     => 'कॅमोरो',
    'chb'    => 'चिब्चा',
    'chg'    => 'छगाताई',
    'chk'    => 'चूकीसे',
    'chm'    => 'मारी',
    'chn'    => "चिनूक\ जारगॉन",
    'cho'    => 'चोक्तौ',
    'chp'    => 'शिपेव्यान',
    'chr'    => 'चेरूकी',
    'chy'    => 'शेयेन्न',
    'cmc'    => "चामिक\ भाषा",
    'co'     => 'कोर्सिकन',
    'cop'    => 'कॉप्टिक',
    'cpe'    => "इंग्रजी\-आधारित\ क्रेओल\ वा\ पिजिन",
    'cpf'    => "फ्रेंच\-आधारित\ क्रेओल\ वा\ पिजिन",
    'cpp'    => "पोर्तुगीज\-आधारित\ क्रेओल\ या\ पिजिन",
    'cr'     => 'क्री',
    'crh'    => "क्राइमीन\ तुर्की",
    'crp'    => "क्रेओल\ वा\ पिजिन",
    'cs'     => 'झेक',
    'csb'    => 'काशुबियन',
    'cu'     => "चर्च\ स्लाव्हिक",
    'cus'    => "कुशितिक\ भाषा",
    'cv'     => 'चूवाश',
    'cy'     => 'वेल्श',
    'da'     => 'डॅनिश',
    'dak'    => 'दाकोता',
    'dar'    => 'दार्गवा',
    'dav'    => 'Taita',
    'day'    => 'दायक',
    'de'     => 'जर्मन',
    'de_at'  => "ऑस्ट्रियन\ जर्मन",
    'de_ch'  => "स्विस\ हाय\ जर्मन",
    'del'    => 'डेलॅवेयर',
    'den'    => 'स्लाव्ह',
    'dgr'    => 'डोग्रिब',
    'din'    => 'दिन्का',
    'dje'    => 'Zarma',
    'doi'    => 'डोगरी',
    'dra'    => "द्रविडी\ भाषा",
    'dsb'    => "निम्न\ सोर्बियन",
    'dua'    => 'दुआला',
    'dum'    => "मिडल\ डच",
    'dv'     => 'दिवेही',
    'dyo'    => "Jola\-Fonyi",
    'dyu'    => 'ड्युला',
    'dz'     => 'झोंगखा',
    'ebu'    => 'Embu',
    'ee'     => 'इवे',
    'efi'    => 'एफिक',
    'egy'    => "प्राचीन\ इजिप्शियन",
    'eka'    => 'एकाजुक',
    'el'     => 'ग्रीक',
    'elx'    => 'एलामाइट',
    'en'     => 'इंग्रजी',
    'en_au'  => "ऑस्ट्रेलियन\ इंग्रजी",
    'en_ca'  => "कॅनेडियन\ इंग्रजी",
    'en_gb'  => "इंग्रजी\ \(यूके\)",
    'en_us'  => "यू\.\ एस\.\ इंग्रजी",
    'enm'    => "मिडल\ इंग्रजी",
    'eo'     => 'एस्परान्टो',
    'es'     => 'स्पॅनिश',
    'es_419' => "लॅटिन\ अमेरिकन\ स्पॅनिश",
    'es_es'  => "इबेरियन\ स्पॅनिश",
    'et'     => 'इस्टोनियन',
    'eu'     => 'बास्क',
    'ewo'    => 'इवोन्डो',
    'fa'     => 'फारसी',
    'fan'    => 'फँग',
    'fat'    => 'फन्टी',
    'ff'     => 'फुलाह',
    'fi'     => 'फिन्निश',
    'fil'    => 'फिलिपिनो',
    'fiu'    => "फिन्नो\-उग्रीयन\ भाषा",
    'fj'     => 'फिजीयन',
    'fo'     => 'फरोइए',
    'fon'    => 'फॉन',
    'fr'     => 'फ्रेंच',
    'fr_ca'  => "कॅनेडियन\ फ्रेंच",
    'fr_ch'  => "स्विस\ फ्रेंच",
    'frm'    => "मिडल\ फ्रेंच",
    'fro'    => "पुरातन\ फ्रेंच",
    'frr'    => "उत्तरी\ फ्रिशियन",
    'frs'    => "पौर्वात्य\ फ्रिशियन",
    'fur'    => 'फ्रियुलियान',
    'fy'     => "पाश्चात्य\ फ्रिशियन",
    'ga'     => 'आयरिश',
    'gaa'    => 'गा',
    'gay'    => 'गायो',
    'gba'    => 'बाया',
    'gd'     => "स्कॉट्स\ गेलिक",
    'gem'    => "जर्मनिक\ भाषा",
    'gez'    => 'गीझ',
    'gil'    => 'जिल्बरटीज',
    'gl'     => 'गॅलिशियन',
    'gmh'    => "मिडल\ हाय\ जर्मन",
    'gn'     => 'गुआरनी',
    'goh'    => "पुरातन\ हाइ\ जर्मन",
    'gon'    => 'गाँडी',
    'gor'    => 'गोरोन्तालो',
    'got'    => 'गॉथिक',
    'grb'    => 'ग्रेबो',
    'grc'    => "प्राचीन\ ग्रीक",
    'gsw'    => "स्विस\ जर्मन",
    'gu'     => 'गुजराती',
    'guz'    => 'Gusii',
    'gv'     => 'मांक्स',
    'gwi'    => "ग्विच\'इन",
    'ha'     => 'हौसा',
    'hai'    => 'हैडा',
    'haw'    => 'हवाईयन',
    'he'     => 'हिब्रू',
    'hi'     => 'हिंदी',
    'hil'    => 'हिलीगेनॉन',
    'him'    => 'हिमाचली',
    'hit'    => 'हिट्टिते',
    'hmn'    => 'माँग',
    'ho'     => "हिरी\ मॉटू",
    'hr'     => 'क्रोएशियन',
    'hsb'    => "अप्पर\ सॉर्बियन",
    'ht'     => 'हैतीयन',
    'hu'     => 'हंगेरियन',
    'hup'    => 'हूपा',
    'hy'     => 'आर्मेनियन',
    'hz'     => 'हरेरो',
    'ia'     => 'इन्टरलिंग्वा',
    'iba'    => 'इबान',
    'id'     => 'इंडोनेशियन',
    'ie'     => 'इन्टरलिंग',
    'ig'     => 'ईग्बो',
    'ii'     => "सिचुआन\ यी",
    'ijo'    => 'इजो',
    'ik'     => 'इनूपियाक',
    'ilo'    => 'इलोको',
    'inc'    => "भारतीय\ भाषा",
    'ine'    => "इंडो\-युरोपीयन\ भाषा",
    'inh'    => 'इंगुश',
    'io'     => 'इडौ',
    'ira'    => "ईराणी\ भाषा",
    'iro'    => "इरोक्वोइयन\ भाषा",
    'is'     => 'आईसलँडिक',
    'it'     => 'इटालियन',
    'iu'     => 'इनुकिटुट्',
    'ja'     => 'जपानी',
    'jbo'    => 'लोज्बान',
    'jmc'    => 'Machame',
    'jpr'    => "जुदेओ\-फारसी",
    'jrb'    => "जुदेओ\-अरबी",
    'jv'     => 'जावनीस्',
    'ka'     => 'जॉर्जियन',
    'kaa'    => "कारा\-कल्पक",
    'kab'    => 'कबाइल',
    'kac'    => 'काचिन',
    'kaj'    => 'ज्जु',
    'kam'    => 'कम्बा',
    'kar'    => 'कारेन',
    'kaw'    => 'कावी',
    'kbd'    => 'कबार्डियन',
    'kcg'    => 'त्याप',
    'kde'    => 'Makonde',
    'kea'    => 'Kabuverdianu',
    'kfo'    => 'कोरो',
    'kg'     => 'काँगो',
    'kha'    => 'खासी',
    'khi'    => "खोसियन\ भाषा",
    'kho'    => 'खोतानीस',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'किकुयू',
    'kj'     => 'क्वान्यामा',
    'kk'     => 'कझाक',
    'kl'     => 'कलाल्लिसुत',
    'kln'    => 'Kalenjin',
    'km'     => 'ख्मेर',
    'kmb'    => 'किम्बन्दु',
    'kn'     => 'कन्नड',
    'ko'     => 'कोरियन',
    'kok'    => 'कोंकणी',
    'kos'    => 'कोसरियन',
    'kpe'    => 'क्पेल्ले',
    'kr'     => 'कनुरी',
    'krc'    => "कराचय\-बाल्कर",
    'krl'    => 'करेलियन',
    'kro'    => 'क्रू',
    'kru'    => 'कुरूख',
    'ks'     => 'काश्मीरी',
    'ksb'    => 'Shambala',
    'ksf'    => 'Bafia',
    'ksh'    => 'Colognian',
    'ku'     => 'कुर्दिश',
    'kum'    => 'कुमीक',
    'kut'    => 'कुतेनाई',
    'kv'     => 'कोमी',
    'kw'     => 'कोर्निश',
    'ky'     => 'किरगीझ',
    'la'     => 'लॅटिन',
    'lad'    => 'लादीनो',
    'lag'    => 'Langi',
    'lah'    => 'लाह्न्डा',
    'lam'    => 'लाम्बा',
    'lb'     => 'लक्झेंबर्गिश',
    'lez'    => 'लेझ्घीयन',
    'lg'     => 'गांडा',
    'li'     => 'लिंबूर्गिश',
    'ln'     => 'लिंगाला',
    'lo'     => 'लाओ',
    'lol'    => 'मोंगो',
    'loz'    => 'लोझी',
    'lt'     => 'लिथुआनियन',
    'lu'     => "ल्यूबा\-कटांगा",
    'lua'    => "लूबा\-लुलुआ",
    'lui'    => 'लुइसेनो',
    'lun'    => 'लुन्डा',
    'luo'    => 'ल्युओ',
    'lus'    => 'लुशाई',
    'luy'    => 'Luyia',
    'lv'     => 'लाट्‌वियन',
    'mad'    => 'मादुरीस',
    'mag'    => 'मगही',
    'mai'    => 'मैथिली',
    'mak'    => 'मकस्सर',
    'man'    => 'मन्डिन्गो',
    'map'    => 'ऑस्ट्रोनेशियन',
    'mas'    => 'मसाई',
    'mdf'    => 'मोक्ष',
    'mdr'    => 'मंडार',
    'men'    => 'मेन्डे',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'मलागसी',
    'mga'    => "मिडल\ आयरिश",
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'मार्शलीज',
    'mi'     => 'माओरी',
    'mic'    => 'मिकमॅक',
    'min'    => 'मिनांग्काबाउ',
    'mis'    => "विविध\ भाषा",
    'mk'     => 'मॅसेडोनियन',
    'mkh'    => "मॉन\-ख्मेर\ भाषा",
    'ml'     => 'मल्याळम',
    'mn'     => 'मंगोलियन',
    'mnc'    => 'मान्चु',
    'mni'    => 'मणिपुरी',
    'mno'    => "मनोबो\ भाषा",
    'mo'     => 'मोल्डाव्हियन',
    'moh'    => 'मोहॉक',
    'mos'    => 'मोस्सी',
    'mr'     => 'मराठी',
    'ms'     => 'मलय',
    'mt'     => 'माल्टिज्',
    'mua'    => 'Mundang',
    'mul'    => "एकविध\ भाषा",
    'mun'    => "मुन्डा\ भाषा",
    'mus'    => 'क्रीक',
    'mwl'    => 'मिरांडिज्',
    'mwr'    => 'मारवाडी',
    'my'     => 'बर्मी',
    'myn'    => "माया\ भाषा",
    'myv'    => 'एर्झ्या',
    'na'     => 'नउरू',
    'nah'    => 'नहुआत्ल',
    'nai'    => "उत्तरी\ अमेरीकी\ इंडियन\ भाषा",
    'nap'    => 'नेपोलिटान',
    'naq'    => 'Nama',
    'nb'     => "नॉर्वेजियन\ बोकमाल",
    'nd'     => "उत्तरी\ देबेली",
    'nds'    => "लो\ जर्मन",
    'ne'     => 'नेपाळी',
    'new'    => 'नेवारी',
    'ng'     => 'डोंगा',
    'nia'    => 'नियास',
    'nic'    => "नाइजर\-कॉर्डोफॅनियन\ भाषा",
    'niu'    => 'नियुआन',
    'nl'     => 'डच',
    'nl_be'  => 'फ्लेमिश',
    'nmg'    => 'Kwasio',
    'nn'     => "नॉर्वेजियन\ न्योर्स्क",
    'no'     => 'नोर्वेजियन',
    'nog'    => 'नोगाई',
    'non'    => "पुरातन\ नॉर्स",
    'nqo'    => 'एन्को',
    'nr'     => "दक्षिणात्य\ देबेली",
    'nso'    => "उत्तरी\ सोथो",
    'nub'    => "न्युबियान\ भाषा",
    'nus'    => 'Nuer',
    'nv'     => 'नावाजो',
    'nwc'    => "अभिजात\ नेवारी",
    'ny'     => 'न्यान्जा',
    'nym'    => 'न्यामवेझी',
    'nyn'    => 'न्यानकोल',
    'nyo'    => 'न्योरो',
    'nzi'    => 'न्झिमा',
    'oc'     => 'ऑक्सिटान',
    'oj'     => 'ओजिब्वा',
    'om'     => 'ओरोमो',
    'or'     => 'उडिया',
    'os'     => 'ओस्सेटिक',
    'osa'    => 'ओसेज',
    'ota'    => "ओटोमान\ तुर्किश",
    'oto'    => "ओटोमियन\ भाषा",
    'pa'     => 'पंजाबी',
    'paa'    => "पापुन\ भाषा",
    'pag'    => 'पंगासीनान',
    'pal'    => 'पहलवी',
    'pam'    => 'पाम्पान्गा',
    'pap'    => 'पापियामेन्टो',
    'pau'    => 'पालाउआन',
    'peo'    => "पुरातन\ फारसी",
    'phi'    => "फिलिपीनी\ भाषा",
    'phn'    => 'फोनिशियन',
    'pi'     => 'पाली',
    'pl'     => 'पोलिश',
    'pon'    => 'पोह्नपियन',
    'pra'    => "प्राकृत\ भाषा",
    'pro'    => "पुरातन\ प्रोव्हेन्सल",
    'ps'     => 'पुश्तो',
    'pt'     => 'पोर्तुगीज',
    'pt_br'  => "ब्राझिलियन\ पोर्तुगीज",
    'pt_pt'  => "इबेरियन\ पोर्तुगीज",
    'qu'     => 'क्वेचुआ',
    'raj'    => 'राजस्थानी',
    'rap'    => 'रापानुई',
    'rar'    => 'रारोटोंगन',
    'rm'     => "र्‍हाएटो\-रोमांस",
    'rn'     => 'रुन्दी',
    'ro'     => 'रोमानियन',
    'roa'    => "रोमांस\ भाषा",
    'rof'    => 'Rombo',
    'rom'    => 'रोमानी',
    'ru'     => 'रशियन',
    'rup'    => 'अरोमानियन',
    'rw'     => 'किन्यार्वान्डा',
    'rwk'    => 'Rwa',
    'sa'     => 'संस्कृत',
    'sad'    => 'सँडवे',
    'sah'    => 'याकूत',
    'sai'    => "दक्षिण\ अमेरीकी\ इंडियन\ भाषा",
    'sal'    => "सलीशन\ भाषा",
    'sam'    => "सामरिटान\ अरॅमिक",
    'saq'    => 'Samburu',
    'sas'    => 'सासाक',
    'sat'    => 'संताली',
    'sbp'    => 'Sangu',
    'sc'     => 'सर्दिनियन',
    'scn'    => 'सिसिलियन',
    'sco'    => 'स्कॉट्स',
    'sd'     => 'सिंधी',
    'se'     => "नॉर्दन\ सामी",
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'सेल्कप',
    'sem'    => "सेमिटिक\ भाषा",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'सांगो',
    'sga'    => "पुरातन\ आयरिश",
    'sgn'    => "सांकेतिक\ भाषा",
    'sh'     => "सर्बो\-क्रोएशियन",
    'shi'    => 'Tachelhit',
    'shn'    => 'शॅन',
    'si'     => 'सिंहली',
    'sid'    => 'सिदामो',
    'sio'    => "सिउआन\ भाषा",
    'sit'    => "चीनी\-तिबेटी\ भाषा",
    'sk'     => 'स्लोव्हाक',
    'sl'     => 'स्लोव्हेनियन',
    'sla'    => "स्लाव्हिक\ भाषा",
    'sm'     => 'सामोअन',
    'sma'    => "दक्षिणात्य\ सामी",
    'smi'    => "सामी\ भाषा",
    'smj'    => "ल्युल\ सामी",
    'smn'    => "इनारी\ सामी",
    'sms'    => "स्कोल्ट\ सामी",
    'sn'     => 'शोना',
    'snk'    => 'सोनिन्के',
    'so'     => 'सोमाली',
    'sog'    => 'सोग्डिएन',
    'son'    => 'सोन्घाई',
    'sq'     => 'अल्बानियन',
    'sr'     => 'सर्बियन',
    'srn'    => "स्रानान\ टॉन्गो",
    'srr'    => 'सेरेर',
    'ss'     => 'स्वाती',
    'ssa'    => "निलो\-सहारन\ भाषा",
    'ssy'    => 'Saho',
    'st'     => 'सेसोथो',
    'su'     => 'सुंदानीज',
    'suk'    => 'सुकुमा',
    'sus'    => 'सुसु',
    'sux'    => 'सुमेरियन',
    'sv'     => 'स्वीडिश',
    'sw'     => 'स्वाहिली',
    'swb'    => 'कोमोरियन',
    'swc'    => "Congo\ Swahili",
    'syc'    => "अभिजात\ सिरियाक",
    'syr'    => 'सिरियाक',
    'ta'     => 'तमिळ',
    'tai'    => "ताई\ भाषा",
    'te'     => 'तेलगू',
    'tem'    => 'टिम्ने',
    'teo'    => 'Teso',
    'ter'    => 'तेरेनो',
    'tet'    => 'तेतुम',
    'tg'     => 'ताजिक',
    'th'     => 'थाई',
    'ti'     => 'टिग्रिन्या',
    'tig'    => 'टाइग्रे',
    'tiv'    => 'तिव',
    'tk'     => 'तुर्कमेन',
    'tkl'    => 'टोकेलाऊ',
    'tl'     => 'टागालोग',
    'tlh'    => 'क्लिंगॉन',
    'tli'    => 'लिंगित',
    'tmh'    => 'तामाशेक',
    'tn'     => 'त्स्वाना',
    'to'     => 'टोंगा',
    'tog'    => "न्यासा\ टोन्गा",
    'tpi'    => "टोक\ पिसिन",
    'tr'     => 'तुर्की',
    'trv'    => 'Taroko',
    'ts'     => 'सोंगा',
    'tsi'    => 'सिम्शियन',
    'tt'     => 'ततार',
    'tum'    => 'तम्बूका',
    'tup'    => "ट्यूपी\ भाषा",
    'tut'    => "अल्टॅइक\ भाषा",
    'tvl'    => 'टुवालु',
    'tw'     => 'ट्वी',
    'twq'    => 'Tasawaq',
    'ty'     => 'ताहितीयन',
    'tyv'    => 'टुवीनियन',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'उदमुर्त',
    'ug'     => 'उईघुर',
    'uga'    => 'युगॅरिटिक',
    'uk'     => 'युक्रेनियन',
    'umb'    => 'उम्बुन्डु',
    'und'    => "अज्ञात\ वा\ अवैध\ भाषा",
    'ur'     => 'उर्दू',
    'uz'     => 'उझ्बेक',
    'vai'    => 'वाई',
    've'     => 'व्हेंदा',
    'vi'     => 'व्हिएतनामी',
    'vo'     => 'ओलापुक',
    'vot'    => 'वॉटिक',
    'vun'    => 'Vunjo',
    'wa'     => 'वालून',
    'wae'    => 'Walser',
    'wak'    => "वाकाशन\ भाषा",
    'wal'    => 'वलामो',
    'war'    => 'वारे',
    'was'    => 'वाशो',
    'wen'    => "सॉर्बियन\ भाषा",
    'wo'     => 'वोलोफ',
    'xal'    => 'काल्मिक',
    'xh'     => 'खोसा',
    'xog'    => 'Soga',
    'yao'    => 'याओ',
    'yap'    => 'यापीस',
    'yav'    => 'Yangben',
    'yi'     => 'यिद्दिश',
    'yo'     => 'योरुबा',
    'ypk'    => "यूपिक\ भाषा",
    'yue'    => 'कँटोनीज',
    'za'     => 'झुआंग',
    'zap'    => 'झेपोटेक',
    'zbl'    => 'ब्लिसिम्बॉल्स',
    'zen'    => 'झेनान्गा',
    'zh'     => 'चीनी',
    'znd'    => 'झन्डे',
    'zu'     => 'झुलू',
    'zun'    => 'झुनी',
    'zxx'    => "भाषावैज्ञानिक\ सामग्री\ नाही",
    'zza'    => 'झाझा',
);

%Locales::DB::Language::mr::name_to_code = (
    'aghem'                                                                                => 'agq',
    'asu'                                                                                  => 'asa',
    'bafia'                                                                                => 'ksf',
    'bena'                                                                                 => 'bez',
    'bodo'                                                                                 => 'brx',
    'cayuga'                                                                               => 'cay',
    'centralmoroccotamazight'                                                              => 'tzm',
    'chiga'                                                                                => 'cgg',
    'colognian'                                                                            => 'ksh',
    'congoswahili'                                                                         => 'swc',
    'embu'                                                                                 => 'ebu',
    'gusii'                                                                                => 'guz',
    'jolafonyi'                                                                            => 'dyo',
    'kabuverdianu'                                                                         => 'kea',
    'kalenjin'                                                                             => 'kln',
    'koyraborosenni'                                                                       => 'ses',
    'koyrachiini'                                                                          => 'khq',
    'kwasio'                                                                               => 'nmg',
    'langi'                                                                                => 'lag',
    'luyia'                                                                                => 'luy',
    'machame'                                                                              => 'jmc',
    'makhuwameetto'                                                                        => 'mgh',
    'makonde'                                                                              => 'kde',
    'meru'                                                                                 => 'mer',
    'morisyen'                                                                             => 'mfe',
    'mundang'                                                                              => 'mua',
    'nama'                                                                                 => 'naq',
    'nuer'                                                                                 => 'nus',
    'rombo'                                                                                => 'rof',
    'rwa'                                                                                  => 'rwk',
    'saho'                                                                                 => 'ssy',
    'samburu'                                                                              => 'saq',
    'sangu'                                                                                => 'sbp',
    'sena'                                                                                 => 'seh',
    'seneca'                                                                               => 'see',
    'shambala'                                                                             => 'ksb',
    'soga'                                                                                 => 'xog',
    'tachelhit'                                                                            => 'shi',
    'taita'                                                                                => 'dav',
    'taroko'                                                                               => 'trv',
    'tasawaq'                                                                              => 'twq',
    'teso'                                                                                 => 'teo',
    'vunjo'                                                                                => 'vun',
    'walser'                                                                               => 'wae',
    'yangben'                                                                              => 'yav',
    'zarma'                                                                                => 'dje',
    'अंगिका'                                                                   => 'anp',
    'अकन'                                                                            => 'ak',
    'अकोली'                                                                      => 'ach',
    'अक्कादिआन'                                                          => 'akk',
    'अचीनी'                                                                      => 'ace',
    'अज्ञातवाअवैधभाषा'                                     => 'und',
    'अझेरी'                                                                      => 'az',
    'अडांग्मे'                                                             => 'ada',
    'अडिघे'                                                                      => 'ady',
    'अत्सम'                                                                      => 'cch',
    'अपाचेभाषा'                                                          => 'apa',
    'अप्परसॉर्बियन'                                              => 'hsb',
    'अफार'                                                                         => 'aa',
    'अफ्रिकान्स'                                                       => 'af',
    'अफ्रिहिली'                                                          => 'afh',
    'अफ्रोअशियाईभाषा'                                        => 'afa',
    'अबखेजियन'                                                             => 'ab',
    'अभिजातनेवारी'                                                 => 'nwc',
    'अभिजातसिरियाक'                                              => 'syc',
    'अम्हारिक'                                                             => 'am',
    'अरबी'                                                                         => 'ar',
    'अराफाओ'                                                                   => 'arp',
    'अरावक'                                                                      => 'arw',
    'अरोमानियन'                                                          => 'rup',
    'अर्गोनीज'                                                             => 'an',
    'अलेउत'                                                                      => 'ale',
    'अल्टॅइकभाषा'                                                    => 'tut',
    'अल्बानियन'                                                          => 'sq',
    'अवधी'                                                                         => 'awa',
    'अवेस्तन'                                                                => 'ae',
    'अस्तुरियन'                                                          => 'ast',
    'अ‍ॅथापास्कानभाषा'                                     => 'ath',
    'अ‍ॅरेमाइक'                                                          => 'arc',
    'अ‍ॅरॉकॅनियन'                                                    => 'arn',
    'अ‍ॅल्गोक्वियनभाषा'                                  => 'alg',
    'अ‍ॅव्हेरिक'                                                       => 'av',
    'आईसलँडिक'                                                             => 'is',
    'आयरिश'                                                                      => 'ga',
    'आर्मेनियन'                                                          => 'hy',
    'आसामी'                                                                      => 'as',
    'इंगुश'                                                                      => 'inh',
    'इंग्रजी'                                                                => 'en',
    'इंग्रजीआधारितक्रेओलवापिजिन'       => 'cpe',
    'इंग्रजीयूके'                                                    => 'en_gb',
    'इंडोनेशियन'                                                       => 'id',
    'इंडोयुरोपीयनभाषा'                                     => 'ine',
    'इजो'                                                                            => 'ijo',
    'इटालियन'                                                                => 'it',
    'इडौ'                                                                            => 'io',
    'इनारीसामी'                                                          => 'smn',
    'इनुकिटुट्'                                                          => 'iu',
    'इनूपियाक'                                                             => 'ik',
    'इन्टरलिंग'                                                          => 'ie',
    'इन्टरलिंग्वा'                                                 => 'ia',
    'इबान'                                                                         => 'iba',
    'इबेरियनपोर्तुगीज'                                     => 'pt_pt',
    'इबेरियनस्पॅनिश'                                           => 'es_es',
    'इरोक्वोइयनभाषा'                                           => 'iro',
    'इलोको'                                                                      => 'ilo',
    'इवे'                                                                            => 'ee',
    'इवोन्डो'                                                                => 'ewo',
    'इस्टोनियन'                                                          => 'et',
    'ईग्बो'                                                                      => 'ig',
    'ईराणीभाषा'                                                          => 'ira',
    'उईघुर'                                                                      => 'ug',
    'उझ्बेक'                                                                   => 'uz',
    'उडिया'                                                                      => 'or',
    'उत्तरीअमेरीकीइंडियनभाषा'                => 'nai',
    'उत्तरीदेबेली'                                                 => 'nd',
    'उत्तरीफ्रिशियन'                                           => 'frr',
    'उत्तरीसोथो'                                                       => 'nso',
    'उदमुर्त'                                                                => 'udm',
    'उम्बुन्डु'                                                          => 'umb',
    'उर्दू'                                                                      => 'ur',
    'एकविधभाषा'                                                          => 'mul',
    'एकाजुक'                                                                   => 'eka',
    'एन्को'                                                                      => 'nqo',
    'एफिक'                                                                         => 'efi',
    'एर्झ्या'                                                                => 'myv',
    'एलामाइट'                                                                => 'elx',
    'एस्परान्टो'                                                       => 'eo',
    'ऐनू'                                                                            => 'ain',
    'ऐमरा'                                                                         => 'ay',
    'ऑक्सिटान'                                                             => 'oc',
    'ऑस्ट्रियनजर्मन'                                           => 'de_at',
    'ऑस्ट्रेलियनइंग्रजी'                               => 'en_au',
    'ऑस्ट्रेलियनभाषा'                                        => 'aus',
    'ऑस्ट्रोनेशियन'                                              => 'map',
    'ओजिब्वा'                                                                => 'oj',
    'ओटोमानतुर्किश'                                              => 'ota',
    'ओटोमियनभाषा'                                                    => 'oto',
    'ओरोमो'                                                                      => 'om',
    'ओलापुक'                                                                   => 'vo',
    'ओसेज'                                                                         => 'osa',
    'ओस्सेटिक'                                                             => 'os',
    'कँटोनीज'                                                                => 'yue',
    'कझाक'                                                                         => 'kk',
    'कनुरी'                                                                      => 'kr',
    'कन्नड'                                                                      => 'kn',
    'कबाइल'                                                                      => 'kab',
    'कबार्डियन'                                                          => 'kbd',
    'कम्बा'                                                                      => 'kam',
    'कराचयबाल्कर'                                                    => 'krc',
    'करेलियन'                                                                => 'krl',
    'कलाल्लिसुत'                                                       => 'kl',
    'काँगो'                                                                      => 'kg',
    'काचिन'                                                                      => 'kac',
    'काराकल्पक'                                                          => 'kaa',
    'कारेन'                                                                      => 'kar',
    'काल्मिक'                                                                => 'xal',
    'कावी'                                                                         => 'kaw',
    'काशुबियन'                                                             => 'csb',
    'काश्मीरी'                                                             => 'ks',
    'किकुयू'                                                                   => 'ki',
    'किन्यार्वान्डा'                                           => 'rw',
    'किम्बन्दु'                                                          => 'kmb',
    'किरगीझ'                                                                   => 'ky',
    'कुतेनाई'                                                                => 'kut',
    'कुमीक'                                                                      => 'kum',
    'कुरूख'                                                                      => 'kru',
    'कुर्दिश'                                                                => 'ku',
    'कुशितिकभाषा'                                                    => 'cus',
    'कृत्रिमभाषा'                                                    => 'art',
    'कॅटलान'                                                                   => 'ca',
    'कॅड्डो'                                                                   => 'cad',
    'कॅनेडियनइंग्रजी'                                        => 'en_ca',
    'कॅनेडियनफ्रेंच'                                           => 'fr_ca',
    'कॅमोरो'                                                                   => 'ch',
    'कॅरिब'                                                                      => 'car',
    'केल्टिकभाषा'                                                    => 'cel',
    'कॉकेशियनभाषा'                                                 => 'cau',
    'कॉप्टिक'                                                                => 'cop',
    'कोंकणी'                                                                   => 'kok',
    'कोमी'                                                                         => 'kv',
    'कोमोरियन'                                                             => 'swb',
    'कोरियन'                                                                   => 'ko',
    'कोरो'                                                                         => 'kfo',
    'कोर्निश'                                                                => 'kw',
    'कोर्सिकन'                                                             => 'co',
    'कोसरियन'                                                                => 'kos',
    'क्पेल्ले'                                                             => 'kpe',
    'क्राइमीनतुर्की'                                           => 'crh',
    'क्री'                                                                         => 'cr',
    'क्रीक'                                                                      => 'mus',
    'क्रू'                                                                         => 'kro',
    'क्रेओलवापिजिन'                                              => 'crp',
    'क्रोएशियन'                                                          => 'hr',
    'क्लिंगॉन'                                                             => 'tlh',
    'क्वान्यामा'                                                       => 'kj',
    'क्वेचुआ'                                                                => 'qu',
    'खासी'                                                                         => 'kha',
    'खोतानीस'                                                                => 'kho',
    'खोसा'                                                                         => 'xh',
    'खोसियनभाषा'                                                       => 'khi',
    'ख्मेर'                                                                      => 'km',
    'गा'                                                                               => 'gaa',
    'गाँडी'                                                                      => 'gon',
    'गांडा'                                                                      => 'lg',
    'गायो'                                                                         => 'gay',
    'गीझ'                                                                            => 'gez',
    'गुआरनी'                                                                   => 'gn',
    'गुजराती'                                                                => 'gu',
    'गॅलिशियन'                                                             => 'gl',
    'गॉथिक'                                                                      => 'got',
    'गोरोन्तालो'                                                       => 'gor',
    'ग्रीक'                                                                      => 'el',
    'ग्रेबो'                                                                   => 'grb',
    'ग्विचइन'                                                                => 'gwi',
    'चर्चस्लाव्हिक'                                              => 'cu',
    'चामिकभाषा'                                                          => 'cmc',
    'चिनूकजारगॉन'                                                    => 'chn',
    'चिब्चा'                                                                   => 'chb',
    'चीनी'                                                                         => 'zh',
    'चीनीतिबेटीभाषा'                                           => 'sit',
    'चूकीसे'                                                                   => 'chk',
    'चूवाश'                                                                      => 'cv',
    'चेचन'                                                                         => 'ce',
    'चेरूकी'                                                                   => 'chr',
    'चोक्तौ'                                                                   => 'cho',
    'छगाताई'                                                                   => 'chg',
    'जपानी'                                                                      => 'ja',
    'जर्मन'                                                                      => 'de',
    'जर्मनिकभाषा'                                                    => 'gem',
    'जावनीस्'                                                                => 'jv',
    'जिल्बरटीज'                                                          => 'gil',
    'जुदेओअरबी'                                                          => 'jrb',
    'जुदेओफारसी'                                                       => 'jpr',
    'जॉर्जियन'                                                             => 'ka',
    'ज्जु'                                                                         => 'kaj',
    'झन्डे'                                                                      => 'znd',
    'झाझा'                                                                         => 'zza',
    'झुआंग'                                                                      => 'za',
    'झुनी'                                                                         => 'zun',
    'झुलू'                                                                         => 'zu',
    'झेक'                                                                            => 'cs',
    'झेनान्गा'                                                             => 'zen',
    'झेपोटेक'                                                                => 'zap',
    'झोंगखा'                                                                   => 'dz',
    'टाइग्रे'                                                                => 'tig',
    'टागालोग'                                                                => 'tl',
    'टिग्रिन्या'                                                       => 'ti',
    'टिम्ने'                                                                   => 'tem',
    'टुवालु'                                                                   => 'tvl',
    'टुवीनियन'                                                             => 'tyv',
    'टोंगा'                                                                      => 'to',
    'टोकपिसिन'                                                             => 'tpi',
    'टोकेलाऊ'                                                                => 'tkl',
    'ट्यूपीभाषा'                                                       => 'tup',
    'ट्वी'                                                                         => 'tw',
    'डच'                                                                               => 'nl',
    'डॅनिश'                                                                      => 'da',
    'डेलॅवेयर'                                                             => 'del',
    'डोंगा'                                                                      => 'ng',
    'डोगरी'                                                                      => 'doi',
    'डोग्रिब'                                                                => 'dgr',
    'ड्युला'                                                                   => 'dyu',
    'ततार'                                                                         => 'tt',
    'तमिळ'                                                                         => 'ta',
    'तम्बूका'                                                                => 'tum',
    'ताईभाषा'                                                                => 'tai',
    'ताजिक'                                                                      => 'tg',
    'तामाशेक'                                                                => 'tmh',
    'ताहितीयन'                                                             => 'ty',
    'तिबेटी'                                                                   => 'bo',
    'तिव'                                                                            => 'tiv',
    'तुर्कमेन'                                                             => 'tk',
    'तुर्की'                                                                   => 'tr',
    'तेतुम'                                                                      => 'tet',
    'तेरेनो'                                                                   => 'ter',
    'तेलगू'                                                                      => 'te',
    'त्याप'                                                                      => 'kcg',
    'त्स्वाना'                                                             => 'tn',
    'थाई'                                                                            => 'th',
    'दक्षिणअमेरीकीइंडियनभाषा'                => 'sai',
    'दक्षिणात्यअल्ताई'                                     => 'alt',
    'दक्षिणात्यदेबेली'                                     => 'nr',
    'दक्षिणात्यसामी'                                           => 'sma',
    'दाकोता'                                                                   => 'dak',
    'दायक'                                                                         => 'day',
    'दार्गवा'                                                                => 'dar',
    'दिन्का'                                                                   => 'din',
    'दिवेही'                                                                   => 'dv',
    'दुआला'                                                                      => 'dua',
    'द्रविडीभाषा'                                                    => 'dra',
    'नउरू'                                                                         => 'na',
    'नहुआत्ल'                                                                => 'nah',
    'नाइजरकॉर्डोफॅनियनभाषा'                      => 'nic',
    'नावाजो'                                                                   => 'nv',
    'निम्नसोर्बियन'                                              => 'dsb',
    'नियास'                                                                      => 'nia',
    'नियुआन'                                                                   => 'niu',
    'निलोसहारनभाषा'                                              => 'ssa',
    'नेपाळी'                                                                   => 'ne',
    'नेपोलिटान'                                                          => 'nap',
    'नेवारी'                                                                   => 'new',
    'नॉर्दनसामी'                                                       => 'se',
    'नॉर्वेजियनन्योर्स्क'                            => 'nn',
    'नॉर्वेजियनबोकमाल'                                     => 'nb',
    'नोगाई'                                                                      => 'nog',
    'नोर्वेजियन'                                                       => 'no',
    'न्झिमा'                                                                   => 'nzi',
    'न्यानकोल'                                                             => 'nyn',
    'न्यान्जा'                                                             => 'ny',
    'न्यामवेझी'                                                          => 'nym',
    'न्यासाटोन्गा'                                                 => 'tog',
    'न्युबियानभाषा'                                              => 'nub',
    'न्योरो'                                                                   => 'nyo',
    'पंगासीनान'                                                          => 'pag',
    'पंजाबी'                                                                   => 'pa',
    'पहलवी'                                                                      => 'pal',
    'पापियामेन्टो'                                                 => 'pap',
    'पापुनभाषा'                                                          => 'paa',
    'पाम्पान्गा'                                                       => 'pam',
    'पालाउआन'                                                                => 'pau',
    'पाली'                                                                         => 'pi',
    'पाश्चात्यफ्रिशियन'                                  => 'fy',
    'पुरातनआयरिश'                                                    => 'sga',
    'पुरातनइंग्रजी'                                              => 'ang',
    'पुरातननॉर्स'                                                    => 'non',
    'पुरातनप्रोव्हेन्सल'                               => 'pro',
    'पुरातनफारसी'                                                    => 'peo',
    'पुरातनफ्रेंच'                                                 => 'fro',
    'पुरातनहाइजर्मन'                                           => 'goh',
    'पुश्तो'                                                                   => 'ps',
    'पोर्तुगीज'                                                          => 'pt',
    'पोर्तुगीजआधारितक्रेओलयापिजिन' => 'cpp',
    'पोलिश'                                                                      => 'pl',
    'पोह्नपियन'                                                          => 'pon',
    'पौर्वात्यफ्रिशियन'                                  => 'frs',
    'प्राकृतभाषा'                                                    => 'pra',
    'प्राचीनइजिप्शियन'                                     => 'egy',
    'प्राचीनग्रीक'                                                 => 'grc',
    'फँग'                                                                            => 'fan',
    'फन्टी'                                                                      => 'fat',
    'फरोइए'                                                                      => 'fo',
    'फारसी'                                                                      => 'fa',
    'फिजीयन'                                                                   => 'fj',
    'फिन्निश'                                                                => 'fi',
    'फिन्नोउग्रीयनभाषा'                                  => 'fiu',
    'फिलिपिनो'                                                             => 'fil',
    'फिलिपीनीभाषा'                                                 => 'phi',
    'फुलाह'                                                                      => 'ff',
    'फॉन'                                                                            => 'fon',
    'फोनिशियन'                                                             => 'phn',
    'फ्रियुलियान'                                                    => 'fur',
    'फ्रेंच'                                                                   => 'fr',
    'फ्रेंचआधारितक्रेओलवापिजिन'          => 'cpf',
    'फ्लेमिश'                                                                => 'nl_be',
    'बंगाली'                                                                   => 'bn',
    'बगिनीस'                                                                   => 'bug',
    'बटाक'                                                                         => 'btk',
    'बन्टु'                                                                      => 'bnt',
    'बमिलेकेभाषा'                                                    => 'bai',
    'बर्बर'                                                                      => 'ber',
    'बर्मी'                                                                      => 'my',
    'बलुची'                                                                      => 'bal',
    'बल्गेरियन'                                                          => 'bg',
    'बष्किर'                                                                   => 'ba',
    'बसा'                                                                            => 'bas',
    'बांदा'                                                                      => 'bad',
    'बाम्बारा'                                                             => 'bm',
    'बाया'                                                                         => 'gba',
    'बालिनीस'                                                                => 'ban',
    'बाल्टिकभाषा'                                                    => 'bat',
    'बास्क'                                                                      => 'eu',
    'बिकोल'                                                                      => 'bik',
    'बिनी'                                                                         => 'bin',
    'बिस्लामा'                                                             => 'bi',
    'बिहारी'                                                                   => 'bh',
    'बुरियात'                                                                => 'bua',
    'बेजा'                                                                         => 'bej',
    'बेम्बा'                                                                   => 'bem',
    'बेलारुशियन'                                                       => 'be',
    'बोस्नियन'                                                             => 'bs',
    'ब्रज'                                                                         => 'bra',
    'ब्राझिलियनपोर्तुगीज'                            => 'pt_br',
    'ब्रेटन'                                                                   => 'br',
    'ब्लिन'                                                                      => 'byn',
    'ब्लिसिम्बॉल्स'                                              => 'zbl',
    'भारतीयभाषा'                                                       => 'inc',
    'भाषावैज्ञानिकसामग्रीनाही'             => 'zxx',
    'भोजपुरी'                                                                => 'bho',
    'मंगोलियन'                                                             => 'mn',
    'मंडार'                                                                      => 'mdr',
    'मकस्सर'                                                                   => 'mak',
    'मगही'                                                                         => 'mag',
    'मणिपुरी'                                                                => 'mni',
    'मध्यअमेरिकीइंडियनभाषा'                      => 'cai',
    'मनोबोभाषा'                                                          => 'mno',
    'मन्डिन्गो'                                                          => 'man',
    'मराठी'                                                                      => 'mr',
    'मलय'                                                                            => 'ms',
    'मलागसी'                                                                   => 'mg',
    'मल्याळम'                                                                => 'ml',
    'मसाई'                                                                         => 'mas',
    'माँग'                                                                         => 'hmn',
    'मांक्स'                                                                   => 'gv',
    'माओरी'                                                                      => 'mi',
    'मादुरीस'                                                                => 'mad',
    'मान्चु'                                                                   => 'mnc',
    'मायाभाषा'                                                             => 'myn',
    'मारवाडी'                                                                => 'mwr',
    'मारी'                                                                         => 'chm',
    'मार्शलीज'                                                             => 'mh',
    'माल्टिज्'                                                             => 'mt',
    'मिकमॅक'                                                                   => 'mic',
    'मिडलआयरिश'                                                          => 'mga',
    'मिडलइंग्रजी'                                                    => 'enm',
    'मिडलडच'                                                                   => 'dum',
    'मिडलफ्रेंच'                                                       => 'frm',
    'मिडलहायजर्मन'                                                 => 'gmh',
    'मिनांग्काबाउ'                                                 => 'min',
    'मिरांडिज्'                                                          => 'mwl',
    'मुन्डाभाषा'                                                       => 'mun',
    'मॅसेडोनियन'                                                       => 'mk',
    'मेन्डे'                                                                   => 'men',
    'मैथिली'                                                                   => 'mai',
    'मॉनख्मेरभाषा'                                                 => 'mkh',
    'मोंगो'                                                                      => 'lol',
    'मोक्ष'                                                                      => 'mdf',
    'मोल्डाव्हियन'                                                 => 'mo',
    'मोस्सी'                                                                   => 'mos',
    'मोहॉक'                                                                      => 'moh',
    'याओ'                                                                            => 'yao',
    'याकूत'                                                                      => 'sah',
    'यापीस'                                                                      => 'yap',
    'यिद्दिश'                                                                => 'yi',
    'युक्रेनियन'                                                       => 'uk',
    'युगॅरिटिक'                                                          => 'uga',
    "यू\.एस\.इंग्रजी"                                                => 'en_us',
    'यूपिकभाषा'                                                          => 'ypk',
    'योरुबा'                                                                   => 'yo',
    'रशियन'                                                                      => 'ru',
    'राजस्थानी'                                                          => 'raj',
    'रापानुई'                                                                => 'rap',
    'रारोटोंगन'                                                          => 'rar',
    'रुन्दी'                                                                   => 'rn',
    'रोमांसभाषा'                                                       => 'roa',
    'रोमानियन'                                                             => 'ro',
    'रोमानी'                                                                   => 'rom',
    'र्‍हाएटोरोमांस'                                           => 'rm',
    'लक्झेंबर्गिश'                                                 => 'lb',
    'लाओ'                                                                            => 'lo',
    'लाट्‌वियन'                                                          => 'lv',
    'लादीनो'                                                                   => 'lad',
    'लाम्बा'                                                                   => 'lam',
    'लाह्न्डा'                                                             => 'lah',
    'लिंगाला'                                                                => 'ln',
    'लिंगित'                                                                   => 'tli',
    'लिंबूर्गिश'                                                       => 'li',
    'लिथुआनियन'                                                          => 'lt',
    'लुइसेनो'                                                                => 'lui',
    'लुन्डा'                                                                   => 'lun',
    'लुशाई'                                                                      => 'lus',
    'लूबालुलुआ'                                                          => 'lua',
    'लॅटिन'                                                                      => 'la',
    'लॅटिनअमेरिकनस्पॅनिश'                            => 'es_419',
    'लेझ्घीयन'                                                             => 'lez',
    'लोजर्मन'                                                                => 'nds',
    'लोज्बान'                                                                => 'jbo',
    'लोझी'                                                                         => 'loz',
    'ल्युओ'                                                                      => 'luo',
    'ल्युलसामी'                                                          => 'smj',
    'ल्यूबाकटांगा'                                                 => 'lu',
    'वलामो'                                                                      => 'wal',
    'वाई'                                                                            => 'vai',
    'वाकाशनभाषा'                                                       => 'wak',
    'वारे'                                                                         => 'war',
    'वालून'                                                                      => 'wa',
    'वाशो'                                                                         => 'was',
    'विविधभाषा'                                                          => 'mis',
    'वेल्श'                                                                      => 'cy',
    'वॉटिक'                                                                      => 'vot',
    'वोलोफ'                                                                      => 'wo',
    'व्हिएतनामी'                                                       => 'vi',
    'व्हेंदा'                                                                => 've',
    'शिपेव्यान'                                                          => 'chp',
    'शॅन'                                                                            => 'shn',
    'शेयेन्न'                                                                => 'chy',
    'शोना'                                                                         => 'sn',
    'सँडवे'                                                                      => 'sad',
    'संताली'                                                                   => 'sat',
    'संस्कृत'                                                                => 'sa',
    'सर्दिनियन'                                                          => 'sc',
    'सर्बियन'                                                                => 'sr',
    'सर्बोक्रोएशियन'                                           => 'sh',
    'सलीशनभाषा'                                                          => 'sal',
    'सांकेतिकभाषा'                                                 => 'sgn',
    'सांगो'                                                                      => 'sg',
    'सामरिटानअरॅमिक'                                           => 'sam',
    'सामीभाषा'                                                             => 'smi',
    'सामोअन'                                                                   => 'sm',
    'सासाक'                                                                      => 'sas',
    'सिंधी'                                                                      => 'sd',
    'सिंहली'                                                                   => 'si',
    'सिउआनभाषा'                                                          => 'sio',
    'सिक्सिका'                                                             => 'bla',
    'सिचुआनयी'                                                             => 'ii',
    'सिदामो'                                                                   => 'sid',
    'सिबुआनो'                                                                => 'ceb',
    'सिम्शियन'                                                             => 'tsi',
    'सिरियाक'                                                                => 'syr',
    'सिसिलियन'                                                             => 'scn',
    'सुंदानीज'                                                             => 'su',
    'सुकुमा'                                                                   => 'suk',
    'सुमेरियन'                                                             => 'sux',
    'सुसु'                                                                         => 'sus',
    'सेमिटिकभाषा'                                                    => 'sem',
    'सेरेर'                                                                      => 'srr',
    'सेल्कप'                                                                   => 'sel',
    'सेसोथो'                                                                   => 'st',
    'सॉर्बियनभाषा'                                                 => 'wen',
    'सोंगा'                                                                      => 'ts',
    'सोग्डिएन'                                                             => 'sog',
    'सोनिन्के'                                                             => 'snk',
    'सोन्घाई'                                                                => 'son',
    'सोमाली'                                                                   => 'so',
    'स्कॉट्स'                                                                => 'sco',
    'स्कॉट्सगेलिक'                                                 => 'gd',
    'स्कोल्टसामी'                                                    => 'sms',
    'स्पॅनिश'                                                                => 'es',
    'स्रानानटॉन्गो'                                              => 'srn',
    'स्लाव्ह'                                                                => 'den',
    'स्लाव्हिकभाषा'                                              => 'sla',
    'स्लोव्हाक'                                                          => 'sk',
    'स्लोव्हेनियन'                                                 => 'sl',
    'स्वाती'                                                                   => 'ss',
    'स्वाहिली'                                                             => 'sw',
    'स्विसजर्मन'                                                       => 'gsw',
    'स्विसफ्रेंच'                                                    => 'fr_ch',
    'स्विसहायजर्मन'                                              => 'de_ch',
    'स्वीडिश'                                                                => 'sv',
    'हंगेरियन'                                                             => 'hu',
    'हरेरो'                                                                      => 'hz',
    'हवाईयन'                                                                   => 'haw',
    'हिंदी'                                                                      => 'hi',
    'हिट्टिते'                                                             => 'hit',
    'हिब्रू'                                                                   => 'he',
    'हिमाचली'                                                                => 'him',
    'हिरीमॉटू'                                                             => 'ho',
    'हिलीगेनॉन'                                                          => 'hil',
    'हूपा'                                                                         => 'hup',
    'हैडा'                                                                         => 'hai',
    'हैतीयन'                                                                   => 'ht',
    'हौसा'                                                                         => 'ha',
);

1;
