/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

import java.io.Reader;

/**
 * A reader that returns EOF always.
 */
public final class NullReader 
	extends Reader
{
	static Reader r = new NullReader();

	private NullReader() {
	}

	/**
	 * Returns this sole instance.
	 * @return a null reader
	 */
	public static Reader getInstance() {
		return r;
	}

	/**
	 * Does nothing.
	 */
	public void close() {
	}

	/**
	 * Returns EOF.
	 */
	public int read() {
		return -1;
	}

	/**
	 * Returns EOF.
	 */
	public int read(char[] cbuf) {
		return -1;
	}

	/**
	 * Returns EOF.
	 */
	public int read(char[] cbuf, int off, int len) {
		return -1;
	}

	/**
	 * Does nothing, returns 0.
	 */
	public long skip(long n) {
		return 0;
	}

}
