//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// type_traits

// array

#include <cuda/std/type_traits>
#include "test_macros.h"

template <class T>
__host__ __device__
void test_array_imp()
{
    static_assert(!cuda::std::is_void<T>::value, "");
#if TEST_STD_VER > 11
    static_assert(!cuda::std::is_null_pointer<T>::value, "");
#endif
    static_assert(!cuda::std::is_integral<T>::value, "");
    static_assert(!cuda::std::is_floating_point<T>::value, "");
    static_assert( cuda::std::is_array<T>::value, "");
    static_assert(!cuda::std::is_pointer<T>::value, "");
    static_assert(!cuda::std::is_lvalue_reference<T>::value, "");
    static_assert(!cuda::std::is_rvalue_reference<T>::value, "");
    static_assert(!cuda::std::is_member_object_pointer<T>::value, "");
    static_assert(!cuda::std::is_member_function_pointer<T>::value, "");
    static_assert(!cuda::std::is_enum<T>::value, "");
    static_assert(!cuda::std::is_union<T>::value, "");
    static_assert(!cuda::std::is_class<T>::value, "");
    static_assert(!cuda::std::is_function<T>::value, "");
}

template <class T>
__host__ __device__
void test_array()
{
    test_array_imp<T>();
    test_array_imp<const T>();
    test_array_imp<volatile T>();
    test_array_imp<const volatile T>();
}

typedef char array[3];
typedef const char const_array[3];
typedef char incomplete_array[];
struct Incomplete;

int main(int, char**)
{
    test_array<array>();
    test_array<const_array>();
    test_array<incomplete_array>();
    test_array<Incomplete[]>();

//  LWG#2582
    static_assert(!cuda::std::is_array<Incomplete>::value, "");

  return 0;
}
