#if   !defined(__FOOBAROBJECTADAPTER_HPP)
#define __FOOBAROBJECTADAPTER_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__ADAPTER_HPP)
#include <Adapter.hpp>
#endif

#if   !defined(__FOO_HPP)
#include <Foo.hpp>
#endif

DECLARE_CLASS( Bar );

/**
FooBarObjectAdapter provides the Foo (Target) interface by adapting 
Bar (Adaptee) through object delegation. 

Object Adapters:

Pro: Lets a single Adapter work with many Adaptees-that is, the
Adaptee itself and all of its subclasses (if any). The Adapter
can also add functionaliry to all Adaptees at once.

Con: Makes it harder to override Adaptee behavior. It will require
subclassing Adaptee and making Adapter refer to the subclass rather
than the Adaptee itself.


As you can see, this inteface is mainly concerned with emulating
Foo. It does not expose the Bar methods
*/
      
DECLARE_CLASS(FooBarObjectAdapter);

class FooBarObjectAdapter : public CORELINUX(Adapter), public Foo
{

public:

                        /// Constructor with coordinates

                        FooBarObjectAdapter( BarPtr ) 
                           throw(CORELINUX(Exception));

                        /// Copy constructor

                        FooBarObjectAdapter( FooBarObjectAdapterCref );

                        /// Destructor

   virtual              ~FooBarObjectAdapter( void );

   //
   // Operator overloads
   //

            /// Assignment operator
         
            FooBarObjectAdapterRef   operator=( FooBarObjectAdapterCref );
         
            /// Equality operator
         
            bool     operator==( FooBarObjectAdapterCref );

   //
   // Accessors
   //
   
   virtual  CORELINUX(IntCref) getVerticalPosition(void) const;

   
   virtual  CORELINUX(IntCref) getHorizontalPosition(void) const;

   //
   // Mutators
   //

   /// Sets the Y coordinate
   
   virtual  void setVerticalPosition(CORELINUX(Int)) 
                  throw(CORELINUX(Exception));

   /// Sets the X coordinate
   
   virtual  void setHorizontalPosition(CORELINUX(Int)) 
                  throw(CORELINUX(Exception));

protected:

                        /**
                        The default constructor is moved to protected
                        because the invariant state requires that
                        FooBarObjectAdapter has the Bar Adaptee
                        */
                     
                        FooBarObjectAdapter( void );


            /// Retrieves the Bar 

            BarPtr   getBar( void ) const;   


private:

            BarPtr   theBar;
};

#endif // if !defined __FOOBAROBJECTADAPTER_HPP

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.3 $
   $Date: 2000/02/10 14:32:20 $
   $Locker:  $
*/

