# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=icelake-server -instruction-tables < %s | FileCheck %s

vaesdec          %zmm16, %zmm17, %zmm19
vaesdec          (%rax), %zmm17, %zmm19

vaesdeclast      %zmm16, %zmm17, %zmm19
vaesdeclast      (%rax), %zmm17, %zmm19

vaesenc          %zmm16, %zmm17, %zmm19
vaesenc          (%rax), %zmm17, %zmm19

vaesenclast      %zmm16, %zmm17, %zmm19
vaesenclast      (%rax), %zmm17, %zmm19

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      4     1.00                        vaesdec	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      10    1.00    *                   vaesdec	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      4     1.00                        vaesdeclast	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      10    1.00    *                   vaesdeclast	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      4     1.00                        vaesenc	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      10    1.00    *                   vaesenc	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      4     1.00                        vaesenclast	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      10    1.00    *                   vaesenclast	(%rax), %zmm17, %zmm19

# CHECK:      Resources:
# CHECK-NEXT: [0]   - ICXDivider
# CHECK-NEXT: [1]   - ICXFPDivider
# CHECK-NEXT: [2]   - ICXPort0
# CHECK-NEXT: [3]   - ICXPort1
# CHECK-NEXT: [4]   - ICXPort2
# CHECK-NEXT: [5]   - ICXPort3
# CHECK-NEXT: [6]   - ICXPort4
# CHECK-NEXT: [7]   - ICXPort5
# CHECK-NEXT: [8]   - ICXPort6
# CHECK-NEXT: [9]   - ICXPort7
# CHECK-NEXT: [10]  - ICXPort8
# CHECK-NEXT: [11]  - ICXPort9

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]
# CHECK-NEXT:  -      -     8.00    -     2.00   2.00    -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   Instructions:
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -      -      -      -     vaesdec	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -     0.50   0.50    -      -      -      -      -      -     vaesdec	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -      -      -      -     vaesdeclast	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -     0.50   0.50    -      -      -      -      -      -     vaesdeclast	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -      -      -      -     vaesenc	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -     0.50   0.50    -      -      -      -      -      -     vaesenc	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -      -      -      -     vaesenclast	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -     0.50   0.50    -      -      -      -      -      -     vaesenclast	(%rax), %zmm17, %zmm19
