/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quarter@users.sourceforge.net> */

#include "include/support.h"
#include "include/paritycommand.h"
#include "include/message.h"

class LWCommandTo: public LWCommandSegment {
private:
gboolean has_step;
public:
LWCommandTo (): has_step(FALSE) {}
	
LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	g_return_val_if_fail ((has_step == FALSE && argc == 1) || (has_step == TRUE && argc == 2), NULL);
	g_return_val_if_fail (context->instrPtr->next != NULL, NULL);
	g_return_val_if_fail (FALSE == g_queue_is_empty (context->stack), NULL);

	LWValue *iterVariable = (LWValue *) g_queue_peek_head (context->stack);
	
	if (iterVariable->toInt() > args[0]->toInt())
	{
		g_queue_pop_head (context->stack);
		context->instrPtr = context->instrPtr->next->next;
	}

	return NULL;
}

LWValue *resume1 (LWContext *context, guint argc, LWValue *args[])
{
	g_return_val_if_fail ((has_step == FALSE && argc == 1) || (has_step == TRUE && argc == 2), NULL);
	g_return_val_if_fail (context->instrPtr->next != NULL, NULL);
	g_return_val_if_fail (FALSE == g_queue_is_empty (context->stack), NULL);
	
	LWValue *iterVariable = (LWValue *) g_queue_peek_head (context->stack);

	gint step = (has_step == TRUE) ? args[1]->toInt() : 1;	
	
	if (iterVariable->toInt() + step > args[0]->toInt())
	{
		g_queue_pop_head (context->stack);
		context->instrPtr = context->instrPtr->next->next;
	} else {
		LWValue v(iterVariable->toInt() + step);
		iterVariable->set (&v);
	}
	
	return NULL;
}

const gchar *getName ()
{
	return "to";
}	

gchar *getHint ()
{
	return _("Count to");
}

void checkArgument (guint n, LWValue *value)
{
	//For now checking step range is not implemented...
	
	if (n == 0)
		if (FALSE == value->isVariable() && FALSE == value->checkRange())
			throw new LWMessage (LW_ERROR_NumberOutOfRange);	
}

void checkArgc (guint n)
{
	if (has_step == FALSE && n != 1) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
	
	if (has_step == TRUE && n != 2)
		throw new LWMessage (LW_ERROR_PleaseSpecifyStep);
}

gboolean matchPrevCondition (LWCommand *cmd)
{
	(void) cmd;
	return TRUE;
}

gboolean matchNextCondition (LWCommand *cmd)
{
	return ((!g_ascii_strcasecmp (cmd->getName(), "break")) ||
				(!g_ascii_strcasecmp (cmd->getName(), "continue")) ||
				(!g_ascii_strcasecmp (cmd->getName(), "step"))) ? TRUE : FALSE;
}

gboolean matchWith (LWCommand *cmd)
{
	if (cmd == NULL)
			throw new LWMessage (LW_ERROR_ToButWhereIsFor);
	
	if (!g_ascii_strcasecmp (cmd->getName(), "step")) {
		has_step = TRUE;
		return TRUE;
	}
	
	if (g_ascii_strcasecmp (cmd->getName(), "for2"))
			throw new LWMessage (LW_ERROR_ToButWhereIsFor);
	
	match();
	
	return TRUE;
}

gboolean isLoop ()
{
	return TRUE;
}

void reset1 ()
{
	has_step = FALSE;
	LWCommandSegment::reset1();
}

};

LWSymbol *new_LWCommandTo()
{
	return new LWCommandTo();
}
