/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.model.types;

import java.util.HashMap;
import org.lisaac.ldt.model.types.ITypeMono;

public class TypeSimple
implements ITypeMono {
    protected static HashMap<String, TypeSimple> dico;
    protected String name;
    protected static TypeSimple typeNull;
    protected static TypeSimple typeVoid;
    protected static TypeSimple typeBoolean;

    TypeSimple(String name) {
        this.name = name;
        if (dico == null) {
            dico = new HashMap();
        }
        dico.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public static void init() {
        typeNull = new TypeSimple("NULL");
        typeVoid = new TypeSimple("VOID");
        typeBoolean = new TypeSimple("BOOLEAN");
    }

    public static TypeSimple get(String n) {
        TypeSimple result = null;
        if (dico == null) {
            dico = new HashMap();
        }
        if ((result = dico.get(n)) == null) {
            result = new TypeSimple(n);
        }
        return result;
    }

    public static ITypeMono getTypeVoid() {
        return typeVoid;
    }

    public static ITypeMono getTypeNull() {
        return typeNull;
    }

    public static ITypeMono getTypeBoolean() {
        return typeBoolean;
    }

    public String toString() {
        if (this.equals(typeVoid) || this.name.compareTo("VOID") == 0) {
            return null;
        }
        return this.name;
    }

    public void rename(String oldName, String newName) {
        if (this.name.compareTo(oldName) == 0) {
            dico.put(this.name, null);
            this.name = newName;
            dico.put(this.name, this);
        }
    }
}

