/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.lisaac.ldt.LisaacPlugin;
import org.lisaac.ldt.editors.LisaacEditor;
import org.lisaac.ldt.model.ILisaacModel;
import org.lisaac.ldt.model.LisaacModel;
import org.lisaac.ldt.model.LisaacParser;
import org.lisaac.ldt.model.items.ICode;
import org.lisaac.ldt.model.items.ITMPrototype;
import org.lisaac.ldt.model.items.ITMRead;
import org.lisaac.ldt.model.items.Prototype;
import org.lisaac.ldt.model.items.Slot;
import org.lisaac.ldt.model.types.IType;
import org.lisaac.ldt.model.types.ITypeMono;
import org.lisaac.ldt.model.types.TypeGeneric;
import org.lisaac.ldt.model.types.TypeParameter;
import org.lisaac.ldt.model.types.TypeSelf;
import org.lisaac.ldt.outline.OutlineImages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LisaacCompletionParser
extends LisaacParser {
    protected static LisaacModel model;
    protected Prototype currentPrototype;
    protected Slot currentSlot;
    protected int endOffset;
    protected TypeGeneric lastGenericType;

    public LisaacCompletionParser(String contents, LisaacModel model) {
        super(null, contents);
        IWorkbenchPart part;
        IWorkbenchWindow w;
        if (model == null && (w = LisaacPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow()) != null && (part = w.getPartService().getActivePart()) instanceof LisaacEditor) {
            model = LisaacModel.getModel(((LisaacEditor)part).getProject());
        }
        LisaacCompletionParser.model = model;
        this.enableErrorReport(false);
    }

    public void parseCompletions(int startOffset, int baseOffset, ArrayList<ICompletionProposal> proposals) throws CoreException {
        this.currentPrototype = LisaacModel.getCurrentPrototype();
        this.currentSlot = this.currentPrototype.getSlot(startOffset);
        this.lastGenericType = null;
        this.endOffset = -1;
        while (this.readKeyword()) {
            if (baseOffset != startOffset + this.position) continue;
            String[] keywords = ILisaacModel.keywords;
            int i = 0;
            while (i < keywords.length) {
                if (keywords[i].startsWith(this.lastString)) {
                    String keywordCompletion = keywords[i].substring(this.lastString.length());
                    proposals.add((ICompletionProposal)new CompletionProposal(keywordCompletion, baseOffset, 0, keywordCompletion.length(), OutlineImages.KEYWORD, keywords[i], null, ""));
                }
                ++i;
            }
            return;
        }
        this.setPosition(0);
        ICode code = this.readExpr();
        if (code != null && this.currentPrototype != null) {
            IType type = code.getType(this.currentSlot, this.currentPrototype);
            if (type != null) {
                if (this.source.charAt(this.position - 1) == '.') {
                    if (type instanceof TypeSelf) {
                        this.currentPrototype = LisaacCompletionParser.findPrototype(((TypeSelf)type).getStaticType());
                    } else if (type instanceof TypeParameter && this.lastGenericType != null) {
                        int index = this.currentPrototype.getGenericIndex((TypeParameter)type);
                        if (index != -1) {
                            ITypeMono realType = this.lastGenericType.getGenericElt(index);
                            this.currentPrototype = LisaacCompletionParser.findPrototype(realType.toString());
                        }
                    } else {
                        this.currentPrototype = LisaacCompletionParser.findPrototype(type.toString());
                    }
                    if (this.currentPrototype != null) {
                        this.currentPrototype.getSlotProposals(proposals, baseOffset, 0);
                    }
                } else if (code instanceof ITMPrototype) {
                    String prefix = type.toString();
                    model.getPathManager().getPathMatch(prefix, proposals, baseOffset);
                }
            } else if (code instanceof ITMRead) {
                String prefix = ((ITMRead)code).getName();
                if (this.currentSlot != null) {
                    this.currentSlot.getArgumentMatchProposals(prefix, proposals, baseOffset, 0);
                    this.currentSlot.getLocalMatchProposals(prefix, proposals, baseOffset, 0);
                }
                this.currentPrototype.lookupSlotMatch(prefix, proposals, baseOffset, 0);
            }
        }
    }

    @Override
    protected ICode readExprMessage() {
        ICode result = this.readExprBase();
        if (result != null) {
            while (this.readCharacter('.')) {
                String stringType;
                if (this.endOffset != -1 && this.position == this.endOffset + 1) break;
                ICode lastResult = result;
                if ((result = this.readSendMsg(result)) == null) {
                    return lastResult;
                }
                IType type = lastResult.getType(this.currentSlot, this.currentPrototype);
                if (type == null || (stringType = type.toString()) == null || "SELF".compareTo(stringType) == 0) continue;
                try {
                    if (type instanceof TypeParameter && this.lastGenericType != null) {
                        int index = this.currentPrototype.getGenericIndex((TypeParameter)type);
                        if (index != -1) {
                            ITypeMono realType = this.lastGenericType.getGenericElt(index);
                            this.currentPrototype = LisaacCompletionParser.findPrototype(realType.toString());
                        }
                    } else {
                        this.currentPrototype = LisaacCompletionParser.findPrototype(stringType);
                    }
                }
                catch (CoreException coreException) {
                    return null;
                }
                if (this.currentPrototype == null) {
                    return null;
                }
                if (type instanceof TypeGeneric) {
                    this.lastGenericType = (TypeGeneric)type;
                }
                this.currentSlot = result instanceof ITMRead ? this.currentPrototype.lookupSlot(((ITMRead)result).getName()) : null;
            }
        }
        return result;
    }

    public Prototype readReceiver(int startOffset, int endOffset, Prototype current) throws CoreException {
        IType type;
        Prototype result = null;
        this.currentPrototype = current;
        this.currentSlot = this.currentPrototype.getSlot(startOffset);
        this.endOffset = endOffset;
        this.setPosition(startOffset);
        this.readSpace();
        ICode code = this.readExpr();
        if (code != null && this.currentPrototype != null && (type = code.getType(this.currentSlot, this.currentPrototype)) != null) {
            int index;
            if (type.toString() != null && "SELF".compareTo(type.toString()) != 0) {
                Prototype save = this.currentPrototype;
                this.currentPrototype = LisaacCompletionParser.findPrototype(type.toString());
                if (this.currentPrototype == null) {
                    this.currentPrototype = save;
                }
            }
            if (type instanceof TypeParameter && this.lastGenericType != null && (index = this.currentPrototype.getGenericIndex((TypeParameter)type)) != -1) {
                ITypeMono realType = this.lastGenericType.getGenericElt(index);
                this.currentPrototype = LisaacCompletionParser.findPrototype(realType.toString());
            }
            result = this.currentPrototype;
        }
        return result;
    }

    public static Prototype findPrototype(String prototypeName) throws CoreException {
        IProject project = null;
        if (model == null) {
            IWorkbenchWindow w = LisaacPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            if (w == null) {
                return null;
            }
            IWorkbenchPart part = w.getPartService().getActivePart();
            if (part instanceof LisaacEditor) {
                project = ((LisaacEditor)part).getProject();
            }
            if (project != null) {
                model = LisaacModel.getModel(project);
            }
        }
        if (model == null) {
            return null;
        }
        if (project == null) {
            project = model.getProject();
        }
        return model.getPrototype(prototypeName);
    }
}

