/*
 * Copyright (c) 2007 - 2015 Joseph Gaeddert
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

//
// autotest fft data for 509-point transform
//

#include <complex.h>

float complex fft_test_x509[] = {
    0.359331995889 +  -1.085301108776*_Complex_I,
   -1.932383412518 +   0.116856180907*_Complex_I,
    0.496271262268 +   0.731796541816*_Complex_I,
    0.431573865944 +   0.591703481184*_Complex_I,
    0.589253369531 +  -0.795072338555*_Complex_I,
   -0.870697944847 +  -0.497562617185*_Complex_I,
    1.247223411086 +   0.771429589056*_Complex_I,
    0.924873577618 +  -1.184353621638*_Complex_I,
    0.659579079487 +   0.126294704315*_Complex_I,
    1.647221437368 +  -2.249906156787*_Complex_I,
   -1.334652205984 +  -0.024425874102*_Complex_I,
    0.095148747858 +  -0.284583137620*_Complex_I,
   -2.534039905928 +   1.936731699042*_Complex_I,
    0.370565605548 +  -0.671454121821*_Complex_I,
    0.382886168067 +   0.318205203845*_Complex_I,
   -1.314163630052 +   0.381239207410*_Complex_I,
   -0.258334295223 +   0.599344826242*_Complex_I,
    1.542372805791 +  -0.381018806439*_Complex_I,
   -0.015408662897 +   1.208686378191*_Complex_I,
   -3.023761214358 +  -0.135651280290*_Complex_I,
   -0.916610967637 +   0.884088889046*_Complex_I,
   -2.081046862959 +   2.001230452826*_Complex_I,
    1.031862595677 +   1.366475262140*_Complex_I,
   -0.259564882667 +   0.315307538802*_Complex_I,
    0.161129496712 +  -1.667686892086*_Complex_I,
   -1.241250123646 +   1.380715267035*_Complex_I,
    0.027019787139 +   2.068943431414*_Complex_I,
    0.164488255181 +  -0.688316587237*_Complex_I,
    1.114819509678 +  -3.008077068837*_Complex_I,
   -1.374358189256 +   0.000217799371*_Complex_I,
    1.783814617294 +  -0.127391483103*_Complex_I,
    1.648034611975 +  -0.251680996856*_Complex_I,
    1.678583258653 +   1.974165102901*_Complex_I,
   -0.857815837356 +  -3.739419503346*_Complex_I,
    1.227762010986 +  -0.496092919671*_Complex_I,
    0.275130781058 +   1.160971226357*_Complex_I,
    0.333840127696 +   1.388036870908*_Complex_I,
   -0.805343489373 +   0.006883877363*_Complex_I,
    0.113234013309 +   0.031253576243*_Complex_I,
   -0.610537915176 +   0.630710349348*_Complex_I,
    1.397240850777 +  -2.014373420814*_Complex_I,
   -0.255790837573 +   0.916792397001*_Complex_I,
    0.129924388336 +  -0.537587690895*_Complex_I,
   -0.926838068677 +   0.308336177664*_Complex_I,
    3.010372178544 +  -2.369144950446*_Complex_I,
    1.263300917549 +  -1.660219437257*_Complex_I,
    0.841656993731 +   1.927041610736*_Complex_I,
   -0.904792064104 +  -1.173048767457*_Complex_I,
    0.989814388062 +   1.253071554414*_Complex_I,
   -0.257249205993 +  -0.959941785447*_Complex_I,
   -1.205852496010 +   0.196179577313*_Complex_I,
    1.940909824834 +  -2.078512378665*_Complex_I,
    0.300600588979 +   0.572506173199*_Complex_I,
   -0.375271364555 +  -0.773019164981*_Complex_I,
   -0.858303843109 +  -0.674765891031*_Complex_I,
   -1.189090659992 +   0.543093004900*_Complex_I,
    2.165334883903 +   0.001082499227*_Complex_I,
    2.057289953335 +  -0.916206975165*_Complex_I,
   -0.161982761480 +  -0.815858087637*_Complex_I,
   -1.390044285564 +  -0.714076838951*_Complex_I,
    0.766348194222 +   0.076251375781*_Complex_I,
   -0.630967707884 +   0.854026208416*_Complex_I,
   -1.309424118846 +   0.470225939681*_Complex_I,
    0.664797780343 +  -1.109803637533*_Complex_I,
    3.563726896705 +   1.370311380835*_Complex_I,
    0.850424444505 +  -0.770251870088*_Complex_I,
    0.316880772888 +  -0.509312503865*_Complex_I,
   -1.439495581618 +  -1.741765587801*_Complex_I,
   -1.095540513740 +   0.552478238644*_Complex_I,
   -0.879540480746 +  -1.782154665595*_Complex_I,
    1.394922475961 +   0.407153930461*_Complex_I,
   -1.583206834198 +   0.548532742373*_Complex_I,
   -0.330266310339 +   0.821466818961*_Complex_I,
   -1.157454328378 +   0.386301239269*_Complex_I,
    0.823214183923 +   0.993600792956*_Complex_I,
   -0.665523708393 +  -0.143306700746*_Complex_I,
   -2.274210663640 +  -0.526858961140*_Complex_I,
    0.675171584769 +   1.608754308056*_Complex_I,
    0.067605428754 +   0.840683747814*_Complex_I,
    0.927563962378 +   0.563153155030*_Complex_I,
   -0.129920407968 +   0.614536449089*_Complex_I,
   -0.633778727653 +   0.174141369494*_Complex_I,
   -0.579622089160 +  -1.179631499150*_Complex_I,
    3.157266013709 +   0.841577893721*_Complex_I,
   -1.564968432235 +   0.237536721331*_Complex_I,
    0.832675154129 +   2.752538330003*_Complex_I,
   -1.003618718524 +  -0.803502222719*_Complex_I,
    1.033045390907 +  -0.887091010037*_Complex_I,
    0.406299848093 +  -0.231522470982*_Complex_I,
   -1.224877731528 +   0.962620343882*_Complex_I,
   -0.287856500251 +  -0.684348325534*_Complex_I,
    0.769551121775 +   1.052171601110*_Complex_I,
    1.211938362349 +  -0.397315302619*_Complex_I,
   -1.801171069328 +   0.782481239455*_Complex_I,
   -0.428774166115 +   0.205654171857*_Complex_I,
    0.742768169350 +   1.078779525233*_Complex_I,
   -0.760778783880 +  -0.392123510805*_Complex_I,
    0.530474251890 +   0.355891481054*_Complex_I,
    1.455692020840 +   0.275438176816*_Complex_I,
   -0.256274791959 +  -1.055463927568*_Complex_I,
    1.397683977888 +  -1.672842861191*_Complex_I,
    1.059395488056 +  -1.195826863369*_Complex_I,
    0.535641711388 +  -0.139593755691*_Complex_I,
    0.767194249054 +   1.159606442946*_Complex_I,
    0.730248752053 +   0.874096637495*_Complex_I,
    0.374817248354 +   0.381042720649*_Complex_I,
   -1.290660859871 +  -1.052408951473*_Complex_I,
   -0.698710060780 +  -0.404862720632*_Complex_I,
    0.260762012984 +  -0.586144943477*_Complex_I,
    0.471825306906 +   0.216309496806*_Complex_I,
    0.902145392649 +   0.734793058179*_Complex_I,
    0.970712066057 +   1.203301629983*_Complex_I,
    0.697414298916 +  -0.091399436653*_Complex_I,
   -0.763151612464 +  -0.155822503488*_Complex_I,
    0.571013025643 +  -0.991520969075*_Complex_I,
    0.488145846303 +   0.518072470835*_Complex_I,
    0.382903596789 +  -0.570642408749*_Complex_I,
   -0.068409602398 +  -0.457729632233*_Complex_I,
    0.328633596900 +  -0.485642431490*_Complex_I,
    1.463236532852 +  -0.689222532447*_Complex_I,
    0.843726237994 +   1.027737725483*_Complex_I,
    0.411174457800 +   1.072703354585*_Complex_I,
   -0.553638496687 +   0.592560929746*_Complex_I,
   -0.519820674211 +   0.395335990219*_Complex_I,
    0.816739721990 +   1.296561601952*_Complex_I,
    0.839055358910 +   0.038232944058*_Complex_I,
   -1.321845319423 +   2.461463566622*_Complex_I,
   -1.244535108317 +  -0.855331739033*_Complex_I,
    0.174834515541 +  -0.236103345803*_Complex_I,
   -0.817712897113 +   0.503960726952*_Complex_I,
   -0.723518973851 +   0.751673530926*_Complex_I,
   -0.189283180062 +   0.644019002779*_Complex_I,
    0.237729751553 +   0.335607912526*_Complex_I,
   -0.969216001025 +  -0.603266829416*_Complex_I,
   -0.207478679057 +  -0.730339402811*_Complex_I,
   -0.024191569913 +  -1.259252874185*_Complex_I,
    1.472785074216 +  -0.491418040669*_Complex_I,
    0.143580527900 +  -1.186038294726*_Complex_I,
    0.835958076660 +   1.651209544972*_Complex_I,
   -1.330070431715 +   0.745655269480*_Complex_I,
   -2.351132556248 +   1.414206325062*_Complex_I,
   -0.647960722564 +   0.019824747070*_Complex_I,
    0.054504089094 +  -0.434505484307*_Complex_I,
   -1.069009000323 +   0.930859192631*_Complex_I,
    2.256466805965 +   0.677754214770*_Complex_I,
   -1.017788464214 +   0.299270915482*_Complex_I,
   -1.350006249149 +   0.860365863370*_Complex_I,
    0.554243078961 +   1.630321512911*_Complex_I,
   -1.709590344454 +  -0.169567705711*_Complex_I,
    0.650774374311 +   0.064592934208*_Complex_I,
    1.989755256430 +   0.536482018456*_Complex_I,
   -0.373249333538 +  -0.106134582591*_Complex_I,
    0.095351627343 +  -0.279297038594*_Complex_I,
    0.230789928160 +   0.532796285505*_Complex_I,
    0.247854968690 +  -2.153358768182*_Complex_I,
    0.136098798048 +   1.135668579132*_Complex_I,
   -0.208329927938 +   0.789350627066*_Complex_I,
    0.039858273209 +  -0.599940553834*_Complex_I,
   -0.117101531764 +   0.201275502180*_Complex_I,
    0.817971264476 +  -1.329760648517*_Complex_I,
    0.035980481979 +  -0.922818951948*_Complex_I,
   -1.888935382734 +  -1.797450884362*_Complex_I,
   -0.097016985104 +  -1.168628933267*_Complex_I,
    0.452048304507 +  -0.675116763083*_Complex_I,
   -1.209707805549 +   0.172148052410*_Complex_I,
    1.432472352322 +   0.632406226221*_Complex_I,
    2.933280640140 +   0.949590441066*_Complex_I,
   -0.309024453832 +   1.192611727581*_Complex_I,
   -0.255306372880 +   0.007559617013*_Complex_I,
    0.081653931435 +  -0.672920464273*_Complex_I,
    0.405276164696 +  -0.077841212841*_Complex_I,
   -0.338396874520 +   0.355225122224*_Complex_I,
    0.109601214660 +   1.392547443330*_Complex_I,
   -1.871393476572 +   0.310989021924*_Complex_I,
    0.332233956611 +   1.730122993833*_Complex_I,
    1.439926026777 +  -1.611064773734*_Complex_I,
   -1.860778448552 +   0.425384165779*_Complex_I,
    0.274648666779 +   1.286600320037*_Complex_I,
    0.762615580678 +  -0.222402755827*_Complex_I,
    0.426513801822 +   1.965805792967*_Complex_I,
   -0.103171697634 +  -0.569960476279*_Complex_I,
    1.562067509000 +  -2.347766792543*_Complex_I,
    0.467044769684 +   0.321342630659*_Complex_I,
   -1.416578640685 +  -0.831113210732*_Complex_I,
   -0.733167805614 +   1.176375168746*_Complex_I,
   -1.282613845051 +  -0.979773114694*_Complex_I,
    0.506103347478 +  -1.085270279646*_Complex_I,
    2.539137831319 +   2.232625718408*_Complex_I,
   -1.637899545016 +   0.265528606195*_Complex_I,
   -1.931767882639 +   0.329066225098*_Complex_I,
    0.127023806083 +   0.504962043815*_Complex_I,
    0.588353928765 +  -1.463911658760*_Complex_I,
    0.907010785485 +  -0.108879037057*_Complex_I,
   -0.951802902717 +  -0.685757383062*_Complex_I,
    1.723143501154 +  -0.419300229480*_Complex_I,
   -0.943119843417 +   0.652144368853*_Complex_I,
   -0.851586780301 +  -1.516257192307*_Complex_I,
    0.472227887604 +   1.052236419944*_Complex_I,
    0.113888251161 +  -1.124587148028*_Complex_I,
    0.051529667469 +  -0.136410527640*_Complex_I,
   -0.647857223628 +   0.431204980149*_Complex_I,
    1.349209612218 +  -0.768179692308*_Complex_I,
   -0.026826971021 +  -0.545234111539*_Complex_I,
   -0.514071604921 +  -0.664124619949*_Complex_I,
    0.320778745077 +   1.111997835236*_Complex_I,
   -0.232562962611 +  -0.669159856913*_Complex_I,
   -0.896014800467 +   0.082046851667*_Complex_I,
   -0.167690950519 +  -1.119443226265*_Complex_I,
   -0.433053084055 +  -0.204133858571*_Complex_I,
   -1.567141147453 +  -0.972571871430*_Complex_I,
   -1.040971048402 +   0.473975308345*_Complex_I,
   -1.551423307502 +  -0.934406696693*_Complex_I,
    1.267729903934 +   2.062089282704*_Complex_I,
   -0.814068862944 +  -0.268491284145*_Complex_I,
    0.721715833176 +  -0.368317000932*_Complex_I,
   -0.236677967201 +  -1.031498627296*_Complex_I,
   -0.027596539058 +  -0.526943246450*_Complex_I,
    0.607765602666 +   0.747238787304*_Complex_I,
    0.442222664332 +  -0.844428479402*_Complex_I,
   -0.584746227099 +   0.008876873310*_Complex_I,
    0.249251666407 +   1.120945916837*_Complex_I,
    0.406090989317 +  -0.832304494623*_Complex_I,
   -1.420792340638 +   0.417700569682*_Complex_I,
    0.469433523536 +  -0.703036988315*_Complex_I,
    0.799192929845 +   0.584252218542*_Complex_I,
   -0.846345284557 +  -0.125059394154*_Complex_I,
    0.187771816466 +   0.373470766869*_Complex_I,
   -2.668531322148 +   0.189825888614*_Complex_I,
    0.684689436275 +   1.519032618934*_Complex_I,
   -0.452797714368 +   1.843053037274*_Complex_I,
   -0.614449241246 +  -0.006236652039*_Complex_I,
    0.929289964606 +   0.965819481866*_Complex_I,
    0.800433661968 +   0.829558429420*_Complex_I,
   -1.088281420026 +  -0.801332579437*_Complex_I,
   -0.080346758942 +   0.412114096369*_Complex_I,
    1.491530334351 +  -0.037720112002*_Complex_I,
   -1.419313834957 +   1.309423611663*_Complex_I,
    0.626194884901 +   0.448698878768*_Complex_I,
    1.062456184701 +  -1.574268630848*_Complex_I,
   -0.284112227827 +   0.550018601059*_Complex_I,
   -0.080443635589 +  -1.362211376503*_Complex_I,
    0.383016098417 +   1.081967093575*_Complex_I,
    0.484156075687 +  -0.162493291081*_Complex_I,
   -0.632696839217 +  -1.499586717062*_Complex_I,
    1.771132365818 +  -0.691460076219*_Complex_I,
    1.177429509865 +  -0.486631740300*_Complex_I,
    0.452912528112 +   1.368403825897*_Complex_I,
    0.007493867542 +  -0.269397882793*_Complex_I,
   -1.107355722972 +   0.037650076863*_Complex_I,
   -0.524329801696 +   1.542074025962*_Complex_I,
    0.448469395501 +   0.620253813644*_Complex_I,
    0.937797278085 +   0.094893367525*_Complex_I,
    0.244627220423 +  -0.865982595984*_Complex_I,
   -0.620857271928 +   1.618502476045*_Complex_I,
   -0.727959747987 +  -1.748132622853*_Complex_I,
   -1.814748553219 +   0.357659723379*_Complex_I,
   -1.190951476209 +  -0.302683547331*_Complex_I,
   -0.642926196548 +  -0.441431483518*_Complex_I,
    0.906018063143 +  -0.456267895782*_Complex_I,
    1.658412527962 +   0.602929674812*_Complex_I,
   -1.372573150919 +  -0.165247494352*_Complex_I,
    0.701050669178 +   0.784117117798*_Complex_I,
   -1.093947418964 +  -2.169417895648*_Complex_I,
   -0.619306010978 +   0.346306836794*_Complex_I,
   -1.153602396000 +   0.310559458662*_Complex_I,
    1.857961002742 +   1.662749378565*_Complex_I,
    0.726892056406 +   0.559412940831*_Complex_I,
    0.618501787181 +   0.753344508665*_Complex_I,
    0.060088823625 +  -1.132388678000*_Complex_I,
   -0.790715886898 +   1.256189591885*_Complex_I,
   -1.346611550340 +  -1.002213804884*_Complex_I,
   -0.153748736848 +  -1.273877582585*_Complex_I,
   -1.102237529635 +  -1.113178017398*_Complex_I,
   -0.526084982723 +   1.255781208343*_Complex_I,
   -0.738929991536 +   1.454321302002*_Complex_I,
   -1.015352909554 +   0.057528759460*_Complex_I,
    0.675998598897 +  -0.143860246243*_Complex_I,
    0.189558927003 +   0.513691656677*_Complex_I,
    0.009183574378 +   0.963901374647*_Complex_I,
   -0.163787067951 +  -1.522554558143*_Complex_I,
    0.302708128196 +   0.904573259262*_Complex_I,
    0.975710589669 +  -1.011907000330*_Complex_I,
   -0.117268931532 +   0.858171829955*_Complex_I,
   -1.306428434179 +   0.113727230388*_Complex_I,
   -0.959251067394 +   0.253171642011*_Complex_I,
    0.898435910380 +   0.293195734212*_Complex_I,
   -0.621680975624 +  -0.582564866291*_Complex_I,
    0.179461744683 +   0.209868112155*_Complex_I,
   -0.203784114877 +  -0.011115684099*_Complex_I,
    1.795424157294 +  -0.117231500488*_Complex_I,
    0.015989098360 +  -0.642768987364*_Complex_I,
   -1.375016631330 +  -2.085463142461*_Complex_I,
   -0.655990108553 +   0.722884678316*_Complex_I,
    1.172312994480 +  -0.355468862899*_Complex_I,
   -0.564442301948 +   0.323979441156*_Complex_I,
    0.899045729865 +  -1.148993122117*_Complex_I,
    1.045854100254 +   1.711078921366*_Complex_I,
    0.592020255938 +   0.219085296351*_Complex_I,
    0.118211086528 +  -1.123504917557*_Complex_I,
    0.233426106939 +  -1.883587119594*_Complex_I,
   -0.301438222142 +  -0.697732158432*_Complex_I,
    0.312117398590 +  -0.010728436711*_Complex_I,
   -0.956339212238 +   0.275577083186*_Complex_I,
    1.086666854829 +  -1.181802410378*_Complex_I,
    1.074818739604 +  -0.636045956563*_Complex_I,
    0.644130821770 +  -0.481626402565*_Complex_I,
    0.055564592606 +  -0.355383569012*_Complex_I,
   -1.710794754131 +  -0.311499134725*_Complex_I,
   -1.357530095316 +   1.586038700811*_Complex_I,
    0.643883320289 +  -1.661496495893*_Complex_I,
    0.916591063253 +   0.463263213793*_Complex_I,
    0.795060678890 +   0.253692839397*_Complex_I,
   -0.353293483561 +  -0.793786778605*_Complex_I,
    1.523091692648 +   1.009541299320*_Complex_I,
   -0.351467193764 +  -0.233882680674*_Complex_I,
   -1.006204919749 +  -1.722099827433*_Complex_I,
   -0.425646600377 +  -0.067539377037*_Complex_I,
   -2.152456912795 +   0.355174573898*_Complex_I,
   -1.397998826498 +   0.043192513073*_Complex_I,
    0.463250457123 +   0.785418638026*_Complex_I,
    0.551007796000 +  -0.600950335023*_Complex_I,
    1.336913064335 +   0.299718316993*_Complex_I,
    0.576007704981 +  -0.703000454871*_Complex_I,
    0.501091983740 +   0.079592846760*_Complex_I,
    0.178571647134 +  -0.055720934489*_Complex_I,
    0.843544810635 +   0.526236292547*_Complex_I,
    1.354311088400 +  -0.480046041766*_Complex_I,
   -1.121411263124 +  -0.220337368903*_Complex_I,
    0.018969956960 +  -0.526588981826*_Complex_I,
   -0.874090913826 +   1.731623994129*_Complex_I,
   -1.108295529258 +   1.163520621835*_Complex_I,
   -0.656720377715 +   0.245096653391*_Complex_I,
    0.625251262223 +   1.662769471886*_Complex_I,
    0.503819391123 +  -1.441549149924*_Complex_I,
   -0.164837089741 +  -0.715463798642*_Complex_I,
    0.355362378583 +   2.159694721953*_Complex_I,
   -0.008848280750 +  -0.018260892822*_Complex_I,
   -0.136686667816 +   1.182755498355*_Complex_I,
   -0.136433742988 +   0.851417981048*_Complex_I,
   -0.395460120756 +   0.812014412771*_Complex_I,
    0.025308338705 +   0.630907052235*_Complex_I,
    1.006681294297 +   1.783315896794*_Complex_I,
   -0.402626477026 +   0.776761257059*_Complex_I,
   -1.317690399125 +   0.130484673594*_Complex_I,
   -0.868791706762 +  -0.642771615764*_Complex_I,
    0.137146795180 +  -0.102157755198*_Complex_I,
    1.633710393863 +  -0.768782548860*_Complex_I,
   -0.867759427420 +   1.601477458878*_Complex_I,
   -1.157703488657 +  -0.206031874994*_Complex_I,
    0.041016911327 +  -1.180389310249*_Complex_I,
   -0.189738035969 +  -0.713067619743*_Complex_I,
    0.933408353482 +   1.194576784859*_Complex_I,
    0.514861178855 +   0.368016550894*_Complex_I,
    0.881690626307 +   2.753761417447*_Complex_I,
   -0.133670635264 +   1.543292970173*_Complex_I,
    2.091596895159 +  -0.093690078394*_Complex_I,
   -1.188956830982 +  -0.114523278237*_Complex_I,
   -0.053197690454 +   0.907571243350*_Complex_I,
    0.401291232622 +  -0.415340086801*_Complex_I,
   -0.681924799342 +   0.669543900292*_Complex_I,
    0.530696047517 +  -0.997585317896*_Complex_I,
   -0.533192039121 +  -1.431729688530*_Complex_I,
    0.536364895113 +   1.169805471895*_Complex_I,
   -1.016375434615 +  -1.450239121127*_Complex_I,
   -1.561071693564 +  -0.170486342837*_Complex_I,
   -0.183747193975 +  -0.977837337154*_Complex_I,
   -0.181940033627 +  -0.248171826564*_Complex_I,
   -0.328526087010 +  -0.030637600322*_Complex_I,
   -1.002704137273 +  -0.085997551664*_Complex_I,
    1.368038996286 +  -0.141325193319*_Complex_I,
    0.403836121556 +   2.008528522943*_Complex_I,
   -0.810518568790 +  -0.149400127852*_Complex_I,
   -0.693120904958 +  -1.117715197785*_Complex_I,
    1.558993909095 +  -2.012078672111*_Complex_I,
    0.029046234836 +  -1.049286048426*_Complex_I,
    0.790327688876 +   0.101616687460*_Complex_I,
   -0.401919211737 +  -0.430529168165*_Complex_I,
    0.287473232440 +  -0.564999246068*_Complex_I,
    1.716421030546 +  -0.404965480273*_Complex_I,
    0.050376052116 +   0.795529162825*_Complex_I,
   -1.281143070062 +   0.808984215487*_Complex_I,
   -2.314127686421 +  -0.020801982220*_Complex_I,
    1.606737133361 +   0.283817403079*_Complex_I,
    0.355463854549 +   0.044155238023*_Complex_I,
   -1.076907023070 +   0.442916691766*_Complex_I,
    0.087222702651 +   1.349524189157*_Complex_I,
   -1.625272715780 +   0.294000847904*_Complex_I,
    2.355923230363 +   0.786258163154*_Complex_I,
    0.590797134194 +  -1.524824299804*_Complex_I,
   -0.247232063439 +   0.027525184425*_Complex_I,
    0.422150431137 +   0.191460073698*_Complex_I,
    0.333205469444 +   0.566695459783*_Complex_I,
    2.040179995474 +  -0.033523279638*_Complex_I,
    1.708801210517 +  -0.514673828477*_Complex_I,
   -1.148367840353 +   0.175705040636*_Complex_I,
   -0.208810451052 +   1.955963982995*_Complex_I,
    0.277462389542 +   0.341691402206*_Complex_I,
    1.115415958264 +   0.268951601110*_Complex_I,
    0.039043618322 +   1.093842223424*_Complex_I,
    0.154656090432 +  -2.528281845522*_Complex_I,
   -0.169580739559 +   1.232275509700*_Complex_I,
   -0.117411131677 +  -1.002389093350*_Complex_I,
    0.035928732692 +   2.439878625945*_Complex_I,
   -0.332442060919 +   0.086411580288*_Complex_I,
    1.801599291824 +  -0.728371893507*_Complex_I,
    2.510167669033 +   0.293277743476*_Complex_I,
    1.336012143828 +   0.553373968985*_Complex_I,
    0.179581375233 +   0.219695624924*_Complex_I,
    0.593263517685 +   0.407445722133*_Complex_I,
    0.684624183099 +   0.589697664907*_Complex_I,
   -2.496382874468 +   0.024438752127*_Complex_I,
   -2.222694698779 +   1.701453939912*_Complex_I,
    0.154420002119 +  -1.338536134506*_Complex_I,
    0.256365846642 +  -0.981555435302*_Complex_I,
    0.646498405245 +   1.015323083702*_Complex_I,
    1.816099125502 +  -0.873689502536*_Complex_I,
    0.973113786206 +   0.638143551822*_Complex_I,
    1.082802452802 +   0.054273301693*_Complex_I,
   -1.477958702052 +  -1.876253882821*_Complex_I,
   -1.509174430498 +  -1.366946689175*_Complex_I,
    0.770200379893 +  -0.037358369644*_Complex_I,
    0.020528472364 +   0.071112924686*_Complex_I,
    1.163573145482 +   0.270667445496*_Complex_I,
   -0.685276141620 +   1.042179563446*_Complex_I,
   -1.450457525407 +  -0.619572993396*_Complex_I,
   -1.087848848412 +   0.747504403403*_Complex_I,
    0.182987452127 +   0.130972663746*_Complex_I,
   -0.146555893049 +   0.691910395951*_Complex_I,
   -1.735762675547 +  -0.761410376033*_Complex_I,
    0.130810608875 +  -1.132633564866*_Complex_I,
    0.393865724887 +  -0.821588251430*_Complex_I,
    1.287503514649 +  -0.355212207325*_Complex_I,
    0.319345692829 +  -1.117466320715*_Complex_I,
    0.418623558075 +  -1.759140288875*_Complex_I,
    1.041852719916 +   0.176006788980*_Complex_I,
   -0.297227854618 +   0.227296263697*_Complex_I,
   -0.164089543129 +  -1.043612906074*_Complex_I,
    0.008690483342 +   1.110377157604*_Complex_I,
   -0.219664588199 +   0.427614664824*_Complex_I,
    1.343587074840 +   0.375898274813*_Complex_I,
    1.490739162431 +   0.021350208856*_Complex_I,
    0.945367199263 +   0.180821025970*_Complex_I,
    0.522231273825 +  -0.497986782057*_Complex_I,
    0.523336519862 +  -0.933508311700*_Complex_I,
    0.496982629732 +   1.473461947118*_Complex_I,
   -0.003062144935 +  -0.162840951249*_Complex_I,
    0.984875642474 +  -0.848717378538*_Complex_I,
   -0.461516263319 +  -0.685745084807*_Complex_I,
   -1.175877458107 +  -0.177846365813*_Complex_I,
   -0.932200203193 +   1.107705439242*_Complex_I,
    1.406397814811 +   0.054681766136*_Complex_I,
    1.109360316168 +  -1.679067648707*_Complex_I,
    0.924696326741 +   0.067692426194*_Complex_I,
   -0.000830800316 +  -0.473092403298*_Complex_I,
   -0.731674917791 +  -0.551769981624*_Complex_I,
   -0.569303781517 +  -0.006801228336*_Complex_I,
    0.110391386502 +  -1.899793883492*_Complex_I,
    0.814109796724 +  -0.160466492041*_Complex_I,
    1.138698851351 +  -0.625131274654*_Complex_I,
   -1.963957708898 +   0.775152493271*_Complex_I,
   -1.659897790238 +   1.056053755857*_Complex_I,
   -0.649474775762 +   1.460655545851*_Complex_I,
   -0.741388571452 +  -1.820826399375*_Complex_I,
   -1.572911393570 +   1.569354704216*_Complex_I,
    0.744026763162 +   0.835499539241*_Complex_I,
    0.095754291390 +   0.796930944242*_Complex_I,
    0.507814608179 +   0.818154740321*_Complex_I,
   -0.383708274783 +  -0.068423423510*_Complex_I,
   -0.888346025964 +   0.571095503271*_Complex_I,
    0.925179546159 +  -1.052147910287*_Complex_I,
   -0.438552116998 +  -0.225556401800*_Complex_I,
    1.164226743249 +   0.148695281475*_Complex_I,
    0.964606990498 +   0.259930491349*_Complex_I,
   -0.343680793432 +   0.578310893020*_Complex_I,
    0.093080205932 +   1.723388863831*_Complex_I,
   -0.756655985085 +   0.681598873690*_Complex_I,
    0.939758986711 +   0.011205851149*_Complex_I,
   -0.141899272761 +   0.521507574016*_Complex_I,
   -0.716208197806 +   1.303295936061*_Complex_I,
   -0.813031307398 +   1.372568923775*_Complex_I,
    1.023111911832 +  -0.701776162450*_Complex_I,
   -0.059513464951 +  -0.562779118569*_Complex_I,
   -1.783877678017 +   1.123340885741*_Complex_I,
   -0.129189002044 +   0.152272891142*_Complex_I,
    0.594929872664 +   0.920537744435*_Complex_I,
    0.958591761922 +   1.041651647113*_Complex_I,
    0.496121593665 +  -0.038971974072*_Complex_I,
    0.184620294659 +  -2.865914521972*_Complex_I,
   -0.173289102032 +   1.628057214738*_Complex_I,
   -1.450876580978 +  -1.542121010661*_Complex_I,
   -0.585624617416 +  -0.000140441111*_Complex_I,
   -0.165171139738 +  -0.792078084035*_Complex_I,
    1.008588335837 +   2.483679153708*_Complex_I,
   -1.101668002181 +  -0.867864575222*_Complex_I,
    1.778741775885 +   1.238012027547*_Complex_I,
    0.418624110589 +  -0.516903858622*_Complex_I,
   -0.623664358679 +   0.685852774278*_Complex_I,
    1.473049190104 +  -0.824653187025*_Complex_I,
   -1.125651402746 +  -0.051861075402*_Complex_I,
    0.942173492837 +   0.284253723912*_Complex_I,
    1.468609011081 +   0.872878783090*_Complex_I,
   -0.523118553730 +   0.065885163104*_Complex_I,
   -1.209516269354 +   1.712795511905*_Complex_I,
   -0.164914664862 +  -1.060198690347*_Complex_I,
    0.081083509872 +   0.514122164431*_Complex_I,
    0.014993899314 +  -0.421407997613*_Complex_I,
    0.921737261188 +  -0.891135385409*_Complex_I,
   -0.186548224004 +   0.410695725270*_Complex_I,
   -0.138866088362 +  -0.530179759052*_Complex_I};

float complex fft_test_y509[] = {
   15.695701816574 +  18.430646076972*_Complex_I,
   17.496535538521 +   6.323908273548*_Complex_I,
  -15.330535795607 + -16.826373817993*_Complex_I,
  -22.995137994536 +   5.848541065489*_Complex_I,
  -29.715938835044 +  12.754412174777*_Complex_I,
   10.901257286656 +  -8.716929489684*_Complex_I,
  -19.628646037487 +  19.226286624799*_Complex_I,
  -20.480875354016 + -31.897908691975*_Complex_I,
   35.124732513036 +  16.324491517218*_Complex_I,
   46.193539420959 +  25.851763792302*_Complex_I,
    5.792757151559 + -12.926180930790*_Complex_I,
  -22.013847261245 +  -5.613610031493*_Complex_I,
    9.404166069447 +  -0.019908771755*_Complex_I,
    8.201675624257 +  -8.967673070400*_Complex_I,
   15.181089874097 +  -6.297364574465*_Complex_I,
   14.570696506052 +  -1.051310941558*_Complex_I,
   -1.882106797398 +  -5.240669196133*_Complex_I,
  -14.868309562238 +   6.106637681928*_Complex_I,
  -15.129890494726 +  -2.984311531498*_Complex_I,
    4.030179316698 + -51.075734845707*_Complex_I,
  -34.365285768090 +   9.975973436808*_Complex_I,
  -10.705381975285 +  -9.109285126921*_Complex_I,
   -9.128619721470 + -32.793223942182*_Complex_I,
   -3.884615181749 +   5.589810405219*_Complex_I,
  -53.818876953386 +   9.826695061389*_Complex_I,
    7.391928508119 +  -6.174427305668*_Complex_I,
   -9.942167986468 + -39.833241210704*_Complex_I,
   -1.462704472474 +  -2.725068915079*_Complex_I,
   -8.330269618062 +  -2.806674135719*_Complex_I,
   25.194669213199 +  30.149530622780*_Complex_I,
   24.265507703667 +  35.899758345115*_Complex_I,
    8.921289067584 +   4.788182047802*_Complex_I,
  -43.846571049868 + -11.381289894906*_Complex_I,
   30.751599932238 +  20.081621692604*_Complex_I,
   12.282504139594 + -23.757854873259*_Complex_I,
   29.365318997990 + -23.868021174550*_Complex_I,
  -18.191992659645 +  23.039066554514*_Complex_I,
  -26.138981350472 + -27.807762467872*_Complex_I,
    4.906806518050 + -64.830853635320*_Complex_I,
   17.645400306096 +   6.438919813853*_Complex_I,
   -8.877478921993 +  22.121925579022*_Complex_I,
   -8.857083278794 +   2.248345191669*_Complex_I,
  -10.165898578719 +  14.029663983838*_Complex_I,
   -4.760350989354 +  14.471217793420*_Complex_I,
   10.088121839257 +  10.378681492497*_Complex_I,
    8.818549764286 +  28.002638865768*_Complex_I,
   15.815201542566 +  -8.171918556057*_Complex_I,
   11.043628161039 +  -4.557146048106*_Complex_I,
  -15.424873625059 +  -1.742974782342*_Complex_I,
    5.374423440509 +  15.897637103576*_Complex_I,
   10.405830658480 +   5.110319843375*_Complex_I,
  -26.501807327618 + -12.862253830222*_Complex_I,
    8.361320271594 + -12.127500776378*_Complex_I,
   -7.065209772913 + -13.109659416735*_Complex_I,
    6.150458328525 +  21.558378724678*_Complex_I,
   19.192390552195 +  57.078335145777*_Complex_I,
   16.247539210043 +  -5.178795721988*_Complex_I,
   -2.182213653083 + -31.382522380551*_Complex_I,
   -3.317969463714 +  -1.385753951871*_Complex_I,
   24.974480529165 +  22.521516957567*_Complex_I,
   29.614215910955 +  22.614533535316*_Complex_I,
    6.616213388437 +  -6.945021315685*_Complex_I,
  -21.081077266042 +  27.911030510024*_Complex_I,
  -16.921827301441 +  18.479208860530*_Complex_I,
    8.043988870051 + -36.113906522591*_Complex_I,
   41.917272128407 +  26.843086076462*_Complex_I,
  -13.727079990761 +   5.205402325839*_Complex_I,
   -4.984705459021 +  -6.291381865515*_Complex_I,
   -2.300982364859 + -21.708353496884*_Complex_I,
   32.721343545850 + -16.032669392585*_Complex_I,
    0.519352193540 +  45.753678340865*_Complex_I,
   31.562265581157 +  -4.268866755468*_Complex_I,
  -40.236062083037 +  -2.384241501530*_Complex_I,
  -30.936637211857 +   3.338370340206*_Complex_I,
  -21.959385231675 +   0.895928669913*_Complex_I,
    7.483781797051 + -52.076927900468*_Complex_I,
  -64.519015760392 +  10.979148490947*_Complex_I,
  -28.029903074937 +   7.946066875195*_Complex_I,
   -0.807954143368 +  10.641591910611*_Complex_I,
   34.165604774109 + -19.071113266579*_Complex_I,
   10.309282793998 + -14.648195920539*_Complex_I,
   26.307206562160 +   3.878504634615*_Complex_I,
  -21.207352431217 +  12.063691363252*_Complex_I,
  -54.243540120475 +  -0.287217034895*_Complex_I,
  -32.080496755198 +  30.540317997631*_Complex_I,
    9.760803073410 +  16.055868478901*_Complex_I,
  -16.078558738770 +  -5.356833086497*_Complex_I,
   36.213555936943 + -24.363868386505*_Complex_I,
  -10.697416407844 +  24.319983619540*_Complex_I,
   17.684302893605 + -12.378065186883*_Complex_I,
   41.844539573965 + -46.705571091504*_Complex_I,
  -24.945971628906 + -10.079221453585*_Complex_I,
  -10.513894508491 +  -4.599940107164*_Complex_I,
   26.189867010892 + -17.124071629849*_Complex_I,
  -34.363585674086 +  -4.077385676473*_Complex_I,
  -32.102375469900 +  18.736917526908*_Complex_I,
  -20.887619654518 + -54.461316084166*_Complex_I,
    0.064775230615 +  24.195856216286*_Complex_I,
   32.270028792805 +  48.132373628158*_Complex_I,
   -1.916807810798 + -12.903225028783*_Complex_I,
   -1.669256173251 +  16.652308679485*_Complex_I,
   -3.071210123118 +  18.164002571879*_Complex_I,
   17.931710499892 + -13.922708426108*_Complex_I,
   19.373112705930 +   8.858054642852*_Complex_I,
    1.712477146172 + -34.349666851373*_Complex_I,
    3.720328613972 + -37.016904392694*_Complex_I,
    5.546925594994 +  -0.892192373145*_Complex_I,
  -22.124438618468 + -41.843458261756*_Complex_I,
  -19.235688566387 +  -2.162824631740*_Complex_I,
   21.783941115220 +  -6.695594391248*_Complex_I,
   33.493805068723 +  62.763842873419*_Complex_I,
  -10.896810929881 +  -8.404131804641*_Complex_I,
   18.216817415924 + -33.590802005326*_Complex_I,
  -25.763824584844 +  -6.302405967415*_Complex_I,
  -15.929448259002 +  49.656053432255*_Complex_I,
   -2.645182567345 +   3.823015231654*_Complex_I,
   33.565352588744 + -14.801476451303*_Complex_I,
   34.780028538088 +  14.782512818128*_Complex_I,
   22.270348337592 +  17.396233784708*_Complex_I,
  -23.998646351712 +  -2.572970386926*_Complex_I,
   -5.212660897164 + -38.032125746868*_Complex_I,
   -5.937127593805 + -21.823373120555*_Complex_I,
   12.376774565444 +  33.920254294747*_Complex_I,
   19.629474738185 +  -7.562284518099*_Complex_I,
  -25.524838793958 + -25.917842984307*_Complex_I,
    7.908690793819 +  53.160190581823*_Complex_I,
  -22.547459647000 + -31.810110557445*_Complex_I,
   14.825411801114 +  -2.623765490622*_Complex_I,
   21.016615330301 +  22.000151402955*_Complex_I,
   -3.127363744257 + -13.350072969695*_Complex_I,
  -57.702154359177 + -15.154831462388*_Complex_I,
  -13.446876000722 + -13.069388640893*_Complex_I,
   -2.176317185084 +  17.496721580831*_Complex_I,
  -54.132263906341 +  16.018239354033*_Complex_I,
   -3.699736432956 +  27.741980074527*_Complex_I,
   -7.311559889274 + -20.665154049268*_Complex_I,
    6.161991265193 +  -5.267960280914*_Complex_I,
   -0.083765300728 + -15.394352140009*_Complex_I,
  -10.209228018076 +  -6.471795099909*_Complex_I,
   -0.812704485184 +  -3.943529308850*_Complex_I,
   -3.174962269778 + -37.702639197964*_Complex_I,
   14.138710546364 +  11.048967022727*_Complex_I,
    6.870463853253 +  10.314002260772*_Complex_I,
    3.221828051661 +  51.234801230509*_Complex_I,
   -2.186983936437 +  38.473329840101*_Complex_I,
   13.533239595473 +  16.037592135971*_Complex_I,
   39.103943522729 +   7.078614835194*_Complex_I,
   30.565445217772 +  12.659846713522*_Complex_I,
   30.303359360199 + -34.312315640466*_Complex_I,
  -20.057347170511 +  50.200448109342*_Complex_I,
   15.117190448180 +   7.835893578929*_Complex_I,
  -15.209082571565 +  10.364865373220*_Complex_I,
    9.144422828705 + -66.027702727533*_Complex_I,
  -18.356336362499 + -27.596404803404*_Complex_I,
  -21.642296590182 + -23.328234101983*_Complex_I,
  -38.679552975441 + -27.294969526274*_Complex_I,
  -17.537683264549 +  11.145767113244*_Complex_I,
  -28.415217286677 +   2.450538508370*_Complex_I,
   -7.839159290091 +   9.590153493395*_Complex_I,
   -4.077913680565 +   3.514849319651*_Complex_I,
   36.547874214296 + -13.621221107484*_Complex_I,
   14.644978554755 + -21.980389507971*_Complex_I,
   -3.073299724899 +  -8.758687284937*_Complex_I,
   35.118241555864 + -42.903789231571*_Complex_I,
  -22.783245832308 +  -9.082081737025*_Complex_I,
  -25.929291660507 +  18.758508598154*_Complex_I,
   33.025142390877 +   5.904152955421*_Complex_I,
   11.948227318252 +   2.161590454494*_Complex_I,
   -1.006102550557 + -28.161894386541*_Complex_I,
   45.136250419544 +   3.976787326589*_Complex_I,
  -33.291978336755 +   0.798986604330*_Complex_I,
   11.265970488150 +  -1.327315667000*_Complex_I,
    3.519436365736 +  16.927952719295*_Complex_I,
  -33.602300462457 +  32.163188907263*_Complex_I,
   -8.361310619248 +  -8.809090782568*_Complex_I,
   11.294901581957 +  -4.245164072484*_Complex_I,
   14.566011481616 +  26.519668998172*_Complex_I,
   14.769898592012 +  56.527707423485*_Complex_I,
   33.116957851259 +  -1.090132926951*_Complex_I,
   20.848136410578 +  10.345884350214*_Complex_I,
   18.958342797158 +   6.566708563840*_Complex_I,
   15.396069027712 + -31.284159225464*_Complex_I,
    2.886181696729 +  18.205515439993*_Complex_I,
    2.258601161648 + -12.548779081296*_Complex_I,
   18.639723094734 + -13.486140556024*_Complex_I,
  -11.071519074610 + -19.339094005264*_Complex_I,
   16.895170033002 +  -9.987185658559*_Complex_I,
   -3.870068718996 +  22.233540496971*_Complex_I,
    8.964139966565 + -27.313941129646*_Complex_I,
  -17.059785268381 +  -4.400625859198*_Complex_I,
   -6.175147302779 +  30.096445776903*_Complex_I,
   18.669084089316 +   6.968259188573*_Complex_I,
    7.657184873046 + -41.697203143381*_Complex_I,
  -33.549050077833 +  24.392895555181*_Complex_I,
   13.852529446346 + -24.121363551436*_Complex_I,
   -8.184532144280 + -21.955892305419*_Complex_I,
  -19.335525950576 +  31.604135153122*_Complex_I,
   30.219851790692 +   9.312089638267*_Complex_I,
   -9.099736227858 +  10.891340718152*_Complex_I,
    8.000001281397 + -11.689007297193*_Complex_I,
   15.301942508385 + -30.427794390813*_Complex_I,
   -7.727208416300 +  13.998979881879*_Complex_I,
   -6.394185171364 +   3.146108002402*_Complex_I,
    9.252474513141 + -16.461589767495*_Complex_I,
   26.863242542498 +  24.608331497751*_Complex_I,
   46.975091007265 + -22.976780803246*_Complex_I,
  -46.543917156055 +  15.869672486948*_Complex_I,
   -4.728161553855 +  29.037018944500*_Complex_I,
    4.070927662548 + -36.042387888924*_Complex_I,
   14.921971168495 +  30.690814385233*_Complex_I,
   35.791446149577 +   4.619796889845*_Complex_I,
    2.303273709336 +  11.205822209351*_Complex_I,
    8.168201691579 + -10.908743400107*_Complex_I,
   -0.043567851626 +  24.059334278527*_Complex_I,
    7.466916906592 +  18.610504314019*_Complex_I,
    7.031977571019 +  -9.358602921852*_Complex_I,
    5.391773391774 +  -0.966245883858*_Complex_I,
    3.392189608224 + -10.986430122434*_Complex_I,
   34.562609814015 +  40.520419348321*_Complex_I,
   -9.427806154592 +  14.449317738714*_Complex_I,
  -28.980935248249 +  35.723542184020*_Complex_I,
  -25.087680212574 + -12.353756547678*_Complex_I,
  -10.456225394292 +  26.299032407868*_Complex_I,
   -3.551781425808 +  36.487758403775*_Complex_I,
  -13.555856836256 +  11.377498259126*_Complex_I,
   -5.711875186735 +  63.014002174535*_Complex_I,
    8.802482546452 +  -9.877617002550*_Complex_I,
   12.398023754693 + -17.252746153510*_Complex_I,
   48.590307765142 + -39.869959281353*_Complex_I,
   -4.228834590895 + -16.849706340702*_Complex_I,
    1.157565934241 +  10.439891849608*_Complex_I,
    6.162905961542 + -42.121455332219*_Complex_I,
   18.623319771899 +   6.782479204326*_Complex_I,
   40.359667537403 +  -5.227038429096*_Complex_I,
    3.960846512784 +  -2.184979700635*_Complex_I,
  -11.294281203268 +   1.462688924503*_Complex_I,
    4.235940899795 +  -5.069039031037*_Complex_I,
  -19.757480291431 + -19.995127344309*_Complex_I,
    9.293994179429 +  30.574726633130*_Complex_I,
  -11.912765926945 +   1.982525086253*_Complex_I,
   32.506223545239 + -17.228481622244*_Complex_I,
   23.261121675341 + -41.619757453530*_Complex_I,
  -16.699711374017 +  17.184396509178*_Complex_I,
  -30.981944222728 +  18.381540125799*_Complex_I,
  -28.134836328395 +  -9.882313867372*_Complex_I,
  -40.216518853122 +   7.954899537374*_Complex_I,
  -17.952578865387 +  27.478809719211*_Complex_I,
  -28.849862783745 +   0.512912610070*_Complex_I,
   21.721522411732 +  -6.115881482201*_Complex_I,
  -82.815498795687 +  -8.942733727142*_Complex_I,
    3.740277816696 + -14.522905567941*_Complex_I,
  -35.229732095265 +  26.709488731346*_Complex_I,
   11.290125122898 +  24.224877496545*_Complex_I,
  -16.635941007754 +   8.630637395391*_Complex_I,
   22.134876007936 +   2.574582351782*_Complex_I,
   33.251774617807 +   5.457413908840*_Complex_I,
   -3.124095302802 + -30.945315750230*_Complex_I,
   25.380261145256 + -12.895408190578*_Complex_I,
   29.590560891351 + -35.336175817647*_Complex_I,
   23.190389336153 + -51.584432366600*_Complex_I,
   23.182126536797 + -30.991661680296*_Complex_I,
  -37.142295822241 +   7.721940476748*_Complex_I,
   26.833304952389 +  15.281809854672*_Complex_I,
    3.795011817607 +  47.705908075813*_Complex_I,
   44.822699796166 +   4.630736159645*_Complex_I,
   20.899042041270 +   2.487657439412*_Complex_I,
    8.742060078106 +   9.864203556590*_Complex_I,
   16.980059178338 +  35.222546217902*_Complex_I,
  -19.255543627730 +   9.410996006466*_Complex_I,
   21.517616907420 +  26.338377945165*_Complex_I,
   48.642251867035 +   6.924884525443*_Complex_I,
   23.548326097336 +  10.784367397399*_Complex_I,
  -11.550545599595 + -22.108959248798*_Complex_I,
   16.733078720638 +  -6.587000041071*_Complex_I,
  -24.552765736255 +  20.310652954928*_Complex_I,
   17.292953612417 +  29.643678070378*_Complex_I,
    9.373109698654 +  24.904713123755*_Complex_I,
   25.238503675115 + -15.183892795659*_Complex_I,
   -1.508310287534 + -32.049583340956*_Complex_I,
   -1.442670825788 + -39.824563428950*_Complex_I,
    3.230145000210 + -25.420530195927*_Complex_I,
   13.229685977004 + -14.075607613923*_Complex_I,
  -19.526361502130 + -29.370000953029*_Complex_I,
  -21.782631521002 + -37.617721671791*_Complex_I,
   27.816003478663 +  24.303079202481*_Complex_I,
  -43.381077867759 +  24.837480951743*_Complex_I,
   -9.560217395595 +   2.382563375055*_Complex_I,
   -1.168465306817 +   1.589115227489*_Complex_I,
   52.542490127417 +   1.424383301004*_Complex_I,
  -10.794625364629 + -19.749473263855*_Complex_I,
   26.168847841768 + -26.658825280073*_Complex_I,
    4.233092270819 + -48.303662607018*_Complex_I,
   -5.014341149907 + -33.130134324155*_Complex_I,
    9.190470374905 + -26.953795736734*_Complex_I,
   -2.846241405053 +  -0.651859597413*_Complex_I,
  -20.225979212962 + -24.560140693339*_Complex_I,
  -10.802336686843 +  51.446188240204*_Complex_I,
   -9.492345818087 + -27.286465734423*_Complex_I,
  -24.394227434292 +  36.495286678206*_Complex_I,
   -4.610288224660 +  13.785902137795*_Complex_I,
   25.266817655154 +   8.853318181494*_Complex_I,
   -1.108114899344 +  -8.902780819762*_Complex_I,
  -34.949213732955 +  16.304692482063*_Complex_I,
   12.401176411050 + -49.617470306114*_Complex_I,
   13.450715987122 +  23.780568951393*_Complex_I,
    0.327891662517 +  20.945521301723*_Complex_I,
  -24.347872941432 + -20.261920769569*_Complex_I,
   -3.742508301325 +  15.297035114593*_Complex_I,
   20.157765205649 +  -2.771550168366*_Complex_I,
  -26.861338262008 +  10.330263597466*_Complex_I,
  -19.103391377917 +  29.070399414699*_Complex_I,
   33.355739256457 +   0.786653290415*_Complex_I,
  -15.811410357704 +  12.334342632002*_Complex_I,
  -31.067213179934 +   4.812703947794*_Complex_I,
  -38.464666136613 +  -9.734460624273*_Complex_I,
  -27.018641211199 + -10.676307399360*_Complex_I,
   10.601332462223 +  12.602266185181*_Complex_I,
  -14.863945203402 +  18.405001560411*_Complex_I,
    6.151006234331 +  -1.325265142280*_Complex_I,
   10.654450023041 +  24.877489064003*_Complex_I,
    7.753711320427 + -24.877496668386*_Complex_I,
   14.215523169674 +  15.750750989795*_Complex_I,
   10.063422021746 +  49.306566727230*_Complex_I,
  -83.835199786581 + -35.146747496108*_Complex_I,
   -0.218459362048 +  -0.770721115796*_Complex_I,
   22.431242892732 + -36.430877828612*_Complex_I,
   17.435164403992 + -17.764746880777*_Complex_I,
  -18.336005961075 + -40.785661916947*_Complex_I,
   -9.708667273758 +  -6.212236081880*_Complex_I,
   15.661415503945 + -23.058769144173*_Complex_I,
    6.754601945166 + -19.307935713609*_Complex_I,
   21.850846235150 +   8.741417315883*_Complex_I,
   25.652896421543 +   2.796534004126*_Complex_I,
   -1.843079544502 +   1.784869908972*_Complex_I,
   -2.568058272174 + -31.336348759351*_Complex_I,
  -23.530597236048 +  17.793870333201*_Complex_I,
   41.700575857144 +   9.089193485713*_Complex_I,
   44.662282998158 +  -3.699022752392*_Complex_I,
   29.042445473764 + -11.349519417295*_Complex_I,
   -7.073983554684 +  29.402856163434*_Complex_I,
   19.939374137561 + -20.731019858441*_Complex_I,
  -27.044678373347 + -39.264065270489*_Complex_I,
   20.211317017215 +  41.386816030545*_Complex_I,
    1.043164784676 +  -2.519947587522*_Complex_I,
   -6.375700266136 + -29.785712929923*_Complex_I,
  -27.700591743931 +  16.461560631605*_Complex_I,
   10.095278660268 +   2.666042949098*_Complex_I,
    6.614197587453 + -36.267409940122*_Complex_I,
    3.024977063712 +  22.518622158190*_Complex_I,
   22.730131517026 +  14.937191189086*_Complex_I,
    0.061498915482 + -33.204005635365*_Complex_I,
    3.246333795519 +  12.298349815877*_Complex_I,
    5.921582958906 +  20.790686987339*_Complex_I,
   22.777331137604 +   6.555360530677*_Complex_I,
   21.199065974566 +  30.692801789200*_Complex_I,
   -1.064699299018 + -30.735783458333*_Complex_I,
    1.711968922160 +   2.764830482799*_Complex_I,
   57.479865205031 +  14.741051010187*_Complex_I,
   -5.222691142638 + -12.945556728288*_Complex_I,
   24.618941208703 +  -8.335156868108*_Complex_I,
    5.362345191955 + -29.659123854849*_Complex_I,
  -13.759594910763 +  -2.839225605024*_Complex_I,
   -0.744944069183 +   9.536259763486*_Complex_I,
   -7.266281313994 +  -9.788530410618*_Complex_I,
  -16.072026028887 +  16.172115574565*_Complex_I,
   -6.901619139003 +  -7.747255335591*_Complex_I,
  -16.302588968059 +  -9.014933207001*_Complex_I,
   -9.878306363842 + -19.984075902846*_Complex_I,
    2.088664771255 +  -8.999802528190*_Complex_I,
  -21.345209871678 + -33.541210734395*_Complex_I,
   12.617534995502 + -12.378687252061*_Complex_I,
   10.047409736042 +  -6.607933917427*_Complex_I,
    9.334831941537 +  10.948924308348*_Complex_I,
   25.695968260034 +   7.063988558158*_Complex_I,
   -9.625298547784 +  16.677076422518*_Complex_I,
   -3.108963319630 +   3.376941849928*_Complex_I,
  -47.044223301845 + -22.447723404064*_Complex_I,
    6.172396063478 +   3.130567372603*_Complex_I,
  -12.391233504725 + -18.965209575430*_Complex_I,
    7.816421386094 + -18.829210484343*_Complex_I,
    2.299165958987 +  21.664313726413*_Complex_I,
   23.073574880632 + -40.647794133271*_Complex_I,
   11.788478207223 +  10.388520650659*_Complex_I,
    2.495494346482 + -40.903748493834*_Complex_I,
    9.204196215081 +   3.731305183829*_Complex_I,
  -11.705334181886 +  -5.698373301119*_Complex_I,
  -10.576847226819 + -24.400174262686*_Complex_I,
    1.125349170571 + -42.931316430041*_Complex_I,
  -34.927593970119 +  15.363588886694*_Complex_I,
   -5.051369474478 +  57.553472286872*_Complex_I,
  -17.737882109182 +  20.993190450070*_Complex_I,
   37.177637689060 +  16.991173325998*_Complex_I,
   44.283601354742 +  17.412222591528*_Complex_I,
   36.495623940354 + -20.061033291263*_Complex_I,
   -0.821113211121 +  -3.092318774340*_Complex_I,
  -22.377701901316 + -16.198210370561*_Complex_I,
   12.319993479497 + -21.923811281565*_Complex_I,
   15.511676349072 +  -9.483307137734*_Complex_I,
   20.189875802738 + -17.301968082172*_Complex_I,
   -5.805824615680 + -36.079316378374*_Complex_I,
   30.255637146078 + -44.362762846218*_Complex_I,
  -20.832965183425 +  -7.304495538217*_Complex_I,
  -13.022907320332 + -57.530437725034*_Complex_I,
  -10.564105798288 + -34.560059804429*_Complex_I,
   21.361954258419 + -36.855969871716*_Complex_I,
    4.506530938557 +  32.048954769246*_Complex_I,
  -33.027950438924 +  28.211482991964*_Complex_I,
  -29.352439177975 +  26.783042078482*_Complex_I,
  -28.424459734912 +  -8.558362358430*_Complex_I,
  -19.967959416569 +  10.959195107292*_Complex_I,
  -23.791686165010 +  32.501306546259*_Complex_I,
  -33.216256571387 +   2.738726266389*_Complex_I,
    8.569384712402 +   1.130870024297*_Complex_I,
   28.525451062286 +  17.073062203997*_Complex_I,
   -1.502286920189 + -10.160446478808*_Complex_I,
   -6.861394365693 +  36.910381121986*_Complex_I,
   -6.268440765630 + -17.493038905156*_Complex_I,
   11.322039030102 + -23.206689618074*_Complex_I,
   -8.701154518730 +  34.222038681525*_Complex_I,
  -24.669027160846 + -36.326555770368*_Complex_I,
   20.943711343327 + -24.033336369879*_Complex_I,
   29.209555657259 + -20.413413259064*_Complex_I,
   -2.572238542979 + -20.816303598934*_Complex_I,
   -1.994249544729 +  23.007487924841*_Complex_I,
  -44.905945955860 +  29.216643846282*_Complex_I,
  -24.062162530228 +  12.109221679204*_Complex_I,
  -12.180111153692 +  17.875695962678*_Complex_I,
   20.435116656247 +   5.797199859832*_Complex_I,
    3.493004564937 +  -5.812772133417*_Complex_I,
  -27.034394973848 +  24.948810080561*_Complex_I,
   21.936211599800 +  -5.553436322258*_Complex_I,
   -4.478679537619 +  -2.641131963451*_Complex_I,
    5.120700840097 +   6.186528528634*_Complex_I,
  -47.624247374659 + -34.895963725954*_Complex_I,
  -43.479965560285 +  10.001886840601*_Complex_I,
  -20.718614873021 +  24.908643623897*_Complex_I,
    9.472646766463 +  -4.586461637219*_Complex_I,
    9.294883958873 +   5.219642918744*_Complex_I,
   24.547287109336 +  15.988189397184*_Complex_I,
   12.811611969328 + -60.146862637486*_Complex_I,
   33.520279815394 +  29.907221430910*_Complex_I,
  -14.152533165001 + -16.446995449346*_Complex_I,
   23.465425390528 +  -4.669981744595*_Complex_I,
  -29.290184394031 +  -6.824899055323*_Complex_I,
   36.044925366731 +  39.699979702815*_Complex_I,
   45.609805078654 +  -0.363597033482*_Complex_I,
   12.247988815457 +  -6.993931713410*_Complex_I,
   14.744368729437 +   4.566968366531*_Complex_I,
   -3.612287261480 + -31.882623904258*_Complex_I,
   -4.625837065570 + -49.204985934025*_Complex_I,
   10.369874666738 +  23.286668162235*_Complex_I,
  -29.995409795889 +  22.748837275811*_Complex_I,
    7.693482749378 +  12.894738140873*_Complex_I,
  -74.632562519909 + -20.685236968252*_Complex_I,
   24.465299052921 + -16.879295578319*_Complex_I,
  -17.287451187811 +  -5.253265233981*_Complex_I,
  -12.792544818057 + -22.347701435426*_Complex_I,
  -30.500042038025 +  -6.625643844530*_Complex_I,
  -25.032206738905 + -11.617648580783*_Complex_I,
  -33.767830120583 + -19.967382042671*_Complex_I,
    8.352625196160 +  -0.210944382477*_Complex_I,
   -2.824794695557 +   7.815259159406*_Complex_I,
  -30.449907818874 + -38.156235692042*_Complex_I,
   34.223672868260 +   5.423974272822*_Complex_I,
   -3.473532089262 + -45.188663541294*_Complex_I,
    1.929635364775 + -17.899772348612*_Complex_I,
  -17.366629103993 +  63.817371804672*_Complex_I,
  -23.515133356267 +  -0.250964260288*_Complex_I,
  -26.558406280873 +   5.464454223022*_Complex_I,
    7.459074663716 +  -5.360173061781*_Complex_I,
   -2.740551125358 + -28.954513936397*_Complex_I,
   26.831634155936 +   7.298762429258*_Complex_I,
   26.189721830795 +  13.528176613886*_Complex_I,
    0.552527132215 +  12.528332436204*_Complex_I,
  -18.980402436415 +  14.388413407600*_Complex_I,
   -2.948074258737 + -26.092284933664*_Complex_I,
   11.237345817375 +  40.862341094348*_Complex_I,
  -31.224869298160 +  17.176727608508*_Complex_I,
    2.721793055983 +  -9.744545888653*_Complex_I,
   -0.776323448517 + -40.995023347911*_Complex_I,
  -49.192082010750 +  11.872769267713*_Complex_I,
  -43.807462185673 +  -6.259081354893*_Complex_I,
   -2.175065114292 +   6.493046453358*_Complex_I,
   23.334296943174 +  19.135612282249*_Complex_I,
   -6.817794711121 +   3.642740073112*_Complex_I,
   11.873498813840 +  37.496197060973*_Complex_I,
   14.779256218032 + -13.159994239230*_Complex_I,
  -19.232512636676 +   5.916208467040*_Complex_I,
   -0.581631693027 +  22.531394609402*_Complex_I,
    1.544210909483 +  14.296122579802*_Complex_I,
    7.044576628257 + -10.190237629704*_Complex_I,
   -4.813365711741 +   7.129670574765*_Complex_I,
   41.167970529260 + -12.916981484001*_Complex_I,
   26.669078124418 + -15.501207232456*_Complex_I,
   12.492422072442 +  -9.037015700661*_Complex_I,
   17.418311261915 +  11.203344744823*_Complex_I,
   18.500273199469 +  19.568644933327*_Complex_I,
  -23.216101473541 +  -2.306087143311*_Complex_I,
   -1.651207984446 +   1.920560461483*_Complex_I,
   22.032664625569 + -67.269204021659*_Complex_I,
    2.687054355440 +  -6.150483980195*_Complex_I,
  -42.445780624117 + -52.847480030760*_Complex_I,
  -18.575368994624 + -11.378786258777*_Complex_I,
   12.874123481209 +  11.199236114650*_Complex_I,
    6.553360933113 +  -7.014357063713*_Complex_I,
   24.351668075370 +  32.239707779122*_Complex_I,
   -3.293543380713 +  15.964518188392*_Complex_I,
  -15.175792848341 +  -2.924538577813*_Complex_I,
   17.561582795484 +  -3.560828531875*_Complex_I};

