/*
 * Copyright (c) 2007 - 2015 Joseph Gaeddert
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

//
// fftfilt_cccf_data_h13x256.c: autotest fftfilt data
//

#include <complex.h>

float complex fftfilt_cccf_data_h13x256_h[] = {
    0.101274943352 +  -0.122793912888*_Complex_I,
    0.058305418491 +  -0.133282411098*_Complex_I,
    0.040646758676 +  -0.024372637272*_Complex_I,
    0.079661983252 +  -0.054072910547*_Complex_I,
    0.001840994880 +   0.061087465286*_Complex_I,
   -0.087824678421 +  -0.017600339651*_Complex_I,
    0.218935108185 +  -0.191448485851*_Complex_I,
    0.063519352674 +   0.238570642471*_Complex_I,
    0.062901532650 +   0.024227905273*_Complex_I,
    0.047201344371 +  -0.122910189629*_Complex_I,
   -0.052710837126 +  -0.028337442875*_Complex_I,
    0.155722010136 +  -0.206684422493*_Complex_I,
    0.158807659149 +  -0.032457110286*_Complex_I};

float complex fftfilt_cccf_data_h13x256_x[] = {
    0.033812573552 +   0.167574334145*_Complex_I,
   -0.180972433090 +   0.003268009797*_Complex_I,
   -0.158811461926 +   0.096975576878*_Complex_I,
    0.089864820242 +  -0.129931354523*_Complex_I,
   -0.048388853669 +   0.209818410873*_Complex_I,
   -0.174670159817 +  -0.000558722531*_Complex_I,
    0.184307169914 +  -0.097096782923*_Complex_I,
    0.055431371927 +  -0.085229063034*_Complex_I,
   -0.005678167194 +  -0.008018184453*_Complex_I,
   -0.069053018093 +   0.055740833282*_Complex_I,
   -0.064427644014 +   0.147326159477*_Complex_I,
    0.257856726646 +  -0.008164577186*_Complex_I,
   -0.001989185810 +  -0.019182929397*_Complex_I,
    0.034131622314 +  -0.019393232465*_Complex_I,
    0.107628858089 +   0.122120463848*_Complex_I,
    0.023927879333 +   0.069706928730*_Complex_I,
   -0.053020107746 +  -0.083087205887*_Complex_I,
   -0.080838572979 +  -0.011525543034*_Complex_I,
    0.031260085106 +   0.001133395731*_Complex_I,
   -0.001233685296 +  -0.189275312424*_Complex_I,
   -0.038783121109 +   0.028758850694*_Complex_I,
    0.036648643017 +  -0.011882914603*_Complex_I,
   -0.020449468493 +   0.139192247391*_Complex_I,
   -0.075582921505 +  -0.002107951231*_Complex_I,
   -0.181470632553 +  -0.014771178365*_Complex_I,
    0.026783564687 +  -0.128984892368*_Complex_I,
   -0.047539860010 +   0.222328519821*_Complex_I,
    0.005170624331 +   0.030745416880*_Complex_I,
    0.053824990988 +  -0.026686629653*_Complex_I,
    0.099266970158 +  -0.031245106459*_Complex_I,
    0.039606907964 +  -0.065418809652*_Complex_I,
   -0.127475917339 +   0.064139616489*_Complex_I,
   -0.042834937572 +  -0.150583517551*_Complex_I,
    0.139883732796 +   0.082940441370*_Complex_I,
   -0.064364117384 +  -0.044677674770*_Complex_I,
    0.055855596066 +   0.017247803509*_Complex_I,
   -0.173977994919 +  -0.052533900738*_Complex_I,
    0.027730098367 +   0.080870586634*_Complex_I,
   -0.091971349716 +  -0.051875424385*_Complex_I,
    0.051230835915 +  -0.061945867538*_Complex_I,
   -0.044583868980 +  -0.032021436095*_Complex_I,
    0.068678015471 +  -0.015937516093*_Complex_I,
    0.019641043246 +   0.090001666546*_Complex_I,
   -0.050730788708 +  -0.067964708805*_Complex_I,
   -0.117348599434 +   0.225804829597*_Complex_I,
   -0.024700947106 +  -0.226277422905*_Complex_I,
    0.044463178515 +   0.038473030925*_Complex_I,
    0.146118962765 +   0.228452873230*_Complex_I,
    0.148312568665 +  -0.089482551813*_Complex_I,
    0.002765571699 +   0.218297338486*_Complex_I,
   -0.058677202463 +  -0.040143096447*_Complex_I,
    0.151873219013 +   0.038929876685*_Complex_I,
   -0.054030978680 +   0.087771093845*_Complex_I,
    0.053254860640 +  -0.107342064381*_Complex_I,
   -0.004281488806 +  -0.147849392891*_Complex_I,
    0.124097406864 +  -0.161590623856*_Complex_I,
   -0.083864957094 +   0.077308541536*_Complex_I,
    0.091537797451 +   0.140995931625*_Complex_I,
   -0.099840551615 +   0.043124458194*_Complex_I,
   -0.121636021137 +   0.081380259991*_Complex_I,
   -0.011938279122 +   0.019365566969*_Complex_I,
   -0.029302325845 +  -0.002548613772*_Complex_I,
    0.039761963487 +   0.151991939545*_Complex_I,
    0.057192808390 +  -0.059029465914*_Complex_I,
   -0.095872926712 +  -0.044790551066*_Complex_I,
    0.095753777027 +  -0.164024686813*_Complex_I,
    0.037644055486 +  -0.033171021938*_Complex_I,
    0.071704179049 +   0.047472149134*_Complex_I,
   -0.072857999802 +   0.045551717281*_Complex_I,
   -0.004142929241 +  -0.048290520906*_Complex_I,
   -0.180688798428 +   0.006293178350*_Complex_I,
    0.038382813334 +   0.122165417671*_Complex_I,
   -0.050295007229 +  -0.127239310741*_Complex_I,
   -0.109994089603 +  -0.176806294918*_Complex_I,
    0.085634392500 +  -0.091329562664*_Complex_I,
   -0.137377023697 +   0.066401362419*_Complex_I,
    0.109237027168 +  -0.000195262639*_Complex_I,
   -0.111181199551 +   0.181575310230*_Complex_I,
   -0.088704961538 +   0.101208889484*_Complex_I,
    0.227800679207 +   0.017428271472*_Complex_I,
   -0.072724056244 +  -0.158883297443*_Complex_I,
   -0.046088048816 +   0.034102421999*_Complex_I,
   -0.086277353764 +   0.048207068443*_Complex_I,
    0.189791500568 +   0.111536753178*_Complex_I,
    0.043753921986 +   0.042386168242*_Complex_I,
    0.175305640697 +  -0.077729618549*_Complex_I,
   -0.090353775024 +  -0.086115002632*_Complex_I,
    0.163218414783 +   0.005952451378*_Complex_I,
   -0.010694872588 +   0.037079387903*_Complex_I,
   -0.067783647776 +   0.015387859941*_Complex_I,
   -0.001508052554 +   0.005860465765*_Complex_I,
   -0.103225553036 +  -0.091570162773*_Complex_I,
   -0.181873428822 +  -0.033351799846*_Complex_I,
    0.014190819860 +  -0.107816028595*_Complex_I,
    0.049625259638 +  -0.131252551079*_Complex_I,
   -0.003888563812 +  -0.083181303740*_Complex_I,
   -0.044093203545 +   0.053719127178*_Complex_I,
   -0.059636509418 +  -0.062606734037*_Complex_I,
    0.043757092953 +   0.143932354450*_Complex_I,
    0.023032055795 +  -0.073675203323*_Complex_I,
    0.074079465866 +  -0.133735966682*_Complex_I,
   -0.016778314114 +  -0.077572107315*_Complex_I,
   -0.213720870018 +  -0.010327737033*_Complex_I,
   -0.011057607085 +   0.039916378260*_Complex_I,
    0.108575832844 +  -0.097652089596*_Complex_I,
    0.169485592842 +   0.195236229897*_Complex_I,
   -0.094353854656 +  -0.053460478783*_Complex_I,
   -0.111175501347 +  -0.177497363091*_Complex_I,
    0.004201298580 +  -0.125308763981*_Complex_I,
    0.051966518164 +   0.123850774765*_Complex_I,
   -0.096300393343 +  -0.013914050162*_Complex_I,
    0.106172311306 +  -0.164844048023*_Complex_I,
    0.124734151363 +  -0.008266538382*_Complex_I,
   -0.008394107223 +   0.042837706208*_Complex_I,
   -0.269948434830 +  -0.133680295944*_Complex_I,
    0.077266824245 +   0.018269205093*_Complex_I,
   -0.018016268313 +  -0.040084049106*_Complex_I,
    0.095163732767 +   0.081313228607*_Complex_I,
   -0.208993816376 +  -0.040263220668*_Complex_I,
    0.064939141273 +  -0.018769615889*_Complex_I,
   -0.037253284454 +  -0.092296826839*_Complex_I,
    0.123162364960 +   0.068240380287*_Complex_I,
   -0.132501530647 +  -0.228929615021*_Complex_I,
    0.168357527256 +  -0.092901027203*_Complex_I,
    0.088688296080 +  -0.001608422026*_Complex_I,
    0.221683001518 +   0.066785657406*_Complex_I,
    0.083319008350 +  -0.164619421959*_Complex_I,
   -0.057560896873 +   0.080689120293*_Complex_I,
    0.017244935036 +  -0.052605807781*_Complex_I,
   -0.103263401985 +   0.128316771984*_Complex_I,
   -0.048902520537 +   0.101460754871*_Complex_I,
   -0.101036417484 +   0.059622770548*_Complex_I,
   -0.006965886056 +   0.062334090471*_Complex_I,
    0.098089504242 +   0.189659333229*_Complex_I,
   -0.170798206329 +   0.049062070251*_Complex_I,
    0.165300846100 +   0.029215490818*_Complex_I,
   -0.075640136003 +  -0.087369698286*_Complex_I,
   -0.013823843002 +   0.127059864998*_Complex_I,
    0.095502263308 +   0.068228989840*_Complex_I,
    0.171380794048 +  -0.077519750595*_Complex_I,
    0.129892742634 +  -0.012643009424*_Complex_I,
    0.023339818418 +   0.093716734648*_Complex_I,
   -0.058398854733 +   0.106715428829*_Complex_I,
   -0.013301552832 +   0.002579919435*_Complex_I,
    0.088806277514 +  -0.297042322159*_Complex_I,
   -0.046128720045 +   0.126318335533*_Complex_I,
    0.051016080379 +  -0.158195829391*_Complex_I,
   -0.137489342690 +   0.012126408517*_Complex_I,
    0.076124078035 +   0.094534236193*_Complex_I,
    0.055480271578 +   0.034476712346*_Complex_I,
    0.197368288040 +  -0.003630393744*_Complex_I,
   -0.132637274265 +   0.016389763355*_Complex_I,
   -0.018736995757 +   0.069434946775*_Complex_I,
    0.024380022287 +   0.032195645571*_Complex_I,
   -0.110287964344 +   0.105914473534*_Complex_I,
    0.180047070980 +   0.122122013569*_Complex_I,
    0.021164430678 +  -0.021511299908*_Complex_I,
   -0.083895099163 +  -0.094187325239*_Complex_I,
   -0.085609924793 +  -0.089779102802*_Complex_I,
   -0.026364889741 +  -0.034728026390*_Complex_I,
   -0.039741188288 +   0.061549043655*_Complex_I,
   -0.182061326504 +  -0.117300724983*_Complex_I,
    0.051411151886 +  -0.039550358057*_Complex_I,
    0.115115880966 +   0.132340645790*_Complex_I,
   -0.172311210632 +   0.157257282734*_Complex_I,
   -0.066816413403 +   0.050810027122*_Complex_I,
    0.075493675470 +  -0.024358917773*_Complex_I,
    0.037579393387 +  -0.105334246159*_Complex_I,
   -0.032166060805 +   0.304082226753*_Complex_I,
   -0.115465772152 +  -0.083099174500*_Complex_I,
    0.213583827019 +  -0.033120486140*_Complex_I,
    0.049020007253 +   0.103692758083*_Complex_I,
    0.039526313543 +   0.159559214115*_Complex_I,
   -0.014911358058 +  -0.009031812847*_Complex_I,
    0.140197467804 +   0.188218057156*_Complex_I,
   -0.014860840142 +  -0.114006638527*_Complex_I,
    0.111025202274 +  -0.101571118832*_Complex_I,
   -0.031162160635 +  -0.044938939810*_Complex_I,
   -0.088898491859 +  -0.196167945862*_Complex_I,
    0.074709993601 +  -0.042812746763*_Complex_I,
    0.020372083783 +  -0.102141439915*_Complex_I,
    0.036488103867 +   0.061840379238*_Complex_I,
    0.113381445408 +  -0.077737921476*_Complex_I,
    0.003184536844 +   0.024977919459*_Complex_I,
   -0.130429613590 +  -0.062496966124*_Complex_I,
   -0.109437787533 +   0.033421832323*_Complex_I,
   -0.107781338692 +  -0.036825361848*_Complex_I,
   -0.121548032761 +  -0.071893042326*_Complex_I,
   -0.032831138372 +   0.036911919713*_Complex_I,
    0.101628661156 +   0.116993212700*_Complex_I,
   -0.052929800749 +  -0.061160600185*_Complex_I,
   -0.155849313736 +  -0.126586461067*_Complex_I,
   -0.093626201153 +  -0.085899829865*_Complex_I,
    0.093120694160 +   0.010586068779*_Complex_I,
   -0.071643483639 +   0.044553604722*_Complex_I,
    0.096362644434 +  -0.005238156021*_Complex_I,
   -0.191972267628 +   0.062410986423*_Complex_I,
    0.175240826607 +   0.055103266239*_Complex_I,
    0.217493343353 +   0.057524204254*_Complex_I,
    0.137563228607 +   0.136677563190*_Complex_I,
   -0.002121994831 +  -0.160035789013*_Complex_I,
   -0.106702613831 +   0.129322338104*_Complex_I,
    0.077257323265 +   0.190817809105*_Complex_I,
    0.030118304491 +   0.068840289116*_Complex_I,
    0.001969731040 +  -0.019872169197*_Complex_I,
    0.038756659627 +  -0.110168564320*_Complex_I,
   -0.094096481800 +   0.178715145588*_Complex_I,
   -0.045212453604 +  -0.001988123916*_Complex_I,
   -0.050746786594 +  -0.038362777233*_Complex_I,
    0.085383939743 +   0.041049334407*_Complex_I,
   -0.044858980179 +   0.073414093256*_Complex_I,
    0.074703049660 +   0.103927171230*_Complex_I,
    0.055366307497 +  -0.115881478786*_Complex_I,
    0.133115530014 +  -0.054990023375*_Complex_I,
   -0.060879433155 +  -0.052990645170*_Complex_I,
   -0.014458604157 +   0.024620576203*_Complex_I,
    0.035869082808 +   0.070715308189*_Complex_I,
    0.001854417846 +  -0.032330670953*_Complex_I,
    0.217453384399 +  -0.031029167771*_Complex_I,
   -0.012186873704 +   0.007021924853*_Complex_I,
    0.082451862097 +  -0.078747928143*_Complex_I,
   -0.079927939177 +  -0.026517114043*_Complex_I,
   -0.049421241879 +  -0.003672285378*_Complex_I,
   -0.050635516644 +  -0.204359102249*_Complex_I,
    0.114336001873 +  -0.075574308634*_Complex_I,
    0.017275553942 +  -0.004209178686*_Complex_I,
    0.093194973469 +  -0.117229437828*_Complex_I,
    0.055422365665 +   0.058078074455*_Complex_I,
    0.051127582788 +  -0.056875407696*_Complex_I,
   -0.033710032701 +  -0.024449241161*_Complex_I,
    0.098715597391 +   0.075275701284*_Complex_I,
    0.049691435695 +  -0.010312996805*_Complex_I,
   -0.143938088417 +  -0.057803511620*_Complex_I,
    0.004402134567 +  -0.171495795250*_Complex_I,
    0.050372958183 +  -0.030280271173*_Complex_I,
   -0.066968792677 +   0.049716952443*_Complex_I,
   -0.030198466778 +  -0.093219310045*_Complex_I,
    0.020674671233 +   0.049302938581*_Complex_I,
   -0.082176977396 +   0.004003078118*_Complex_I,
    0.051144361496 +  -0.025944027305*_Complex_I,
   -0.136934876442 +   0.030611222982*_Complex_I,
    0.072055798769 +   0.072714412212*_Complex_I,
    0.006607705355 +  -0.154940152168*_Complex_I,
   -0.055419456959 +   0.142084217072*_Complex_I,
    0.127882242203 +  -0.068437719345*_Complex_I,
   -0.028541901708 +   0.125126791000*_Complex_I,
   -0.071173512936 +   0.003831871226*_Complex_I,
   -0.040117982030 +  -0.071510893106*_Complex_I,
   -0.036725261807 +   0.037219762802*_Complex_I,
    0.018186755478 +   0.046204718947*_Complex_I,
    0.145269620419 +   0.059547924995*_Complex_I,
    0.040549764037 +   0.051019173861*_Complex_I,
    0.017368020117 +   0.015167059004*_Complex_I,
    0.018691918254 +  -0.096917903423*_Complex_I,
    0.085063648224 +   0.024469487369*_Complex_I,
    0.107211554050 +  -0.066898560524*_Complex_I};

float complex fftfilt_cccf_data_h13x256_y[] = {
    0.024001474660 +   0.012819102986*_Complex_I,
    0.006379486345 +   0.027817151043*_Complex_I,
   -0.008833116513 +   0.059620513709*_Complex_I,
    0.001290360957 +   0.018691901680*_Complex_I,
   -0.019720088289 +   0.027870569701*_Complex_I,
   -0.000089104333 +   0.022554509191*_Complex_I,
    0.048983753430 +   0.008870419475*_Complex_I,
   -0.059738782036 +   0.031503141884*_Complex_I,
   -0.072004160761 +   0.015777738903*_Complex_I,
   -0.011979216083 +  -0.114153406857*_Complex_I,
    0.084719374355 +   0.122759620341*_Complex_I,
   -0.002652524124 +   0.074081920456*_Complex_I,
   -0.010647425116 +  -0.055247615062*_Complex_I,
    0.009826036454 +   0.077018691837*_Complex_I,
    0.043050527194 +  -0.030195436945*_Complex_I,
    0.096977257426 +   0.014196001707*_Complex_I,
   -0.069749349540 +   0.084922275308*_Complex_I,
   -0.020592821729 +  -0.078815687497*_Complex_I,
    0.015344750806 +   0.046911643882*_Complex_I,
    0.003215160982 +  -0.044654666098*_Complex_I,
    0.045065388666 +  -0.014762372700*_Complex_I,
   -0.000649914548 +   0.078685026348*_Complex_I,
    0.004242245469 +  -0.018256519858*_Complex_I,
    0.068463378080 +   0.002186618045*_Complex_I,
   -0.013886532699 +  -0.006164365808*_Complex_I,
   -0.023002266230 +  -0.024231940574*_Complex_I,
    0.059444806653 +   0.063727454712*_Complex_I,
    0.005199838368 +  -0.013523702394*_Complex_I,
   -0.014439329476 +   0.017624416202*_Complex_I,
   -0.021969811821 +   0.031968738864*_Complex_I,
   -0.099775723814 +  -0.032339826558*_Complex_I,
   -0.023202788664 +  -0.102402077252*_Complex_I,
    0.039130993156 +   0.049187762643*_Complex_I,
   -0.024993065771 +   0.041659056463*_Complex_I,
   -0.035177096744 +   0.034267402820*_Complex_I,
   -0.012813786527 +   0.035585893453*_Complex_I,
   -0.010166359548 +  -0.030098941996*_Complex_I,
    0.035012509492 +   0.104480427481*_Complex_I,
   -0.067925226605 +  -0.033727903935*_Complex_I,
    0.038150929611 +  -0.034144316119*_Complex_I,
   -0.031836563804 +   0.003970737127*_Complex_I,
    0.022331990340 +  -0.044052273250*_Complex_I,
   -0.024273008320 +   0.027787498353*_Complex_I,
   -0.035557076930 +  -0.024109903696*_Complex_I,
   -0.015439201027 +   0.010120871946*_Complex_I,
   -0.005667692817 +   0.009808534446*_Complex_I,
   -0.023993809759 +  -0.001976323260*_Complex_I,
    0.033939569756 +   0.006322746502*_Complex_I,
    0.038339628046 +  -0.021022149468*_Complex_I,
    0.000846072793 +   0.018029554697*_Complex_I,
    0.053339414921 +   0.071529172443*_Complex_I,
   -0.104230849664 +  -0.080895763503*_Complex_I,
    0.071647820798 +  -0.030732758724*_Complex_I,
    0.101421268066 +   0.054142700304*_Complex_I,
   -0.070017141172 +  -0.048691110375*_Complex_I,
    0.071783266356 +   0.132628048489*_Complex_I,
   -0.125892768778 +  -0.020392469132*_Complex_I,
    0.077534371443 +  -0.106386873570*_Complex_I,
    0.118899511278 +   0.091045477209*_Complex_I,
    0.019035177150 +   0.019334344232*_Complex_I,
    0.072542950409 +   0.021775500164*_Complex_I,
    0.018913391291 +  -0.008423771096*_Complex_I,
    0.068880105631 +   0.006805725914*_Complex_I,
    0.070165826853 +  -0.001076549347*_Complex_I,
   -0.092150026143 +   0.032247576962*_Complex_I,
   -0.065407227079 +  -0.006168603538*_Complex_I,
   -0.051509544946 +  -0.131615847220*_Complex_I,
   -0.001170276180 +  -0.019427264753*_Complex_I,
    0.083364051792 +   0.041323212038*_Complex_I,
    0.007295606110 +   0.057364049960*_Complex_I,
   -0.057103564464 +   0.118719947312*_Complex_I,
    0.004531748675 +  -0.012147464062*_Complex_I,
    0.012749373222 +  -0.030480391526*_Complex_I,
    0.011125930632 +   0.028825825693*_Complex_I,
   -0.043938238280 +   0.011854121979*_Complex_I,
   -0.075321232264 +  -0.018064459135*_Complex_I,
   -0.060886977242 +  -0.042110048390*_Complex_I,
    0.056409867179 +  -0.045351450134*_Complex_I,
   -0.018186918127 +   0.057805159108*_Complex_I,
   -0.000535255779 +   0.017342658310*_Complex_I,
    0.044187556819 +  -0.080806819744*_Complex_I,
   -0.077107500264 +   0.074314966560*_Complex_I,
   -0.000316037199 +  -0.033151523412*_Complex_I,
    0.004502285827 +   0.096977958968*_Complex_I,
   -0.093482268512 +   0.004941127824*_Complex_I,
    0.021543628024 +  -0.127138737110*_Complex_I,
   -0.024144738766 +   0.045799607631*_Complex_I,
    0.073683578652 +  -0.012636723694*_Complex_I,
    0.037103315594 +  -0.019525859806*_Complex_I,
   -0.000690801053 +   0.046026880071*_Complex_I,
    0.026954746660 +   0.048691313027*_Complex_I,
    0.007353638085 +   0.001105524364*_Complex_I,
   -0.054855624724 +   0.041421970378*_Complex_I,
    0.022781842217 +  -0.038200366123*_Complex_I,
    0.008043522754 +  -0.024654798773*_Complex_I,
   -0.026166674166 +   0.009031999284*_Complex_I,
    0.015652619885 +  -0.077945632696*_Complex_I,
   -0.049664412838 +  -0.015226397097*_Complex_I,
   -0.011383210898 +  -0.016385255644*_Complex_I,
    0.020234061901 +  -0.066780782463*_Complex_I,
   -0.046755003222 +  -0.039668549878*_Complex_I,
   -0.003720962630 +  -0.011626088440*_Complex_I,
   -0.053663894051 +   0.033112538916*_Complex_I,
   -0.121787017031 +   0.003208574048*_Complex_I,
   -0.028376450272 +  -0.019370775859*_Complex_I,
   -0.047890954007 +  -0.041473896341*_Complex_I,
    0.011519092293 +  -0.078183218332*_Complex_I,
    0.028829438437 +   0.001487290342*_Complex_I,
   -0.075450909852 +   0.021430470386*_Complex_I,
   -0.034355836889 +  -0.040885483718*_Complex_I,
   -0.058002545755 +  -0.068146319622*_Complex_I,
    0.075219933002 +  -0.010912041314*_Complex_I,
   -0.036651133000 +   0.019765597603*_Complex_I,
   -0.098981225134 +  -0.018643142319*_Complex_I,
   -0.032500295138 +  -0.084155976688*_Complex_I,
    0.049578122325 +  -0.016429877737*_Complex_I,
   -0.013361520737 +   0.029138302084*_Complex_I,
   -0.043356913875 +  -0.030952278560*_Complex_I,
    0.014132503851 +  -0.028805299647*_Complex_I,
   -0.017867267512 +   0.026284047653*_Complex_I,
   -0.083047255042 +  -0.017096821986*_Complex_I,
    0.008417904103 +  -0.048597238033*_Complex_I,
   -0.089743880041 +  -0.096283355401*_Complex_I,
    0.035975823890 +  -0.056271631450*_Complex_I,
   -0.015269531402 +   0.017064247022*_Complex_I,
   -0.053012454761 +  -0.057229106407*_Complex_I,
   -0.020365053756 +  -0.125161538208*_Complex_I,
    0.066674345673 +   0.011158699255*_Complex_I,
   -0.036133831454 +  -0.011201495817*_Complex_I,
    0.016361003153 +  -0.025706876818*_Complex_I,
    0.044163879016 +   0.016897283579*_Complex_I,
    0.016023914791 +   0.021215167172*_Complex_I,
    0.029810334754 +   0.009766734291*_Complex_I,
    0.035636470208 +   0.060987445145*_Complex_I,
   -0.006302550511 +  -0.115013574847*_Complex_I,
    0.051720848730 +  -0.009461663454*_Complex_I,
    0.047973920047 +  -0.016849009904*_Complex_I,
   -0.046701499921 +   0.016919642862*_Complex_I,
    0.043467132678 +  -0.016102822186*_Complex_I,
    0.067871787511 +   0.010066831600*_Complex_I,
   -0.035710415892 +   0.082788003225*_Complex_I,
    0.069725504265 +  -0.005507023393*_Complex_I,
    0.015433685804 +   0.073521250471*_Complex_I,
    0.063438026419 +   0.060901474404*_Complex_I,
    0.041153827196 +  -0.018596637068*_Complex_I,
   -0.048641595104 +   0.055630921150*_Complex_I,
    0.070785738691 +  -0.021001547792*_Complex_I,
    0.030058519696 +   0.002719657788*_Complex_I,
    0.033781571029 +   0.057641496421*_Complex_I,
   -0.011861512115 +  -0.000934312027*_Complex_I,
    0.026823353697 +  -0.148020696569*_Complex_I,
    0.149407622218 +  -0.001917493861*_Complex_I,
    0.031564264895 +  -0.033648864447*_Complex_I,
    0.013500408643 +   0.049606336179*_Complex_I,
    0.018200592161 +   0.054843460925*_Complex_I,
   -0.042220409610 +  -0.057168354901*_Complex_I,
    0.087247514708 +  -0.025386591035*_Complex_I,
   -0.028531902133 +   0.071536103147*_Complex_I,
   -0.025160173288 +  -0.020151250712*_Complex_I,
   -0.022772795332 +  -0.017187718098*_Complex_I,
   -0.029078837193 +   0.069628451313*_Complex_I,
    0.049111894335 +  -0.041621311215*_Complex_I,
   -0.023619794976 +   0.077908526801*_Complex_I,
    0.000333911391 +   0.053474867787*_Complex_I,
    0.029475675088 +  -0.009019730084*_Complex_I,
    0.034174066620 +   0.017898879791*_Complex_I,
    0.065544425508 +   0.045084590196*_Complex_I,
   -0.090015977785 +   0.028850540224*_Complex_I,
   -0.012871094837 +  -0.054608369039*_Complex_I,
    0.047544364344 +   0.008538257328*_Complex_I,
   -0.063104697961 +   0.090294378190*_Complex_I,
   -0.011929275791 +   0.022601352310*_Complex_I,
   -0.047521622205 +   0.007445085519*_Complex_I,
    0.022958962838 +  -0.062917965176*_Complex_I,
    0.214158563544 +   0.108130217870*_Complex_I,
   -0.073961792459 +   0.071479678221*_Complex_I,
   -0.015320084620 +  -0.052303661814*_Complex_I,
    0.077538995397 +   0.033838920671*_Complex_I,
   -0.034556396252 +   0.000838447098*_Complex_I,
    0.000060541807 +  -0.004333615826*_Complex_I,
    0.019595150038 +   0.059919909742*_Complex_I,
   -0.060268723573 +  -0.056864079389*_Complex_I,
    0.125955282742 +  -0.089792980055*_Complex_I,
    0.104088003218 +   0.030894546232*_Complex_I,
   -0.057778045852 +  -0.020383254417*_Complex_I,
    0.072179136454 +  -0.043422298997*_Complex_I,
   -0.033946126046 +   0.018129630965*_Complex_I,
   -0.049055572484 +  -0.016390359113*_Complex_I,
   -0.025066786874 +  -0.031503746350*_Complex_I,
   -0.027009840982 +   0.016252291912*_Complex_I,
   -0.042713013603 +  -0.046577467289*_Complex_I,
   -0.046395432817 +  -0.042034197104*_Complex_I,
   -0.066951975959 +  -0.006293309275*_Complex_I,
   -0.076584206559 +  -0.038789936400*_Complex_I,
    0.005278362238 +  -0.031661049359*_Complex_I,
    0.006878243906 +   0.019853143294*_Complex_I,
   -0.074683265419 +   0.092712646012*_Complex_I,
   -0.048535905143 +   0.066894323514*_Complex_I,
   -0.011718308326 +  -0.093940704974*_Complex_I,
    0.054231403971 +  -0.067545703916*_Complex_I,
    0.027390269161 +   0.013522266374*_Complex_I,
    0.027113327798 +   0.025183265482*_Complex_I,
   -0.041823544233 +   0.108944472361*_Complex_I,
   -0.030438012256 +  -0.063572748831*_Complex_I,
    0.066074070111 +  -0.020231915298*_Complex_I,
    0.069140337649 +   0.114893641537*_Complex_I,
   -0.005919906768 +   0.004293077149*_Complex_I,
    0.056489424450 +   0.068597409742*_Complex_I,
    0.027928885781 +  -0.031072362986*_Complex_I,
    0.033715956662 +   0.016500309835*_Complex_I,
    0.066646875440 +   0.052841945423*_Complex_I,
    0.059048505781 +  -0.044714082918*_Complex_I,
    0.083521538493 +   0.040432491516*_Complex_I,
   -0.015140885802 +   0.007398722932*_Complex_I,
   -0.018685866288 +  -0.005688072534*_Complex_I,
    0.037444281102 +  -0.001275030615*_Complex_I,
    0.009248759930 +   0.000917465357*_Complex_I,
    0.037078087936 +   0.054897922621*_Complex_I,
   -0.032804989991 +  -0.001205514200*_Complex_I,
    0.049475279806 +  -0.034629284571*_Complex_I,
    0.040449266799 +  -0.025094164230*_Complex_I,
    0.028840625614 +  -0.034271290637*_Complex_I,
    0.022502076079 +   0.028207110264*_Complex_I,
   -0.095209370089 +  -0.024287776579*_Complex_I,
    0.036853780217 +  -0.112642535014*_Complex_I,
    0.011055463457 +   0.014755419711*_Complex_I,
   -0.007470671462 +  -0.082840060740*_Complex_I,
    0.049493876654 +  -0.029503227741*_Complex_I,
    0.003287878646 +  -0.011760309552*_Complex_I,
   -0.052454911751 +  -0.135685038742*_Complex_I,
    0.100557451271 +  -0.060727168658*_Complex_I,
    0.030460767615 +  -0.025297334320*_Complex_I,
   -0.041900949710 +  -0.044189282191*_Complex_I,
    0.002239369339 +   0.018583017194*_Complex_I,
   -0.094251314287 +  -0.045638715401*_Complex_I,
   -0.043687223316 +  -0.073236757137*_Complex_I,
    0.042678054726 +  -0.053958008845*_Complex_I,
   -0.000338320251 +  -0.031016295417*_Complex_I,
   -0.017513369486 +   0.046863199684*_Complex_I,
   -0.017742806904 +  -0.098421945495*_Complex_I,
    0.035630421170 +  -0.042774040828*_Complex_I,
    0.023161832990 +   0.056833847742*_Complex_I,
   -0.035822048154 +  -0.064590977441*_Complex_I,
   -0.008387640915 +   0.040501176809*_Complex_I,
   -0.068025770572 +  -0.021755292254*_Complex_I,
    0.001359162188 +  -0.081310455090*_Complex_I,
    0.012404768734 +   0.083535778559*_Complex_I,
   -0.038725035226 +  -0.008917515519*_Complex_I,
   -0.038625918697 +  -0.011541140189*_Complex_I,
    0.023371955995 +   0.096714602422*_Complex_I,
    0.017691840656 +  -0.095198285220*_Complex_I,
    0.045385440171 +   0.068921408368*_Complex_I,
    0.002806803285 +   0.044993613294*_Complex_I,
   -0.033553704471 +  -0.075678324986*_Complex_I,
    0.033838944413 +   0.008301990809*_Complex_I,
    0.001278998079 +  -0.054009422018*_Complex_I};

