/* Copyright (c) 2013, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <msm8x10_wcd_registers.h>
#include "msm8x10-wcd.h"

const u8 msm8x10_wcd_reg_readable[MSM8X10_WCD_CACHE_SIZE] = {
	[MSM8X10_WCD_A_CHIP_CTL] = 1,
	[MSM8X10_WCD_A_CHIP_STATUS] = 1,
	[MSM8X10_WCD_A_CDC_TLMM_MODE_SELECT] = 1,
	[MSM8X10_WCD_A_MODE_LOCK] = 0,
	[MSM8X10_WCD_A_CHIP_ID_BYTE_0] = 1,
	[MSM8X10_WCD_A_CHIP_ID_BYTE_1] = 1,
	[MSM8X10_WCD_A_CHIP_ID_BYTE_2] = 1,
	[MSM8X10_WCD_A_CHIP_ID_BYTE_3] = 1,
	[MSM8X10_WCD_A_CHIP_VERSION] = 1,
	[MSM8X10_WCD_A_ANALOG_SLAVE_ID] = 1,
	[MSM8X10_WCD_A_PIN_CTL_OE] = 1,
	[MSM8X10_WCD_A_PIN_CTL_DATA] = 1,
	[MSM8X10_WCD_A_PIN_STATUS] = 1,
	[MSM8X10_WCD_A_HDRIVE_CTL] = 1,
	[MSM8X10_WCD_A_HDRIVE_I2C_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RST_CTL] = 1,
	[MSM8X10_WCD_A_CDC_TOP_CLK_CTL] = 1,
	[MSM8X10_WCD_A_CDC_ANA_CLK_CTL] = 1,
	[MSM8X10_WCD_A_CDC_DIG_CLK_CTL] = 1,
	[MSM8X10_WCD_A_PROCESS_MONITOR_CTL0] = 1,
	[MSM8X10_WCD_A_PROCESS_MONITOR_CTL1] = 1,
	[MSM8X10_WCD_A_PROCESS_MONITOR_CTL2] = 1,
	[MSM8X10_WCD_A_PROCESS_MONITOR_CTL3] = 1,
	[MSM8X10_WCD_A_QFUSE_CTL] = 1,
	[MSM8X10_WCD_A_QFUSE_STATUS] = 1,
	[MSM8X10_WCD_A_QFUSE_DATA_OUT0] = 1,
	[MSM8X10_WCD_A_QFUSE_DATA_OUT1] = 1,
	[MSM8X10_WCD_A_QFUSE_DATA_OUT2] = 1,
	[MSM8X10_WCD_A_QFUSE_DATA_OUT3] = 1,
	[MSM8X10_WCD_A_CDC_CONN_TX1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_TX2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_HPHR_DAC_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_LO_DAC_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_RX1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_RX2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_RX3_CTL] = 1,
	[MSM8X10_WCD_A_DIGITAL_DEBUG_CTL] = 1,
	[MSM8X10_WCD_A_ANALOG_DEBUG_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX3_CTL] = 1,
	[MSM8X10_WCD_A_DEM_BYPASS_DATA0] = 1,
	[MSM8X10_WCD_A_DEM_BYPASS_DATA1] = 1,
	[MSM8X10_WCD_A_DEM_BYPASS_DATA2] = 1,
	[MSM8X10_WCD_A_DEM_BYPASS_DATA3] = 1,
	[MSM8X10_WCD_A_SPARE_0] = 1,
	[MSM8X10_WCD_A_SPARE_1] = 1,
	[MSM8X10_WCD_A_SPARE_2] = 1,
	[MSM8X10_WCD_A_INTR_MODE] = 1,
	[MSM8X10_WCD_A_INTR_MASK0] = 1,
	[MSM8X10_WCD_A_INTR_MASK1] = 1,
	[MSM8X10_WCD_A_INTR_MASK2] = 1,
	[MSM8X10_WCD_A_INTR_STATUS0] = 1,
	[MSM8X10_WCD_A_INTR_STATUS1] = 1,
	[MSM8X10_WCD_A_INTR_STATUS2] = 1,
	[MSM8X10_WCD_A_INTR_CLEAR0] = 0,
	[MSM8X10_WCD_A_INTR_CLEAR1] = 0,
	[MSM8X10_WCD_A_INTR_CLEAR2] = 0,
	[MSM8X10_WCD_A_INTR_TEST0] = 1,
	[MSM8X10_WCD_A_INTR_TEST1] = 1,
	[MSM8X10_WCD_A_INTR_TEST2] = 1,
	[MSM8X10_WCD_A_INTR_SET0] = 1,
	[MSM8X10_WCD_A_INTR_SET1] = 1,
	[MSM8X10_WCD_A_INTR_SET2] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_EN_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_FIR_B1_CFG] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_FIR_B2_CFG] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_TIMER_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_TIMER_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_TIMER_B3_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_TIMER_B4_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_TIMER_B5_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_TIMER_B6_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_B1_STATUS] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_B2_STATUS] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_B3_STATUS] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_B4_STATUS] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_B5_STATUS] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B3_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B4_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B5_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B6_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B7_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B8_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B9_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B10_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B11_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B12_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_CLK_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_INT_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_DEBUG_CTL] = 1,
	[MSM8X10_WCD_A_CDC_MBHC_SPARE] = 1,
	[MSM8X10_WCD_A_BIAS_REF_CTL] = 1,
	[MSM8X10_WCD_A_BIAS_CENTRAL_BG_CTL] = 1,
	[MSM8X10_WCD_A_BIAS_PRECHRG_CTL] = 1,
	[MSM8X10_WCD_A_BIAS_CURR_CTL_1] = 1,
	[MSM8X10_WCD_A_BIAS_CURR_CTL_2] = 1,
	[MSM8X10_WCD_A_BIAS_OSC_BG_CTL] = 1,
	[MSM8X10_WCD_A_MICB_CFILT_1_CTL] = 1,
	[MSM8X10_WCD_A_MICB_CFILT_1_VAL] = 1,
	[MSM8X10_WCD_A_MICB_CFILT_1_PRECHRG] = 1,
	[MSM8X10_WCD_A_MICB_1_CTL] = 1,
	[MSM8X10_WCD_A_MICB_1_INT_RBIAS] = 1,
	[MSM8X10_WCD_A_MICB_1_MBHC] = 1,
	[MSM8X10_WCD_A_MBHC_INSERT_DETECT] = 1,
	[MSM8X10_WCD_A_MBHC_INSERT_DET_STATUS] = 1,
	[MSM8X10_WCD_A_TX_COM_BIAS] = 1,
	[MSM8X10_WCD_A_MBHC_SCALING_MUX_1] = 1,
	[MSM8X10_WCD_A_MBHC_SCALING_MUX_2] = 1,
	[MSM8X10_WCD_A_RESERVED_MAD_ANA_CTRL] = 1,
	[MSM8X10_WCD_A_TX_SUP_SWITCH_CTRL_1] = 1,
	[MSM8X10_WCD_A_TX_SUP_SWITCH_CTRL_2] = 1,
	[MSM8X10_WCD_A_TX_1_EN] = 1,
	[MSM8X10_WCD_A_TX_2_EN] = 1,
	[MSM8X10_WCD_A_TX_1_2_ADC_CH1] = 1,
	[MSM8X10_WCD_A_TX_1_2_ADC_CH2] = 1,
	[MSM8X10_WCD_A_TX_1_2_ATEST_REFCTRL] = 1,
	[MSM8X10_WCD_A_TX_1_2_TEST_CTL] = 1,
	[MSM8X10_WCD_A_TX_1_2_TEST_BLOCK_EN] = 1,
	[MSM8X10_WCD_A_TX_1_2_TXFE_CLKDIV] = 1,
	[MSM8X10_WCD_A_TX_1_2_SAR_ERR_CH1] = 1,
	[MSM8X10_WCD_A_TX_1_2_SAR_ERR_CH2] = 1,
	[MSM8X10_WCD_A_TX_3_EN] = 1,
	[MSM8X10_WCD_A_TX_1_2_TEST_EN] = 1,
	[MSM8X10_WCD_A_TX_7_MBHC_EN_ATEST_CTRL] = 1,
	[MSM8X10_WCD_A_TX_7_MBHC_SAR_ERR] = 1,
	[MSM8X10_WCD_A_CP_EN] = 1,
	[MSM8X10_WCD_A_CP_CLK] = 1,
	[MSM8X10_WCD_A_CP_STATIC] = 1,
	[MSM8X10_WCD_A_CP_DCC1] = 1,
	[MSM8X10_WCD_A_CP_DCC3] = 1,
	[MSM8X10_WCD_A_CP_ATEST] = 1,
	[MSM8X10_WCD_A_CP_DTEST] = 1,
	[MSM8X10_WCD_A_RX_AUX_SW_CTL] = 1,
	[MSM8X10_WCD_A_RX_PA_AUX_IN_CONN] = 1,
	[MSM8X10_WCD_A_RX_COM_TIMER_DIV] = 1,
	[MSM8X10_WCD_A_RX_COM_OCP_CTL] = 1,
	[MSM8X10_WCD_A_RX_COM_OCP_COUNT] = 1,
	[MSM8X10_WCD_A_RX_COM_DAC_CTL] = 1,
	[MSM8X10_WCD_A_RX_COM_BIAS] = 1,
	[MSM8X10_WCD_A_RX_HPH_AUTO_CHOP] = 1,
	[MSM8X10_WCD_A_RX_HPH_CHOP_CTL] = 1,
	[MSM8X10_WCD_A_RX_HPH_BIAS_PA] = 1,
	[MSM8X10_WCD_A_RX_HPH_BIAS_LDO] = 1,
	[MSM8X10_WCD_A_RX_HPH_BIAS_CNP] = 1,
	[MSM8X10_WCD_A_RX_HPH_BIAS_WG_OCP] = 1,
	[MSM8X10_WCD_A_RX_HPH_OCP_CTL] = 1,
	[MSM8X10_WCD_A_RX_HPH_CNP_EN] = 1,
	[MSM8X10_WCD_A_RX_HPH_CNP_WG_CTL] = 1,
	[MSM8X10_WCD_A_RX_HPH_CNP_WG_TIME] = 1,
	[MSM8X10_WCD_A_RX_HPH_L_GAIN] = 1,
	[MSM8X10_WCD_A_RX_HPH_L_TEST] = 1,
	[MSM8X10_WCD_A_RX_HPH_L_PA_CTL] = 1,
	[MSM8X10_WCD_A_RX_HPH_L_DAC_CTL] = 1,
	[MSM8X10_WCD_A_RX_HPH_L_ATEST] = 1,
	[MSM8X10_WCD_A_RX_HPH_L_STATUS] = 1,
	[MSM8X10_WCD_A_RX_HPH_R_GAIN] = 1,
	[MSM8X10_WCD_A_RX_HPH_R_TEST] = 1,
	[MSM8X10_WCD_A_RX_HPH_R_PA_CTL] = 1,
	[MSM8X10_WCD_A_RX_HPH_R_DAC_CTL] = 1,
	[MSM8X10_WCD_A_RX_HPH_R_ATEST] = 1,
	[MSM8X10_WCD_A_RX_HPH_R_STATUS] = 1,
	[MSM8X10_WCD_A_RX_EAR_BIAS_PA] = 1,
	[MSM8X10_WCD_A_RX_EAR_BIAS_CMBUFF] = 1,
	[MSM8X10_WCD_A_RX_EAR_EN] = 1,
	[MSM8X10_WCD_A_RX_EAR_GAIN] = 1,
	[MSM8X10_WCD_A_RX_EAR_CMBUFF] = 1,
	[MSM8X10_WCD_A_RX_EAR_ICTL] = 1,
	[MSM8X10_WCD_A_RX_EAR_CCOMP] = 1,
	[MSM8X10_WCD_A_RX_EAR_VCM] = 1,
	[MSM8X10_WCD_A_RX_EAR_CNP] = 1,
	[MSM8X10_WCD_A_RX_EAR_DAC_CTL_ATEST] = 1,
	[MSM8X10_WCD_A_RX_EAR_STATUS] = 1,
	[MSM8X10_WCD_A_RX_LINE_BIAS_PA] = 1,
	[MSM8X10_WCD_A_RX_BUCK_BIAS1] = 1,
	[MSM8X10_WCD_A_RX_BUCK_BIAS2] = 1,
	[MSM8X10_WCD_A_RX_LINE_COM] = 1,
	[MSM8X10_WCD_A_RX_LINE_CNP_EN] = 1,
	[MSM8X10_WCD_A_RX_LINE_CNP_WG_CTL] = 1,
	[MSM8X10_WCD_A_RX_LINE_CNP_WG_TIME] = 1,
	[MSM8X10_WCD_A_RX_LINE_1_GAIN] = 1,
	[MSM8X10_WCD_A_RX_LINE_1_TEST] = 1,
	[MSM8X10_WCD_A_RX_LINE_1_DAC_CTL] = 1,
	[MSM8X10_WCD_A_RX_LINE_1_STATUS] = 1,
	[MSM8X10_WCD_A_RX_LINE_CNP_DBG] = 1,
	[MSM8X10_WCD_A_SPKR_DRV_EN] = 1,
	[MSM8X10_WCD_A_SPKR_DRV_GAIN] = 1,
	[MSM8X10_WCD_A_SPKR_DRV_DAC_CTL] = 1,
	[MSM8X10_WCD_A_SPKR_DRV_OCP_CTL] = 1,
	[MSM8X10_WCD_A_SPKR_DRV_CLIP_DET] = 1,
	[MSM8X10_WCD_A_SPKR_DRV_IEC] = 1,
	[MSM8X10_WCD_A_SPKR_DRV_DBG_DAC] = 1,
	[MSM8X10_WCD_A_SPKR_DRV_DBG_PA] = 1,
	[MSM8X10_WCD_A_SPKR_DRV_DBG_PWRSTG] = 1,
	[MSM8X10_WCD_A_SPKR_DRV_BIAS_LDO] = 1,
	[MSM8X10_WCD_A_SPKR_DRV_BIAS_INT] = 1,
	[MSM8X10_WCD_A_SPKR_DRV_BIAS_PA] = 1,
	[MSM8X10_WCD_A_SPKR_DRV_STATUS_OCP] = 1,
	[MSM8X10_WCD_A_SPKR_DRV_STATUS_PA] = 1,
	[MSM8X10_WCD_A_RC_OSC_FREQ] = 1,
	[MSM8X10_WCD_A_RC_OSC_TEST] = 1,
	[MSM8X10_WCD_A_RC_OSC_STATUS] = 1,
	[MSM8X10_WCD_A_RC_OSC_TUNER] = 1,
	[MSM8X10_WCD_A_MBHC_HPH] = 1,
	[MSM8X10_WCD_A_CDC_CLK_RX_RESET_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CLK_TX_RESET_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CLK_DMIC_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CLK_RX_I2S_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CLK_TX_I2S_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CLK_OTHR_RESET_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CLK_TX_CLK_EN_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CLK_OTHR_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CLK_RX_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CLK_MCLK_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CLK_PDM_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CLK_SD_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX1_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX2_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX3_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX1_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX2_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX3_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX1_B3_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX2_B3_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX3_B3_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX1_B4_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX2_B4_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX3_B4_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX1_B5_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX2_B5_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX3_B5_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX1_B6_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX2_B6_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX3_B6_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX1_VOL_CTL_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX2_VOL_CTL_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX3_VOL_CTL_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX1_VOL_CTL_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX2_VOL_CTL_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_RX3_VOL_CTL_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B3_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B4_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CLSG_GAIN_THRESH_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CLSG_TIMER_B1_CFG] = 1,
	[MSM8X10_WCD_A_CDC_CLSG_TIMER_B2_CFG] = 1,
	[MSM8X10_WCD_A_CDC_CLSG_CTL] = 1,
	[MSM8X10_WCD_A_CDC_TX1_VOL_CTL_TIMER] = 1,
	[MSM8X10_WCD_A_CDC_TX2_VOL_CTL_TIMER] = 1,
	[MSM8X10_WCD_A_CDC_TX1_VOL_CTL_GAIN] = 1,
	[MSM8X10_WCD_A_CDC_TX2_VOL_CTL_GAIN] = 1,
	[MSM8X10_WCD_A_CDC_TX1_VOL_CTL_CFG] = 1,
	[MSM8X10_WCD_A_CDC_TX2_VOL_CTL_CFG] = 1,
	[MSM8X10_WCD_A_CDC_TX1_MUX_CTL] = 1,
	[MSM8X10_WCD_A_CDC_TX2_MUX_CTL] = 1,
	[MSM8X10_WCD_A_CDC_TX1_CLK_FS_CTL] = 1,
	[MSM8X10_WCD_A_CDC_TX2_CLK_FS_CTL] = 1,
	[MSM8X10_WCD_A_CDC_TX1_DMIC_CTL] = 1,
	[MSM8X10_WCD_A_CDC_TX2_DMIC_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR1_GAIN_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR2_GAIN_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR1_GAIN_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR2_GAIN_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR1_GAIN_B3_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR2_GAIN_B3_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR1_GAIN_B4_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR2_GAIN_B4_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR1_GAIN_B5_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR2_GAIN_B5_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR1_GAIN_B6_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR2_GAIN_B6_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR1_GAIN_B7_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR2_GAIN_B7_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR1_GAIN_B8_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR2_GAIN_B8_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR1_GAIN_TIMER_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR2_GAIN_TIMER_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR1_COEF_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR2_COEF_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR1_COEF_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_IIR2_COEF_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_RX1_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_RX1_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_RX1_B3_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_RX2_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_RX2_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_RX2_B3_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_RX3_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_RX3_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_TX_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_EQ1_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_EQ1_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_EQ1_B3_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_EQ1_B4_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_EQ2_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_EQ2_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_EQ2_B3_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_EQ2_B4_CTL] = 1,
	[MSM8X10_WCD_A_CDC_CONN_TX_I2S_SD1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_TOP_GAIN_UPDATE] = 1,
	[MSM8X10_WCD_A_CDC_TOP_CTL] = 1,
	[MSM8X10_WCD_A_CDC_DEBUG_DESER1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_DEBUG_DESER2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_DEBUG_B1_CTL] = 1,
	[MSM8X10_WCD_A_CDC_DEBUG_B2_CTL] = 1,
	[MSM8X10_WCD_A_CDC_DEBUG_B3_CTL] = 1,
};

const u8 msm8x10_wcd_reset_reg_defaults[MSM8X10_WCD_CACHE_SIZE] = {
	[MSM8X10_WCD_A_CHIP_CTL] = MSM8X10_WCD_A_CHIP_CTL__POR,
	[MSM8X10_WCD_A_CHIP_STATUS] = MSM8X10_WCD_A_CHIP_STATUS__POR,
	[MSM8X10_WCD_A_CDC_TLMM_MODE_SELECT] =
			MSM8X10_WCD_A_CDC_TLMM_MODE_SELECT__POR,
	[MSM8X10_WCD_A_MODE_LOCK] = MSM8X10_WCD_A_MODE_LOCK__POR,
	[MSM8X10_WCD_A_CHIP_ID_BYTE_0] = MSM8X10_WCD_A_CHIP_ID_BYTE_0__POR,
	[MSM8X10_WCD_A_CHIP_ID_BYTE_1] = MSM8X10_WCD_A_CHIP_ID_BYTE_1__POR,
	[MSM8X10_WCD_A_CHIP_ID_BYTE_2] = MSM8X10_WCD_A_CHIP_ID_BYTE_2__POR,
	[MSM8X10_WCD_A_CHIP_ID_BYTE_3] = MSM8X10_WCD_A_CHIP_ID_BYTE_3__POR,
	[MSM8X10_WCD_A_CHIP_VERSION] = MSM8X10_WCD_A_CHIP_VERSION__POR,
	[MSM8X10_WCD_A_ANALOG_SLAVE_ID] = MSM8X10_WCD_A_ANALOG_SLAVE_ID__POR,
	[MSM8X10_WCD_A_PIN_CTL_OE] = MSM8X10_WCD_A_PIN_CTL_OE__POR,
	[MSM8X10_WCD_A_PIN_CTL_DATA] = MSM8X10_WCD_A_PIN_CTL_DATA__POR,
	[MSM8X10_WCD_A_PIN_STATUS] = MSM8X10_WCD_A_PIN_STATUS__POR,
	[MSM8X10_WCD_A_HDRIVE_CTL] = MSM8X10_WCD_A_HDRIVE_CTL__POR,
	[MSM8X10_WCD_A_HDRIVE_I2C_CTL] = MSM8X10_WCD_A_HDRIVE_I2C_CTL__POR,
	[MSM8X10_WCD_A_CDC_RST_CTL] = MSM8X10_WCD_A_CDC_RST_CTL__POR,
	[MSM8X10_WCD_A_CDC_TOP_CLK_CTL] = MSM8X10_WCD_A_CDC_TOP_CLK_CTL__POR,
	[MSM8X10_WCD_A_CDC_ANA_CLK_CTL] = MSM8X10_WCD_A_CDC_ANA_CLK_CTL__POR,
	[MSM8X10_WCD_A_CDC_DIG_CLK_CTL] = MSM8X10_WCD_A_CDC_DIG_CLK_CTL__POR,
	[MSM8X10_WCD_A_PROCESS_MONITOR_CTL0] =
			MSM8X10_WCD_A_PROCESS_MONITOR_CTL0__POR,
	[MSM8X10_WCD_A_PROCESS_MONITOR_CTL1] =
			MSM8X10_WCD_A_PROCESS_MONITOR_CTL1__POR,
	[MSM8X10_WCD_A_PROCESS_MONITOR_CTL2] =
			MSM8X10_WCD_A_PROCESS_MONITOR_CTL2__POR,
	[MSM8X10_WCD_A_PROCESS_MONITOR_CTL3] =
			MSM8X10_WCD_A_PROCESS_MONITOR_CTL3__POR,
	[MSM8X10_WCD_A_QFUSE_CTL] = MSM8X10_WCD_A_QFUSE_CTL__POR,
	[MSM8X10_WCD_A_QFUSE_STATUS] = MSM8X10_WCD_A_QFUSE_STATUS__POR,
	[MSM8X10_WCD_A_QFUSE_DATA_OUT0] = MSM8X10_WCD_A_QFUSE_DATA_OUT0__POR,
	[MSM8X10_WCD_A_QFUSE_DATA_OUT1] = MSM8X10_WCD_A_QFUSE_DATA_OUT1__POR,
	[MSM8X10_WCD_A_QFUSE_DATA_OUT2] = MSM8X10_WCD_A_QFUSE_DATA_OUT2__POR,
	[MSM8X10_WCD_A_QFUSE_DATA_OUT3] = MSM8X10_WCD_A_QFUSE_DATA_OUT3__POR,
	[MSM8X10_WCD_A_CDC_CONN_TX1_CTL] = MSM8X10_WCD_A_CDC_CONN_TX1_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_TX2_CTL] = MSM8X10_WCD_A_CDC_CONN_TX2_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_HPHR_DAC_CTL] =
			MSM8X10_WCD_A_CDC_CONN_HPHR_DAC_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_LO_DAC_CTL] =
			MSM8X10_WCD_A_CDC_CONN_LO_DAC_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_RX1_CTL] = MSM8X10_WCD_A_CDC_CONN_RX1_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_RX2_CTL] = MSM8X10_WCD_A_CDC_CONN_RX2_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_RX3_CTL] = MSM8X10_WCD_A_CDC_CONN_RX3_CTL__POR,
	[MSM8X10_WCD_A_DIGITAL_DEBUG_CTL] =
			MSM8X10_WCD_A_DIGITAL_DEBUG_CTL__POR,
	[MSM8X10_WCD_A_ANALOG_DEBUG_CTL] = MSM8X10_WCD_A_ANALOG_DEBUG_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX1_CTL] = MSM8X10_WCD_A_CDC_RX1_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX2_CTL] = MSM8X10_WCD_A_CDC_RX2_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX3_CTL] = MSM8X10_WCD_A_CDC_RX3_CTL__POR,
	[MSM8X10_WCD_A_DEM_BYPASS_DATA0] = MSM8X10_WCD_A_DEM_BYPASS_DATA0__POR,
	[MSM8X10_WCD_A_DEM_BYPASS_DATA1] = MSM8X10_WCD_A_DEM_BYPASS_DATA1__POR,
	[MSM8X10_WCD_A_DEM_BYPASS_DATA2] = MSM8X10_WCD_A_DEM_BYPASS_DATA2__POR,
	[MSM8X10_WCD_A_DEM_BYPASS_DATA3] = MSM8X10_WCD_A_DEM_BYPASS_DATA3__POR,
	[MSM8X10_WCD_A_SPARE_0] = MSM8X10_WCD_A_SPARE_0__POR,
	[MSM8X10_WCD_A_SPARE_1] = MSM8X10_WCD_A_SPARE_1__POR,
	[MSM8X10_WCD_A_SPARE_2] = MSM8X10_WCD_A_SPARE_2__POR,
	[MSM8X10_WCD_A_INTR_MODE] = MSM8X10_WCD_A_INTR_MODE__POR,
	[MSM8X10_WCD_A_INTR_MASK0] = MSM8X10_WCD_A_INTR_MASK0__POR,
	[MSM8X10_WCD_A_INTR_MASK1] = MSM8X10_WCD_A_INTR_MASK1__POR,
	[MSM8X10_WCD_A_INTR_MASK2] = MSM8X10_WCD_A_INTR_MASK2__POR,
	[MSM8X10_WCD_A_INTR_STATUS0] = MSM8X10_WCD_A_INTR_STATUS0__POR,
	[MSM8X10_WCD_A_INTR_STATUS1] = MSM8X10_WCD_A_INTR_STATUS1__POR,
	[MSM8X10_WCD_A_INTR_STATUS2] = MSM8X10_WCD_A_INTR_STATUS2__POR,
	[MSM8X10_WCD_A_INTR_CLEAR0] = MSM8X10_WCD_A_INTR_CLEAR0__POR,
	[MSM8X10_WCD_A_INTR_CLEAR1] = MSM8X10_WCD_A_INTR_CLEAR1__POR,
	[MSM8X10_WCD_A_INTR_CLEAR2] = MSM8X10_WCD_A_INTR_CLEAR2__POR,
	[MSM8X10_WCD_A_INTR_TEST0] = MSM8X10_WCD_A_INTR_TEST0__POR,
	[MSM8X10_WCD_A_INTR_TEST1] = MSM8X10_WCD_A_INTR_TEST1__POR,
	[MSM8X10_WCD_A_INTR_TEST2] = MSM8X10_WCD_A_INTR_TEST2__POR,
	[MSM8X10_WCD_A_INTR_SET0] = MSM8X10_WCD_A_INTR_SET0__POR,
	[MSM8X10_WCD_A_INTR_SET1] = MSM8X10_WCD_A_INTR_SET1__POR,
	[MSM8X10_WCD_A_INTR_SET2] = MSM8X10_WCD_A_INTR_SET2__POR,
	[MSM8X10_WCD_A_CDC_MBHC_EN_CTL] = MSM8X10_WCD_A_CDC_MBHC_EN_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_FIR_B1_CFG] =
			MSM8X10_WCD_A_CDC_MBHC_FIR_B1_CFG__POR,
	[MSM8X10_WCD_A_CDC_MBHC_FIR_B2_CFG] =
			MSM8X10_WCD_A_CDC_MBHC_FIR_B2_CFG__POR,
	[MSM8X10_WCD_A_CDC_MBHC_TIMER_B1_CTL] =
			MSM8X10_WCD_A_CDC_MBHC_TIMER_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_TIMER_B2_CTL] =
			MSM8X10_WCD_A_CDC_MBHC_TIMER_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_TIMER_B3_CTL] =
			MSM8X10_WCD_A_CDC_MBHC_TIMER_B3_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_TIMER_B4_CTL] =
			MSM8X10_WCD_A_CDC_MBHC_TIMER_B4_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_TIMER_B5_CTL] =
			MSM8X10_WCD_A_CDC_MBHC_TIMER_B5_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_TIMER_B6_CTL] =
			MSM8X10_WCD_A_CDC_MBHC_TIMER_B6_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_B1_STATUS] =
			MSM8X10_WCD_A_CDC_MBHC_B1_STATUS__POR,
	[MSM8X10_WCD_A_CDC_MBHC_B2_STATUS] =
			MSM8X10_WCD_A_CDC_MBHC_B2_STATUS__POR,
	[MSM8X10_WCD_A_CDC_MBHC_B3_STATUS] =
			MSM8X10_WCD_A_CDC_MBHC_B3_STATUS__POR,
	[MSM8X10_WCD_A_CDC_MBHC_B4_STATUS] =
			MSM8X10_WCD_A_CDC_MBHC_B4_STATUS__POR,
	[MSM8X10_WCD_A_CDC_MBHC_B5_STATUS] =
			MSM8X10_WCD_A_CDC_MBHC_B5_STATUS__POR,
	[MSM8X10_WCD_A_CDC_MBHC_B1_CTL] = MSM8X10_WCD_A_CDC_MBHC_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_B2_CTL] = MSM8X10_WCD_A_CDC_MBHC_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B1_CTL] =
			MSM8X10_WCD_A_CDC_MBHC_VOLT_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B2_CTL] =
			MSM8X10_WCD_A_CDC_MBHC_VOLT_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B3_CTL] =
			MSM8X10_WCD_A_CDC_MBHC_VOLT_B3_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B4_CTL] =
			MSM8X10_WCD_A_CDC_MBHC_VOLT_B4_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B5_CTL] =
			MSM8X10_WCD_A_CDC_MBHC_VOLT_B5_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B6_CTL] =
			MSM8X10_WCD_A_CDC_MBHC_VOLT_B6_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B7_CTL] =
			MSM8X10_WCD_A_CDC_MBHC_VOLT_B7_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B8_CTL] =
			MSM8X10_WCD_A_CDC_MBHC_VOLT_B8_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B9_CTL] =
			MSM8X10_WCD_A_CDC_MBHC_VOLT_B9_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B10_CTL] =
			MSM8X10_WCD_A_CDC_MBHC_VOLT_B10_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B11_CTL] =
			MSM8X10_WCD_A_CDC_MBHC_VOLT_B11_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_VOLT_B12_CTL] =
			MSM8X10_WCD_A_CDC_MBHC_VOLT_B12_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_CLK_CTL] = MSM8X10_WCD_A_CDC_MBHC_CLK_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_INT_CTL] = MSM8X10_WCD_A_CDC_MBHC_INT_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_DEBUG_CTL] =
			MSM8X10_WCD_A_CDC_MBHC_DEBUG_CTL__POR,
	[MSM8X10_WCD_A_CDC_MBHC_SPARE] = MSM8X10_WCD_A_CDC_MBHC_SPARE__POR,
	[MSM8X10_WCD_A_BIAS_REF_CTL] = MSM8X10_WCD_A_BIAS_REF_CTL__POR,
	[MSM8X10_WCD_A_BIAS_CENTRAL_BG_CTL] =
			MSM8X10_WCD_A_BIAS_CENTRAL_BG_CTL__POR,
	[MSM8X10_WCD_A_BIAS_PRECHRG_CTL] = MSM8X10_WCD_A_BIAS_PRECHRG_CTL__POR,
	[MSM8X10_WCD_A_BIAS_CURR_CTL_1] = MSM8X10_WCD_A_BIAS_CURR_CTL_1__POR,
	[MSM8X10_WCD_A_BIAS_CURR_CTL_2] = MSM8X10_WCD_A_BIAS_CURR_CTL_2__POR,
	[MSM8X10_WCD_A_BIAS_OSC_BG_CTL] = MSM8X10_WCD_A_BIAS_OSC_BG_CTL__POR,
	[MSM8X10_WCD_A_MICB_CFILT_1_CTL] = MSM8X10_WCD_A_MICB_CFILT_1_CTL__POR,
	[MSM8X10_WCD_A_MICB_CFILT_1_VAL] = MSM8X10_WCD_A_MICB_CFILT_1_VAL__POR,
	[MSM8X10_WCD_A_MICB_CFILT_1_PRECHRG] =
			MSM8X10_WCD_A_MICB_CFILT_1_PRECHRG__POR,
	[MSM8X10_WCD_A_MICB_1_CTL] = MSM8X10_WCD_A_MICB_1_CTL__POR,
	[MSM8X10_WCD_A_MICB_1_INT_RBIAS] = MSM8X10_WCD_A_MICB_1_INT_RBIAS__POR,
	[MSM8X10_WCD_A_MICB_1_MBHC] = MSM8X10_WCD_A_MICB_1_MBHC__POR,
	[MSM8X10_WCD_A_MBHC_INSERT_DETECT] =
			MSM8X10_WCD_A_MBHC_INSERT_DETECT__POR,
	[MSM8X10_WCD_A_MBHC_INSERT_DET_STATUS] =
			MSM8X10_WCD_A_MBHC_INSERT_DET_STATUS__POR,
	[MSM8X10_WCD_A_TX_COM_BIAS] = MSM8X10_WCD_A_TX_COM_BIAS__POR,
	[MSM8X10_WCD_A_MBHC_SCALING_MUX_1] =
			MSM8X10_WCD_A_MBHC_SCALING_MUX_1__POR,
	[MSM8X10_WCD_A_MBHC_SCALING_MUX_2] =
			MSM8X10_WCD_A_MBHC_SCALING_MUX_2__POR,
	[MSM8X10_WCD_A_RESERVED_MAD_ANA_CTRL] =
			MSM8X10_WCD_A_RESERVED_MAD_ANA_CTRL__POR,
	[MSM8X10_WCD_A_TX_SUP_SWITCH_CTRL_1] =
			MSM8X10_WCD_A_TX_SUP_SWITCH_CTRL_1__POR,
	[MSM8X10_WCD_A_TX_SUP_SWITCH_CTRL_2] =
			MSM8X10_WCD_A_TX_SUP_SWITCH_CTRL_2__POR,
	[MSM8X10_WCD_A_TX_1_EN] = MSM8X10_WCD_A_TX_1_EN__POR,
	[MSM8X10_WCD_A_TX_2_EN] = MSM8X10_WCD_A_TX_2_EN__POR,
	[MSM8X10_WCD_A_TX_1_2_ADC_CH1] = MSM8X10_WCD_A_TX_1_2_ADC_CH1__POR,
	[MSM8X10_WCD_A_TX_1_2_ADC_CH2] = MSM8X10_WCD_A_TX_1_2_ADC_CH2__POR,
	[MSM8X10_WCD_A_TX_1_2_ATEST_REFCTRL] =
			MSM8X10_WCD_A_TX_1_2_ATEST_REFCTRL__POR,
	[MSM8X10_WCD_A_TX_1_2_TEST_CTL] =
			MSM8X10_WCD_A_TX_1_2_TEST_CTL__POR,
	[MSM8X10_WCD_A_TX_1_2_TEST_BLOCK_EN] =
			MSM8X10_WCD_A_TX_1_2_TEST_BLOCK_EN__POR,
	[MSM8X10_WCD_A_TX_1_2_TXFE_CLKDIV] =
			MSM8X10_WCD_A_TX_1_2_TXFE_CLKDIV__POR,
	[MSM8X10_WCD_A_TX_1_2_SAR_ERR_CH1] =
			MSM8X10_WCD_A_TX_1_2_SAR_ERR_CH1__POR,
	[MSM8X10_WCD_A_TX_1_2_SAR_ERR_CH2] =
			MSM8X10_WCD_A_TX_1_2_SAR_ERR_CH2__POR,
	[MSM8X10_WCD_A_TX_3_EN] = MSM8X10_WCD_A_TX_3_EN__POR,
	[MSM8X10_WCD_A_TX_1_2_TEST_EN] = MSM8X10_WCD_A_TX_1_2_TEST_EN__POR,
	[MSM8X10_WCD_A_TX_7_MBHC_EN_ATEST_CTRL] =
			MSM8X10_WCD_A_TX_7_MBHC_EN_ATEST_CTRL__POR,
	[MSM8X10_WCD_A_TX_7_MBHC_SAR_ERR] =
			MSM8X10_WCD_A_TX_7_MBHC_SAR_ERR__POR,
	[MSM8X10_WCD_A_CP_EN] = MSM8X10_WCD_A_CP_EN__POR,
	[MSM8X10_WCD_A_CP_CLK] = MSM8X10_WCD_A_CP_CLK__POR,
	[MSM8X10_WCD_A_CP_STATIC] = MSM8X10_WCD_A_CP_STATIC__POR,
	[MSM8X10_WCD_A_CP_DCC1] = MSM8X10_WCD_A_CP_DCC1__POR,
	[MSM8X10_WCD_A_CP_DCC3] = MSM8X10_WCD_A_CP_DCC3__POR,
	[MSM8X10_WCD_A_CP_ATEST] = MSM8X10_WCD_A_CP_ATEST__POR,
	[MSM8X10_WCD_A_CP_DTEST] = MSM8X10_WCD_A_CP_DTEST__POR,
	[MSM8X10_WCD_A_RX_AUX_SW_CTL] = MSM8X10_WCD_A_RX_AUX_SW_CTL__POR,
	[MSM8X10_WCD_A_RX_PA_AUX_IN_CONN] =
			MSM8X10_WCD_A_RX_PA_AUX_IN_CONN__POR,
	[MSM8X10_WCD_A_RX_COM_TIMER_DIV] = MSM8X10_WCD_A_RX_COM_TIMER_DIV__POR,
	[MSM8X10_WCD_A_RX_COM_OCP_CTL] = MSM8X10_WCD_A_RX_COM_OCP_CTL__POR,
	[MSM8X10_WCD_A_RX_COM_OCP_COUNT] = MSM8X10_WCD_A_RX_COM_OCP_COUNT__POR,
	[MSM8X10_WCD_A_RX_COM_DAC_CTL] = MSM8X10_WCD_A_RX_COM_DAC_CTL__POR,
	[MSM8X10_WCD_A_RX_COM_BIAS] = MSM8X10_WCD_A_RX_COM_BIAS__POR,
	[MSM8X10_WCD_A_RX_HPH_AUTO_CHOP] = MSM8X10_WCD_A_RX_HPH_AUTO_CHOP__POR,
	[MSM8X10_WCD_A_RX_HPH_CHOP_CTL] = MSM8X10_WCD_A_RX_HPH_CHOP_CTL__POR,
	[MSM8X10_WCD_A_RX_HPH_BIAS_PA] = MSM8X10_WCD_A_RX_HPH_BIAS_PA__POR,
	[MSM8X10_WCD_A_RX_HPH_BIAS_LDO] = MSM8X10_WCD_A_RX_HPH_BIAS_LDO__POR,
	[MSM8X10_WCD_A_RX_HPH_BIAS_CNP] = MSM8X10_WCD_A_RX_HPH_BIAS_CNP__POR,
	[MSM8X10_WCD_A_RX_HPH_BIAS_WG_OCP] =
			MSM8X10_WCD_A_RX_HPH_BIAS_WG_OCP__POR,
	[MSM8X10_WCD_A_RX_HPH_OCP_CTL] = MSM8X10_WCD_A_RX_HPH_OCP_CTL__POR,
	[MSM8X10_WCD_A_RX_HPH_CNP_EN] = MSM8X10_WCD_A_RX_HPH_CNP_EN__POR,
	[MSM8X10_WCD_A_RX_HPH_CNP_WG_CTL] =
			MSM8X10_WCD_A_RX_HPH_CNP_WG_CTL__POR,
	[MSM8X10_WCD_A_RX_HPH_CNP_WG_TIME] =
			MSM8X10_WCD_A_RX_HPH_CNP_WG_TIME__POR,
	[MSM8X10_WCD_A_RX_HPH_L_GAIN] = MSM8X10_WCD_A_RX_HPH_L_GAIN__POR,
	[MSM8X10_WCD_A_RX_HPH_L_TEST] = MSM8X10_WCD_A_RX_HPH_L_TEST__POR,
	[MSM8X10_WCD_A_RX_HPH_L_PA_CTL] = MSM8X10_WCD_A_RX_HPH_L_PA_CTL__POR,
	[MSM8X10_WCD_A_RX_HPH_L_DAC_CTL] =
			MSM8X10_WCD_A_RX_HPH_L_DAC_CTL__POR,
	[MSM8X10_WCD_A_RX_HPH_L_ATEST] = MSM8X10_WCD_A_RX_HPH_L_ATEST__POR,
	[MSM8X10_WCD_A_RX_HPH_L_STATUS] = MSM8X10_WCD_A_RX_HPH_L_STATUS__POR,
	[MSM8X10_WCD_A_RX_HPH_R_GAIN] = MSM8X10_WCD_A_RX_HPH_R_GAIN__POR,
	[MSM8X10_WCD_A_RX_HPH_R_TEST] = MSM8X10_WCD_A_RX_HPH_R_TEST__POR,
	[MSM8X10_WCD_A_RX_HPH_R_PA_CTL] = MSM8X10_WCD_A_RX_HPH_R_PA_CTL__POR,
	[MSM8X10_WCD_A_RX_HPH_R_DAC_CTL] = MSM8X10_WCD_A_RX_HPH_R_DAC_CTL__POR,
	[MSM8X10_WCD_A_RX_HPH_R_ATEST] = MSM8X10_WCD_A_RX_HPH_R_ATEST__POR,
	[MSM8X10_WCD_A_RX_HPH_R_STATUS] = MSM8X10_WCD_A_RX_HPH_R_STATUS__POR,
	[MSM8X10_WCD_A_RX_EAR_BIAS_PA] = MSM8X10_WCD_A_RX_EAR_BIAS_PA__POR,
	[MSM8X10_WCD_A_RX_EAR_BIAS_CMBUFF] =
			MSM8X10_WCD_A_RX_EAR_BIAS_CMBUFF__POR,
	[MSM8X10_WCD_A_RX_EAR_EN] = MSM8X10_WCD_A_RX_EAR_EN__POR,
	[MSM8X10_WCD_A_RX_EAR_GAIN] = MSM8X10_WCD_A_RX_EAR_GAIN__POR,
	[MSM8X10_WCD_A_RX_EAR_CMBUFF] = MSM8X10_WCD_A_RX_EAR_CMBUFF__POR,
	[MSM8X10_WCD_A_RX_EAR_ICTL] = MSM8X10_WCD_A_RX_EAR_ICTL__POR,
	[MSM8X10_WCD_A_RX_EAR_CCOMP] = MSM8X10_WCD_A_RX_EAR_CCOMP__POR,
	[MSM8X10_WCD_A_RX_EAR_VCM] = MSM8X10_WCD_A_RX_EAR_VCM__POR,
	[MSM8X10_WCD_A_RX_EAR_CNP] = MSM8X10_WCD_A_RX_EAR_CNP__POR,
	[MSM8X10_WCD_A_RX_EAR_DAC_CTL_ATEST] =
			MSM8X10_WCD_A_RX_EAR_DAC_CTL_ATEST__POR,
	[MSM8X10_WCD_A_RX_EAR_STATUS] = MSM8X10_WCD_A_RX_EAR_STATUS__POR,
	[MSM8X10_WCD_A_RX_LINE_BIAS_PA] =
			MSM8X10_WCD_A_RX_LINE_BIAS_PA__POR,
	[MSM8X10_WCD_A_RX_BUCK_BIAS1] = MSM8X10_WCD_A_RX_BUCK_BIAS1__POR,
	[MSM8X10_WCD_A_RX_BUCK_BIAS2] = MSM8X10_WCD_A_RX_BUCK_BIAS2__POR,
	[MSM8X10_WCD_A_RX_LINE_COM] = MSM8X10_WCD_A_RX_LINE_COM__POR,
	[MSM8X10_WCD_A_RX_LINE_CNP_EN] = MSM8X10_WCD_A_RX_LINE_CNP_EN__POR,
	[MSM8X10_WCD_A_RX_LINE_CNP_WG_CTL] =
			MSM8X10_WCD_A_RX_LINE_CNP_WG_CTL__POR,
	[MSM8X10_WCD_A_RX_LINE_CNP_WG_TIME] =
			MSM8X10_WCD_A_RX_LINE_CNP_WG_TIME__POR,
	[MSM8X10_WCD_A_RX_LINE_1_GAIN] = MSM8X10_WCD_A_RX_LINE_1_GAIN__POR,
	[MSM8X10_WCD_A_RX_LINE_1_TEST] = MSM8X10_WCD_A_RX_LINE_1_TEST__POR,
	[MSM8X10_WCD_A_RX_LINE_1_DAC_CTL] =
			MSM8X10_WCD_A_RX_LINE_1_DAC_CTL__POR,
	[MSM8X10_WCD_A_RX_LINE_1_STATUS] =
			MSM8X10_WCD_A_RX_LINE_1_STATUS__POR,
	[MSM8X10_WCD_A_RX_LINE_CNP_DBG] = MSM8X10_WCD_A_RX_LINE_CNP_DBG__POR,
	[MSM8X10_WCD_A_SPKR_DRV_EN] = MSM8X10_WCD_A_SPKR_DRV_EN__POR,
	[MSM8X10_WCD_A_SPKR_DRV_GAIN] = MSM8X10_WCD_A_SPKR_DRV_GAIN__POR,
	[MSM8X10_WCD_A_SPKR_DRV_DAC_CTL] = MSM8X10_WCD_A_SPKR_DRV_DAC_CTL__POR,
	[MSM8X10_WCD_A_SPKR_DRV_OCP_CTL] = MSM8X10_WCD_A_SPKR_DRV_OCP_CTL__POR,
	[MSM8X10_WCD_A_SPKR_DRV_CLIP_DET] =
			MSM8X10_WCD_A_SPKR_DRV_CLIP_DET__POR,
	[MSM8X10_WCD_A_SPKR_DRV_IEC] = MSM8X10_WCD_A_SPKR_DRV_IEC__POR,
	[MSM8X10_WCD_A_SPKR_DRV_DBG_DAC] = MSM8X10_WCD_A_SPKR_DRV_DBG_DAC__POR,
	[MSM8X10_WCD_A_SPKR_DRV_DBG_PA] = MSM8X10_WCD_A_SPKR_DRV_DBG_PA__POR,
	[MSM8X10_WCD_A_SPKR_DRV_DBG_PWRSTG] =
			MSM8X10_WCD_A_SPKR_DRV_DBG_PWRSTG__POR,
	[MSM8X10_WCD_A_SPKR_DRV_BIAS_LDO] =
			MSM8X10_WCD_A_SPKR_DRV_BIAS_LDO__POR,
	[MSM8X10_WCD_A_SPKR_DRV_BIAS_INT] =
			MSM8X10_WCD_A_SPKR_DRV_BIAS_INT__POR,
	[MSM8X10_WCD_A_SPKR_DRV_BIAS_PA] = MSM8X10_WCD_A_SPKR_DRV_BIAS_PA__POR,
	[MSM8X10_WCD_A_SPKR_DRV_STATUS_OCP] =
			MSM8X10_WCD_A_SPKR_DRV_STATUS_OCP__POR,
	[MSM8X10_WCD_A_SPKR_DRV_STATUS_PA] =
			MSM8X10_WCD_A_SPKR_DRV_STATUS_PA__POR,
	[MSM8X10_WCD_A_RC_OSC_FREQ] = MSM8X10_WCD_A_RC_OSC_FREQ__POR,
	[MSM8X10_WCD_A_RC_OSC_TEST] = MSM8X10_WCD_A_RC_OSC_TEST__POR,
	[MSM8X10_WCD_A_RC_OSC_STATUS] = MSM8X10_WCD_A_RC_OSC_STATUS__POR,
	[MSM8X10_WCD_A_RC_OSC_TUNER] = MSM8X10_WCD_A_RC_OSC_TUNER__POR,
	[MSM8X10_WCD_A_MBHC_HPH] = MSM8X10_WCD_A_MBHC_HPH__POR,
	[MSM8X10_WCD_A_CDC_CLK_RX_RESET_CTL] =
			MSM8X10_WCD_A_CDC_CLK_RX_RESET_CTL__POR,
	[MSM8X10_WCD_A_CDC_CLK_TX_RESET_B1_CTL] =
			MSM8X10_WCD_A_CDC_CLK_TX_RESET_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_CLK_DMIC_B1_CTL] =
			MSM8X10_WCD_A_CDC_CLK_DMIC_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_CLK_RX_I2S_CTL] =
			MSM8X10_WCD_A_CDC_CLK_RX_I2S_CTL__POR,
	[MSM8X10_WCD_A_CDC_CLK_TX_I2S_CTL] =
			MSM8X10_WCD_A_CDC_CLK_TX_I2S_CTL__POR,
	[MSM8X10_WCD_A_CDC_CLK_OTHR_RESET_B1_CTL] =
			MSM8X10_WCD_A_CDC_CLK_OTHR_RESET_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_CLK_TX_CLK_EN_B1_CTL] =
			MSM8X10_WCD_A_CDC_CLK_TX_CLK_EN_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_CLK_OTHR_CTL] = MSM8X10_WCD_A_CDC_CLK_OTHR_CTL__POR,
	[MSM8X10_WCD_A_CDC_CLK_RX_B1_CTL] =
			MSM8X10_WCD_A_CDC_CLK_RX_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_CLK_MCLK_CTL] = MSM8X10_WCD_A_CDC_CLK_MCLK_CTL__POR,
	[MSM8X10_WCD_A_CDC_CLK_PDM_CTL] = MSM8X10_WCD_A_CDC_CLK_PDM_CTL__POR,
	[MSM8X10_WCD_A_CDC_CLK_SD_CTL] = MSM8X10_WCD_A_CDC_CLK_SD_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX1_B1_CTL] = MSM8X10_WCD_A_CDC_RX1_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX2_B1_CTL] = MSM8X10_WCD_A_CDC_RX2_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX3_B1_CTL] = MSM8X10_WCD_A_CDC_RX3_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX1_B2_CTL] = MSM8X10_WCD_A_CDC_RX1_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX2_B2_CTL] = MSM8X10_WCD_A_CDC_RX2_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX3_B2_CTL] = MSM8X10_WCD_A_CDC_RX3_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX1_B3_CTL] = MSM8X10_WCD_A_CDC_RX1_B3_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX2_B3_CTL] = MSM8X10_WCD_A_CDC_RX2_B3_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX3_B3_CTL] = MSM8X10_WCD_A_CDC_RX3_B3_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX1_B4_CTL] = MSM8X10_WCD_A_CDC_RX1_B4_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX2_B4_CTL] = MSM8X10_WCD_A_CDC_RX2_B4_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX3_B4_CTL] = MSM8X10_WCD_A_CDC_RX3_B4_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX1_B5_CTL] = MSM8X10_WCD_A_CDC_RX1_B5_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX2_B5_CTL] = MSM8X10_WCD_A_CDC_RX2_B5_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX3_B5_CTL] = MSM8X10_WCD_A_CDC_RX3_B5_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX1_B6_CTL] = MSM8X10_WCD_A_CDC_RX1_B6_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX2_B6_CTL] = MSM8X10_WCD_A_CDC_RX2_B6_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX3_B6_CTL] = MSM8X10_WCD_A_CDC_RX3_B6_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX1_VOL_CTL_B1_CTL] =
			MSM8X10_WCD_A_CDC_RX1_VOL_CTL_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX2_VOL_CTL_B1_CTL] =
			MSM8X10_WCD_A_CDC_RX2_VOL_CTL_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX3_VOL_CTL_B1_CTL] =
			MSM8X10_WCD_A_CDC_RX3_VOL_CTL_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX1_VOL_CTL_B2_CTL] =
			MSM8X10_WCD_A_CDC_RX1_VOL_CTL_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX2_VOL_CTL_B2_CTL] =
			MSM8X10_WCD_A_CDC_RX2_VOL_CTL_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_RX3_VOL_CTL_B2_CTL] =
			MSM8X10_WCD_A_CDC_RX3_VOL_CTL_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B1_CTL] =
			MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B2_CTL] =
			MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B3_CTL] =
			MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B3_CTL__POR,
	[MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B4_CTL] =
			MSM8X10_WCD_A_CDC_CLSG_FREQ_THRESH_B4_CTL__POR,
	[MSM8X10_WCD_A_CDC_CLSG_GAIN_THRESH_CTL] =
			MSM8X10_WCD_A_CDC_CLSG_GAIN_THRESH_CTL__POR,
	[MSM8X10_WCD_A_CDC_CLSG_TIMER_B1_CFG] =
			MSM8X10_WCD_A_CDC_CLSG_TIMER_B1_CFG__POR,
	[MSM8X10_WCD_A_CDC_CLSG_TIMER_B2_CFG] =
			MSM8X10_WCD_A_CDC_CLSG_TIMER_B2_CFG__POR,
	[MSM8X10_WCD_A_CDC_CLSG_CTL] = MSM8X10_WCD_A_CDC_CLSG_CTL__POR,
	[MSM8X10_WCD_A_CDC_TX1_VOL_CTL_TIMER] =
			MSM8X10_WCD_A_CDC_TX1_VOL_CTL_TIMER__POR,
	[MSM8X10_WCD_A_CDC_TX2_VOL_CTL_TIMER] =
			MSM8X10_WCD_A_CDC_TX2_VOL_CTL_TIMER__POR,
	[MSM8X10_WCD_A_CDC_TX1_VOL_CTL_GAIN] =
			MSM8X10_WCD_A_CDC_TX1_VOL_CTL_GAIN__POR,
	[MSM8X10_WCD_A_CDC_TX2_VOL_CTL_GAIN] =
			MSM8X10_WCD_A_CDC_TX2_VOL_CTL_GAIN__POR,
	[MSM8X10_WCD_A_CDC_TX1_VOL_CTL_CFG] =
			MSM8X10_WCD_A_CDC_TX1_VOL_CTL_CFG__POR,
	[MSM8X10_WCD_A_CDC_TX2_VOL_CTL_CFG] =
			MSM8X10_WCD_A_CDC_TX2_VOL_CTL_CFG__POR,
	[MSM8X10_WCD_A_CDC_TX1_MUX_CTL] =
			MSM8X10_WCD_A_CDC_TX1_MUX_CTL__POR,
	[MSM8X10_WCD_A_CDC_TX2_MUX_CTL] =
			MSM8X10_WCD_A_CDC_TX2_MUX_CTL__POR,
	[MSM8X10_WCD_A_CDC_TX1_CLK_FS_CTL] =
			MSM8X10_WCD_A_CDC_TX1_CLK_FS_CTL__POR,
	[MSM8X10_WCD_A_CDC_TX2_CLK_FS_CTL] =
			MSM8X10_WCD_A_CDC_TX2_CLK_FS_CTL__POR,
	[MSM8X10_WCD_A_CDC_TX1_DMIC_CTL] =
			MSM8X10_WCD_A_CDC_TX1_DMIC_CTL__POR,
	[MSM8X10_WCD_A_CDC_TX2_DMIC_CTL] =
			MSM8X10_WCD_A_CDC_TX2_DMIC_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR1_GAIN_B1_CTL] =
			MSM8X10_WCD_A_CDC_IIR1_GAIN_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR2_GAIN_B1_CTL] =
			MSM8X10_WCD_A_CDC_IIR2_GAIN_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR1_GAIN_B2_CTL] =
			MSM8X10_WCD_A_CDC_IIR1_GAIN_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR2_GAIN_B2_CTL] =
			MSM8X10_WCD_A_CDC_IIR2_GAIN_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR1_GAIN_B3_CTL] =
			MSM8X10_WCD_A_CDC_IIR1_GAIN_B3_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR2_GAIN_B3_CTL] =
			MSM8X10_WCD_A_CDC_IIR2_GAIN_B3_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR1_GAIN_B4_CTL] =
			MSM8X10_WCD_A_CDC_IIR1_GAIN_B4_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR2_GAIN_B4_CTL] =
			MSM8X10_WCD_A_CDC_IIR2_GAIN_B4_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR1_GAIN_B5_CTL] =
			MSM8X10_WCD_A_CDC_IIR1_GAIN_B5_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR2_GAIN_B5_CTL] =
			MSM8X10_WCD_A_CDC_IIR2_GAIN_B5_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR1_GAIN_B6_CTL] =
			MSM8X10_WCD_A_CDC_IIR1_GAIN_B6_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR2_GAIN_B6_CTL] =
			MSM8X10_WCD_A_CDC_IIR2_GAIN_B6_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR1_GAIN_B7_CTL] =
			MSM8X10_WCD_A_CDC_IIR1_GAIN_B7_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR2_GAIN_B7_CTL] =
			MSM8X10_WCD_A_CDC_IIR2_GAIN_B7_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR1_GAIN_B8_CTL] =
			MSM8X10_WCD_A_CDC_IIR1_GAIN_B8_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR2_GAIN_B8_CTL] =
			MSM8X10_WCD_A_CDC_IIR2_GAIN_B8_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR1_CTL] = MSM8X10_WCD_A_CDC_IIR1_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR2_CTL] = MSM8X10_WCD_A_CDC_IIR2_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR1_GAIN_TIMER_CTL] =
			MSM8X10_WCD_A_CDC_IIR1_GAIN_TIMER_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR2_GAIN_TIMER_CTL] =
			MSM8X10_WCD_A_CDC_IIR2_GAIN_TIMER_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR1_COEF_B1_CTL] =
			MSM8X10_WCD_A_CDC_IIR1_COEF_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR2_COEF_B1_CTL] =
			MSM8X10_WCD_A_CDC_IIR2_COEF_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR1_COEF_B2_CTL] =
			MSM8X10_WCD_A_CDC_IIR1_COEF_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_IIR2_COEF_B2_CTL] =
			MSM8X10_WCD_A_CDC_IIR2_COEF_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_RX1_B1_CTL] =
			MSM8X10_WCD_A_CDC_CONN_RX1_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_RX1_B2_CTL] =
			MSM8X10_WCD_A_CDC_CONN_RX1_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_RX1_B3_CTL] =
			MSM8X10_WCD_A_CDC_CONN_RX1_B3_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_RX2_B1_CTL] =
			MSM8X10_WCD_A_CDC_CONN_RX2_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_RX2_B2_CTL] =
			MSM8X10_WCD_A_CDC_CONN_RX2_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_RX2_B3_CTL] =
			MSM8X10_WCD_A_CDC_CONN_RX2_B3_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_RX3_B1_CTL] =
			MSM8X10_WCD_A_CDC_CONN_RX3_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_RX3_B2_CTL] =
			MSM8X10_WCD_A_CDC_CONN_RX3_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_TX_B1_CTL] =
			MSM8X10_WCD_A_CDC_CONN_TX_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_EQ1_B1_CTL] =
			MSM8X10_WCD_A_CDC_CONN_EQ1_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_EQ1_B2_CTL] =
			MSM8X10_WCD_A_CDC_CONN_EQ1_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_EQ1_B3_CTL] =
			MSM8X10_WCD_A_CDC_CONN_EQ1_B3_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_EQ1_B4_CTL] =
			MSM8X10_WCD_A_CDC_CONN_EQ1_B4_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_EQ2_B1_CTL] =
			MSM8X10_WCD_A_CDC_CONN_EQ2_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_EQ2_B2_CTL] =
			MSM8X10_WCD_A_CDC_CONN_EQ2_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_EQ2_B3_CTL] =
			MSM8X10_WCD_A_CDC_CONN_EQ2_B3_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_EQ2_B4_CTL] =
			MSM8X10_WCD_A_CDC_CONN_EQ2_B4_CTL__POR,
	[MSM8X10_WCD_A_CDC_CONN_TX_I2S_SD1_CTL] =
			MSM8X10_WCD_A_CDC_CONN_TX_I2S_SD1_CTL__POR,
	[MSM8X10_WCD_A_CDC_TOP_GAIN_UPDATE] =
			MSM8X10_WCD_A_CDC_TOP_GAIN_UPDATE__POR,
	[MSM8X10_WCD_A_CDC_TOP_CTL] = MSM8X10_WCD_A_CDC_TOP_CTL__POR,
	[MSM8X10_WCD_A_CDC_DEBUG_DESER1_CTL] =
			MSM8X10_WCD_A_CDC_DEBUG_DESER1_CTL__POR,
	[MSM8X10_WCD_A_CDC_DEBUG_DESER2_CTL] =
			MSM8X10_WCD_A_CDC_DEBUG_DESER2_CTL__POR,
	[MSM8X10_WCD_A_CDC_DEBUG_B1_CTL] =
			MSM8X10_WCD_A_CDC_DEBUG_B1_CTL__POR,
	[MSM8X10_WCD_A_CDC_DEBUG_B2_CTL] =
			MSM8X10_WCD_A_CDC_DEBUG_B2_CTL__POR,
	[MSM8X10_WCD_A_CDC_DEBUG_B3_CTL] =
			MSM8X10_WCD_A_CDC_DEBUG_B3_CTL__POR,
};
