/* =====================================
=== LIMEREG - Lightweight Image Registration ===
========================================

Forked from the project FIMREG, which was written for a distributed calculation on the PCIe card DSPC-8681 of Advantech. LIMEREG does not use DSPs and can
be run on an ordinary PC without special hardware. FIMREG was originally developed by by Roelof Berg, Berg Solutions (rberg@berg-solutions.de) with support
from Lars Koenig, Fraunhofer MEVIS (lars.koenig@mevis.fraunhofer.de) and Jan Ruehaak, Fraunhofer MEVIS (jan.ruehaak@mevis.fraunhofer.de).

THIS IS A LIMITED RESEARCH PROTOTYPE. Documentation: www.berg-solutions.de/limereg.html

------------------------------------------------------------------------------

Copyright (c) 2014, Roelof Berg
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

* Neither the name of the owner nor the names of its
contributors may be used to endorse or promote products derived from
this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

----------------------------------------------------------------------------*/

/*
 * jacobian.cpp
 *
 * CODE GENERATED BY MATLAB CODER (THE HUMAN READABILITY IS THEREFORE LIMITED)
 *
 */

#include "../../stdafx.h"

#ifndef USE_ROELOF_CODE

/* Include files */
#include "rt_nonfinite.h"
#include "diffimg.h"
#include "gaussnewton.h"
#include "generatePyramidPC.h"
#include "jacobian.h"
#include "ssd.h"
#include "transform.h"
#include "limereg_emxutil.h"
#include "limereg_rtwutil.h"

/* Custom Source Code */
#include "../pseudo_stdafx.h"             //precompiled header not possible because of include position of matlab
#if WIN32
#include "omp.h"
#endif

namespace Limereg {

void jacobian(const real64_T w[3], const uint32_T BoundBox[4], const uint32_T
              MarginAddon[3], const real64_T DSPRange[4], uint8_T
              *Tvec, const uint32_T TOffset, uint8_T *Rvec, const uint32_T ROffset, uint32_T dX, uint32_T dY,
              real64_T *SSD, real64_T JD[3], real64_T JD2[9])
{
  int32_T i;
  real64_T omegaR[4];
  real64_T omegaT[4];
  int32_T mR[2];
  int32_T mT[2];
  real64_T b_w[3];

  *SSD = 0.0F;
  for (i = 0; i < 3; i++) {
    JD[i] = 0.0F;
  }

  for (i = 0; i < 9; i++) {
    JD2[i] = 0.0F;
  }

  omegaR[0] = DSPRange[0]-0.5f;
  omegaR[1] = DSPRange[1]+0.5f;
  omegaR[2] = DSPRange[2]-0.5f;
  omegaR[3] = DSPRange[3]+0.5f;
  mR[0] = (int)(omegaR[1]-omegaR[0]);
  mR[1] = (int)(omegaR[3]-omegaR[2]);

  const real64_T shiftX = (dX/2)+0.5f;
  const real64_T shiftY = (dY/2)+0.5f;
  omegaT[0] = BoundBox[0] - shiftX-0.5f;
  omegaT[1] = BoundBox[1] - shiftX+0.5f;
  omegaT[2] = BoundBox[2] - shiftY-0.5f;
  omegaT[3] = BoundBox[3] - shiftY+0.5f;
  mT[0] = (int)(BoundBox[1]-BoundBox[0])+1;
  mT[1] = (int)(BoundBox[3]-BoundBox[2])+1;

  for (i = 0; i < 3; i++) {
    b_w[i] = w[i];
  }

  //debug
  #ifdef _TRACE_OUTPUT_
  	printf("d=%uX%u, shift=%f\n", dX, xY, shift);

	const uint8_T* p=&Tvec[TOffset];
	uint32_T iWidth = (BoundBox[1]+1)-BoundBox[0];
	uint32_T iHeight = (BoundBox[3]+1)-BoundBox[2];
	uint32_T iA=(iWidth+MarginAddon[0])*((iHeight/4)+MarginAddon[1])+(iWidth/4)-1;
	uint32_T iB=(iWidth+MarginAddon[0])*((iHeight/2)+MarginAddon[1])+(iWidth*3/4)-1;
	uint32_T iC=(iWidth+MarginAddon[0])*((iHeight*6/10)+MarginAddon[1])+(iWidth*8/10)-1;
	printf("f(0), f(1) ... f(0x%x), f(0x%x) ... f(0x%x), f(0x%x)\n", iA, iA+1, iB-1, iB);
	printf("T: %.2x %.2x ... %.2x %.2x ... %.2x %.2x ... %.2x %.2x\n",
			p[0], p[1], p[iA], p[iA+1], p[iB-1], p[iB], p[iC-1], p[iC]
			);

	p=&Rvec[ROffset];
	iWidth = uint32_T(DSPRange[1]-DSPRange[0]);
	iHeight = uint32_T(DSPRange[3]-DSPRange[2]);
	iA=iWidth*(iHeight/4)+(iWidth/4)-1;
	iB=iWidth*(iHeight/2)+(iWidth*3/4)-1;
	iC=iWidth*(iHeight*6/10)+(iWidth*8/10)-1;
	printf("R: %.2x %.2x ... %.2x %.2x ... %.2x %.2x ... %.2x %.2x\n",
			p[0], p[1], p[iA], p[iA+1], p[iB-1], p[iB], p[iC-1], p[iC]
			);

  printf("mT=[%u, %u], omegaT=[%f, %f, %f, %f]\n",
	  mT[0], mT[1], omegaT[0], omegaT[1], omegaT[2], omegaT[3]);

  printf("mR=[%u, %u], omegaR=[%f, %f, %f, %f]\n",
	  mR[0], mR[1], omegaR[0], omegaR[1], omegaR[2], omegaR[3]);

  printf("MarginAddon=[%u, %u, %u], DSPRange=[%f, %f, %f, %f], d=%u\n",
	  MarginAddon[0], MarginAddon[1], MarginAddon[2], DSPRange[0], DSPRange[1], DSPRange[2], DSPRange[3], d);

  #endif

  *SSD = matlab_c_ssdRigid2D(&Rvec[ROffset], mR, omegaR,
                            &Tvec[TOffset], mT, omegaT,
                            b_w, &MarginAddon[0],
							&DSPRange[0], JD, JD2);

  #ifdef _TRACE_OUTPUT_
  printf("  SSD=%f, JD=[%f, %f, %f], JD2=[%f, %f, %f, %f ... %f]\n", *SSD, JD[0], JD[1], JD[2], 
			JD2[0], JD2[1], JD2[2], JD2[3], JD2[8]);
  #endif

}

}

#endif //ndef USE_ROELOF_CODE
