/* =====================================
=== LIMEREG - Lightweight Image Registration ===
========================================

Forked from the project FIMREG, which was written for a distributed calculation on the PCIe card DSPC-8681 of Advantech. LIMEREG does not use DSPs and can
be run on an ordinary PC without special hardware. FIMREG was originally developed by by Roelof Berg, Berg Solutions (rberg@berg-solutions.de) with support
from Lars Koenig, Fraunhofer MEVIS (lars.koenig@mevis.fraunhofer.de) and Jan Ruehaak, Fraunhofer MEVIS (jan.ruehaak@mevis.fraunhofer.de).

THIS IS A LIMITED RESEARCH PROTOTYPE. Documentation: www.berg-solutions.de/limereg.html

------------------------------------------------------------------------------

Copyright (c) 2014, Roelof Berg
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

* Neither the name of the owner nor the names of its
contributors may be used to endorse or promote products derived from
this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

----------------------------------------------------------------------------*/

/*
 * diffimg.cpp
 *
 * CODE GENERATED BY MATLAB CODER (THE HUMAN READABILITY IS THEREFORE LIMITED)
 *
 */

#include "../../stdafx.h"

/* Include files */
#include "rt_nonfinite.h"
#include "diffimg.h"
#include "gaussnewton.h"
#include "generatePyramidPC.h"
#include "jacobian.h"
#include "ssd.h"
#include "transform.h"
#include "limereg_emxutil.h"
#include "limereg_rtwutil.h"

/* Custom Source Code */
#include "../pseudo_stdafx.h"             //precompiled header not possible because of include position of matlab
namespace Limereg {

/* Type Definitions */

/* Named Constants */

/* Variable Declarations */

/* Variable Definitions */

/* Function Declarations */

/* Function Definitions */
void diffimg(const emxArray_uint8_T *Rvec, const emxArray_uint8_T *Tvec,
             uint32_T dx, uint32_T dy, emxArray_uint8_T *Dvec)
{
  uint32_T mn;
  int32_T i0;
  int32_T loop_ub;
  uint32_T i;
  real64_T pixeldiff;

  mn = dx * dy;
  i0 = Dvec->size[0];
  Dvec->size[0] = (int32_T)mn;
  emxEnsureCapacity((emxArray__common *)Dvec, i0, (int32_T)sizeof(uint8_T));
  loop_ub = (int32_T)mn - 1;
  for (i0 = 0; i0 <= loop_ub; i0++) {
    Dvec->data[i0] = 0;
  }

  for (i = 1U; i <= mn; i++) {

   //Old version (corresponds to matlab code), the darker the different: 255 - (uint8_T)rt_roundf_snf(pixeldiff * pixeldiff * 255.0F)
#if 0
	pixeldiff =
		    (real64_T) Rvec->data[(int32_T)i - 1] / 255.0F
		  - (real64_T) Tvec->data[(int32_T)i - 1] / 255.0F;

    Dvec->data[(int32_T)i - 1] =
		(uint8_T)(
		   255 - (uint8_T)rt_roundf_snf(pixeldiff * pixeldiff * 255.0F)
		);
#else

	pixeldiff = 
		    (real64_T) Rvec->data[(int32_T)i - 1] / 255.0F
		  - (real64_T) Tvec->data[(int32_T)i - 1] / 255.0F;

    Dvec->data[(int32_T)i - 1] =
		(uint8_T)(
		   128 + (int8_T)rt_roundf_snf(pixeldiff * 128.0F)
		);

#endif
  }
}

}
/* End of code generation (diffimg.cpp) */
