/***********************************************************************************

    Copyright (C) 2007-2020 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_TEXTVIEW_DIARY_SEARCH_HEADER
#define LIFEOGRAPH_TEXTVIEW_DIARY_SEARCH_HEADER


#include "widget_textview.hpp"


namespace LIFEO
{

// FORWARD DECLERATIONS
class TextbufferDiarySearch;

// LINKS ===========================================================================================
class LinkMatch : public Link
{
    public:
        typedef sigc::signal< void, Date >
                                    Signal_void_Date;

                                    LinkMatch( const Glib::RefPtr< Gtk::TextMark >&,
                                               const Glib::RefPtr< Gtk::TextMark >&,
                                               Match&, TextbufferDiarySearch*, int );
        void                        go();

        Match&                      m_match;
        TextbufferDiarySearch*      m_container;
        int                         m_para_no;
};

// TEXTBUFFER ======================================================================================
class TextbufferDiarySearch : public TextbufferDiary
{
    public:
                                    TextbufferDiarySearch();

        void                        set_para_sel( int );

    protected:
        void                        set_text_from_matches( ListMatches* );

        void                        set_theme( const Theme* ) override;

        // PARSING
        void                        reset( UstringSize, UstringSize ) override;

        void                        apply_heading() override;
        void                        apply_ignore() override { }
        void                        apply_link_hidden() override;
        void                        apply_link() override;
        void                        apply_date() override;
        void                        apply_chart() override;
        void                        apply_match() override;
        void                        apply_inline_tag() override;

        void                        apply_custom1() override;

        // TAGS
        Glib::RefPtr< Tag >         m_tag_para_sel;

        // OTHER VARIABLES
        ListMatches*                m_ptr2matches{ nullptr };
        unsigned int                m_index_match{ 0 }; // current index in parsing
        int                         m_para_no_sel{ -1 };

        const static Recipe::Contents   s_rc_separator;

    friend class TextviewDiarySearch;
    friend class LinkMatch;
};

// TEXTVIEW ========================================================================================
class TextviewDiarySearch : public TextviewDiary
{
    public:
    typedef sigc::signal< void, Match& >
                                    Signal_void_Match;

        TextviewDiarySearch();
        TextviewDiarySearch( BaseObjectType*, const Glib::RefPtr< Gtk::Builder >& );
        ~TextviewDiarySearch() {}

        TextbufferDiarySearch*      get_buffer()
        { return m_buffer_search; }

        bool                        is_derived() const override { return true; }

        void                        set_diary( Diary* diary )
        {
            m_buffer_search->m_ptr2diary = diary;
        }
        void                        set_text_from_matches( ListMatches* matches )
        { m_buffer_search->set_text_from_matches( matches ); }
        void                        set_static_text( const Ustring&, bool ) = delete;

        void                        show_Po_find();

        void                        replace_match( Match&, const Ustring& );

        void                        set_para_sel( Match& );

        Signal_void_Match           signal_replace()
        { return m_Sg_replace; }

    protected:
        void                        init() override;

        bool                        on_button_press_event( GdkEventButton* ) override
        { return true; } // to block clicks
        bool                        on_button_release_event( GdkEventButton* ) override;
        bool                        on_draw( const Cairo::RefPtr< Cairo::Context >& ) override;

        bool                        handle_query_tooltip(
                                        int, int, bool,
                                        const Glib::RefPtr< Gtk::Tooltip >& ) override;

        TextbufferDiarySearch*      m_buffer_search;
        Gtk::Popover*               m_Po_find{ nullptr };
        Gtk::ModelButton*           m_MoB_replace{ nullptr };

        Signal_void_Match           m_Sg_replace;

    friend class TextbufferDiary;
};

} // end of namespace LIFEO

#endif
