#!/usr/bin/python
# -*- coding: utf-8 -*-
### BEGIN LICENSE
# Copyright (C) 2009 Jono Bacon <jono@ubuntu.com>
# Copyright (C) 2010 Michael Budde <mbudde@gmail.com>
#
#This program is free software: you can redistribute it and/or modify it
#under the terms of the GNU General Public License version 3, as published
#by the Free Software Foundation.
#
#This program is distributed in the hope that it will be useful, but
#WITHOUT ANY WARRANTY; without even the implied warranties of
#MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
#PURPOSE.  See the GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License along
#with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE


class Event(object):

    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            if k in ('name', 'nick', 'homepage', 'icalurl', 'classroom',
                     'chat', 'eventstart', 'eventend', 'locale', 'logstring',
                     'question_token', 'server'):
                setattr(self, '_'+k, v)

    @property
    def name(self):
        return self._name

    @property
    def nick(self):
        return self._nick

    @property
    def homepage(self):
        return self._homepage

    @property
    def icalurl(self):
        if self._icalurl.upper().startswith("HTTPS"):
            return self._icalurl[0:4] + self._icalurl[5:]
        else:
            return self._icalurl

    @property
    def classroom(self):
        return self._classroom

    @property
    def chat(self):
        return self._chat

    @property
    def locale(self):
        return self._locale

    @property
    def logstring(self):
        return self._logstring

    @property
    def server(self):
        return self._server

    @property
    def question_token(self):
        return self._question_token

    @property
    def eventstart(self):
        return self._eventstart

    @property
    def eventend(self):
        return self._eventend
