/*
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 */


/**
    \file   lcmaps_gss_assist_gridmap.h
    \brief  This interface is equal to the gss_assist_gridmap interface, but uses
            the LCMAPS libraries in the back.

    \author Martijn Steenbakkers for the EU DataGrid.

    This header contains the following LCMAPS library functions:
    -# globus_gss_assist_gridmap
        Legacy interface
    \ingroup LcmapsBasicInterface
*/

#ifndef LCMAPS_GSS_ASSIST_GRIDMAP_H
#define LCMAPS_GSS_ASSIST_GRIDMAP_H

#include "lcmaps_basic.h"

/******************************************************************************
 *                 Module definition
 *****************************************************************************/

typedef int
globus_gss_assist_gridmap_t(
    char *   globusidp,
    char **  useridp
);

#include "_lcmaps_gss_assist_gridmap.h"

#ifndef LCMAPS_USE_DLOPEN
/**
   \brief declaration of the interface function

   The interface function needs to be declared when linking rather than dlopen()'ing.
*/
globus_gss_assist_gridmap_t globus_gss_assist_gridmap;
#endif /* LCMAPS_USE_DLOPEN */

/**
   \brief Opaque handle type for the interface

   The opaque handle type that the API user should declare a single instance of.
   This must be passed to nearly all macros (in OO terms, this would be a derived
   type of LCMAPS_HANDLE).
   Usage: 
   LCMAPS_HANDLE_GSS_ASSIST_GRIDMAP handle;
 */
typedef _lcmaps_handle_gss_assist_gridmap_t LCMAPS_HANDLE_GSS_ASSIST_GRIDMAP;

/**
   The declarator can be used to declare and init the handle in one go.
 */
#define LCMAPS_DECL_HANDLE_GSS_ASSIST_GRIDMAP(l) \
    _LCMAPS_DECL_HANDLE_GSS_ASSIST_GRIDMAP(l)

/**
   The initializer of the handle object. This macro must be called before any
   other macro using an LCMAPS_HANDLE.
   \param l An instance of LCMAPS_HANDLE_GSS_ASSIST_GRIDMAP
   \retval 1 always.
 */
#define LCMAPS_INIT_HANDLE_GSS_ASSIST_GRIDMAP(l) \
    _LCMAPS_INIT_HANDLE_GSS_ASSIST_GRIDMAP(l)

/**
   This macro loads and prepares LCMAPS; must be called before any 
   use of the interface functions, but after LCMAPS_INIT_HANDLE_GSS_ASSIST_GRIDMAP.
   \param l an initialized handle
   \retval 0 in case of failure, inspect LCMAPS_ERRMSG(l)
   \retval 1 on success
 */
#define LCMAPS_LOAD_GSS_ASSIST_GRIDMAP(l) \
    _LCMAPS_LOAD_GSS_ASSIST_GRIDMAP(l)

/**
    \brief close the LCMAPS_HANDLE

    This macro closes any opened interface libraries and clears the handle.
    After this call the handle must be considered invalid. The LCMAPS_CLOSE_HANDLE
    can be found in lcmaps.h.
*/
#define LCMAPS_CLOSE_HANDLE_GSS_ASSIST_GRIDMAP(l)	\
    LCMAPS_CLOSE_HANDLE(l)


#endif /* LCMAPS_GSS_ASSIST_GRIDMAP_H */

