/***************************************************************************
 *   Copyright (C) 2008-2011 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KOSD.                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include "powermanager.h"

#include <QtDBus>

#include <Solid/AcAdapter>
#include <Solid/Battery>
#include <Solid/Device>

void PowerManager::increaseBrightness()
{
    int current = brightness();
    if (current < 100)
    {
        QDBusMessage m = QDBusMessage::createMethodCall("org.kde.Solid.PowerManagement", "/org/kde/Solid/PowerManagement",
                                                        "org.kde.Solid.PowerManagement", "setBrightness");
        m << ((current >= 90) ? 100 : (current + 10));
        QDBusConnection::sessionBus().call(m);
    }
}


void PowerManager::decreaseBrightness()
{
    int current = brightness();
    if (current > 0)
    {
        QDBusMessage m = QDBusMessage::createMethodCall("org.kde.Solid.PowerManagement", "/org/kde/Solid/PowerManagement",
                                                        "org.kde.Solid.PowerManagement", "setBrightness");
        m << ((current <= 10) ? 0 : (current - 10));
        QDBusConnection::sessionBus().call(m);
    }
}


int PowerManager::brightness()
{
    QDBusMessage m = QDBusMessage::createMethodCall("org.kde.Solid.PowerManagement", "/org/kde/Solid/PowerManagement",
                                                    "org.kde.Solid.PowerManagement", "brightness");
    QDBusReply<int> brightness = QDBusConnection::sessionBus().call(m);

    if (brightness.isValid())
        return brightness.value();

    return 0;
}


int PowerManager::batteryCharge()
{
    QList<Solid::Device> batteries = Solid::Device::listFromType(Solid::DeviceInterface::Battery);
    if (batteries.size() == 0)
        return 0;

    int charge = 0;

    Solid::Device device;
    foreach (device, batteries)
    {
        Solid::Battery *battery = device.as<Solid::Battery>();
        charge += battery->chargePercent();
    }

    charge /= batteries.size();
    return charge;
}


bool PowerManager::acAdapterPlugged()
{
    QList<Solid::Device> adapters = Solid::Device::listFromType(Solid::DeviceInterface::AcAdapter);
    if (adapters.size() == 0)
        return false;

    const Solid::AcAdapter *adapter = adapters.at(0).as<Solid::AcAdapter>();
    return adapter->isPlugged();
}
