/***************************************************************************
 *   Copyright (C) 2006-2007 by Julien Lemoine, Simon Viennot              *
 *   lapinot@tuxfamily.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef WIDGETPLAQUE_H
#define WIDGETPLAQUE_H

#include <QWidget>
#include <QWheelEvent>
#include <QMouseEvent>

#include "global.h"

class QLCDNumber;
class QTimer;

//Widget regroupant 1 Lcd et 2 pushbuttons pour les plaques
class WidgetPlaque : public QWidget, couleurs {
	Q_OBJECT
	
  public:
	WidgetPlaque( QWidget *parent=0, int numW=0, int type_plaque=0); //constructeur
	
	//elements graphiques
	QLCDNumber *lcd;
	
	//numero de widget
	int num;
	//type de plaque : 0 pour une plaque du compte, 1 pour une plaque du tirage, 2 pour une plaque du widget de rsolution.
	int type_plaque;
	//true si un clic doit la modifier (+-), false si elle doit servir  faire un calcul
	bool reglable;
	//false si elle a dj t utilise
	bool cliquable;
	
	//timer pour la rptition des clics
	QTimer *timer;
	bool clicPlus;
	
	private slots :
	void pbClicked();

	public slots :
	void displayRefresh(int numW, int valeur);
	void updateEtat(int numW, int valeur);
	void estReglable(bool reglable);    //permet d'activer/dsactiver les possibilits de rglage de la plaque
	void colorise(int couleur);
	void nonCliquable(int numW);
	
	void mousePressEvent(QMouseEvent *);
	void mouseReleaseEvent ( QMouseEvent *);
	void wheelEvent(QWheelEvent *event);
	
	signals :
	void change(int, bool); //prt  tre connect directement  tirage_change
	void valeur(int, int);  //met la valeur de la plaque
};

#endif
