/***************************************************************************
 *   Copyright (C) 2006-2007 by Julien Lemoine, Simon Viennot              *
 *   lapinot@tuxfamily.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef WIDGETOPTIONS_H
#define WIDGETOPTIONS_H

#include "global.h"
#include <QDialog>

class QCheckBox;
class QSpinBox;
class QRadioButton;
class QString;

class WidgetOptions : public QDialog, policesQt {
  Q_OBJECT
	
  public:
	//paramtres limites/par dfaut des options
	static int min_temps_reflexion;
	static int max_temps_reflexion;
	static int min_nb_plaques;
	static int max_nb_plaques;
	static int min_min_compte;
	static int max_min_compte;
	static int min_max_compte;
	static int max_max_compte;
	
	//paramtres pour les langues 
	static QString langue;
	static int NVE_LANGUE;  //valeur pour relancer l'appli (valeur sans importance - sauf 0)
	
	//lecture du fichier d'options
	static void lireFichier();			//appelable tel quel
	static bool sauveOptions; //indique s'il faut sauvegarder les options sur le disque
	
	//widget options
	WidgetOptions( QWidget* parent = 0);
	
	QCheckBox *cano1, *cano2, *cano3, *sauveOptionsBox;
	QRadioButton *langue1, *langue2, *langue3;
	QSpinBox *boxTemps, *boxNbPlaque, *boxCompte, *boxCompte2;
	
  public slots:
	void modifOk();
	void modifDefaut();
	void supprFichierOptions();
};

#endif
