#ifndef __obj_valve
#define __obj_valve

#define render_valve { \
    glInterleavedArrays (GL_N3F_V3F, 0, valveInterleavedQuads); \
    glDrawArrays (GL_QUADS, 0, valveNumQuads*4); \
    glInterleavedArrays (GL_N3F_V3F, 0, valveInterleavedQuadStrips); \
    for (int i = 0; i < valveNumQuadStrips; i++) { \
        glDrawArrays (GL_QUAD_STRIP, valveQuadStripIndices[i]/6, \
                        (valveQuadStripIndices[i+1] - valveQuadStripIndices[i])/6); \
    } \
    glInterleavedArrays (GL_N3F_V3F, 0, valveInterleavedTriangleFans); \
    for (int ii = 0; ii < valveNumTriangleFans; ii++) { \
        glDrawArrays (GL_TRIANGLE_FAN, valveTriangleFanIndices[ii]/6, \
                        (valveTriangleFanIndices[ii+1] - valveTriangleFanIndices[ii])/6); \
    } \
}

static int valveNumQuads = 4;
static float valveInterleavedQuads[96] = {
 0.000, -0.000,  1.000, 0.100, -0.000,  0.500,
 0.000, -0.000,  1.000, 0.071,  0.071,  0.500,
 0.000, -0.000,  1.000,-0.000,  0.100,  0.500,
 0.000, -0.000,  1.000, 0.071, -0.071,  0.500,

-0.000, -0.000,  1.000,-0.100, -0.000,  0.500,
-0.000, -0.000,  1.000,-0.071, -0.071,  0.500,
-0.000, -0.000,  1.000, 0.000, -0.100,  0.500,
-0.000, -0.000,  1.000,-0.071,  0.071,  0.500,

 0.000,  0.000, -1.000, 0.100,  0.000, -0.500,
 0.000,  0.000, -1.000, 0.071, -0.071, -0.500,
 0.000,  0.000, -1.000, 0.000, -0.100, -0.500,
 0.000,  0.000, -1.000, 0.071,  0.071, -0.500,

-0.000,  0.000, -1.000,-0.100,  0.000, -0.500,
-0.000,  0.000, -1.000,-0.071,  0.071, -0.500,
-0.000,  0.000, -1.000,-0.000,  0.100, -0.500,
-0.000,  0.000, -1.000,-0.071, -0.071, -0.500,

};

static int valveNumQuadStrips = 5;

static int valveQuadStripIndices[6] = { 0, 120, 240, 360, 480, 600 };

static float valveInterleavedQuadStrips[600] = {
 0.673,  0.673,  0.308,  0.071,  0.071, -0.346,  0.673,  0.673,  0.308,  0.042,  0.042, -0.220,
 0.951, -0.000,  0.308,  0.100,  0.000, -0.346, 
 0.951, -0.000,  0.308,  0.059,  0.000, -0.220, 
 0.673, -0.673,  0.308,  0.071, -0.071, -0.346, 
 0.673, -0.673,  0.308,  0.042, -0.042, -0.220, 
-0.000, -0.951,  0.308,  0.000, -0.100, -0.346, 
-0.000, -0.951,  0.308,  0.000, -0.059, -0.220, 
-0.673, -0.673,  0.308, -0.071, -0.071, -0.346, 
-0.673, -0.673,  0.308, -0.042, -0.042, -0.220, 
-0.951, -0.000,  0.308, -0.100,  0.000, -0.346, 
-0.951, -0.000,  0.308, -0.059,  0.000, -0.220, 
-0.673,  0.673,  0.308, -0.071,  0.071, -0.346, 
-0.673,  0.673,  0.308, -0.042,  0.042, -0.220, 
-0.000,  0.951,  0.308, -0.000,  0.100, -0.346, 
-0.000,  0.951,  0.308, -0.000,  0.059, -0.220, 
 0.673,  0.673,  0.308,  0.071,  0.071, -0.346, 
 0.673,  0.673,  0.308,  0.042,  0.042, -0.220, 
 0.951, -0.000,  0.308,  0.100,  0.000, -0.346, 
 0.951, -0.000,  0.308,  0.059,  0.000, -0.220, 
 0.707,  0.707,  0.000,  0.042,  0.042, -0.220,  0.707,  0.707,  0.000,  0.042,  0.042,  0.220,
 1.000,  0.000,  0.000,  0.059,  0.000, -0.220, 
 1.000,  0.000,  0.000,  0.059, -0.000,  0.220, 
 0.707, -0.707, -0.000,  0.042, -0.042, -0.220, 
 0.707, -0.707, -0.000,  0.042, -0.042,  0.220, 
 0.000, -1.000, -0.000,  0.000, -0.059, -0.220, 
 0.000, -1.000, -0.000,  0.000, -0.059,  0.220, 
-0.707, -0.707, -0.000, -0.042, -0.042, -0.220, 
-0.707, -0.707, -0.000, -0.042, -0.042,  0.220, 
-1.000, -0.000,  0.000, -0.059,  0.000, -0.220, 
-1.000, -0.000,  0.000, -0.059, -0.000,  0.220, 
-0.707,  0.707,  0.000, -0.042,  0.042, -0.220, 
-0.707,  0.707,  0.000, -0.042,  0.042,  0.220, 
-0.000,  1.000,  0.000, -0.000,  0.059, -0.220, 
-0.000,  1.000,  0.000, -0.000,  0.059,  0.220, 
 0.707,  0.707,  0.000,  0.042,  0.042, -0.220, 
 0.707,  0.707,  0.000,  0.042,  0.042,  0.220, 
 1.000,  0.000,  0.000,  0.059,  0.000, -0.220, 
 1.000,  0.000,  0.000,  0.059, -0.000,  0.220, 
 0.707,  0.707,  0.000,  0.071,  0.071, -0.500,  0.707,  0.707,  0.000,  0.071,  0.071, -0.346,
 1.000, -0.000,  0.000,  0.100,  0.000, -0.500, 
 1.000, -0.000,  0.000,  0.100,  0.000, -0.346, 
 0.707, -0.707, -0.000,  0.071, -0.071, -0.500, 
 0.707, -0.707, -0.000,  0.071, -0.071, -0.346, 
 0.000, -1.000, -0.000,  0.000, -0.100, -0.500, 
 0.000, -1.000, -0.000,  0.000, -0.100, -0.346, 
-0.707, -0.707, -0.000, -0.071, -0.071, -0.500, 
-0.707, -0.707, -0.000, -0.071, -0.071, -0.346, 
-1.000, -0.000, -0.000, -0.100,  0.000, -0.500, 
-1.000, -0.000, -0.000, -0.100,  0.000, -0.346, 
-0.707,  0.707,  0.000, -0.071,  0.071, -0.500, 
-0.707,  0.707,  0.000, -0.071,  0.071, -0.346, 
-0.000,  1.000,  0.000, -0.000,  0.100, -0.500, 
-0.000,  1.000,  0.000, -0.000,  0.100, -0.346, 
 0.707,  0.707,  0.000,  0.071,  0.071, -0.500, 
 0.707,  0.707,  0.000,  0.071,  0.071, -0.346, 
 1.000, -0.000,  0.000,  0.100,  0.000, -0.500, 
 1.000, -0.000,  0.000,  0.100,  0.000, -0.346, 
-0.000,  1.000,  0.000, -0.000,  0.100,  0.354, -0.000,  1.000,  0.000, -0.000,  0.100,  0.500,
 0.707,  0.707,  0.000,  0.071,  0.071,  0.354, 
 0.707,  0.707,  0.000,  0.071,  0.071,  0.500, 
 1.000,  0.000, -0.000,  0.100, -0.000,  0.354, 
 1.000,  0.000, -0.000,  0.100, -0.000,  0.500, 
 0.707, -0.707, -0.000,  0.071, -0.071,  0.354, 
 0.707, -0.707, -0.000,  0.071, -0.071,  0.500, 
 0.000, -1.000, -0.000,  0.000, -0.100,  0.354, 
 0.000, -1.000, -0.000,  0.000, -0.100,  0.500, 
-0.707, -0.707, -0.000, -0.071, -0.071,  0.354, 
-0.707, -0.707, -0.000, -0.071, -0.071,  0.500, 
-1.000, -0.000,  0.000, -0.100, -0.000,  0.354, 
-1.000, -0.000,  0.000, -0.100, -0.000,  0.500, 
-0.707,  0.707,  0.000, -0.071,  0.071,  0.354, 
-0.707,  0.707,  0.000, -0.071,  0.071,  0.500, 
-0.000,  1.000,  0.000, -0.000,  0.100,  0.354, 
-0.000,  1.000,  0.000, -0.000,  0.100,  0.500, 
 0.707,  0.707,  0.000,  0.071,  0.071,  0.354, 
 0.707,  0.707,  0.000,  0.071,  0.071,  0.500, 
 0.676,  0.676, -0.291,  0.042,  0.042,  0.220,  0.676,  0.676, -0.291,  0.071,  0.071,  0.354,
 0.957,  0.000, -0.291,  0.059, -0.000,  0.220, 
 0.957,  0.000, -0.291,  0.100, -0.000,  0.354, 
 0.676, -0.676, -0.291,  0.042, -0.042,  0.220, 
 0.676, -0.676, -0.291,  0.071, -0.071,  0.354, 
 0.000, -0.957, -0.291,  0.000, -0.059,  0.220, 
 0.000, -0.957, -0.291,  0.000, -0.100,  0.354, 
-0.676, -0.676, -0.291, -0.042, -0.042,  0.220, 
-0.676, -0.676, -0.291, -0.071, -0.071,  0.354, 
-0.957,  0.000, -0.291, -0.059, -0.000,  0.220, 
-0.957,  0.000, -0.291, -0.100, -0.000,  0.354, 
-0.676,  0.676, -0.291, -0.042,  0.042,  0.220, 
-0.676,  0.676, -0.291, -0.071,  0.071,  0.354, 
 0.000,  0.957, -0.291, -0.000,  0.059,  0.220, 
 0.000,  0.957, -0.291, -0.000,  0.100,  0.354, 
 0.676,  0.676, -0.291,  0.042,  0.042,  0.220, 
 0.676,  0.676, -0.291,  0.071,  0.071,  0.354, 
 0.957,  0.000, -0.291,  0.059, -0.000,  0.220, 
 0.957,  0.000, -0.291,  0.100, -0.000,  0.354, 
};

static int valveNumTriangleFans = 2;

static int valveTriangleFanIndices[3] = { 0, 24, 48 };

static float valveInterleavedTriangleFans[48] = {
-0.000, -0.000,  1.000,  0.000, -0.100,  0.500,  0.000, -0.000,  1.000,  0.071, -0.071,  0.500, 
 0.000, -0.000,  1.000, -0.000,  0.100,  0.500, 
-0.000, -0.000,  1.000, -0.071,  0.071,  0.500, 
-0.000,  0.000, -1.000, -0.000,  0.100, -0.500,  0.000,  0.000, -1.000,  0.071,  0.071, -0.500, 
 0.000,  0.000, -1.000,  0.000, -0.100, -0.500, 
-0.000,  0.000, -1.000, -0.071, -0.071, -0.500, 
};

#endif // __obj_valve

