/*
 * Private Extended TIFF library interface.
 *
 *  uses private LIBTIFF interface.
 *
 *  The portions of this module marked "XXX" should be
 *  modified to support your tags instead.
 *
 *  written by: Niles D. Ritter
 *
 */

#ifndef __xtiffiop_h
#define __xtiffiop_h

#include "tiffiop.h"
#include "xtiffio.h"

/**********************************************************************
 *               User Configuration
 **********************************************************************/

/* XXX - Define number of your extended tags here */
#define NUM_XFIELD 18
#define XFIELD_BASE (FIELD_LAST-NUM_XFIELD)

/*  XXX - Define your Tag Fields here  */
#define FIELD_33423 (XFIELD_BASE+0)
#define FIELD_33424 (XFIELD_BASE+1)
#define FIELD_33434 (XFIELD_BASE+2)
#define FIELD_33437 (XFIELD_BASE+3)
#define FIELD_34850 (XFIELD_BASE+4)
#define FIELD_34859 (XFIELD_BASE+5)
#define FIELD_36867 (XFIELD_BASE+6)
#define FIELD_37382 (XFIELD_BASE+7)
#define FIELD_37385 (XFIELD_BASE+8)
#define FIELD_37386 (XFIELD_BASE+9)
#define FIELD_37393 (XFIELD_BASE+10)
#define FIELD_37398 (XFIELD_BASE+11)
#define FIELD_37399 (XFIELD_BASE+12)
#define FIELD_33421 (XFIELD_BASE+13)
#define FIELD_33422 (XFIELD_BASE+14)
#define FIELD_37122 (XFIELD_BASE+15)
#define FIELD_37400 (XFIELD_BASE+16)
#define FIELD_33432 (XFIELD_BASE+17)

/* XXX - Define Private directory tag structure here */
struct XTIFFDirectory {
  char*   xd_copyright;
  char*   xd_kdc_33423;
  uint32  xd_kdc_33424;
  uint32* xd_kdc_33434;  /* RATIONAL */
  uint32* xd_kdc_33437;  /* RATIONAL */
  uint16  xd_kdc_34850;
  uint16  xd_kdc_34859;
  char*   xd_kdc_36867;
  uint32* xd_kdc_37382;  /* RATIONAL */
  uint16  xd_kdc_37385;
  uint32* xd_kdc_37386;  /* RATIONAL */
  uint16  xd_kdc_37393;
  void*   xd_kdc_37398;
  uint16  xd_kdc_37399;
  uint16* xd_kdc_33421;
  void*   xd_kdc_33422;
  uint32* xd_kdc_37122;  /* RATIONAL */
  uint32* xd_kdc_37400;  /* 24 x SRATIONAL */
};
typedef struct XTIFFDirectory XTIFFDirectory;

/**********************************************************************
 *    Nothing below this line should need to be changed by the user.
 **********************************************************************/

struct xtiff {
	TIFF 		*xtif_tif;	/* parent TIFF pointer */
	uint32		xtif_flags;
#define       XTIFFP_PRINT   0x00000001
	XTIFFDirectory	xtif_dir;	/* internal rep of current directory */
	TIFFVSetMethod	xtif_vsetfield;	/* inherited tag set routine */
	TIFFVGetMethod	xtif_vgetfield;	/* inherited tag get routine */
	TIFFPrintMethod	xtif_printdir;  /* inherited dir print method */
};
typedef struct xtiff xtiff;


#define PARENT(xt,pmember) ((xt)->xtif_ ## pmember) 
#define TIFFMEMBER(tf,pmember) ((tf)->tif_ ## pmember) 
#define XTIFFDIR(tif) ((xtiff *)TIFFMEMBER(tif,clientdir))
	
/* Extended TIFF flags */
#define XTIFF_INITIALIZED 0x80000000
	
#endif /* __xtiffiop_h */
