#ifndef _REPL_LOAD_H
#define _REPL_LOAD_H

typedef void(*prepareFn)();
typedef void(*pushIntFn)(int);
typedef void(*pushFloatFn)(double);
typedef void(*pushStringFn)(char*);
typedef int(*callFn)(void*, const char*);
typedef void(*initFn)();
typedef void(*arrayFn)(int);
typedef void(*opFn)(int);
typedef void(*coerceFn)();
typedef void(*appendFn)();
typedef void(*actionFn)();

// Load a program, living in a shared object
void interp_load(const char* pathname);
// Initialise the library (set up GC)
void interp_init();
// Close the current library
void interp_close();

// Push a value onto the stack for the return value of a function
void interp_prepare_call();

// Clear the stack
void interp_clear();

// Push values
void interp_push_int(int v);
void interp_push_float(double v);
void interp_push_string(char* v);

// Call a function in the given vm, in the loaded program.
// Returns 1 on success, 0 on failure
int interp_call(const char* function);

// Make an array from the stack
void interp_array(int len);

// Run operators
void interp_op(int opid);
void interp_floatop(int opid);
void interp_unop(int opid);
void interp_floatunop(int opid);
void interp_append();

// Coercions
void interp_str2int();
void interp_int2str();
void interp_str2real();
void interp_real2str();
void interp_str2chr();
void interp_chr2str();
void interp_int2real();
void interp_real2int();
void interp_bool2str();

#endif
