/*
 * Copyright (c) 2016 Vivid Solutions.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * and Eclipse Distribution License v. 1.0 which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v20.html
 * and the Eclipse Distribution License is available at
 *
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */
package org.locationtech.jtstest.testbuilder;


import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import org.locationtech.jtstest.testbuilder.model.TestBuilderModel;
import org.locationtech.jtstest.util.ExceptionFormatter;


/**
 * @version 1.7
 */
public class ResultValuePanel 
extends JPanel 
{
	TestBuilderModel tbModel = null;
  Object currResult = null;
 
  
  JPanel labelPanel = new JPanel();
  JLabel resultLabel = new JLabel();
  BorderLayout labelPanelLayout = new BorderLayout();
  
	JScrollPane jScrollPane1 = new JScrollPane();
	JTextArea txtResult = new JTextArea();
  BorderLayout tabPanelLayout = new BorderLayout();
	
	public ResultValuePanel() {
		try {
			jbInit();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
	
  void jbInit() throws Exception {
    
    this.setLayout(tabPanelLayout);

    txtResult.setWrapStyleWord(true);
    txtResult.setLineWrap(true);
    txtResult.setBackground(AppColors.BACKGROUND);

    labelPanel.setLayout(labelPanelLayout);
    labelPanel.setBorder(BorderFactory.createEmptyBorder(0,4,2,2));
    labelPanel.add(resultLabel);
    resultLabel.setText("Value");

    this.add(jScrollPane1, BorderLayout.CENTER);
    this.add(labelPanel, BorderLayout.NORTH);
    
    jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
    jScrollPane1.getViewport().add(txtResult, null);
  }
  
	public void setModel(TestBuilderModel tbModel)
	{
		this.tbModel = tbModel;
	}
	
  public void setResult(String opName, String execTime, Object o)
  {
    currResult = o;
    resultLabel.setText("Value of: " + opName
        + "    ( " + execTime + " )");
    
    if (o == null) {
      setString("");
    }
    else if (o instanceof Throwable) {
      setError((Throwable) o);
    }
    else {
      setString(o.toString());
    }
  }

  public void setString(String s)
  {
    txtResult.setText(s);
    txtResult.setBackground(AppColors.BACKGROUND);
  }
  
  public void setError(Throwable ex)
  {
    String exStr = ExceptionFormatter.getFullString(ex);
    txtResult.setText(exStr);
    txtResult.setBackground(Color.pink);
  }

  
}
