/*
 * Copyright 2002-2006 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.jexl;

/**
 * Signals an error inside JEXL.
 *
 * @author Kohsuke Kawaguchi
 */
public class JexlException extends Exception {
    private Throwable cause;

    public JexlException(String message) {
        this(message,null);
    }

    public JexlException(String message, Throwable cause) {
        super(message);
        this.cause = cause;
    }

    public JexlException(Throwable cause) {
        this(cause.getMessage(),cause);
    }

    public Throwable getCause() {
        return cause;
    }
}
