/*
 * File    : TextPrevScreenEditorPanel.java
 * Created : 18-jun-2003 15:38
 * By      : fbusquets
 *
 * JClic - Authoring and playing system for educational activities
 *
 * Copyright (C) 2000 - 2005 Francesc Busquets & Departament
 * d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 */

package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.ActiveBoxContentEditor;
import edu.xtec.jclic.boxes.ActiveBoxPreviewPanel;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.util.Options;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author Francesc Busquets (fbusquets@xtec.cat)
 * @version 13.09.16
 */
public class TextPrevScreenEditorPanel extends javax.swing.JPanel implements java.awt.event.ActionListener {
    
    Options options;
    ActiveBoxPreviewPanel abpp;
    TextActivityBaseEditor tabe;
    
    /** Creates new form TextPrevScreenEditorPanel */
    public TextPrevScreenEditorPanel(Options options) {
        this.options=options;
        initComponents();
        styleBtn.setOptions(options);
        abpp=(ActiveBoxPreviewPanel)prevMsgPanel;
        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        javax.swing.JScrollPane scroll;
        javax.swing.JLabel prevMsgLb;
        javax.swing.JLabel styleLb;
        java.awt.GridBagConstraints gridBagConstraints;

        mainGroup = new javax.swing.ButtonGroup();
        btnNo = new javax.swing.JRadioButton();
        btnOriginal = new javax.swing.JRadioButton();
        btnSpecial = new javax.swing.JRadioButton();
        scroll = new javax.swing.JScrollPane();
        textEdit = new javax.swing.JTextPane();
        styleLb = new javax.swing.JLabel();
        styleBtn = new edu.xtec.jclic.beans.BoxBaseButton();
        prevMsgLb = new javax.swing.JLabel();
        prevMsgPanel = new ActiveBoxPreviewPanel(null);
        timeLb = new javax.swing.JLabel();
        timeEdit = new edu.xtec.jclic.beans.SmallIntEditor();

        setLayout(new java.awt.GridBagLayout());

        setMinimumSize(new java.awt.Dimension(200, 300));
        btnNo.setText(options.getMsg("edit_text_act_prevScreen_no"));
        mainGroup.add(btnNo);
        btnNo.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(btnNo, gridBagConstraints);

        btnOriginal.setText(options.getMsg("edit_text_act_prevScreen_original"));
        mainGroup.add(btnOriginal);
        btnOriginal.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(btnOriginal, gridBagConstraints);

        btnSpecial.setText(options.getMsg("edit_text_act_prevScreen_special"));
        mainGroup.add(btnSpecial);
        btnSpecial.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(btnSpecial, gridBagConstraints);

        scroll.setPreferredSize(new java.awt.Dimension(200, 100));
        scroll.setMinimumSize(new java.awt.Dimension(100, 100));
        scroll.setViewportView(textEdit);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(scroll, gridBagConstraints);

        styleLb.setText(options.getMsg("edit_style_title"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(styleLb, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(styleBtn, gridBagConstraints);

        prevMsgLb.setText(options.getMsg("edit_act_msg_prev"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(prevMsgLb, gridBagConstraints);

        prevMsgPanel.setBorder(new javax.swing.border.EtchedBorder());
        prevMsgPanel.setToolTipText(options.getMsg("edit_act_msg_prev_tooltip"));
        prevMsgPanel.setPreferredSize(new java.awt.Dimension(200, 40));
        prevMsgPanel.setMinimumSize(new java.awt.Dimension(100, 40));
        prevMsgPanel.setMaximumSize(new java.awt.Dimension(32767, 40));
        prevMsgPanel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                prevMsgPanelMouseClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(prevMsgPanel, gridBagConstraints);

        timeLb.setText(options.getMsg("edit_text_act_prevScreen_time"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(12, 2, 2, 2);
        add(timeLb, gridBagConstraints);

        timeEdit.setMax(999);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 2, 2, 2);
        add(timeEdit, gridBagConstraints);

    }//GEN-END:initComponents

    private void prevMsgPanelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_prevMsgPanelMouseClicked

        if(tabe!=null && !btnNo.isSelected()){
            ActiveBoxContent abc=ActiveBoxContentEditor.getActiveBoxContent(abpp.getActiveBoxContent(), this, options, tabe.getMediaBagEditor(), abpp.getActiveBox());
            if(abc!=null)
                abpp.setActiveBoxContent(abc);
        }
        

    }//GEN-LAST:event_prevMsgPanelMouseClicked
    
    public void setTextActivityBaseEditor(TextActivityBaseEditor tabe){
        this.tabe=tabe;
        if(tabe!=null){
            TextActivityBase tab=(TextActivityBase)tabe.getActivity();
            if(!tab.prevScreen)
                btnNo.setSelected(true);
            else if(tab.prevScreenText==null)
                btnOriginal.setSelected(true);
            else
                btnSpecial.setSelected(true);
        
            textEdit.setText(tab.prevScreenText!=null ? tab.prevScreenText : "");
            timeEdit.setValue(tab.prevScreenMaxTime);
            styleBtn.setBoxBase(tab.prevScreenStyle);
        
            ActiveBoxContent abc=tab.getMessages()[0];
            if(abc!=null)
                abpp.setActiveBoxContent(abc);
            else{
                ActiveBoxContent nabc=new ActiveBoxContent();
                nabc.setBoxBase(new BoxBase());
                abpp.setActiveBoxContent(nabc);
            }
            checkEnabled();
        }
    }
    
    public void checkEnabled(){
        textEdit.setEnabled(btnSpecial.isSelected());
        styleBtn.setEnabled(btnSpecial.isSelected());
        timeEdit.setEnabled(!btnNo.isSelected());
    }
    
    public void actionPerformed(java.awt.event.ActionEvent ev) {
        checkEnabled();
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup mainGroup;
    private edu.xtec.jclic.beans.SmallIntEditor timeEdit;
    private javax.swing.JRadioButton btnSpecial;
    private javax.swing.JTextPane textEdit;
    private edu.xtec.jclic.beans.BoxBaseButton styleBtn;
    private javax.swing.JPanel prevMsgPanel;
    private javax.swing.JRadioButton btnOriginal;
    private javax.swing.JLabel timeLb;
    private javax.swing.JRadioButton btnNo;
    // End of variables declaration//GEN-END:variables
 
    private static Map<Options, TextPrevScreenEditorPanel> panels=new HashMap<Options, TextPrevScreenEditorPanel>(1);
    public static boolean editPrevScreen(Options options, TextActivityBaseEditor tabe, Component parent){
        TextPrevScreenEditorPanel tpsep=panels.get(options);
        if(tpsep==null){
            tpsep=new TextPrevScreenEditorPanel(options);
            panels.put(options, tpsep);
        }
        tpsep.setTextActivityBaseEditor(tabe);
        boolean result=options.getMessages().showInputDlg(parent, tpsep, "edit_text_act_prevScreen_title");
        if(result){
            TextActivityBase tab=(TextActivityBase)tabe.getActivity();
            tab.prevScreen=!tpsep.btnNo.isSelected();
            if(tab.prevScreen){
                tab.prevScreenText=tpsep.btnOriginal.isSelected() ? null : tpsep.textEdit.getText();
                tab.prevScreenStyle=tpsep.styleBtn.getBoxBase();                
                tab.prevScreenMaxTime=tpsep.timeEdit.getValue();
                tab.getMessages()[0]=tpsep.abpp.getActiveBox().getContent();
            }
            else
                tab.getMessages()[0]=null;
        }
        return result;
    }
    
}
