/*
Jaxe - Editeur XML en Java

Copyright (C) 2008 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/
package jaxe;

import org.w3c.dom.Element;

/**
 * Le gestionnaire d'erreurs affiche les erreurs aux utilisateurs.
 * Il peut tre remplac pour une meilleure gestion d'erreurs, comme
 * avec l'affichage de bulles d'aides.
 */
public interface InterfaceGestionErreurs {
    /**
     * L'utilisateur a essay d'ajouter un lment avant ou aprs la racine
     * @param refElement Rfrence vers l'lment que l'utilisateur a essay d'ajouter
     */
    public void pasSousLaRacine(Element refElement);
    
    /**
     * L'utilisateur a essay d'ajouter un lment dans un lment qui n'est pas ditable
     * @param parent L'lment Jaxe dit
     * @param refElement Rfrence vers l'lment que l'utilisateur a essay d'ajouter
     */
    public void editionInterdite(JaxeElement parent, Element refElement);
    
    /**
     * Un enfant n'a pas t insr parce-qu'il n'est pas autoris sous le parent
     * @param refParent L'lment Jaxe du parent
     * @param defbalise Rfrence vers l'lment que l'utilisateur a essay d'insrer
     */
    public void enfantInterditSousParent(JaxeElement parent, Element refElement);
    
    /**
     * L'enfant est interdit  cet endroit d'aprs l'expression rgulire de l'lment parent.
     * @param expr Expression rgulire de l'lment parent
     * @param parent L'lment Jaxe du parent
     * @param refElement Rfrence vers l'lment que l'utilisateur a essay d'insrer
     */
    public void insertionImpossible(String expr, JaxeElement parent, Element refElement);
    
    /**
     * Le texte n'est pas autoris sous cet lment
     * @param je L'lment Jaxe sous lequel le texte n'est pas autoris
     */
    public void texteInterdit(JaxeElement parent);
}
