# coding=utf-8
from color_lesslight import LessLight
from .test_inkex_extensions import ColorBaseCase


class ColorLessLightTest(ColorBaseCase):
    effect_class = LessLight
    color_tests = [
        ("none", "none"),
        ("hsl(0, 0, 0)", "hsl(0, 0, 0)"),
        ("hsl(255, 255, 255)", "hsl(255, 255, 243)"),
        ((0, 0, 0), "#000000"),
        ((255, 255, 255), "#f3f3f3"),
        ((192, 192, 192), "#b4b4b4"),
        ((128, 128, 128), "#747474"),
        ((128, 0, 0), "#680000"),
        ((255, 0, 0), "#e60000"),
        ((128, 128, 0), "#686600"),
        ((255, 255, 0), "#e6e300"),
        ((0, 128, 0), "#006800"),
        ((0, 255, 0), "#00e600"),
        ((0, 128, 128), "#006866"),
        ((0, 255, 255), "#00e6e3"),
        ((0, 0, 128), "#000068"),
        ((0, 0, 255), "#0000e6"),
        ((128, 0, 128), "#660068"),
        ((255, 0, 255), "#e300e6"),
    ]
