{- This module was generated from data in the Kate syntax
   highlighting file coffee.xml, version 2, by Max Shawabkeh (max99x@gmail.com) -}

module Text.Highlighting.Kate.Syntax.Coffee
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert_indent
import qualified Text.Highlighting.Kate.Syntax.Javascript
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "CoffeeScript"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "Cakefile;*.coffee;*.coco"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("CoffeeScript","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("CoffeeScript","Normal") -> return ()
      ("CoffeeScript","Multiline Regex") -> return ()
      ("CoffeeScript","Class") -> return ()
      ("CoffeeScript","Comment") -> (popContext) >> pEndLine
      ("CoffeeScript","Multiline Comment") -> return ()
      ("CoffeeScript","String") -> return ()
      ("CoffeeScript","Rich String") -> return ()
      ("CoffeeScript","Heredoc") -> return ()
      ("CoffeeScript","Rich Heredoc") -> return ()
      ("CoffeeScript","Embedding") -> return ()
      ("CoffeeScript","Javascript") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_value'5fkeywords = Set.fromList $ words $ "false true yes no on off undefined null NaN Infinity"
list_keywords = Set.fromList $ words $ "return break continue throw for while until loop if else unless switch when then and or in do of by is isnt not typeof delete where super try catch finally try catch finally constructor"
list_class'5fkeywords = Set.fromList $ words $ "class extends new instanceof"
list_reserved = Set.fromList $ words $ "case default function var void with const let enum export import native __hasProp __extends __slice __bind __indexOf"
list_globals = Set.fromList $ words $ "Object Number Boolean Array String RegExp Function Date Math eval setInterval clearInterval setTimeout clearTimeout isFinite isNaN parseFloat parseInt escape unescape console encodeURI encodeURIComponent decodeURI decodeURIComponent"
list_browser'5fglobals = Set.fromList $ words $ "window document navigator location history screen alert prompt"
list_nodejs'5fglobals = Set.fromList $ words $ "process GLOBAL require exports"

regex_'28'40'5b'5f'24a'2dzA'2dZ'5d'5b'24'5cw'5d'2a'7c'5cbthis'29'5cb = compileRegex True "(@[_$a-zA-Z][$\\w]*|\\bthis)\\b"
regex_'28'5c'28'28'5c'27'5b'5e'27'5d'2a'27'7c'22'5b'5e'22'5d'2a'22'7c'5b'5e'28'29'5d'29'2a'5c'29'29'3f'5cs'2a'28'2d'7c'3d'29'3e = compileRegex True "(\\((\\'[^']*'|\"[^\"]*\"|[^()])*\\))?\\s*(-|=)>"
regex_'5b'5f'24a'2dz'5d'5b'24'5cw'5d'2a'5cb = compileRegex True "[_$a-z][$\\w]*\\b"
regex_'2f'2f'2f = compileRegex True "///"
regex_'2f'28'5b'5e'2f'5c'5c'5cr'5cn'5d'7c'5c'5c'2e'29'2a'2f'5bmig'5d'7b0'2c3'7d = compileRegex True "/([^/\\\\\\r\\n]|\\\\.)*/[mig]{0,3}"
regex_'2f'2f'2f'5bmig'5d'7b0'2c3'7d = compileRegex True "///[mig]{0,3}"
regex_'5b'40'24'3a'2e'5cw'5c'5b'5c'5d'5d'2b = compileRegex True "[@$:.\\w\\[\\]]+"

parseRules ("CoffeeScript","Normal") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pHlCOct >>= withAttribute BaseNTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_class'5fkeywords >>= withAttribute KeywordTok) >>~ pushContext ("CoffeeScript","Class"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_value'5fkeywords >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_reserved >>= withAttribute AlertTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_globals >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_browser'5fglobals >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\#'" list_nodejs'5fglobals >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'28'40'5b'5f'24a'2dzA'2dZ'5d'5b'24'5cw'5d'2a'7c'5cbthis'29'5cb >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'28'5c'28'28'5c'27'5b'5e'27'5d'2a'27'7c'22'5b'5e'22'5d'2a'22'7c'5b'5e'28'29'5d'29'2a'5c'29'29'3f'5cs'2a'28'2d'7c'3d'29'3e >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5b'5f'24a'2dz'5d'5b'24'5cw'5d'2a'5cb >>= withAttribute NormalTok))
   <|>
   ((pString False "'''" >>= withAttribute StringTok) >>~ pushContext ("CoffeeScript","Heredoc"))
   <|>
   ((pString False "\"\"\"" >>= withAttribute StringTok) >>~ pushContext ("CoffeeScript","Rich Heredoc"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("CoffeeScript","String"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("CoffeeScript","Rich String"))
   <|>
   ((pDetectChar False '`' >>= withAttribute AlertTok) >>~ pushContext ("CoffeeScript","Javascript"))
   <|>
   ((pString False "###" >>= withAttribute CommentTok) >>~ pushContext ("CoffeeScript","Multiline Comment"))
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("CoffeeScript","Comment"))
   <|>
   ((pRegExpr regex_'2f'2f'2f >>= withAttribute StringTok) >>~ pushContext ("CoffeeScript","Multiline Regex"))
   <|>
   ((pRegExpr regex_'2f'28'5b'5e'2f'5c'5c'5cr'5cn'5d'7c'5c'5c'2e'29'2a'2f'5bmig'5d'7b0'2c3'7d >>= withAttribute StringTok))
   <|>
   ((pAnyChar "():!%&+,-/.*<=>?[]|~^;{}" >>= withAttribute KeywordTok))
   <|>
   (currentContext >>= \x -> guard (x == ("CoffeeScript","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CoffeeScript","Multiline Regex") =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("CoffeeScript","Comment"))
   <|>
   ((pRegExpr regex_'2f'2f'2f'5bmig'5d'7b0'2c3'7d >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("CoffeeScript","Multiline Regex")) >> pDefault >>= withAttribute StringTok))

parseRules ("CoffeeScript","Class") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5b'40'24'3a'2e'5cw'5c'5b'5c'5d'5d'2b >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("CoffeeScript","Class")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CoffeeScript","Comment") =
  (((Text.Highlighting.Kate.Syntax.Alert_indent.parseExpression (Just ("Alerts_indent","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("CoffeeScript","Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("CoffeeScript","Multiline Comment") =
  (((pString False "###" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert_indent.parseExpression (Just ("Alerts_indent","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("CoffeeScript","Multiline Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("CoffeeScript","String") =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("CoffeeScript","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("CoffeeScript","Rich String") =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((pDetect2Chars False '#' '{' >>= withAttribute CharTok) >>~ pushContext ("CoffeeScript","Embedding"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("CoffeeScript","Rich String")) >> pDefault >>= withAttribute StringTok))

parseRules ("CoffeeScript","Heredoc") =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((pString False "'''" >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("CoffeeScript","Heredoc")) >> pDefault >>= withAttribute StringTok))

parseRules ("CoffeeScript","Rich Heredoc") =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((pDetect2Chars False '#' '{' >>= withAttribute CharTok) >>~ pushContext ("CoffeeScript","Embedding"))
   <|>
   ((pString False "\"\"\"" >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("CoffeeScript","Rich Heredoc")) >> pDefault >>= withAttribute StringTok))

parseRules ("CoffeeScript","Embedding") =
  (((pDetectChar False '}' >>= withAttribute CharTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("CoffeeScript","Embedding")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CoffeeScript","Javascript") =
  (((pDetectChar False '`' >>= withAttribute AlertTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Javascript.parseExpression (Just ("JavaScript","Normal"))))
   <|>
   (currentContext >>= \x -> guard (x == ("CoffeeScript","Javascript")) >> pDefault >>= withAttribute AlertTok))

parseRules ("Alerts_indent", _) = Text.Highlighting.Kate.Syntax.Alert_indent.parseExpression Nothing
parseRules ("JavaScript", _) = Text.Highlighting.Kate.Syntax.Javascript.parseExpression Nothing

parseRules x = parseRules ("CoffeeScript","Normal") <|> fail ("Unknown context" ++ show x)
