use warnings;
use strict;
use IPC::System::Simple qw(system);
use IPC::Cmd            qw(can_run);
use Test::More tests => 1;
use Gscan2pdf::Helpers;
use Gscan2pdf::Tesseract;
use Gscan2pdf::Document;
use Gscan2pdf::Unpaper;
use Gtk3 -init;  # on some systems, initialising earlier segfaults

#########################

use Log::Log4perl qw(:easy);
Log::Log4perl->easy_init($WARN);
my $logger = Log::Log4perl::get_logger;
Gscan2pdf::Document->setup($logger);

Gscan2pdf::Translation::set_domain('gscan2pdf');

my $slist = Gscan2pdf::Document->new;

# dir for temporary files
my $dir = File::Temp->newdir;
$slist->set_dir($dir);

SKIP: {
    skip 'Tesseract not installed', 1
      unless Gscan2pdf::Tesseract->setup($logger);
    skip 'unpaper not installed', 1 unless can_run('unpaper');

    my $unpaper = Gscan2pdf::Unpaper->new;
    my $vbox    = Gtk3::VBox->new;
    $unpaper->add_options($vbox);

    # Create b&w test image
    system(
        Gscan2pdf::Helpers::get_imagemagick_command(),
        'label:The quick brown fox',
        qw(-alpha Off -depth 1 -colorspace Gray),
        '-family',
        'DejaVu Sans',
        qw(-pointsize 12 -density 300),
        qw(-rotate -90 test.pnm)
    );

    my %options = (
        filename       => 'test.pnm',
        to_png         => 1,
        rotate         => 90,
        unpaper        => $unpaper,
        ocr            => 1,
        resolution     => 300,
        delete         => 0,
        dir            => $dir,
        engine         => 'tesseract',
        language       => 'eng',
        error_callback => sub {
            pass "Didn't hang waiting for deleted page";
            Gtk3->main_quit;
        },
        finished_callback => sub {
            pass "Didn't hang waiting for deleted page";
            Gtk3->main_quit;
        },
    );
    $slist->import_scan( %options, page => 1 );
    $slist->import_scan(
        %options,
        page             => 2,
        started_callback => sub {
            $slist->select(0);
            $slist->delete_selection;
        }
    );
    Gtk3->main;
}

#########################

unlink 'test.pnm';
Gscan2pdf::Document->quit();
