/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package gls.annotations.closures

abstract class AnnotationClosureExhaustiveTestSupport extends GroovyTestCase {
    abstract Class getAnnotationClass()

    abstract Class getAnnotatedClass()

    abstract void verify(Class closureClass)

    void testWorksOnClassLevel() {
        worksOn(annotatedClass)
    }

    void testWorksOnMethodLevel() {
        worksOn(annotatedClass.getDeclaredMethod("aMethod", Object))
    }

    void testWorksOnFieldLevel() {
        worksOn(annotatedClass.getDeclaredField("aField"))
    }

    void testWorksOnPropertyLevel() {
        worksOn(annotatedClass.getDeclaredField("aProperty"))
    }

    private worksOn(level) {
        verify(level.getAnnotation(getAnnotationClass()).elem())
    }
}
