_head <<
"; Thanks to Brian Raiter and his\n"
"; \"A Whirlwind Tutorial on Creating Really Teensy ELF Executables for Linux\".\n"
"; Site:http://www.muppetlabs.com/~breadbox/software/tiny/teensy.html\n"
"\n"
"%define orgno 0x08048000\n"
"BITS 32             \n"
"ORG     orgno\n"
"\n"
"ehdr:                                            \n"
"              db      0x7F, \"ELF\", 1, 1, 1        \n"
"      times 9 db      0                           \n"
"              dw      2                           \n"
"              dw      3                           \n"
"              dd      1                           \n"
"              dd      start                       \n"
"              dd      phdr_text - $$               \n"
"              dd      0                           \n"
"              dd      0                           \n"
"              dw      ehdrsize                    \n"
"              dw      phdrsize                    \n"
"              dw      2                           \n"
"              dw      0                           \n"
"              dw      0                           \n"
"              dw      0                           \n"
"  \n"
"ehdrsize      equ     $ - ehdr\n"
"\n"
"\n"
"phdr_text:                            \n"
"              dd      1               \n"
"              dd      start_no-orgno  \n"
"              dd      start           \n"
"              dd      start           \n"
"              dd      textsize        \n"
"              dd      textsize        \n"
"              dd      5               \n"
"              dd      0x1000          \n"
"phdrsize      equ     $ - phdr_text\n"
"\n"
"phdrdata:                            \n"
"              dd      1              \n"
"              dd      data_no-orgno  \n"
"              dd      data_no        \n"
"              dd      data_no        \n"
"              dd      datasize       \n"
"              dd      datasize | 0x100000       \n"
"              dd      6              \n"
"              dd      0x1000\n"
"\n"
"%macro exit 1\n"
"    mov eax, 1\n"
"    mov ebx, %1\n"
"    int 80h\n"
"%endmacro\n";

#include "asm_prologue.h"

/***************************************************************************/

/* Linux specific syscalls */

_lib << 
"\n"
"print:\n"
"    \n"
"    %define string ebp+8\n"
"\n"
"    begin 0\n"
"\n"
"    addarg dword [string]\n"
"    call strlen\n"
"    clargs 1\n"
"\n"
"    mov edx, eax\n"
"    mov eax, 4\n"
"    mov ebx, 1\n"
"    mov ecx, [string]\n"
"    int 80h\n"
"\n"
"    return\n"
"    %undef string\n"
"\n"
"readline:\n"
"    \n"
"    %define buffer   ebp+12\n"
"    %define size     ebp+8\n"
"    begin 0\n"
"\n"
"    \n"
"    mov eax, 3 \n"
"    mov ebx, 0 \n"
"    mov ecx, [buffer]\n"
"    mov edx, [size]\n"
"    int 80h\n"
"\n"
"    \n"
"    mov ebx, [buffer]\n"
"    mov [ebx+eax-1], byte 0\n"
"\n"
"    return\n\n"
"    %undef buffer\n"
"    %undef size\n";

/* Generic lib */

#include "asm_lib.h"

/* Linux specific footer */

_lib << 
"\n"
"textsize   equ     $ - start_no\n"
"filesize   equ     $ - $$\n";
