/*
    Copyright (C) 2002 Alex Mottram (geo_alexm at cox-internet.com)
    Copyright (C) 2002-2014 Robert Lipe

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

 */

#ifndef CSV_UTIL_H_INCLUDED_
#define CSV_UTIL_H_INCLUDED_

#include <QString>      // for QString
#include <QStringList>  // for QStringList

#include "defs.h"


/* function prototypes */

QString
csv_stringclean(const QString& source, const QString& to_nuke);

QString
csv_stringtrim(const QString& string, const QString& enclosure, int strip_max);
QString
csv_enquote(const QString& str, const QString& enclosure);
QString
csv_dequote(const QString& string, const QString& enclosure);

enum class CsvQuoteMethod {historic, rfc4180};

QStringList
csv_linesplit(const QString& string, const QString& delimited_by,
              const QString& enclosed_in, int line_no, CsvQuoteMethod method = CsvQuoteMethod::historic);

int
dec_to_intdeg(double d);

double
intdeg_to_dec(int ideg);

double
decdir_to_dec(const char* decdir);

double
ddmmdir_to_degrees(const char* ddmmdir);

void
human_to_dec(const QString& instr, double* outlat, double* outlon, int which);

QString
dec_to_human(const char* format, const char* dirs, double val);

#endif // CSV_UTIL_H_INCLUDED_
