#include <stdlib.h>
#include <biff-types.h>

const char *
biff_opcode_name (unsigned int opcode)
{
  switch (opcode) {
  case 0x000: return "BIFF_DIMENSIONS_v0";
  case 0x001: return "BIFF_BLANK_v0";
  case 0x002: return "BIFF_INTEGER";
  case 0x003: return "BIFF_NUMBER_v0";
  case 0x004: return "BIFF_LABEL_v0";
  case 0x005: return "BIFF_BOOLERR_v0";
  case 0x006: return "BIFF_FORMULA_v0";
  case 0x007: return "BIFF_STRING_v0";
  case 0x008: return "BIFF_ROW_v0";
  case 0x009: return "BIFF_BOF_v0";
  case 0x00a: return "BIFF_EOF";
  case 0x00b: return "BIFF_INDEX_v0";
  case 0x00c: return "BIFF_CALCCOUNT";
  case 0x00d: return "BIFF_CALCMODE";
  case 0x00e: return "BIFF_PRECISION";
  case 0x00f: return "BIFF_REFMODE";
  case 0x010: return "BIFF_DELTA";
  case 0x011: return "BIFF_ITERATION";
  case 0x012: return "BIFF_PROTECT";
  case 0x013: return "BIFF_PASSWORD";
  case 0x014: return "BIFF_HEADER";
  case 0x015: return "BIFF_FOOTER";
  case 0x016: return "BIFF_EXTERNCOUNT";
  case 0x017: return "BIFF_EXTERNSHEET";
  case 0x018: return "BIFF_NAME_v0";
  case 0x019: return "BIFF_WINDOWPROTECT";
  case 0x01a: return "BIFF_VERTICALPAGEBREAKS";
  case 0x01b: return "BIFF_HORIZONTALPAGEBREAKS";
  case 0x01c: return "BIFF_NOTE";
  case 0x01d: return "BIFF_SELECTION";
  case 0x01e: return "BIFF_FORMAT_v0";
  case 0x01f: return "BIFF_FORMATCOUNT";
  case 0x020: return "BIFF_COLUMNDEFAULT";
  case 0x021: return "BIFF_ARRAY_v0";
  case 0x022: return "BIFF_1904";
  case 0x023: return "BIFF_EXTERNNAME_v0";
  case 0x024: return "BIFF_COLWIDTH";
  case 0x025: return "BIFF_DEFAULTROWHEIGHT_v0";
  case 0x026: return "BIFF_LEFT_MARGIN";
  case 0x027: return "BIFF_RIGHT_MARGIN";
  case 0x028: return "BIFF_TOP_MARGIN";
  case 0x029: return "BIFF_BOTTOM_MARGIN";
  case 0x02a: return "BIFF_PRINTHEADERS";
  case 0x02b: return "BIFF_PRINTGRIDLINES";
  case 0x02f: return "BIFF_FILEPASS";
  case 0x031: return "BIFF_FONT_v0";
  case 0x032: return "BIFF_FONTCOUNT";
  case 0x033: return "BIFF_PRINTSIZE";
  case 0x036: return "BIFF_TABLE_v0";
  case 0x037: return "BIFF_TABLE2";
  case 0x038: return "BIFF_WNDESK";
  case 0x039: return "BIFF_ZOOM";
  case 0x03a: return "BIFF_BEGINPREF";
  case 0x03b: return "BIFF_ENDPREF";
  case 0x03c: return "BIFF_CONTINUE";
  case 0x03d: return "BIFF_WINDOW1";
  case 0x03e: return "BIFF_WINDOW2_v0";
  case 0x03f: return "BIFF_PANE_V2";
  case 0x040: return "BIFF_BACKUP";
  case 0x041: return "BIFF_PANE";
  case 0x042: return "BIFF_CODEPAGE";
  case 0x043: return "BIFF_XF_OLD_v0";
  case 0x044: return "BIFF_XF_INDEX";
  case 0x045: return "BIFF_FONT_COLOR";
  case 0x04d: return "BIFF_PLS";
  case 0x050: return "BIFF_DCON";
  case 0x051: return "BIFF_DCONREF";
  case 0x052: return "BIFF_DCONNAME";
  case 0x055: return "BIFF_DEFCOLWIDTH";
  case 0x059: return "BIFF_XCT";
  case 0x05a: return "BIFF_CRN";
  case 0x05b: return "BIFF_FILESHARING";
  case 0x05c: return "BIFF_WRITEACCESS";
  case 0x05d: return "BIFF_OBJ";
  case 0x05e: return "BIFF_UNCALCED";
  case 0x05f: return "BIFF_SAVERECALC";
  case 0x060: return "BIFF_TEMPLATE";
  case 0x061: return "BIFF_INTL";
  case 0x063: return "BIFF_OBJPROTECT";
  case 0x07d: return "BIFF_COLINFO";
  case 0x07f: return "BIFF_IMDATA";
  case 0x080: return "BIFF_GUTS";
  case 0x081: return "BIFF_WSBOOL";
  case 0x082: return "BIFF_GRIDSET";
  case 0x083: return "BIFF_HCENTER";
  case 0x084: return "BIFF_VCENTER";
  case 0x085: return "BIFF_BOUNDSHEET";
  case 0x086: return "BIFF_WRITEPROT";
  case 0x087: return "BIFF_ADDIN";
  case 0x088: return "BIFF_EDG";
  case 0x089: return "BIFF_PUB";
  case 0x08c: return "BIFF_COUNTRY";
  case 0x08d: return "BIFF_HIDEOBJ";
  case 0x08e: return "BIFF_BUNDLESOFFSET";
  case 0x08f: return "BIFF_BUNDLEHEADER";
  case 0x090: return "BIFF_SORT";
  case 0x091: return "BIFF_SUB";
  case 0x092: return "BIFF_PALETTE";
  case 0x094: return "BIFF_LHRECORD";
  case 0x095: return "BIFF_LHNGRAPH";
  case 0x096: return "BIFF_SOUND";
  case 0x097: return "BIFF_SYNC";
  case 0x098: return "BIFF_LPR";
  case 0x099: return "BIFF_STANDARDWIDTH";
  case 0x09a: return "BIFF_FNGROUPNAME";
  case 0x09b: return "BIFF_FILTERMODE";
  case 0x09c: return "BIFF_FNGROUPCOUNT";
  case 0x09d: return "BIFF_AUTOFILTERINFO";
  case 0x09e: return "BIFF_AUTOFILTER";
  case 0x0a0: return "BIFF_SCL";
  case 0x0a1: return "BIFF_SETUP";
  case 0x0a4: return "BIFF_TOOLBARVER";
  case 0x0a9: return "BIFF_COORDLIST";
  case 0x0ab: return "BIFF_GCW";
  case 0x0ae: return "BIFF_SCENMAN";
  case 0x0af: return "BIFF_SCENARIO";
  case 0x0b0: return "BIFF_SXVIEW";
  case 0x0b1: return "BIFF_SXVD";
  case 0x0b2: return "BIFF_SXVI";
  case 0x0b3: return "BIFF_SXSI";
  case 0x0b4: return "BIFF_SXIVD";
  case 0x0b5: return "BIFF_SXLI";
  case 0x0b6: return "BIFF_SXPI";
  case 0x0b7: return "BIFF_FACENUM";
  case 0x0b8: return "BIFF_DOCROUTE";
  case 0x0b9: return "BIFF_RECIPNAME";
  case 0x0ba: return "BIFF_SSLIST";
  case 0x0bb: return "BIFF_MASKIMDATA";
  case 0x0bd: return "BIFF_MULRK";
  case 0x0be: return "BIFF_MULBLANK";
  case 0x0bf: return "BIFF_TOOLBARHDR";
  case 0x0c0: return "BIFF_TOOLBAREND";
  case 0x0c1: return "BIFF_MMS";
  case 0x0c2: return "BIFF_ADDMENU";
  case 0x0c3: return "BIFF_DELMENU";
  case 0x0c4: return "BIFF_TIPHISTORY";
  case 0x0c5: return "BIFF_SXDI";
  case 0x0c6: return "BIFF_SXDB";
  case 0x0c7: return "BIFF_SXFDB";
  case 0x0c8: return "BIFF_SXDDB";
  case 0x0c9: return "BIFF_SXNUM";
  case 0x0ca: return "BIFF_SXBOOL";
  case 0x0cb: return "BIFF_SXERR";
  case 0x0cc: return "BIFF_SXINT";
  case 0x0cd: return "BIFF_SXSTRING";
  case 0x0ce: return "BIFF_SXDTR";
  case 0x0cf: return "BIFF_SXNIL";
  case 0x0d0: return "BIFF_SXTBL";
  case 0x0d1: return "BIFF_SXTBRGIITM";
  case 0x0d2: return "BIFF_SXTBPG";
  case 0x0d3: return "BIFF_OBPROJ";
  case 0x0d5: return "BIFF_SXStreamID";
  case 0x0d6: return "BIFF_RSTRING";
  case 0x0d7: return "BIFF_DBCELL";
  case 0x0d8: return "BIFF_SXNUMGROUP";
  case 0x0da: return "BIFF_BOOKBOOL";
  case 0x0dc: return "BIFF_PARAMQRY/BIFF_SXEXT";
  case 0x0dd: return "BIFF_SCENPROTECT";
  case 0x0de: return "BIFF_OLESIZE";
  case 0x0df: return "BIFF_UDDESC";
  case 0x0e0: return "BIFF_XF";
  case 0x0e1: return "BIFF_INTERFACEHDR";
  case 0x0e2: return "BIFF_INTERFACEEND";
  case 0x0e3: return "BIFF_SXVS";
  case 0x0e5: return "BIFF_MERGECELLS";
  case 0x0e9: return "BIFF_BG_PIC";
  case 0x0ea: return "BIFF_TABIDCONF";
  case 0x0eb: return "BIFF_MS_O_DRAWING_GROUP";
  case 0x0ec: return "BIFF_MS_O_DRAWING";
  case 0x0ed: return "BIFF_MS_O_DRAWING_SELECTION";
  case 0x0ef: return "BIFF_PHONETIC";
  case 0x0f0: return "BIFF_SXRULE";
  case 0x0f1: return "BIFF_SXEX";
  case 0x0f2: return "BIFF_SXFILT";
  case 0x0f6: return "BIFF_SXNAME";
  case 0x0f7: return "BIFF_SXSELECT";
  case 0x0f8: return "BIFF_SXPAIR";
  case 0x0f9: return "BIFF_SXFMLA";
  case 0x0fb: return "BIFF_SXFORMAT";
  case 0x0fc: return "BIFF_SST";
  case 0x0fd: return "BIFF_LABELSST";
  case 0x0ff: return "BIFF_EXTSST";
  case 0x100: return "BIFF_SXVDEX";
  case 0x1001: return "BIFF_CHART_units";
  case 0x1002: return "BIFF_CHART_chart";
  case 0x1003: return "BIFF_CHART_series";
  case 0x1006: return "BIFF_CHART_dataformat";
  case 0x1007: return "BIFF_CHART_lineformat";
  case 0x1009: return "BIFF_CHART_markerformat";
  case 0x100a: return "BIFF_CHART_areaformat";
  case 0x100b: return "BIFF_CHART_pieformat";
  case 0x100c: return "BIFF_CHART_attachedlabel";
  case 0x100d: return "BIFF_CHART_seriestext";
  case 0x1014: return "BIFF_CHART_chartformat";
  case 0x1015: return "BIFF_CHART_legend";
  case 0x1016: return "BIFF_CHART_serieslist";
  case 0x1017: return "BIFF_CHART_bar";
  case 0x1018: return "BIFF_CHART_line";
  case 0x1019: return "BIFF_CHART_pie";
  case 0x101a: return "BIFF_CHART_area";
  case 0x101b: return "BIFF_CHART_scatter";
  case 0x101c: return "BIFF_CHART_chartline";
  case 0x101d: return "BIFF_CHART_axis";
  case 0x101e: return "BIFF_CHART_tick";
  case 0x101f: return "BIFF_CHART_valuerange";
  case 0x1020: return "BIFF_CHART_catserrange";
  case 0x1021: return "BIFF_CHART_axislineformat";
  case 0x1022: return "BIFF_CHART_chartformatlink";
  case 0x1024: return "BIFF_CHART_defaulttext";
  case 0x1025: return "BIFF_CHART_text";
  case 0x1026: return "BIFF_CHART_fontx";
  case 0x1027: return "BIFF_CHART_objectlink";
  case 0x103: return "BIFF_SXFORMULA";
  case 0x1032: return "BIFF_CHART_frame";
  case 0x1033: return "BIFF_CHART_begin";
  case 0x1034: return "BIFF_CHART_end";
  case 0x1035: return "BIFF_CHART_plotarea";
  case 0x103a: return "BIFF_CHART_3d";
  case 0x103c: return "BIFF_CHART_picf";
  case 0x103d: return "BIFF_CHART_dropbar";
  case 0x103e: return "BIFF_CHART_radar";
  case 0x103f: return "BIFF_CHART_surf";
  case 0x1040: return "BIFF_CHART_radararea";
  case 0x1041: return "BIFF_CHART_axisparent";
  case 0x1043: return "BIFF_CHART_legendxn";
  case 0x1044: return "BIFF_CHART_shtprops";
  case 0x1045: return "BIFF_CHART_sertocrt";
  case 0x1046: return "BIFF_CHART_axesused";
  case 0x1048: return "BIFF_CHART_sbaseref";
  case 0x104a: return "BIFF_CHART_serparent";
  case 0x104b: return "BIFF_CHART_serauxtrend";
  case 0x104e: return "BIFF_CHART_ifmt";
  case 0x104f: return "BIFF_CHART_pos";
  case 0x1050: return "BIFF_CHART_alruns";
  case 0x1051: return "BIFF_CHART_ai";
  case 0x105b: return "BIFF_CHART_serauxerrbar";
  case 0x105c: return "BIFF_CHART_clrtclient";
  case 0x105d: return "BIFF_CHART_serfmt";
  case 0x105f: return "BIFF_CHART_3dbarshape";
  case 0x1060: return "BIFF_CHART_fbi";
  case 0x1061: return "BIFF_CHART_boppop";
  case 0x1062: return "BIFF_CHART_axcext";
  case 0x1063: return "BIFF_CHART_dat";
  case 0x1064: return "BIFF_CHART_plotgrowth";
  case 0x1065: return "BIFF_CHART_siindex";
  case 0x1066: return "BIFF_CHART_gelframe";
  case 0x1067: return "BIFF_CHART_boppopcustom";
  case 0x10C0: return "BIFF_CHART_trendlimits";
  case 0x122: return "BIFF_SXDBEX";
  case 0x137: return "BIFF_CHTRINSERT";
  case 0x138: return "BIFF_CHTRINFO";
  case 0x13B: return "BIFF_CHTRCELLCONTENT";
  case 0x13d: return "BIFF_TABID";
  case 0x140: return "BIFF_CHTRMOVERANGE";
  case 0x14D: return "BIFF_CHTRINSERTTAB";
  case 0x15F: return "BIFF_LABELRANGES";
  case 0x160: return "BIFF_USESELFS";
  case 0x161: return "BIFF_DSF";
  case 0x162: return "BIFF_XL5MODIFY";
  case 0x196: return "BIFF_CHTRHEADER";
  case 0x1a5: return "BIFF_FILESHARING2";
  case 0x1a9: return "BIFF_USERDBVIEW";
  case 0x1aa: return "BIFF_USERSVIEWBEGIN";
  case 0x1ab: return "BIFF_USERSVIEWEND";
  case 0x1ad: return "BIFF_QSI";
  case 0x1ae: return "BIFF_SUPBOOK";
  case 0x1af: return "BIFF_PROT4REV";
  case 0x1b0: return "BIFF_CONDFMT";
  case 0x1b1: return "BIFF_CF";
  case 0x1b2: return "BIFF_DVAL";
  case 0x1b5: return "BIFF_DCONBIN";
  case 0x1b6: return "BIFF_TXO";
  case 0x1b7: return "BIFF_REFRESHALL";
  case 0x1b8: return "BIFF_HLINK";
  case 0x1ba: return "BIFF_CODENAME";
  case 0x1bb: return "BIFF_SXFDBTYPE";
  case 0x1bc: return "BIFF_PROT4REVPASS";
  case 0x1be: return "BIFF_DV";
  case 0x1c0: return "BIFF_XL9FILE";
  case 0x1c1: return "BIFF_RECALCID";
  case 0x200: return "BIFF_DIMENSIONS_v2";
  case 0x201: return "BIFF_BLANK_v2";
  case 0x203: return "BIFF_NUMBER_v2";
  case 0x204: return "BIFF_LABEL_v2";
  case 0x205: return "BIFF_BOOLERR_v2";
  case 0x206: return "BIFF_FORMULA_v2";
  case 0x207: return "BIFF_STRING_v2";
  case 0x208: return "BIFF_ROW_v2";
  case 0x209: return "BIFF_BOF_v2";
  case 0x20b: return "BIFF_INDEX_v2";
  case 0x218: return "BIFF_NAME_v2";
  case 0x221: return "BIFF_ARRAY_v2";
  case 0x223: return "BIFF_EXTERNNAME_v2";
  case 0x225: return "BIFF_DEFAULTROWHEIGHT_v2";
  case 0x231: return "BIFF_FONT_v2";
  case 0x236: return "BIFF_TABLE_v2";
  case 0x23e: return "BIFF_WINDOW2_v2";
  case 0x243: return "BIFF_XF_OLD_v2";
  case 0x27e: return "BIFF_RK";
  case 0x293: return "BIFF_STYLE";
  case 0x406: return "BIFF_FORMULA_v4";
  case 0x409: return "BIFF_BOF_v4";
  case 0x41e: return "BIFF_FORMAT_v4";
  case 0x443: return "BIFF_XF_OLD_v4";
  case 0x4bc: return "BIFF_SHRFMLA";
  case 0x800: return "BIFF_LINK_TIP";
  case 0x801: return "BIFF_WEBPUB";
  case 0x802: return "BIFF_QSISXTAG";
  case 0x803: return "BIFF_DBQUERYEXT";
  case 0x804: return "BIFF_EXTSTRING";
  case 0x805: return "BIFF_TXTQUERY";
  case 0x806: return "BIFF_QSIR";
  case 0x807: return "BIFF_QSIF";
  case 0x809: return "BIFF_BOF_v8";
  case 0x80A: return "BIFF_OLEDBCONN";
  case 0x80B: return "BIFF_WOPT";
  case 0x80C: return "BIFF_SXVIEWEX";
  case 0x80D: return "BIFF_SXTH";
  case 0x80E: return "BIFF_SXPIEX";
  case 0x80F: return "BIFF_SXVDTEX";
  case 0x810: return "BIFF_SXVIEWEX9";
  case 0x812: return "BIFF_CONTINUEFRT";
  case 0x813: return "BIFF_REALTIMEDATA";
  case 0x862: return "BIFF_TAB_COLOR/BIFF_SHEETEXT";
  case 0x863: return "BIFF_BOOKEXT";
  case 0x864: return "BIFF_SXADDL";
  case 0x865: return "BIFF_CRASHRECERR";
  case 0x866: return "BIFF_HFPICTURE";
  case 0x867: return "BIFF_SHEETPROTECTION";
  case 0x868: return "BIFF_RANGEPROTECTION";
  default: return NULL;
  }
}
