/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2016 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

namespace BitBoard
{
    /* Bitboard for each location */
    public const uint64 set_location_masks[] =
    {
        0x0000000000000001, 0x0000000000000002, 0x0000000000000004, 0x0000000000000008,
        0x0000000000000010, 0x0000000000000020, 0x0000000000000040, 0x0000000000000080,
        0x0000000000000100, 0x0000000000000200, 0x0000000000000400, 0x0000000000000800,
        0x0000000000001000, 0x0000000000002000, 0x0000000000004000, 0x0000000000008000,
        0x0000000000010000, 0x0000000000020000, 0x0000000000040000, 0x0000000000080000,
        0x0000000000100000, 0x0000000000200000, 0x0000000000400000, 0x0000000000800000,
        0x0000000001000000, 0x0000000002000000, 0x0000000004000000, 0x0000000008000000,
        0x0000000010000000, 0x0000000020000000, 0x0000000040000000, 0x0000000080000000,
        0x0000000100000000, 0x0000000200000000, 0x0000000400000000, 0x0000000800000000,
        0x0000001000000000, 0x0000002000000000, 0x0000004000000000, 0x0000008000000000,
        0x0000010000000000, 0x0000020000000000, 0x0000040000000000, 0x0000080000000000,
        0x0000100000000000, 0x0000200000000000, 0x0000400000000000, 0x0000800000000000,
        0x0001000000000000, 0x0002000000000000, 0x0004000000000000, 0x0008000000000000,
        0x0010000000000000, 0x0020000000000000, 0x0040000000000000, 0x0080000000000000,
        0x0100000000000000, 0x0200000000000000, 0x0400000000000000, 0x0800000000000000,
        0x1000000000000000, 0x2000000000000000, 0x4000000000000000, 0x8000000000000000
    };

    /* Mask to clear the given location */
    public const uint64 clear_location_masks[] =
    {
        0xfffffffffffffffe, 0xfffffffffffffffd, 0xfffffffffffffffb, 0xfffffffffffffff7,
        0xffffffffffffffef, 0xffffffffffffffdf, 0xffffffffffffffbf, 0xffffffffffffff7f,
        0xfffffffffffffeff, 0xfffffffffffffdff, 0xfffffffffffffbff, 0xfffffffffffff7ff,
        0xffffffffffffefff, 0xffffffffffffdfff, 0xffffffffffffbfff, 0xffffffffffff7fff,
        0xfffffffffffeffff, 0xfffffffffffdffff, 0xfffffffffffbffff, 0xfffffffffff7ffff,
        0xffffffffffefffff, 0xffffffffffdfffff, 0xffffffffffbfffff, 0xffffffffff7fffff,
        0xfffffffffeffffff, 0xfffffffffdffffff, 0xfffffffffbffffff, 0xfffffffff7ffffff,
        0xffffffffefffffff, 0xffffffffdfffffff, 0xffffffffbfffffff, 0xffffffff7fffffff,
        0xfffffffeffffffff, 0xfffffffdffffffff, 0xfffffffbffffffff, 0xfffffff7ffffffff,
        0xffffffefffffffff, 0xffffffdfffffffff, 0xffffffbfffffffff, 0xffffff7fffffffff,
        0xfffffeffffffffff, 0xfffffdffffffffff, 0xfffffbffffffffff, 0xfffff7ffffffffff,
        0xffffefffffffffff, 0xffffdfffffffffff, 0xffffbfffffffffff, 0xffff7fffffffffff,
        0xfffeffffffffffff, 0xfffdffffffffffff, 0xfffbffffffffffff, 0xfff7ffffffffffff,
        0xffefffffffffffff, 0xffdfffffffffffff, 0xffbfffffffffffff, 0xff7fffffffffffff,
        0xfeffffffffffffff, 0xfdffffffffffffff, 0xfbffffffffffffff, 0xf7ffffffffffffff,
        0xefffffffffffffff, 0xdfffffffffffffff, 0xbfffffffffffffff, 0x7fffffffffffffff
    };

    /* Locations moved over for each move */
    public const uint64 over_masks[] =
    {
        0x0000000000000000, 0x0000000000000000, 0x0000000000000002, 0x0000000000000006,
        0x000000000000000e, 0x000000000000001e, 0x000000000000003e, 0x000000000000007e,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000100, 0x0000000000000000, 0x0000000000000200, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000010100, 0x0000000000000000, 0x0000000000000000, 0x0000000000040200,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000001010100, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000008040200, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000101010100, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000001008040200, 0x0000000000000000, 0x0000000000000000,
        0x0000010101010100, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000201008040200, 0x0000000000000000,
        0x0001010101010100, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0040201008040200,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000004,
        0x000000000000000c, 0x000000000000001c, 0x000000000000003c, 0x000000000000007c,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000200, 0x0000000000000000, 0x0000000000000400,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000020200, 0x0000000000000000, 0x0000000000000000,
        0x0000000000080400, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000002020200, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000010080400, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000202020200, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000002010080400, 0x0000000000000000,
        0x0000000000000000, 0x0000020202020200, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000402010080400,
        0x0000000000000000, 0x0002020202020200, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000002, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000008, 0x0000000000000018, 0x0000000000000038, 0x0000000000000078,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000200, 0x0000000000000000, 0x0000000000000400, 0x0000000000000000,
        0x0000000000000800, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000040400, 0x0000000000000000,
        0x0000000000000000, 0x0000000000100800, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000004040400, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000020100800, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000404040400, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000004020100800,
        0x0000000000000000, 0x0000000000000000, 0x0000040404040400, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0004040404040400, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000006, 0x0000000000000004, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000010, 0x0000000000000030, 0x0000000000000070,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000400, 0x0000000000000000, 0x0000000000000800,
        0x0000000000000000, 0x0000000000001000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000020400, 0x0000000000000000, 0x0000000000000000, 0x0000000000080800,
        0x0000000000000000, 0x0000000000000000, 0x0000000000201000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000008080800,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000040201000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000808080800,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000080808080800,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0008080808080800,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x000000000000000e, 0x000000000000000c, 0x0000000000000008, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000020, 0x0000000000000060,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000800, 0x0000000000000000,
        0x0000000000001000, 0x0000000000000000, 0x0000000000002000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000040800, 0x0000000000000000, 0x0000000000000000,
        0x0000000000101000, 0x0000000000000000, 0x0000000000000000, 0x0000000000402000,
        0x0000000002040800, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000010101000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000001010101000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000101010101000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0010101010101000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x000000000000001e, 0x000000000000001c, 0x0000000000000018, 0x0000000000000010,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000040,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000001000,
        0x0000000000000000, 0x0000000000002000, 0x0000000000000000, 0x0000000000004000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000081000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000202000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000004081000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000020202000, 0x0000000000000000, 0x0000000000000000,
        0x0000000204081000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000002020202000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000202020202000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0020202020202000, 0x0000000000000000, 0x0000000000000000,
        0x000000000000003e, 0x000000000000003c, 0x0000000000000038, 0x0000000000000030,
        0x0000000000000020, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000002000, 0x0000000000000000, 0x0000000000004000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000102000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000404000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000008102000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000040404000, 0x0000000000000000,
        0x0000000000000000, 0x0000000408102000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000004040404000, 0x0000000000000000,
        0x0000020408102000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000404040404000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0040404040404000, 0x0000000000000000,
        0x000000000000007e, 0x000000000000007c, 0x0000000000000078, 0x0000000000000070,
        0x0000000000000060, 0x0000000000000040, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000004000, 0x0000000000000000, 0x0000000000008000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000204000, 0x0000000000000000, 0x0000000000000000, 0x0000000000808000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000010204000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000080808000,
        0x0000000000000000, 0x0000000000000000, 0x0000000810204000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000008080808000,
        0x0000000000000000, 0x0000040810204000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000808080808000,
        0x0002040810204000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0080808080808000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000200, 0x0000000000000600,
        0x0000000000000e00, 0x0000000000001e00, 0x0000000000003e00, 0x0000000000007e00,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000010000, 0x0000000000000000, 0x0000000000020000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000001010000, 0x0000000000000000, 0x0000000000000000, 0x0000000004020000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000101010000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000804020000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000010101010000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000100804020000, 0x0000000000000000, 0x0000000000000000,
        0x0001010101010000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0020100804020000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000400,
        0x0000000000000c00, 0x0000000000001c00, 0x0000000000003c00, 0x0000000000007c00,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000020000, 0x0000000000000000, 0x0000000000040000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000002020000, 0x0000000000000000, 0x0000000000000000,
        0x0000000008040000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000202020000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000001008040000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000020202020000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000201008040000, 0x0000000000000000,
        0x0000000000000000, 0x0002020202020000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0040201008040000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000200, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000800, 0x0000000000001800, 0x0000000000003800, 0x0000000000007800,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000020000, 0x0000000000000000, 0x0000000000040000, 0x0000000000000000,
        0x0000000000080000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000004040000, 0x0000000000000000,
        0x0000000000000000, 0x0000000010080000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000404040000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000002010080000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000040404040000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000402010080000,
        0x0000000000000000, 0x0000000000000000, 0x0004040404040000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000600, 0x0000000000000400, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000001000, 0x0000000000003000, 0x0000000000007000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000040000, 0x0000000000000000, 0x0000000000080000,
        0x0000000000000000, 0x0000000000100000, 0x0000000000000000, 0x0000000000000000,
        0x0000000002040000, 0x0000000000000000, 0x0000000000000000, 0x0000000008080000,
        0x0000000000000000, 0x0000000000000000, 0x0000000020100000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000808080000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000004020100000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000080808080000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0008080808080000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000e00, 0x0000000000000c00, 0x0000000000000800, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000002000, 0x0000000000006000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000080000, 0x0000000000000000,
        0x0000000000100000, 0x0000000000000000, 0x0000000000200000, 0x0000000000000000,
        0x0000000000000000, 0x0000000004080000, 0x0000000000000000, 0x0000000000000000,
        0x0000000010100000, 0x0000000000000000, 0x0000000000000000, 0x0000000040200000,
        0x0000000204080000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000001010100000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000101010100000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0010101010100000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000001e00, 0x0000000000001c00, 0x0000000000001800, 0x0000000000001000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000004000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000100000,
        0x0000000000000000, 0x0000000000200000, 0x0000000000000000, 0x0000000000400000,
        0x0000000000000000, 0x0000000000000000, 0x0000000008100000, 0x0000000000000000,
        0x0000000000000000, 0x0000000020200000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000408100000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000002020200000, 0x0000000000000000, 0x0000000000000000,
        0x0000020408100000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000202020200000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0020202020200000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000003e00, 0x0000000000003c00, 0x0000000000003800, 0x0000000000003000,
        0x0000000000002000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000200000, 0x0000000000000000, 0x0000000000400000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000010200000,
        0x0000000000000000, 0x0000000000000000, 0x0000000040400000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000810200000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000004040400000, 0x0000000000000000,
        0x0000000000000000, 0x0000040810200000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000404040400000, 0x0000000000000000,
        0x0002040810200000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0040404040400000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000007e00, 0x0000000000007c00, 0x0000000000007800, 0x0000000000007000,
        0x0000000000006000, 0x0000000000004000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000400000, 0x0000000000000000, 0x0000000000800000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000020400000, 0x0000000000000000, 0x0000000000000000, 0x0000000080800000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000001020400000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000008080800000,
        0x0000000000000000, 0x0000000000000000, 0x0000081020400000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000808080800000,
        0x0000000000000000, 0x0004081020400000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0080808080800000,
        0x0000000000000100, 0x0000000000000000, 0x0000000000000200, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000020000, 0x0000000000060000,
        0x00000000000e0000, 0x00000000001e0000, 0x00000000003e0000, 0x00000000007e0000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000001000000, 0x0000000000000000, 0x0000000002000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000101000000, 0x0000000000000000, 0x0000000000000000, 0x0000000402000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000010101000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000080402000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0001010101000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0010080402000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000200, 0x0000000000000000, 0x0000000000000400,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000040000,
        0x00000000000c0000, 0x00000000001c0000, 0x00000000003c0000, 0x00000000007c0000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000002000000, 0x0000000000000000, 0x0000000004000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000202000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000804000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000020202000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000100804000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0002020202000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0020100804000000, 0x0000000000000000,
        0x0000000000000200, 0x0000000000000000, 0x0000000000000400, 0x0000000000000000,
        0x0000000000000800, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000020000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000080000, 0x0000000000180000, 0x0000000000380000, 0x0000000000780000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000002000000, 0x0000000000000000, 0x0000000004000000, 0x0000000000000000,
        0x0000000008000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000404000000, 0x0000000000000000,
        0x0000000000000000, 0x0000001008000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000040404000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000201008000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0004040404000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0040201008000000,
        0x0000000000000000, 0x0000000000000400, 0x0000000000000000, 0x0000000000000800,
        0x0000000000000000, 0x0000000000001000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000060000, 0x0000000000040000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000100000, 0x0000000000300000, 0x0000000000700000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000004000000, 0x0000000000000000, 0x0000000008000000,
        0x0000000000000000, 0x0000000010000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000204000000, 0x0000000000000000, 0x0000000000000000, 0x0000000808000000,
        0x0000000000000000, 0x0000000000000000, 0x0000002010000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000080808000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000402010000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0008080808000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000800, 0x0000000000000000,
        0x0000000000001000, 0x0000000000000000, 0x0000000000002000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x00000000000e0000, 0x00000000000c0000, 0x0000000000080000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000200000, 0x0000000000600000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000008000000, 0x0000000000000000,
        0x0000000010000000, 0x0000000000000000, 0x0000000020000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000408000000, 0x0000000000000000, 0x0000000000000000,
        0x0000001010000000, 0x0000000000000000, 0x0000000000000000, 0x0000004020000000,
        0x0000020408000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000101010000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0010101010000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000001000,
        0x0000000000000000, 0x0000000000002000, 0x0000000000000000, 0x0000000000004000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x00000000001e0000, 0x00000000001c0000, 0x0000000000180000, 0x0000000000100000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000400000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000010000000,
        0x0000000000000000, 0x0000000020000000, 0x0000000000000000, 0x0000000040000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000810000000, 0x0000000000000000,
        0x0000000000000000, 0x0000002020000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000040810000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000202020000000, 0x0000000000000000, 0x0000000000000000,
        0x0002040810000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0020202020000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000002000, 0x0000000000000000, 0x0000000000004000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x00000000003e0000, 0x00000000003c0000, 0x0000000000380000, 0x0000000000300000,
        0x0000000000200000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000020000000, 0x0000000000000000, 0x0000000040000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000001020000000,
        0x0000000000000000, 0x0000000000000000, 0x0000004040000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000081020000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000404040000000, 0x0000000000000000,
        0x0000000000000000, 0x0004081020000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0040404040000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000004000, 0x0000000000000000, 0x0000000000008000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x00000000007e0000, 0x00000000007c0000, 0x0000000000780000, 0x0000000000700000,
        0x0000000000600000, 0x0000000000400000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000040000000, 0x0000000000000000, 0x0000000080000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000002040000000, 0x0000000000000000, 0x0000000000000000, 0x0000008080000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000102040000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000808080000000,
        0x0000000000000000, 0x0000000000000000, 0x0008102040000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0080808080000000,
        0x0000000000010100, 0x0000000000000000, 0x0000000000000000, 0x0000000000020400,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000010000, 0x0000000000000000, 0x0000000000020000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000002000000, 0x0000000006000000,
        0x000000000e000000, 0x000000001e000000, 0x000000003e000000, 0x000000007e000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000100000000, 0x0000000000000000, 0x0000000200000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000010100000000, 0x0000000000000000, 0x0000000000000000, 0x0000040200000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0001010100000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0008040200000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000020200, 0x0000000000000000, 0x0000000000000000,
        0x0000000000040800, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000020000, 0x0000000000000000, 0x0000000000040000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000004000000,
        0x000000000c000000, 0x000000001c000000, 0x000000003c000000, 0x000000007c000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000200000000, 0x0000000000000000, 0x0000000400000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000020200000000, 0x0000000000000000, 0x0000000000000000,
        0x0000080400000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0002020200000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0010080400000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000040400, 0x0000000000000000,
        0x0000000000000000, 0x0000000000081000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000020000, 0x0000000000000000, 0x0000000000040000, 0x0000000000000000,
        0x0000000000080000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000002000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000008000000, 0x0000000018000000, 0x0000000038000000, 0x0000000078000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000200000000, 0x0000000000000000, 0x0000000400000000, 0x0000000000000000,
        0x0000000800000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000040400000000, 0x0000000000000000,
        0x0000000000000000, 0x0000100800000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0004040400000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0020100800000000, 0x0000000000000000,
        0x0000000000040200, 0x0000000000000000, 0x0000000000000000, 0x0000000000080800,
        0x0000000000000000, 0x0000000000000000, 0x0000000000102000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000040000, 0x0000000000000000, 0x0000000000080000,
        0x0000000000000000, 0x0000000000100000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000006000000, 0x0000000004000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000010000000, 0x0000000030000000, 0x0000000070000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000400000000, 0x0000000000000000, 0x0000000800000000,
        0x0000000000000000, 0x0000001000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000020400000000, 0x0000000000000000, 0x0000000000000000, 0x0000080800000000,
        0x0000000000000000, 0x0000000000000000, 0x0000201000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0008080800000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0040201000000000,
        0x0000000000000000, 0x0000000000080400, 0x0000000000000000, 0x0000000000000000,
        0x0000000000101000, 0x0000000000000000, 0x0000000000000000, 0x0000000000204000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000080000, 0x0000000000000000,
        0x0000000000100000, 0x0000000000000000, 0x0000000000200000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x000000000e000000, 0x000000000c000000, 0x0000000008000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000020000000, 0x0000000060000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000800000000, 0x0000000000000000,
        0x0000001000000000, 0x0000000000000000, 0x0000002000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000040800000000, 0x0000000000000000, 0x0000000000000000,
        0x0000101000000000, 0x0000000000000000, 0x0000000000000000, 0x0000402000000000,
        0x0002040800000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0010101000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000100800, 0x0000000000000000,
        0x0000000000000000, 0x0000000000202000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000100000,
        0x0000000000000000, 0x0000000000200000, 0x0000000000000000, 0x0000000000400000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x000000001e000000, 0x000000001c000000, 0x0000000018000000, 0x0000000010000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000040000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000001000000000,
        0x0000000000000000, 0x0000002000000000, 0x0000000000000000, 0x0000004000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000081000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000202000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0004081000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0020202000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000201000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000404000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000200000, 0x0000000000000000, 0x0000000000400000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x000000003e000000, 0x000000003c000000, 0x0000000038000000, 0x0000000030000000,
        0x0000000020000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000002000000000, 0x0000000000000000, 0x0000004000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000102000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000404000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0008102000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0040404000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000402000, 0x0000000000000000, 0x0000000000000000, 0x0000000000808000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000400000, 0x0000000000000000, 0x0000000000800000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x000000007e000000, 0x000000007c000000, 0x0000000078000000, 0x0000000070000000,
        0x0000000060000000, 0x0000000040000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000004000000000, 0x0000000000000000, 0x0000008000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000204000000000, 0x0000000000000000, 0x0000000000000000, 0x0000808000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0010204000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0080808000000000,
        0x0000000001010100, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000002040800, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000001010000, 0x0000000000000000, 0x0000000000000000, 0x0000000002040000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000001000000, 0x0000000000000000, 0x0000000002000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000200000000, 0x0000000600000000,
        0x0000000e00000000, 0x0000001e00000000, 0x0000003e00000000, 0x0000007e00000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000010000000000, 0x0000000000000000, 0x0000020000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0001010000000000, 0x0000000000000000, 0x0000000000000000, 0x0004020000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000002020200, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000004081000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000002020000, 0x0000000000000000, 0x0000000000000000,
        0x0000000004080000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000002000000, 0x0000000000000000, 0x0000000004000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000400000000,
        0x0000000c00000000, 0x0000001c00000000, 0x0000003c00000000, 0x0000007c00000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000020000000000, 0x0000000000000000, 0x0000040000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0002020000000000, 0x0000000000000000, 0x0000000000000000,
        0x0008040000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000004040400, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000008102000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000004040000, 0x0000000000000000,
        0x0000000000000000, 0x0000000008100000, 0x0000000000000000, 0x0000000000000000,
        0x0000000002000000, 0x0000000000000000, 0x0000000004000000, 0x0000000000000000,
        0x0000000008000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000200000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000800000000, 0x0000001800000000, 0x0000003800000000, 0x0000007800000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000020000000000, 0x0000000000000000, 0x0000040000000000, 0x0000000000000000,
        0x0000080000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0004040000000000, 0x0000000000000000,
        0x0000000000000000, 0x0010080000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000008080800,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000010204000,
        0x0000000004020000, 0x0000000000000000, 0x0000000000000000, 0x0000000008080000,
        0x0000000000000000, 0x0000000000000000, 0x0000000010200000, 0x0000000000000000,
        0x0000000000000000, 0x0000000004000000, 0x0000000000000000, 0x0000000008000000,
        0x0000000000000000, 0x0000000010000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000600000000, 0x0000000400000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000001000000000, 0x0000003000000000, 0x0000007000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000040000000000, 0x0000000000000000, 0x0000080000000000,
        0x0000000000000000, 0x0000100000000000, 0x0000000000000000, 0x0000000000000000,
        0x0002040000000000, 0x0000000000000000, 0x0000000000000000, 0x0008080000000000,
        0x0000000000000000, 0x0000000000000000, 0x0020100000000000, 0x0000000000000000,
        0x0000000008040200, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000010101000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000008040000, 0x0000000000000000, 0x0000000000000000,
        0x0000000010100000, 0x0000000000000000, 0x0000000000000000, 0x0000000020400000,
        0x0000000000000000, 0x0000000000000000, 0x0000000008000000, 0x0000000000000000,
        0x0000000010000000, 0x0000000000000000, 0x0000000020000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000e00000000, 0x0000000c00000000, 0x0000000800000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000002000000000, 0x0000006000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000080000000000, 0x0000000000000000,
        0x0000100000000000, 0x0000000000000000, 0x0000200000000000, 0x0000000000000000,
        0x0000000000000000, 0x0004080000000000, 0x0000000000000000, 0x0000000000000000,
        0x0010100000000000, 0x0000000000000000, 0x0000000000000000, 0x0040200000000000,
        0x0000000000000000, 0x0000000010080400, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000020202000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000010080000, 0x0000000000000000,
        0x0000000000000000, 0x0000000020200000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000010000000,
        0x0000000000000000, 0x0000000020000000, 0x0000000000000000, 0x0000000040000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000001e00000000, 0x0000001c00000000, 0x0000001800000000, 0x0000001000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000004000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000100000000000,
        0x0000000000000000, 0x0000200000000000, 0x0000000000000000, 0x0000400000000000,
        0x0000000000000000, 0x0000000000000000, 0x0008100000000000, 0x0000000000000000,
        0x0000000000000000, 0x0020200000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000020100800, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000040404000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000020100000,
        0x0000000000000000, 0x0000000000000000, 0x0000000040400000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000020000000, 0x0000000000000000, 0x0000000040000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000003e00000000, 0x0000003c00000000, 0x0000003800000000, 0x0000003000000000,
        0x0000002000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000200000000000, 0x0000000000000000, 0x0000400000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0010200000000000,
        0x0000000000000000, 0x0000000000000000, 0x0040400000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000040201000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000080808000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000040200000, 0x0000000000000000, 0x0000000000000000, 0x0000000080800000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000040000000, 0x0000000000000000, 0x0000000080000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000007e00000000, 0x0000007c00000000, 0x0000007800000000, 0x0000007000000000,
        0x0000006000000000, 0x0000004000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000400000000000, 0x0000000000000000, 0x0000800000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0020400000000000, 0x0000000000000000, 0x0000000000000000, 0x0080800000000000,
        0x0000000101010100, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000204081000, 0x0000000000000000, 0x0000000000000000,
        0x0000000101010000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000204080000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000101000000, 0x0000000000000000, 0x0000000000000000, 0x0000000204000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000100000000, 0x0000000000000000, 0x0000000200000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000020000000000, 0x0000060000000000,
        0x00000e0000000000, 0x00001e0000000000, 0x00003e0000000000, 0x00007e0000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0001000000000000, 0x0000000000000000, 0x0002000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000202020200, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000408102000, 0x0000000000000000,
        0x0000000000000000, 0x0000000202020000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000408100000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000202000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000408000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000200000000, 0x0000000000000000, 0x0000000400000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000040000000000,
        0x00000c0000000000, 0x00001c0000000000, 0x00003c0000000000, 0x00007c0000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0002000000000000, 0x0000000000000000, 0x0004000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000404040400, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000810204000,
        0x0000000000000000, 0x0000000000000000, 0x0000000404040000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000810200000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000404000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000810000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000200000000, 0x0000000000000000, 0x0000000400000000, 0x0000000000000000,
        0x0000000800000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000020000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000080000000000, 0x0000180000000000, 0x0000380000000000, 0x0000780000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0002000000000000, 0x0000000000000000, 0x0004000000000000, 0x0000000000000000,
        0x0008000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000808080800,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000808080000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000001020400000,
        0x0000000402000000, 0x0000000000000000, 0x0000000000000000, 0x0000000808000000,
        0x0000000000000000, 0x0000000000000000, 0x0000001020000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000400000000, 0x0000000000000000, 0x0000000800000000,
        0x0000000000000000, 0x0000001000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000060000000000, 0x0000040000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000100000000000, 0x0000300000000000, 0x0000700000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0004000000000000, 0x0000000000000000, 0x0008000000000000,
        0x0000000000000000, 0x0010000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000001010101000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000804020000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000001010100000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000804000000, 0x0000000000000000, 0x0000000000000000,
        0x0000001010000000, 0x0000000000000000, 0x0000000000000000, 0x0000002040000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000800000000, 0x0000000000000000,
        0x0000001000000000, 0x0000000000000000, 0x0000002000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x00000e0000000000, 0x00000c0000000000, 0x0000080000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000200000000000, 0x0000600000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0008000000000000, 0x0000000000000000,
        0x0010000000000000, 0x0000000000000000, 0x0020000000000000, 0x0000000000000000,
        0x0000001008040200, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000002020202000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000001008040000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000002020200000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000001008000000, 0x0000000000000000,
        0x0000000000000000, 0x0000002020000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000001000000000,
        0x0000000000000000, 0x0000002000000000, 0x0000000000000000, 0x0000004000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x00001e0000000000, 0x00001c0000000000, 0x0000180000000000, 0x0000100000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000400000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0010000000000000,
        0x0000000000000000, 0x0020000000000000, 0x0000000000000000, 0x0040000000000000,
        0x0000000000000000, 0x0000002010080400, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000004040404000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000002010080000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000004040400000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000002010000000,
        0x0000000000000000, 0x0000000000000000, 0x0000004040000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000002000000000, 0x0000000000000000, 0x0000004000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x00003e0000000000, 0x00003c0000000000, 0x0000380000000000, 0x0000300000000000,
        0x0000200000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0020000000000000, 0x0000000000000000, 0x0040000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000004020100800, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000008080808000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000004020100000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000008080800000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000004020000000, 0x0000000000000000, 0x0000000000000000, 0x0000008080000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000004000000000, 0x0000000000000000, 0x0000008000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x00007e0000000000, 0x00007c0000000000, 0x0000780000000000, 0x0000700000000000,
        0x0000600000000000, 0x0000400000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0040000000000000, 0x0000000000000000, 0x0080000000000000,
        0x0000010101010100, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000020408102000, 0x0000000000000000,
        0x0000010101010000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000020408100000, 0x0000000000000000, 0x0000000000000000,
        0x0000010101000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000020408000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000010100000000, 0x0000000000000000, 0x0000000000000000, 0x0000020400000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000010000000000, 0x0000000000000000, 0x0000020000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0002000000000000, 0x0006000000000000,
        0x000e000000000000, 0x001e000000000000, 0x003e000000000000, 0x007e000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000020202020200, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000040810204000,
        0x0000000000000000, 0x0000020202020000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000040810200000, 0x0000000000000000,
        0x0000000000000000, 0x0000020202000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000040810000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000020200000000, 0x0000000000000000, 0x0000000000000000,
        0x0000040800000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000020000000000, 0x0000000000000000, 0x0000040000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0004000000000000,
        0x000c000000000000, 0x001c000000000000, 0x003c000000000000, 0x007c000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000040404040400, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000040404040000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000081020400000,
        0x0000000000000000, 0x0000000000000000, 0x0000040404000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000081020000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000040400000000, 0x0000000000000000,
        0x0000000000000000, 0x0000081000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000020000000000, 0x0000000000000000, 0x0000040000000000, 0x0000000000000000,
        0x0000080000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0002000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0008000000000000, 0x0018000000000000, 0x0038000000000000, 0x0078000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000080808080800,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000080808080000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000080808000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000102040000000,
        0x0000040200000000, 0x0000000000000000, 0x0000000000000000, 0x0000080800000000,
        0x0000000000000000, 0x0000000000000000, 0x0000102000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000040000000000, 0x0000000000000000, 0x0000080000000000,
        0x0000000000000000, 0x0000100000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0006000000000000, 0x0004000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0010000000000000, 0x0030000000000000, 0x0070000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000101010101000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000101010100000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000080402000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000101010000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000080400000000, 0x0000000000000000, 0x0000000000000000,
        0x0000101000000000, 0x0000000000000000, 0x0000000000000000, 0x0000204000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000080000000000, 0x0000000000000000,
        0x0000100000000000, 0x0000000000000000, 0x0000200000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x000e000000000000, 0x000c000000000000, 0x0008000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0020000000000000, 0x0060000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000202020202000, 0x0000000000000000, 0x0000000000000000,
        0x0000100804020000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000202020200000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000100804000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000202020000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000100800000000, 0x0000000000000000,
        0x0000000000000000, 0x0000202000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000100000000000,
        0x0000000000000000, 0x0000200000000000, 0x0000000000000000, 0x0000400000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x001e000000000000, 0x001c000000000000, 0x0018000000000000, 0x0010000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0040000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000201008040200, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000404040404000, 0x0000000000000000,
        0x0000000000000000, 0x0000201008040000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000404040400000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000201008000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000404040000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000201000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000404000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000200000000000, 0x0000000000000000, 0x0000400000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x003e000000000000, 0x003c000000000000, 0x0038000000000000, 0x0030000000000000,
        0x0020000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000402010080400, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000808080808000,
        0x0000000000000000, 0x0000000000000000, 0x0000402010080000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000808080800000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000402010000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000808080000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000402000000000, 0x0000000000000000, 0x0000000000000000, 0x0000808000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000400000000000, 0x0000000000000000, 0x0000800000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x007e000000000000, 0x007c000000000000, 0x0078000000000000, 0x0070000000000000,
        0x0060000000000000, 0x0040000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0001010101010100, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0002040810204000,
        0x0001010101010000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0002040810200000, 0x0000000000000000,
        0x0001010101000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0002040810000000, 0x0000000000000000, 0x0000000000000000,
        0x0001010100000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0002040800000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0001010000000000, 0x0000000000000000, 0x0000000000000000, 0x0002040000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0001000000000000, 0x0000000000000000, 0x0002000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0200000000000000, 0x0600000000000000,
        0x0e00000000000000, 0x1e00000000000000, 0x3e00000000000000, 0x7e00000000000000,
        0x0000000000000000, 0x0002020202020200, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0002020202020000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0004081020400000,
        0x0000000000000000, 0x0002020202000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0004081020000000, 0x0000000000000000,
        0x0000000000000000, 0x0002020200000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0004081000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0002020000000000, 0x0000000000000000, 0x0000000000000000,
        0x0004080000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0002000000000000, 0x0000000000000000, 0x0004000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0400000000000000,
        0x0c00000000000000, 0x1c00000000000000, 0x3c00000000000000, 0x7c00000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0004040404040400, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0004040404040000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0004040404000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0008102040000000,
        0x0000000000000000, 0x0000000000000000, 0x0004040400000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0008102000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0004040000000000, 0x0000000000000000,
        0x0000000000000000, 0x0008100000000000, 0x0000000000000000, 0x0000000000000000,
        0x0002000000000000, 0x0000000000000000, 0x0004000000000000, 0x0000000000000000,
        0x0008000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0200000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0800000000000000, 0x1800000000000000, 0x3800000000000000, 0x7800000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0008080808080800,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0008080808080000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0008080808000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0008080800000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0010204000000000,
        0x0004020000000000, 0x0000000000000000, 0x0000000000000000, 0x0008080000000000,
        0x0000000000000000, 0x0000000000000000, 0x0010200000000000, 0x0000000000000000,
        0x0000000000000000, 0x0004000000000000, 0x0000000000000000, 0x0008000000000000,
        0x0000000000000000, 0x0010000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0600000000000000, 0x0400000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x1000000000000000, 0x3000000000000000, 0x7000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0010101010101000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0010101010100000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0010101010000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0008040200000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0010101000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0008040000000000, 0x0000000000000000, 0x0000000000000000,
        0x0010100000000000, 0x0000000000000000, 0x0000000000000000, 0x0020400000000000,
        0x0000000000000000, 0x0000000000000000, 0x0008000000000000, 0x0000000000000000,
        0x0010000000000000, 0x0000000000000000, 0x0020000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0e00000000000000, 0x0c00000000000000, 0x0800000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x2000000000000000, 0x6000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0020202020202000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0020202020200000, 0x0000000000000000, 0x0000000000000000,
        0x0010080402000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0020202020000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0010080400000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0020202000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0010080000000000, 0x0000000000000000,
        0x0000000000000000, 0x0020200000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0010000000000000,
        0x0000000000000000, 0x0020000000000000, 0x0000000000000000, 0x0040000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x1e00000000000000, 0x1c00000000000000, 0x1800000000000000, 0x1000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x4000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0040404040404000, 0x0000000000000000,
        0x0020100804020000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0040404040400000, 0x0000000000000000,
        0x0000000000000000, 0x0020100804000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0040404040000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0020100800000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0040404000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0020100000000000,
        0x0000000000000000, 0x0000000000000000, 0x0040400000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0020000000000000, 0x0000000000000000, 0x0040000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x3e00000000000000, 0x3c00000000000000, 0x3800000000000000, 0x3000000000000000,
        0x2000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0040201008040200, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0080808080808000,
        0x0000000000000000, 0x0040201008040000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0080808080800000,
        0x0000000000000000, 0x0000000000000000, 0x0040201008000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0080808080000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0040201000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0080808000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0040200000000000, 0x0000000000000000, 0x0000000000000000, 0x0080800000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0040000000000000, 0x0000000000000000, 0x0080000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x7e00000000000000, 0x7c00000000000000, 0x7800000000000000, 0x7000000000000000,
        0x6000000000000000, 0x4000000000000000, 0x0000000000000000, 0x0000000000000000
    };

    /* Allowed moves for each piece */
    public const uint64 move_masks[] =
    {
        /* White Pawn */
        0x0000000000000300, 0x0000000000000700, 0x0000000000000e00, 0x0000000000001c00,
        0x0000000000003800, 0x0000000000007000, 0x000000000000e000, 0x000000000000c000,
        0x0000000001030000, 0x0000000002070000, 0x00000000040e0000, 0x00000000081c0000,
        0x0000000010380000, 0x0000000020700000, 0x0000000040e00000, 0x0000000080c00000,
        0x0000000003000000, 0x0000000007000000, 0x000000000e000000, 0x000000001c000000,
        0x0000000038000000, 0x0000000070000000, 0x00000000e0000000, 0x00000000c0000000,
        0x0000000300000000, 0x0000000700000000, 0x0000000e00000000, 0x0000001c00000000,
        0x0000003800000000, 0x0000007000000000, 0x000000e000000000, 0x000000c000000000,
        0x0000030000000000, 0x0000070000000000, 0x00000e0000000000, 0x00001c0000000000,
        0x0000380000000000, 0x0000700000000000, 0x0000e00000000000, 0x0000c00000000000,
        0x0003000000000000, 0x0007000000000000, 0x000e000000000000, 0x001c000000000000,
        0x0038000000000000, 0x0070000000000000, 0x00e0000000000000, 0x00c0000000000000,
        0x0300000000000000, 0x0700000000000000, 0x0e00000000000000, 0x1c00000000000000,
        0x3800000000000000, 0x7000000000000000, 0xe000000000000000, 0xc000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        /* White Rook */
        0x01010101010101fe, 0x02020202020202fd, 0x04040404040404fb, 0x08080808080808f7,
        0x10101010101010ef, 0x20202020202020df, 0x40404040404040bf, 0x808080808080807f,
        0x010101010101fe01, 0x020202020202fd02, 0x040404040404fb04, 0x080808080808f708,
        0x101010101010ef10, 0x202020202020df20, 0x404040404040bf40, 0x8080808080807f80,
        0x0101010101fe0101, 0x0202020202fd0202, 0x0404040404fb0404, 0x0808080808f70808,
        0x1010101010ef1010, 0x2020202020df2020, 0x4040404040bf4040, 0x80808080807f8080,
        0x01010101fe010101, 0x02020202fd020202, 0x04040404fb040404, 0x08080808f7080808,
        0x10101010ef101010, 0x20202020df202020, 0x40404040bf404040, 0x808080807f808080,
        0x010101fe01010101, 0x020202fd02020202, 0x040404fb04040404, 0x080808f708080808,
        0x101010ef10101010, 0x202020df20202020, 0x404040bf40404040, 0x8080807f80808080,
        0x0101fe0101010101, 0x0202fd0202020202, 0x0404fb0404040404, 0x0808f70808080808,
        0x1010ef1010101010, 0x2020df2020202020, 0x4040bf4040404040, 0x80807f8080808080,
        0x01fe010101010101, 0x02fd020202020202, 0x04fb040404040404, 0x08f7080808080808,
        0x10ef101010101010, 0x20df202020202020, 0x40bf404040404040, 0x807f808080808080,
        0xfe01010101010101, 0xfd02020202020202, 0xfb04040404040404, 0xf708080808080808,
        0xef10101010101010, 0xdf20202020202020, 0xbf40404040404040, 0x7f80808080808080,
        /* White Knight */
        0x0000000000020400, 0x0000000000050800, 0x00000000000a1100, 0x0000000000142200,
        0x0000000000284400, 0x0000000000508800, 0x0000000000a01000, 0x0000000000402000,
        0x0000000002040004, 0x0000000005080008, 0x000000000a110011, 0x0000000014220022,
        0x0000000028440044, 0x0000000050880088, 0x00000000a0100010, 0x0000000040200020,
        0x0000000204000402, 0x0000000508000805, 0x0000000a1100110a, 0x0000001422002214,
        0x0000002844004428, 0x0000005088008850, 0x000000a0100010a0, 0x0000004020002040,
        0x0000020400040200, 0x0000050800080500, 0x00000a1100110a00, 0x0000142200221400,
        0x0000284400442800, 0x0000508800885000, 0x0000a0100010a000, 0x0000402000204000,
        0x0002040004020000, 0x0005080008050000, 0x000a1100110a0000, 0x0014220022140000,
        0x0028440044280000, 0x0050880088500000, 0x00a0100010a00000, 0x0040200020400000,
        0x0204000402000000, 0x0508000805000000, 0x0a1100110a000000, 0x1422002214000000,
        0x2844004428000000, 0x5088008850000000, 0xa0100010a0000000, 0x4020002040000000,
        0x0400040200000000, 0x0800080500000000, 0x1100110a00000000, 0x2200221400000000,
        0x4400442800000000, 0x8800885000000000, 0x100010a000000000, 0x2000204000000000,
        0x0004020000000000, 0x0008050000000000, 0x00110a0000000000, 0x0022140000000000,
        0x0044280000000000, 0x0088500000000000, 0x0010a00000000000, 0x0020400000000000,
        /* White Bishop */
        0x8040201008040200, 0x0080402010080500, 0x0000804020110a00, 0x0000008041221400,
        0x0000000182442800, 0x0000010204885000, 0x000102040810a000, 0x0102040810204000,
        0x4020100804020002, 0x8040201008050005, 0x00804020110a000a, 0x0000804122140014,
        0x0000018244280028, 0x0001020488500050, 0x0102040810a000a0, 0x0204081020400040,
        0x2010080402000204, 0x4020100805000508, 0x804020110a000a11, 0x0080412214001422,
        0x0001824428002844, 0x0102048850005088, 0x02040810a000a010, 0x0408102040004020,
        0x1008040200020408, 0x2010080500050810, 0x4020110a000a1120, 0x8041221400142241,
        0x0182442800284482, 0x0204885000508804, 0x040810a000a01008, 0x0810204000402010,
        0x0804020002040810, 0x1008050005081020, 0x20110a000a112040, 0x4122140014224180,
        0x8244280028448201, 0x0488500050880402, 0x0810a000a0100804, 0x1020400040201008,
        0x0402000204081020, 0x0805000508102040, 0x110a000a11204080, 0x2214001422418000,
        0x4428002844820100, 0x8850005088040201, 0x10a000a010080402, 0x2040004020100804,
        0x0200020408102040, 0x0500050810204080, 0x0a000a1120408000, 0x1400142241800000,
        0x2800284482010000, 0x5000508804020100, 0xa000a01008040201, 0x4000402010080402,
        0x0002040810204080, 0x0005081020408000, 0x000a112040800000, 0x0014224180000000,
        0x0028448201000000, 0x0050880402010000, 0x00a0100804020100, 0x0040201008040201,
        /* White Queen */
        0x81412111090503fe, 0x02824222120a07fd, 0x0404844424150efb, 0x08080888492a1cf7,
        0x10101011925438ef, 0x2020212224a870df, 0x404142444850e0bf, 0x8182848890a0c07f,
        0x412111090503fe03, 0x824222120a07fd07, 0x04844424150efb0e, 0x080888492a1cf71c,
        0x101011925438ef38, 0x20212224a870df70, 0x4142444850e0bfe0, 0x82848890a0c07fc0,
        0x2111090503fe0305, 0x4222120a07fd070a, 0x844424150efb0e15, 0x0888492a1cf71c2a,
        0x1011925438ef3854, 0x212224a870df70a8, 0x42444850e0bfe050, 0x848890a0c07fc0a0,
        0x11090503fe030509, 0x22120a07fd070a12, 0x4424150efb0e1524, 0x88492a1cf71c2a49,
        0x11925438ef385492, 0x2224a870df70a824, 0x444850e0bfe05048, 0x8890a0c07fc0a090,
        0x090503fe03050911, 0x120a07fd070a1222, 0x24150efb0e152444, 0x492a1cf71c2a4988,
        0x925438ef38549211, 0x24a870df70a82422, 0x4850e0bfe0504844, 0x90a0c07fc0a09088,
        0x0503fe0305091121, 0x0a07fd070a122242, 0x150efb0e15244484, 0x2a1cf71c2a498808,
        0x5438ef3854921110, 0xa870df70a8242221, 0x50e0bfe050484442, 0xa0c07fc0a0908884,
        0x03fe030509112141, 0x07fd070a12224282, 0x0efb0e1524448404, 0x1cf71c2a49880808,
        0x38ef385492111010, 0x70df70a824222120, 0xe0bfe05048444241, 0xc07fc0a090888482,
        0xfe03050911214181, 0xfd070a1222428202, 0xfb0e152444840404, 0xf71c2a4988080808,
        0xef38549211101010, 0xdf70a82422212020, 0xbfe0504844424140, 0x7fc0a09088848281,
        /* White King */
        0x0000000000000302, 0x0000000000000705, 0x0000000000000e0a, 0x0000000000001c14,
        0x000000000000386c, 0x0000000000007050, 0x000000000000e0a0, 0x000000000000c040,
        0x0000000000030203, 0x0000000000070507, 0x00000000000e0a0e, 0x00000000001c141c,
        0x0000000000382838, 0x0000000000705070, 0x0000000000e0a0e0, 0x0000000000c040c0,
        0x0000000003020300, 0x0000000007050700, 0x000000000e0a0e00, 0x000000001c141c00,
        0x0000000038283800, 0x0000000070507000, 0x00000000e0a0e000, 0x00000000c040c000,
        0x0000000302030000, 0x0000000705070000, 0x0000000e0a0e0000, 0x0000001c141c0000,
        0x0000003828380000, 0x0000007050700000, 0x000000e0a0e00000, 0x000000c040c00000,
        0x0000030203000000, 0x0000070507000000, 0x00000e0a0e000000, 0x00001c141c000000,
        0x0000382838000000, 0x0000705070000000, 0x0000e0a0e0000000, 0x0000c040c0000000,
        0x0003020300000000, 0x0007050700000000, 0x000e0a0e00000000, 0x001c141c00000000,
        0x0038283800000000, 0x0070507000000000, 0x00e0a0e000000000, 0x00c040c000000000,
        0x0302030000000000, 0x0705070000000000, 0x0e0a0e0000000000, 0x1c141c0000000000,
        0x3828380000000000, 0x7050700000000000, 0xe0a0e00000000000, 0xc040c00000000000,
        0x0203000000000000, 0x0507000000000000, 0x0a0e000000000000, 0x141c000000000000,
        0x2838000000000000, 0x5070000000000000, 0xa0e0000000000000, 0x40c0000000000000,
        /* Black Pawn */
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,
        0x0000000000000003, 0x0000000000000007, 0x000000000000000e, 0x000000000000001c,
        0x0000000000000038, 0x0000000000000070, 0x00000000000000e0, 0x00000000000000c0,
        0x0000000000000300, 0x0000000000000700, 0x0000000000000e00, 0x0000000000001c00,
        0x0000000000003800, 0x0000000000007000, 0x000000000000e000, 0x000000000000c000,
        0x0000000000030000, 0x0000000000070000, 0x00000000000e0000, 0x00000000001c0000,
        0x0000000000380000, 0x0000000000700000, 0x0000000000e00000, 0x0000000000c00000,
        0x0000000003000000, 0x0000000007000000, 0x000000000e000000, 0x000000001c000000,
        0x0000000038000000, 0x0000000070000000, 0x00000000e0000000, 0x00000000c0000000,
        0x0000000300000000, 0x0000000700000000, 0x0000000e00000000, 0x0000001c00000000,
        0x0000003800000000, 0x0000007000000000, 0x000000e000000000, 0x000000c000000000,
        0x0000030100000000, 0x0000070200000000, 0x00000e0400000000, 0x00001c0800000000,
        0x0000381000000000, 0x0000702000000000, 0x0000e04000000000, 0x0000c08000000000,
        0x0003000000000000, 0x0007000000000000, 0x000e000000000000, 0x001c000000000000,
        0x0038000000000000, 0x0070000000000000, 0x00e0000000000000, 0x00c0000000000000,
        /* Black Rook */
        0x01010101010101fe, 0x02020202020202fd, 0x04040404040404fb, 0x08080808080808f7,
        0x10101010101010ef, 0x20202020202020df, 0x40404040404040bf, 0x808080808080807f,
        0x010101010101fe01, 0x020202020202fd02, 0x040404040404fb04, 0x080808080808f708,
        0x101010101010ef10, 0x202020202020df20, 0x404040404040bf40, 0x8080808080807f80,
        0x0101010101fe0101, 0x0202020202fd0202, 0x0404040404fb0404, 0x0808080808f70808,
        0x1010101010ef1010, 0x2020202020df2020, 0x4040404040bf4040, 0x80808080807f8080,
        0x01010101fe010101, 0x02020202fd020202, 0x04040404fb040404, 0x08080808f7080808,
        0x10101010ef101010, 0x20202020df202020, 0x40404040bf404040, 0x808080807f808080,
        0x010101fe01010101, 0x020202fd02020202, 0x040404fb04040404, 0x080808f708080808,
        0x101010ef10101010, 0x202020df20202020, 0x404040bf40404040, 0x8080807f80808080,
        0x0101fe0101010101, 0x0202fd0202020202, 0x0404fb0404040404, 0x0808f70808080808,
        0x1010ef1010101010, 0x2020df2020202020, 0x4040bf4040404040, 0x80807f8080808080,
        0x01fe010101010101, 0x02fd020202020202, 0x04fb040404040404, 0x08f7080808080808,
        0x10ef101010101010, 0x20df202020202020, 0x40bf404040404040, 0x807f808080808080,
        0xfe01010101010101, 0xfd02020202020202, 0xfb04040404040404, 0xf708080808080808,
        0xef10101010101010, 0xdf20202020202020, 0xbf40404040404040, 0x7f80808080808080,
        /* Black Knight */
        0x0000000000020400, 0x0000000000050800, 0x00000000000a1100, 0x0000000000142200,
        0x0000000000284400, 0x0000000000508800, 0x0000000000a01000, 0x0000000000402000,
        0x0000000002040004, 0x0000000005080008, 0x000000000a110011, 0x0000000014220022,
        0x0000000028440044, 0x0000000050880088, 0x00000000a0100010, 0x0000000040200020,
        0x0000000204000402, 0x0000000508000805, 0x0000000a1100110a, 0x0000001422002214,
        0x0000002844004428, 0x0000005088008850, 0x000000a0100010a0, 0x0000004020002040,
        0x0000020400040200, 0x0000050800080500, 0x00000a1100110a00, 0x0000142200221400,
        0x0000284400442800, 0x0000508800885000, 0x0000a0100010a000, 0x0000402000204000,
        0x0002040004020000, 0x0005080008050000, 0x000a1100110a0000, 0x0014220022140000,
        0x0028440044280000, 0x0050880088500000, 0x00a0100010a00000, 0x0040200020400000,
        0x0204000402000000, 0x0508000805000000, 0x0a1100110a000000, 0x1422002214000000,
        0x2844004428000000, 0x5088008850000000, 0xa0100010a0000000, 0x4020002040000000,
        0x0400040200000000, 0x0800080500000000, 0x1100110a00000000, 0x2200221400000000,
        0x4400442800000000, 0x8800885000000000, 0x100010a000000000, 0x2000204000000000,
        0x0004020000000000, 0x0008050000000000, 0x00110a0000000000, 0x0022140000000000,
        0x0044280000000000, 0x0088500000000000, 0x0010a00000000000, 0x0020400000000000,
        /* Black Bishop */
        0x8040201008040200, 0x0080402010080500, 0x0000804020110a00, 0x0000008041221400,
        0x0000000182442800, 0x0000010204885000, 0x000102040810a000, 0x0102040810204000,
        0x4020100804020002, 0x8040201008050005, 0x00804020110a000a, 0x0000804122140014,
        0x0000018244280028, 0x0001020488500050, 0x0102040810a000a0, 0x0204081020400040,
        0x2010080402000204, 0x4020100805000508, 0x804020110a000a11, 0x0080412214001422,
        0x0001824428002844, 0x0102048850005088, 0x02040810a000a010, 0x0408102040004020,
        0x1008040200020408, 0x2010080500050810, 0x4020110a000a1120, 0x8041221400142241,
        0x0182442800284482, 0x0204885000508804, 0x040810a000a01008, 0x0810204000402010,
        0x0804020002040810, 0x1008050005081020, 0x20110a000a112040, 0x4122140014224180,
        0x8244280028448201, 0x0488500050880402, 0x0810a000a0100804, 0x1020400040201008,
        0x0402000204081020, 0x0805000508102040, 0x110a000a11204080, 0x2214001422418000,
        0x4428002844820100, 0x8850005088040201, 0x10a000a010080402, 0x2040004020100804,
        0x0200020408102040, 0x0500050810204080, 0x0a000a1120408000, 0x1400142241800000,
        0x2800284482010000, 0x5000508804020100, 0xa000a01008040201, 0x4000402010080402,
        0x0002040810204080, 0x0005081020408000, 0x000a112040800000, 0x0014224180000000,
        0x0028448201000000, 0x0050880402010000, 0x00a0100804020100, 0x0040201008040201,
        /* Black Queen */
        0x81412111090503fe, 0x02824222120a07fd, 0x0404844424150efb, 0x08080888492a1cf7,
        0x10101011925438ef, 0x2020212224a870df, 0x404142444850e0bf, 0x8182848890a0c07f,
        0x412111090503fe03, 0x824222120a07fd07, 0x04844424150efb0e, 0x080888492a1cf71c,
        0x101011925438ef38, 0x20212224a870df70, 0x4142444850e0bfe0, 0x82848890a0c07fc0,
        0x2111090503fe0305, 0x4222120a07fd070a, 0x844424150efb0e15, 0x0888492a1cf71c2a,
        0x1011925438ef3854, 0x212224a870df70a8, 0x42444850e0bfe050, 0x848890a0c07fc0a0,
        0x11090503fe030509, 0x22120a07fd070a12, 0x4424150efb0e1524, 0x88492a1cf71c2a49,
        0x11925438ef385492, 0x2224a870df70a824, 0x444850e0bfe05048, 0x8890a0c07fc0a090,
        0x090503fe03050911, 0x120a07fd070a1222, 0x24150efb0e152444, 0x492a1cf71c2a4988,
        0x925438ef38549211, 0x24a870df70a82422, 0x4850e0bfe0504844, 0x90a0c07fc0a09088,
        0x0503fe0305091121, 0x0a07fd070a122242, 0x150efb0e15244484, 0x2a1cf71c2a498808,
        0x5438ef3854921110, 0xa870df70a8242221, 0x50e0bfe050484442, 0xa0c07fc0a0908884,
        0x03fe030509112141, 0x07fd070a12224282, 0x0efb0e1524448404, 0x1cf71c2a49880808,
        0x38ef385492111010, 0x70df70a824222120, 0xe0bfe05048444241, 0xc07fc0a090888482,
        0xfe03050911214181, 0xfd070a1222428202, 0xfb0e152444840404, 0xf71c2a4988080808,
        0xef38549211101010, 0xdf70a82422212020, 0xbfe0504844424140, 0x7fc0a09088848281,
        /* Black King */
        0x0000000000000302, 0x0000000000000705, 0x0000000000000e0a, 0x0000000000001c14,
        0x0000000000003828, 0x0000000000007050, 0x000000000000e0a0, 0x000000000000c040,
        0x0000000000030203, 0x0000000000070507, 0x00000000000e0a0e, 0x00000000001c141c,
        0x0000000000382838, 0x0000000000705070, 0x0000000000e0a0e0, 0x0000000000c040c0,
        0x0000000003020300, 0x0000000007050700, 0x000000000e0a0e00, 0x000000001c141c00,
        0x0000000038283800, 0x0000000070507000, 0x00000000e0a0e000, 0x00000000c040c000,
        0x0000000302030000, 0x0000000705070000, 0x0000000e0a0e0000, 0x0000001c141c0000,
        0x0000003828380000, 0x0000007050700000, 0x000000e0a0e00000, 0x000000c040c00000,
        0x0000030203000000, 0x0000070507000000, 0x00000e0a0e000000, 0x00001c141c000000,
        0x0000382838000000, 0x0000705070000000, 0x0000e0a0e0000000, 0x0000c040c0000000,
        0x0003020300000000, 0x0007050700000000, 0x000e0a0e00000000, 0x001c141c00000000,
        0x0038283800000000, 0x0070507000000000, 0x00e0a0e000000000, 0x00c040c000000000,
        0x0302030000000000, 0x0705070000000000, 0x0e0a0e0000000000, 0x1c141c0000000000,
        0x3828380000000000, 0x7050700000000000, 0xe0a0e00000000000, 0xc040c00000000000,
        0x0203000000000000, 0x0507000000000000, 0x0a0e000000000000, 0x141c000000000000,
        0x6c38000000000000, 0x5070000000000000, 0xa0e0000000000000, 0x40c0000000000000
    };

    public string to_string (uint64 mask)
    {
        var string = "+---+---+---+---+---+---+---+---+\n";
        int rowCount = 0;
        var colour = " ";
        for (int rank = 7; rank >= 0; rank--)
        {
            for (int file = 0; file < 8; file++)
            {
                if ((mask & set_location_masks[rank * 8 + file]) != 0)
                    string += "|[%s]".printf (colour);
                else
                    string += "| %s ".printf (colour);
                rowCount++;
                if (rowCount == 8)
                {
                    rowCount = 0;
                    string += "|\n+---+---+---+---+---+---+---+---+\n";
                }
                else
                {
                    if (colour == " ")
                        colour = ".";
                    else
                        colour = " ";
                }
            }
        }

        return string;
    }
}
